/******************************************************************************/
/* DISCLAIMER                                                                 */
/* This software is supplied by Renesas Electronics Corporation and is only   */
/* intended for use with Renesas products. No other uses are authorized.This  */
/* software is owned by Renesas Electronics Corporation and is protected      */
/* under all applicable laws, including copyright laws.                       */
/* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES          */
/* REGARDING THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING  */
/* BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR */
/* PURPOSE AND NON-INFRINGEMENT.  ALL SUCH WARRANTIES ARE EXPRESSLY           */
/* DISCLAIMED.                                                                */
/* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS     */
/* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE       */
/* LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL      */
/* DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS    */
/* AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.           */
/* Renesas reserves the right, without notice, to make changes to this        */
/* software and to discontinue the availability of this software.             */
/* By using this software, you agree to the additional terms and conditions   */
/* found by accessing the following link:                                     */
/* www.renesas.com/disclaimer                                                 */
/*                                                                            */
/* Device     : RL78/R7F125FML                                                */
/* File Name  : iodefine.h                                                    */
/* Abstract   : Definition of Special Function Register (SFR)                 */
/* History    : V1.00  [Device File version]                                  */
/* Options    : -df=C:\Program Files (x86)\Renesas Electronics\CS+\CC\Device\ */
/*              RL78\Devicefile\DR7F125FML.DVF -o=C:\Users\admin\Documents\RL */
/*              78F25\iodefine.h -f                                           */
/* Date       : 2025/12/28                                                    */
/* Version    : V1.19.00.01  [df2iodef.exe version]                           */
/* This is a typical example.                                                 */
/*                                                                            */
/******************************************************************************/
#ifndef __R7F125FMLIODEFINE_HEADER__
#define __R7F125FMLIODEFINE_HEADER__

typedef struct
{
    unsigned char no0:1;
    unsigned char no1:1;
    unsigned char no2:1;
    unsigned char no3:1;
    unsigned char no4:1;
    unsigned char no5:1;
    unsigned char no6:1;
    unsigned char no7:1;
} __bitf_T;

typedef struct
{
    unsigned char no0:1;
    unsigned char no1:1;
    unsigned char no2:1;
    unsigned char no3:1;
    unsigned char no4:1;
    unsigned char no5:1;
    unsigned char no6:1;
    unsigned char no7:1;
    unsigned char no8:1;
    unsigned char no9:1;
    unsigned char no10:1;
    unsigned char no11:1;
    unsigned char no12:1;
    unsigned char no13:1;
    unsigned char no14:1;
    unsigned char no15:1;
} __bitf_T2;



#define PIOR0          (*(volatile __near unsigned char  *)0x16)
#define PIOR1          (*(volatile __near unsigned char  *)0x17)
#define PIOR2          (*(volatile __near unsigned char  *)0x18)
#define PIOR3          (*(volatile __near unsigned char  *)0x19)
#define PIOR4          (*(volatile __near unsigned char  *)0x1A)
#define PIOR5          (*(volatile __near unsigned char  *)0x1B)
#define PIOR6          (*(volatile __near unsigned char  *)0x1C)
#define PIOR7          (*(volatile __near unsigned char  *)0x1D)
#define PIOR9          (*(volatile __near unsigned char  *)0x1F)
#define PITHL1         (*(volatile __near unsigned char  *)0x21)
#define PITHL1_bit     (*(volatile __near __bitf_T *)0x21)
#define PITHL3         (*(volatile __near unsigned char  *)0x23)
#define PITHL3_bit     (*(volatile __near __bitf_T *)0x23)
#define PITHL4         (*(volatile __near unsigned char  *)0x24)
#define PITHL4_bit     (*(volatile __near __bitf_T *)0x24)
#define PITHL5         (*(volatile __near unsigned char  *)0x25)
#define PITHL5_bit     (*(volatile __near __bitf_T *)0x25)
#define PITHL6         (*(volatile __near unsigned char  *)0x26)
#define PITHL6_bit     (*(volatile __near __bitf_T *)0x26)
#define PITHL7         (*(volatile __near unsigned char  *)0x27)
#define PITHL7_bit     (*(volatile __near __bitf_T *)0x27)
#define PITHL12        (*(volatile __near unsigned char  *)0x2C)
#define PITHL12_bit    (*(volatile __near __bitf_T *)0x2C)
#define PU0            (*(volatile __near unsigned char  *)0x30)
#define PU0_bit        (*(volatile __near __bitf_T *)0x30)
#define PU1            (*(volatile __near unsigned char  *)0x31)
#define PU1_bit        (*(volatile __near __bitf_T *)0x31)
#define PU3            (*(volatile __near unsigned char  *)0x33)
#define PU3_bit        (*(volatile __near __bitf_T *)0x33)
#define PU4            (*(volatile __near unsigned char  *)0x34)
#define PU4_bit        (*(volatile __near __bitf_T *)0x34)
#define PU5            (*(volatile __near unsigned char  *)0x35)
#define PU5_bit        (*(volatile __near __bitf_T *)0x35)
#define PU6            (*(volatile __near unsigned char  *)0x36)
#define PU6_bit        (*(volatile __near __bitf_T *)0x36)
#define PU7            (*(volatile __near unsigned char  *)0x37)
#define PU7_bit        (*(volatile __near __bitf_T *)0x37)
#define PU12           (*(volatile __near unsigned char  *)0x3C)
#define PU12_bit       (*(volatile __near __bitf_T *)0x3C)
#define PU14           (*(volatile __near unsigned char  *)0x3E)
#define PU14_bit       (*(volatile __near __bitf_T *)0x3E)
#define PIM1           (*(volatile __near unsigned char  *)0x41)
#define PIM1_bit       (*(volatile __near __bitf_T *)0x41)
#define PIM3           (*(volatile __near unsigned char  *)0x43)
#define PIM3_bit       (*(volatile __near __bitf_T *)0x43)
#define PIM5           (*(volatile __near unsigned char  *)0x45)
#define PIM5_bit       (*(volatile __near __bitf_T *)0x45)
#define PIM6           (*(volatile __near unsigned char  *)0x46)
#define PIM6_bit       (*(volatile __near __bitf_T *)0x46)
#define PIM7           (*(volatile __near unsigned char  *)0x47)
#define PIM7_bit       (*(volatile __near __bitf_T *)0x47)
#define PIM12          (*(volatile __near unsigned char  *)0x4C)
#define PIM12_bit      (*(volatile __near __bitf_T *)0x4C)
#define POM1           (*(volatile __near unsigned char  *)0x51)
#define POM1_bit       (*(volatile __near __bitf_T *)0x51)
#define POM3           (*(volatile __near unsigned char  *)0x53)
#define POM3_bit       (*(volatile __near __bitf_T *)0x53)
#define POM6           (*(volatile __near unsigned char  *)0x56)
#define POM6_bit       (*(volatile __near __bitf_T *)0x56)
#define POM7           (*(volatile __near unsigned char  *)0x57)
#define POM7_bit       (*(volatile __near __bitf_T *)0x57)
#define POM12          (*(volatile __near unsigned char  *)0x5C)
#define POM12_bit      (*(volatile __near __bitf_T *)0x5C)
#define PMC7           (*(volatile __near unsigned char  *)0x67)
#define PMC7_bit       (*(volatile __near __bitf_T *)0x67)
#define PMC8           (*(volatile __near unsigned char  *)0x68)
#define PMC8_bit       (*(volatile __near __bitf_T *)0x68)
#define PMC9           (*(volatile __near unsigned char  *)0x69)
#define PMC9_bit       (*(volatile __near __bitf_T *)0x69)
#define PMC12          (*(volatile __near unsigned char  *)0x6C)
#define PMC12_bit      (*(volatile __near __bitf_T *)0x6C)
#define NFEN0          (*(volatile __near unsigned char  *)0x70)
#define NFEN0_bit      (*(volatile __near __bitf_T *)0x70)
#define NFEN1          (*(volatile __near unsigned char  *)0x71)
#define NFEN1_bit      (*(volatile __near __bitf_T *)0x71)
#define NFEN2          (*(volatile __near unsigned char  *)0x72)
#define NFEN2_bit      (*(volatile __near __bitf_T *)0x72)
#define ISC            (*(volatile __near unsigned char  *)0x73)
#define ISC_bit        (*(volatile __near __bitf_T *)0x73)
#define TIS0           (*(volatile __near unsigned char  *)0x74)
#define TIS1           (*(volatile __near unsigned char  *)0x75)
#define RAMSAR         (*(volatile __near unsigned char  *)0x76)
#define PMS            (*(volatile __near unsigned char  *)0x77)
#define PMS_bit        (*(volatile __near __bitf_T *)0x77)
#define IAWCTL         (*(volatile __near unsigned char  *)0x78)
#define INTFLG0        (*(volatile __near unsigned char  *)0x79)
#define TIS2           (*(volatile __near unsigned char  *)0x7A)
#define LCHSEL         (*(volatile __near unsigned char  *)0x7B)
#define INTMSK         (*(volatile __near unsigned char  *)0x7C)
#define INTFLG1        (*(volatile __near unsigned char  *)0x7D)
#define DFLCTL         (*(volatile __near unsigned char  *)0x90)
#define DFLCTL_bit     (*(volatile __near __bitf_T *)0x90)
#define DFLEN          (((volatile __near __bitf_T *)0x90)->no0)
#define CFERRCTLR      (*(volatile __near unsigned char  *)0x98)
#define CFERRSTR       (*(volatile __near unsigned char  *)0x99)
#define ERRADRL        (*(volatile __near unsigned short *)0x9C)
#define ERRADRH        (*(volatile __near unsigned char  *)0x9E)
#define HIOTRM         (*(volatile __near unsigned char  *)0xA0)
#define HOCODIV        (*(volatile __near unsigned char  *)0xA8)
#define CTSUTRIM0      (*(volatile __near unsigned short *)0xB8)
#define RTRIM          (*(volatile __near unsigned char  *)0xB8)
#define DACTRIM        (*(volatile __near unsigned char  *)0xB9)
#define CTSUTRIM1      (*(volatile __near unsigned short *)0xBA)
#define SUADJD         (*(volatile __near unsigned char  *)0xBA)
#define TRESULT4       (*(volatile __near unsigned char  *)0xBB)
#define CTSUTRIM2      (*(volatile __near unsigned short *)0xBC)
#define TRESULT0       (*(volatile __near unsigned char  *)0xBC)
#define TRESULT1       (*(volatile __near unsigned char  *)0xBD)
#define CTSUTRIM3      (*(volatile __near unsigned short *)0xBE)
#define TRESULT2       (*(volatile __near unsigned char  *)0xBE)
#define TRESULT3       (*(volatile __near unsigned char  *)0xBF)
#define FLPMC          (*(volatile __near unsigned char  *)0xC0)
#define FLARS          (*(volatile __near unsigned char  *)0xC1)
#define FLARS_bit      (*(volatile __near __bitf_T *)0xC1)
#define FLAPL          (*(volatile __near unsigned short *)0xC2)
#define FLAPH          (*(volatile __near unsigned char  *)0xC4)
#define FSSQ           (*(volatile __near unsigned char  *)0xC5)
#define FSSQ_bit       (*(volatile __near __bitf_T *)0xC5)
#define FSSTP          (((volatile __near __bitf_T *)0xC5)->no6)
#define SQST           (((volatile __near __bitf_T *)0xC5)->no7)
#define FLSEDL         (*(volatile __near unsigned short *)0xC6)
#define FLSEDH         (*(volatile __near unsigned char  *)0xC8)
#define FLRST          (*(volatile __near unsigned char  *)0xC9)
#define FLRST_bit      (*(volatile __near __bitf_T *)0xC9)
#define FSASTL         (*(volatile __near unsigned char  *)0xCA)
#define FSASTL_bit     (*(volatile __near __bitf_T *)0xCA)
#define FSASTH         (*(volatile __near unsigned char  *)0xCB)
#define FSASTH_bit     (*(volatile __near __bitf_T *)0xCB)
#define SQEND          (((volatile __near __bitf_T *)0xCB)->no6)
#define ESQEND         (((volatile __near __bitf_T *)0xCB)->no7)
#define FLWL           (*(volatile __near unsigned short *)0xCC)
#define FLWH           (*(volatile __near unsigned short *)0xCE)
#define SPMCTRL        (*(volatile __near unsigned char  *)0xD8)
#define SPOFR          (*(volatile __near unsigned short *)0xDA)
#define SPUFR          (*(volatile __near unsigned short *)0xDC)
#define OSMC           (*(volatile __near unsigned char  *)0xF3)
#define PSMCR          (*(volatile __near unsigned char  *)0xF9)
#define PSMCR_bit      (*(volatile __near __bitf_T *)0xF9)
#define RAMSDS         (((volatile __near __bitf_T *)0xF9)->no0)
#define RAMSDMD        (((volatile __near __bitf_T *)0xF9)->no1)
#define LVDFCLR        (*(volatile __near unsigned char  *)0xFA)
#define LVDFCLR_bit    (*(volatile __near __bitf_T *)0xFA)
#define DLVD1FCLR      (((volatile __near __bitf_T *)0xFA)->no3)
#define BCDADJ         (*(volatile __near unsigned char  *)0xFE)
#define SSR00          (*(volatile __near unsigned short *)0x100)
#define SSR10          (*(volatile __near unsigned short *)0x100)
#define SSR00L         (*(volatile __near unsigned char  *)0x100)
#define SSR10L         (*(volatile __near unsigned char  *)0x100)
#define SSR01          (*(volatile __near unsigned short *)0x102)
#define SSR11          (*(volatile __near unsigned short *)0x102)
#define SSR11L         (*(volatile __near unsigned char  *)0x102)
#define SSR01L         (*(volatile __near unsigned char  *)0x102)
#define SIR10          (*(volatile __near unsigned short *)0x104)
#define SIR00          (*(volatile __near unsigned short *)0x104)
#define SIR10L         (*(volatile __near unsigned char  *)0x104)
#define SIR00L         (*(volatile __near unsigned char  *)0x104)
#define SIR11          (*(volatile __near unsigned short *)0x106)
#define SIR01          (*(volatile __near unsigned short *)0x106)
#define SIR11L         (*(volatile __near unsigned char  *)0x106)
#define SIR01L         (*(volatile __near unsigned char  *)0x106)
#define SMR00          (*(volatile __near unsigned short *)0x108)
#define SMR10          (*(volatile __near unsigned short *)0x108)
#define SMR01          (*(volatile __near unsigned short *)0x10A)
#define SMR11          (*(volatile __near unsigned short *)0x10A)
#define SCR10          (*(volatile __near unsigned short *)0x10C)
#define SCR00          (*(volatile __near unsigned short *)0x10C)
#define SCR11          (*(volatile __near unsigned short *)0x10E)
#define SCR01          (*(volatile __near unsigned short *)0x10E)
#define SE1            (*(volatile __near unsigned short *)0x110)
#define SE0            (*(volatile __near unsigned short *)0x110)
#define SE1L           (*(volatile __near unsigned char  *)0x110)
#define SE1L_bit       (*(volatile __near __bitf_T *)0x110)
#define SE0L           (*(volatile __near unsigned char  *)0x110)
#define SE0L_bit       (*(volatile __near __bitf_T *)0x110)
#define SS1            (*(volatile __near unsigned short *)0x112)
#define SS0            (*(volatile __near unsigned short *)0x112)
#define SS1L           (*(volatile __near unsigned char  *)0x112)
#define SS1L_bit       (*(volatile __near __bitf_T *)0x112)
#define SS0L           (*(volatile __near unsigned char  *)0x112)
#define SS0L_bit       (*(volatile __near __bitf_T *)0x112)
#define ST1            (*(volatile __near unsigned short *)0x114)
#define ST0            (*(volatile __near unsigned short *)0x114)
#define ST0L           (*(volatile __near unsigned char  *)0x114)
#define ST0L_bit       (*(volatile __near __bitf_T *)0x114)
#define ST1L           (*(volatile __near unsigned char  *)0x114)
#define ST1L_bit       (*(volatile __near __bitf_T *)0x114)
#define SPS1           (*(volatile __near unsigned short *)0x116)
#define SPS0           (*(volatile __near unsigned short *)0x116)
#define SPS1L          (*(volatile __near unsigned char  *)0x116)
#define SPS0L          (*(volatile __near unsigned char  *)0x116)
#define SO1            (*(volatile __near unsigned short *)0x118)
#define SO0            (*(volatile __near unsigned short *)0x118)
#define SOE1           (*(volatile __near unsigned short *)0x11A)
#define SOE0           (*(volatile __near unsigned short *)0x11A)
#define SOE0L          (*(volatile __near unsigned char  *)0x11A)
#define SOE0L_bit      (*(volatile __near __bitf_T *)0x11A)
#define SOE1L          (*(volatile __near unsigned char  *)0x11A)
#define SOE1L_bit      (*(volatile __near __bitf_T *)0x11A)
#define SOL1           (*(volatile __near unsigned short *)0x120)
#define SOL0           (*(volatile __near unsigned short *)0x120)
#define SOL1L          (*(volatile __near unsigned char  *)0x120)
#define SOL0L          (*(volatile __near unsigned char  *)0x120)
#define SSE1           (*(volatile __near unsigned short *)0x122)
#define SSE0           (*(volatile __near unsigned short *)0x122)
#define SSE1L          (*(volatile __near unsigned char  *)0x122)
#define SSE0L          (*(volatile __near unsigned char  *)0x122)
#define TCR00          (*(volatile __near unsigned short *)0x140)
#define TCR10          (*(volatile __near unsigned short *)0x140)
#define TCR01          (*(volatile __near unsigned short *)0x142)
#define TCR11          (*(volatile __near unsigned short *)0x142)
#define TCR02          (*(volatile __near unsigned short *)0x144)
#define TCR12          (*(volatile __near unsigned short *)0x144)
#define TCR03          (*(volatile __near unsigned short *)0x146)
#define TCR13          (*(volatile __near unsigned short *)0x146)
#define TCR04          (*(volatile __near unsigned short *)0x148)
#define TCR14          (*(volatile __near unsigned short *)0x148)
#define TCR05          (*(volatile __near unsigned short *)0x14A)
#define TCR15          (*(volatile __near unsigned short *)0x14A)
#define TCR16          (*(volatile __near unsigned short *)0x14C)
#define TCR06          (*(volatile __near unsigned short *)0x14C)
#define TCR17          (*(volatile __near unsigned short *)0x14E)
#define TCR07          (*(volatile __near unsigned short *)0x14E)
#define TMR10          (*(volatile __near unsigned short *)0x150)
#define TMR00          (*(volatile __near unsigned short *)0x150)
#define TMR01          (*(volatile __near unsigned short *)0x152)
#define TMR11          (*(volatile __near unsigned short *)0x152)
#define TMR02          (*(volatile __near unsigned short *)0x154)
#define TMR12          (*(volatile __near unsigned short *)0x154)
#define TMR03          (*(volatile __near unsigned short *)0x156)
#define TMR13          (*(volatile __near unsigned short *)0x156)
#define TMR04          (*(volatile __near unsigned short *)0x158)
#define TMR14          (*(volatile __near unsigned short *)0x158)
#define TMR05          (*(volatile __near unsigned short *)0x15A)
#define TMR15          (*(volatile __near unsigned short *)0x15A)
#define TMR06          (*(volatile __near unsigned short *)0x15C)
#define TMR16          (*(volatile __near unsigned short *)0x15C)
#define TMR07          (*(volatile __near unsigned short *)0x15E)
#define TMR17          (*(volatile __near unsigned short *)0x15E)
#define TSR00          (*(volatile __near unsigned short *)0x160)
#define TSR10          (*(volatile __near unsigned short *)0x160)
#define TSR00L         (*(volatile __near unsigned char  *)0x160)
#define TSR10L         (*(volatile __near unsigned char  *)0x160)
#define TSR11          (*(volatile __near unsigned short *)0x162)
#define TSR01          (*(volatile __near unsigned short *)0x162)
#define TSR01L         (*(volatile __near unsigned char  *)0x162)
#define TSR11L         (*(volatile __near unsigned char  *)0x162)
#define TSR02          (*(volatile __near unsigned short *)0x164)
#define TSR12          (*(volatile __near unsigned short *)0x164)
#define TSR12L         (*(volatile __near unsigned char  *)0x164)
#define TSR02L         (*(volatile __near unsigned char  *)0x164)
#define TSR13          (*(volatile __near unsigned short *)0x166)
#define TSR03          (*(volatile __near unsigned short *)0x166)
#define TSR03L         (*(volatile __near unsigned char  *)0x166)
#define TSR13L         (*(volatile __near unsigned char  *)0x166)
#define TSR14          (*(volatile __near unsigned short *)0x168)
#define TSR04          (*(volatile __near unsigned short *)0x168)
#define TSR14L         (*(volatile __near unsigned char  *)0x168)
#define TSR04L         (*(volatile __near unsigned char  *)0x168)
#define TSR15          (*(volatile __near unsigned short *)0x16A)
#define TSR05          (*(volatile __near unsigned short *)0x16A)
#define TSR15L         (*(volatile __near unsigned char  *)0x16A)
#define TSR05L         (*(volatile __near unsigned char  *)0x16A)
#define TSR06          (*(volatile __near unsigned short *)0x16C)
#define TSR16          (*(volatile __near unsigned short *)0x16C)
#define TSR06L         (*(volatile __near unsigned char  *)0x16C)
#define TSR16L         (*(volatile __near unsigned char  *)0x16C)
#define TSR07          (*(volatile __near unsigned short *)0x16E)
#define TSR17          (*(volatile __near unsigned short *)0x16E)
#define TSR07L         (*(volatile __near unsigned char  *)0x16E)
#define TSR17L         (*(volatile __near unsigned char  *)0x16E)
#define TE0            (*(volatile __near unsigned short *)0x170)
#define TE1            (*(volatile __near unsigned short *)0x170)
#define TE0L           (*(volatile __near unsigned char  *)0x170)
#define TE0L_bit       (*(volatile __near __bitf_T *)0x170)
#define TE1L           (*(volatile __near unsigned char  *)0x170)
#define TE1L_bit       (*(volatile __near __bitf_T *)0x170)
#define TS1            (*(volatile __near unsigned short *)0x172)
#define TS0            (*(volatile __near unsigned short *)0x172)
#define TS0L           (*(volatile __near unsigned char  *)0x172)
#define TS0L_bit       (*(volatile __near __bitf_T *)0x172)
#define TS1L           (*(volatile __near unsigned char  *)0x172)
#define TS1L_bit       (*(volatile __near __bitf_T *)0x172)
#define TT1            (*(volatile __near unsigned short *)0x174)
#define TT0            (*(volatile __near unsigned short *)0x174)
#define TT1L           (*(volatile __near unsigned char  *)0x174)
#define TT1L_bit       (*(volatile __near __bitf_T *)0x174)
#define TT0L           (*(volatile __near unsigned char  *)0x174)
#define TT0L_bit       (*(volatile __near __bitf_T *)0x174)
#define TPS1           (*(volatile __near unsigned short *)0x176)
#define TPS0           (*(volatile __near unsigned short *)0x176)
#define TO1            (*(volatile __near unsigned short *)0x178)
#define TO0            (*(volatile __near unsigned short *)0x178)
#define TO1L           (*(volatile __near unsigned char  *)0x178)
#define TO0L           (*(volatile __near unsigned char  *)0x178)
#define TOE1           (*(volatile __near unsigned short *)0x17A)
#define TOE0           (*(volatile __near unsigned short *)0x17A)
#define TOE1L          (*(volatile __near unsigned char  *)0x17A)
#define TOE1L_bit      (*(volatile __near __bitf_T *)0x17A)
#define TOE0L          (*(volatile __near unsigned char  *)0x17A)
#define TOE0L_bit      (*(volatile __near __bitf_T *)0x17A)
#define TOL0           (*(volatile __near unsigned short *)0x17C)
#define TOL1           (*(volatile __near unsigned short *)0x17C)
#define TOL1L          (*(volatile __near unsigned char  *)0x17C)
#define TOL0L          (*(volatile __near unsigned char  *)0x17C)
#define TOM1           (*(volatile __near unsigned short *)0x17E)
#define TOM0           (*(volatile __near unsigned short *)0x17E)
#define TOM1L          (*(volatile __near unsigned char  *)0x17E)
#define TOM0L          (*(volatile __near unsigned char  *)0x17E)
#define CTSUCRAL       (*(volatile __near unsigned short *)0x180)
#define CTSUCR0        (*(volatile __near unsigned char  *)0x180)
#define CTSUCR1        (*(volatile __near unsigned char  *)0x181)
#define CTSUCRAH       (*(volatile __near unsigned short *)0x182)
#define CTSUCR2        (*(volatile __near unsigned char  *)0x182)
#define CTSUCR3        (*(volatile __near unsigned char  *)0x183)
#define CTSUCRBL       (*(volatile __near unsigned short *)0x184)
#define CTSUSDPRS      (*(volatile __near unsigned char  *)0x184)
#define CTSUSST        (*(volatile __near unsigned char  *)0x185)
#define CTSUCRBH       (*(volatile __near unsigned short *)0x186)
#define CTSUDCLKC      (*(volatile __near unsigned char  *)0x187)
#define CTSUMCHL       (*(volatile __near unsigned short *)0x188)
#define CTSUMCH0       (*(volatile __near unsigned char  *)0x188)
#define CTSUMCH1       (*(volatile __near unsigned char  *)0x189)
#define CTSUMCHH       (*(volatile __near unsigned short *)0x18A)
#define CTSUMFAF       (*(volatile __near unsigned char  *)0x18A)
#define CTSUCHACAL     (*(volatile __near unsigned short *)0x18C)
#define CTSUCHAC0      (*(volatile __near unsigned char  *)0x18C)
#define CTSUCHAC1      (*(volatile __near unsigned char  *)0x18D)
#define CTSUCHACAH     (*(volatile __near unsigned short *)0x18E)
#define CTSUCHAC2      (*(volatile __near unsigned char  *)0x18E)
#define CTSUCHAC3      (*(volatile __near unsigned char  *)0x18F)
#define CTSUCHTRCAL    (*(volatile __near unsigned short *)0x194)
#define CTSUCHTRC0     (*(volatile __near unsigned char  *)0x194)
#define CTSUCHTRC1     (*(volatile __near unsigned char  *)0x195)
#define CTSUCHTRCAH    (*(volatile __near unsigned short *)0x196)
#define CTSUCHTRC2     (*(volatile __near unsigned char  *)0x196)
#define CTSUCHTRC3     (*(volatile __near unsigned char  *)0x197)
#define CTSUSRL        (*(volatile __near unsigned short *)0x19C)
#define CTSUST1        (*(volatile __near unsigned char  *)0x19C)
#define CTSUST         (*(volatile __near unsigned char  *)0x19D)
#define CTSUSO0        (*(volatile __near unsigned short *)0x1A0)
#define CTSUSO1        (*(volatile __near unsigned short *)0x1A2)
#define CTSUSC         (*(volatile __near unsigned short *)0x1A4)
#define CTSUUC         (*(volatile __near unsigned short *)0x1A6)
#define CTSUDBGR0      (*(volatile __near unsigned short *)0x1A8)
#define CTSUDBGR1      (*(volatile __near unsigned short *)0x1AA)
#define CTSUSUCLK0     (*(volatile __near unsigned short *)0x1AC)
#define CTSUSUCLK1     (*(volatile __near unsigned short *)0x1AE)
#define CTSUSUCLK2     (*(volatile __near unsigned short *)0x1B0)
#define CTSUSUCLK3     (*(volatile __near unsigned short *)0x1B2)
#define CTSUOPTL       (*(volatile __near unsigned short *)0x1C0)
#define CTSUOPTAC      (*(volatile __near unsigned char  *)0x1C0)
#define CTSUOPTAJ      (*(volatile __near unsigned char  *)0x1C1)
#define CTSUOPTH       (*(volatile __near unsigned short *)0x1C2)
#define CTSUOPTACSB    (*(volatile __near unsigned char  *)0x1C2)
#define CTSUSCTACTL    (*(volatile __near unsigned short *)0x1C4)
#define CTSUSCTACTH    (*(volatile __near unsigned short *)0x1C6)
#define CTSUMACT1L     (*(volatile __near unsigned short *)0x1CC)
#define CTSUMACT1H     (*(volatile __near unsigned short *)0x1CE)
#define CTSUMACT2L     (*(volatile __near unsigned short *)0x1D0)
#define CTSUMACT2H     (*(volatile __near unsigned short *)0x1D2)
#define CTSUMACT3L     (*(volatile __near unsigned short *)0x1D4)
#define CTSUMACT3H     (*(volatile __near unsigned short *)0x1D6)
#define CTSUAJCRL      (*(volatile __near unsigned short *)0x1D8)
#define CTSUAJCR0      (*(volatile __near unsigned char  *)0x1D8)
#define CTSUAJCR1      (*(volatile __near unsigned char  *)0x1D9)
#define CTSUAJCRH      (*(volatile __near unsigned short *)0x1DA)
#define CTSUAJCR2      (*(volatile __near unsigned char  *)0x1DA)
#define CTSUAJCR3      (*(volatile __near unsigned char  *)0x1DB)
#define CTSUAJTHRL     (*(volatile __near unsigned short *)0x1DC)
#define CTSUAJTHRH     (*(volatile __near unsigned short *)0x1DE)
#define CTSUAJMMARL    (*(volatile __near unsigned short *)0x1E0)
#define CTSUAJMMARH    (*(volatile __near unsigned short *)0x1E2)
#define CTSUAJBLACL    (*(volatile __near unsigned short *)0x1E4)
#define CTSUAJBLACH    (*(volatile __near unsigned short *)0x1E6)
#define CTSUAJBLARL    (*(volatile __near unsigned short *)0x1E8)
#define CTSUAJBLARH    (*(volatile __near unsigned short *)0x1EA)
#define CTSUAJRRL      (*(volatile __near unsigned short *)0x1EC)
#define CTSUAJRR0      (*(volatile __near unsigned char  *)0x1EC)
#define CTSUAJRR1      (*(volatile __near unsigned char  *)0x1ED)
#define UTSEL          (*(volatile __near unsigned char  *)0x1F0)
#define UTSEL_bit      (*(volatile __near __bitf_T *)0x1F0)
#define INTFLG2        (*(volatile __near unsigned char  *)0x1F2)
#define INTFLG3        (*(volatile __near unsigned char  *)0x1F3)
#define I2SER          (*(volatile __near unsigned char  *)0x1F6)
#define CFDWINR        (*(volatile __near unsigned char  *)0x1F7)
#define CFDWINR_bit    (*(volatile __near __bitf_T *)0x1F7)
#define CTSUTRG        (*(volatile __near unsigned char  *)0x1F8)
#define ERADR          (*(volatile __near unsigned short *)0x200)
#define ECCIER         (*(volatile __near unsigned char  *)0x202)
#define ECCER          (*(volatile __near unsigned char  *)0x203)
#define ECCTPR         (*(volatile __near unsigned char  *)0x204)
#define ECCTMDR        (*(volatile __near unsigned char  *)0x205)
#define ECCDWRVR       (*(volatile __near unsigned short *)0x206)
#define TSPMC1         (*(volatile __near unsigned char  *)0x211)
#define TSPMC1_bit     (*(volatile __near __bitf_T *)0x211)
#define TSPMC5         (*(volatile __near unsigned char  *)0x215)
#define TSPMC5_bit     (*(volatile __near __bitf_T *)0x215)
#define TSPMC6         (*(volatile __near unsigned char  *)0x216)
#define TSPMC6_bit     (*(volatile __near __bitf_T *)0x216)
#define TSPMC7         (*(volatile __near unsigned char  *)0x217)
#define TSPMC7_bit     (*(volatile __near __bitf_T *)0x217)
#define PSRSEL         (*(volatile __near unsigned char  *)0x220)
#define PSRSEL_bit     (*(volatile __near __bitf_T *)0x220)
#define PSNZCNT0       (*(volatile __near unsigned char  *)0x222)
#define PSNZCNT0_bit   (*(volatile __near __bitf_T *)0x222)
#define PSNZCNT1       (*(volatile __near unsigned char  *)0x223)
#define PSNZCNT1_bit   (*(volatile __near __bitf_T *)0x223)
#define PSNZCNT2       (*(volatile __near unsigned char  *)0x224)
#define PSNZCNT2_bit   (*(volatile __near __bitf_T *)0x224)
#define PSNZCNT3       (*(volatile __near unsigned char  *)0x225)
#define PSNZCNT3_bit   (*(volatile __near __bitf_T *)0x225)
#define DAM2           (*(volatile __near unsigned char  *)0x227)
#define DAM2_bit       (*(volatile __near __bitf_T *)0x227)
#define ANO0EN         (((volatile __near __bitf_T *)0x227)->no0)
#define PWMDLY0        (*(volatile __near unsigned short *)0x228)
#define PWMDLY1        (*(volatile __near unsigned short *)0x22A)
#define PWMDLY2        (*(volatile __near unsigned short *)0x22C)
#define IICCTL00       (*(volatile __near unsigned char  *)0x230)
#define IICCTL00_bit   (*(volatile __near __bitf_T *)0x230)
#define SPT0           (((volatile __near __bitf_T *)0x230)->no0)
#define STT0           (((volatile __near __bitf_T *)0x230)->no1)
#define ACKE0          (((volatile __near __bitf_T *)0x230)->no2)
#define WTIM0          (((volatile __near __bitf_T *)0x230)->no3)
#define SPIE0          (((volatile __near __bitf_T *)0x230)->no4)
#define WREL0          (((volatile __near __bitf_T *)0x230)->no5)
#define LREL0          (((volatile __near __bitf_T *)0x230)->no6)
#define IICE0          (((volatile __near __bitf_T *)0x230)->no7)
#define IICCTL01       (*(volatile __near unsigned char  *)0x231)
#define IICCTL01_bit   (*(volatile __near __bitf_T *)0x231)
#define PRS0           (((volatile __near __bitf_T *)0x231)->no0)
#define DFC0           (((volatile __near __bitf_T *)0x231)->no2)
#define SMC0           (((volatile __near __bitf_T *)0x231)->no3)
#define DAD0           (((volatile __near __bitf_T *)0x231)->no4)
#define CLD0           (((volatile __near __bitf_T *)0x231)->no5)
#define WUP0           (((volatile __near __bitf_T *)0x231)->no7)
#define IICWL0         (*(volatile __near unsigned char  *)0x232)
#define IICWH0         (*(volatile __near unsigned char  *)0x233)
#define SVA0           (*(volatile __near unsigned char  *)0x234)
#define TRJCR0         (*(volatile __near unsigned char  *)0x240)
#define TRJIOC0        (*(volatile __near unsigned char  *)0x241)
#define TRJIOC0_bit    (*(volatile __near __bitf_T *)0x241)
#define TRJMR0         (*(volatile __near unsigned char  *)0x242)
#define TRJMR0_bit     (*(volatile __near __bitf_T *)0x242)
#define TRJISR0        (*(volatile __near unsigned char  *)0x243)
#define TRJISR0_bit    (*(volatile __near __bitf_T *)0x243)
#define OPCTL0         (*(volatile __near unsigned char  *)0x248)
#define OPCTL0_bit     (*(volatile __near __bitf_T *)0x248)
#define HZ_REL         (((volatile __near __bitf_T *)0x248)->no1)
#define OPDF0          (*(volatile __near unsigned char  *)0x249)
#define OPDF1          (*(volatile __near unsigned char  *)0x24A)
#define OPEDGE         (*(volatile __near unsigned char  *)0x24B)
#define OPSR           (*(volatile __near unsigned char  *)0x24C)
#define OPSR_bit       (*(volatile __near __bitf_T *)0x24C)
#define TRDMBKCTL      (*(volatile __near unsigned char  *)0x24E)
#define TRDMBKCMP      (*(volatile __near unsigned char  *)0x24F)
#define TRDELC         (*(volatile __near unsigned char  *)0x250)
#define TRDELC_bit     (*(volatile __near __bitf_T *)0x250)
#define TRDSTR         (*(volatile __near unsigned char  *)0x253)
#define TRDMR          (*(volatile __near unsigned char  *)0x254)
#define TRDMR_bit      (*(volatile __near __bitf_T *)0x254)
#define TRDSYNC        (((volatile __near __bitf_T *)0x254)->no0)
#define TRDBFC0        (((volatile __near __bitf_T *)0x254)->no4)
#define TRDBFD0        (((volatile __near __bitf_T *)0x254)->no5)
#define TRDBFC1        (((volatile __near __bitf_T *)0x254)->no6)
#define TRDBFD1        (((volatile __near __bitf_T *)0x254)->no7)
#define TRDPMR         (*(volatile __near unsigned char  *)0x255)
#define TRDPMR_bit     (*(volatile __near __bitf_T *)0x255)
#define TRDPWMB0       (((volatile __near __bitf_T *)0x255)->no0)
#define TRDPWMC0       (((volatile __near __bitf_T *)0x255)->no1)
#define TRDPWMD0       (((volatile __near __bitf_T *)0x255)->no2)
#define TRDPWMB1       (((volatile __near __bitf_T *)0x255)->no4)
#define TRDPWMC1       (((volatile __near __bitf_T *)0x255)->no5)
#define TRDPWMD1       (((volatile __near __bitf_T *)0x255)->no6)
#define TRDFCR         (*(volatile __near unsigned char  *)0x256)
#define TRDFCR_bit     (*(volatile __near __bitf_T *)0x256)
#define TRDOER1        (*(volatile __near unsigned char  *)0x257)
#define TRDOER1_bit    (*(volatile __near __bitf_T *)0x257)
#define TRDOER2        (*(volatile __near unsigned char  *)0x258)
#define TRDOER2_bit    (*(volatile __near __bitf_T *)0x258)
#define TRDSHUTS       (((volatile __near __bitf_T *)0x258)->no0)
#define TRDPTO         (((volatile __near __bitf_T *)0x258)->no7)
#define TRDOCR         (*(volatile __near unsigned char  *)0x259)
#define TRDOCR_bit     (*(volatile __near __bitf_T *)0x259)
#define TRDDF0         (*(volatile __near unsigned char  *)0x25A)
#define TRDDF0_bit     (*(volatile __near __bitf_T *)0x25A)
#define TRDDF1         (*(volatile __near unsigned char  *)0x25B)
#define TRDDF1_bit     (*(volatile __near __bitf_T *)0x25B)
#define TRDCR0         (*(volatile __near unsigned char  *)0x260)
#define TRDCR0_bit     (*(volatile __near __bitf_T *)0x260)
#define TRDIORA0       (*(volatile __near unsigned char  *)0x261)
#define TRDIORA0_bit   (*(volatile __near __bitf_T *)0x261)
#define TRDIORC0       (*(volatile __near unsigned char  *)0x262)
#define TRDIORC0_bit   (*(volatile __near __bitf_T *)0x262)
#define TRDSR0         (*(volatile __near unsigned char  *)0x263)
#define TRDSR0_bit     (*(volatile __near __bitf_T *)0x263)
#define TRDIER0        (*(volatile __near unsigned char  *)0x264)
#define TRDIER0_bit    (*(volatile __near __bitf_T *)0x264)
#define TRDPOCR0       (*(volatile __near unsigned char  *)0x265)
#define TRDPOCR0_bit   (*(volatile __near __bitf_T *)0x265)
#define TRD0           (*(volatile __near unsigned short *)0x266)
#define TRDGRA0        (*(volatile __near unsigned short *)0x268)
#define TRDGRB0        (*(volatile __near unsigned short *)0x26A)
#define TRDCR1         (*(volatile __near unsigned char  *)0x270)
#define TRDCR1_bit     (*(volatile __near __bitf_T *)0x270)
#define TRDIORA1       (*(volatile __near unsigned char  *)0x271)
#define TRDIORA1_bit   (*(volatile __near __bitf_T *)0x271)
#define TRDIORC1       (*(volatile __near unsigned char  *)0x272)
#define TRDIORC1_bit   (*(volatile __near __bitf_T *)0x272)
#define TRDSR1         (*(volatile __near unsigned char  *)0x273)
#define TRDSR1_bit     (*(volatile __near __bitf_T *)0x273)
#define TRDIER1        (*(volatile __near unsigned char  *)0x274)
#define TRDIER1_bit    (*(volatile __near __bitf_T *)0x274)
#define TRDPOCR1       (*(volatile __near unsigned char  *)0x275)
#define TRDPOCR1_bit   (*(volatile __near __bitf_T *)0x275)
#define TRD1           (*(volatile __near unsigned short *)0x276)
#define TRDGRA1        (*(volatile __near unsigned short *)0x278)
#define TRDGRB1        (*(volatile __near unsigned short *)0x27A)
#define TRDCMPB0       (*(volatile __near unsigned short *)0x280)
#define TRDCMPA1       (*(volatile __near unsigned short *)0x284)
#define TRDCMPB1       (*(volatile __near unsigned short *)0x288)
#define TRDADTC0       (*(volatile __near unsigned short *)0x28C)
#define TRDADTC1       (*(volatile __near unsigned short *)0x290)
#define TRDRSF01       (*(volatile __near unsigned short *)0x296)
#define TRDRSF0        (*(volatile __near unsigned char  *)0x296)
#define TRDRSF0_bit    (*(volatile __near __bitf_T *)0x296)
#define TRDRSF1        (*(volatile __near unsigned char  *)0x297)
#define TRDRSF1_bit    (*(volatile __near __bitf_T *)0x297)
#define TRDADCR        (*(volatile __near unsigned char  *)0x298)
#define TRDADCR_bit    (*(volatile __near __bitf_T *)0x298)
#define TRDEMR0        (*(volatile __near unsigned char  *)0x29A)
#define TRDEMR0_bit    (*(volatile __near __bitf_T *)0x29A)
#define TRDEMR1        (*(volatile __near unsigned char  *)0x29B)
#define TRDEMR1_bit    (*(volatile __near __bitf_T *)0x29B)
#define CMPCTL         (*(volatile __near unsigned char  *)0x2A0)
#define CMPCTL_bit     (*(volatile __near __bitf_T *)0x2A0)
#define COE            (((volatile __near __bitf_T *)0x2A0)->no1)
#define HCMPON         (((volatile __near __bitf_T *)0x2A0)->no7)
#define CMPSEL         (*(volatile __near unsigned char  *)0x2A1)
#define CMPSEL_bit     (*(volatile __near __bitf_T *)0x2A1)
#define CPOE           (((volatile __near __bitf_T *)0x2A1)->no6)
#define CMPMON         (*(volatile __near unsigned char  *)0x2A2)
#define CMPMON_bit     (*(volatile __near __bitf_T *)0x2A2)
#define AL3REF         (*(volatile __near unsigned short *)0x2B0)
#define ADUTYL1        (*(volatile __near unsigned short *)0x2B0)
#define ADTREG0        (*(volatile __near unsigned short *)0x2B0)
#define AIDBFL         (*(volatile __near unsigned short *)0x2B0)
#define AKPD           (*(volatile __near unsigned short *)0x2B0)
#define AL1OFS         (*(volatile __near unsigned short *)0x2B2)
#define ADTREG1        (*(volatile __near unsigned short *)0x2B2)
#define AIDBFH         (*(volatile __near unsigned short *)0x2B2)
#define AKID           (*(volatile __near unsigned short *)0x2B2)
#define ADUTYL2        (*(volatile __near unsigned short *)0x2B2)
#define AIQBFL         (*(volatile __near unsigned short *)0x2B4)
#define AL2OFS         (*(volatile __near unsigned short *)0x2B4)
#define ADUTYL3        (*(volatile __near unsigned short *)0x2B4)
#define ADTREG2        (*(volatile __near unsigned short *)0x2B4)
#define AKPQ           (*(volatile __near unsigned short *)0x2B4)
#define AIQBFH         (*(volatile __near unsigned short *)0x2B6)
#define AL3OFS         (*(volatile __near unsigned short *)0x2B6)
#define AKIQ           (*(volatile __near unsigned short *)0x2B6)
#define ADTREG3        (*(volatile __near unsigned short *)0x2B6)
#define AIPL1          (*(volatile __near unsigned short *)0x2B6)
#define ADOVER         (*(volatile __near unsigned short *)0x2B8)
#define AIPL2          (*(volatile __near unsigned short *)0x2B8)
#define AIPL3          (*(volatile __near unsigned short *)0x2BA)
#define AQOVER         (*(volatile __near unsigned short *)0x2BA)
#define ACTLREG        (*(volatile __near unsigned char  *)0x2BA)
#define ACTLREG_bit    (*(volatile __near __bitf_T *)0x2BA)
#define ADUTYMX        (*(volatile __near unsigned char  *)0x2BB)
#define AKRAG          (*(volatile __near unsigned char  *)0x2BB)
#define OST            (((volatile __near __bitf_T *)0x2BA)->no0)
#define STM            (((volatile __near __bitf_T *)0x2BA)->no1)
#define AILIM          (*(volatile __near unsigned short *)0x2BC)
#define AIDREF         (*(volatile __near unsigned short *)0x2BC)
#define AKI1           (*(volatile __near unsigned short *)0x2BC)
#define AL1REF         (*(volatile __near unsigned short *)0x2BC)
#define AIQREF         (*(volatile __near unsigned short *)0x2BE)
#define AL2REF         (*(volatile __near unsigned short *)0x2BE)
#define APILIM         (*(volatile __near unsigned short *)0x2BE)
#define AKI2           (*(volatile __near unsigned short *)0x2BE)
#define PER0           (*(volatile __near unsigned char  *)0x2C0)
#define PER0_bit       (*(volatile __near __bitf_T *)0x2C0)
#define TAU0EN         (((volatile __near __bitf_T *)0x2C0)->no0)
#define TAU1EN         (((volatile __near __bitf_T *)0x2C0)->no1)
#define SAU0EN         (((volatile __near __bitf_T *)0x2C0)->no2)
#define SAU1EN         (((volatile __near __bitf_T *)0x2C0)->no3)
#define IICA0EN        (((volatile __near __bitf_T *)0x2C0)->no4)
#define ADCEN          (((volatile __near __bitf_T *)0x2C0)->no5)
#define RTCEN          (((volatile __near __bitf_T *)0x2C0)->no7)
#define PER1           (*(volatile __near unsigned char  *)0x2C1)
#define PER1_bit       (*(volatile __near __bitf_T *)0x2C1)
#define TRJ0EN         (((volatile __near __bitf_T *)0x2C1)->no0)
#define PWMOPEN        (((volatile __near __bitf_T *)0x2C1)->no2)
#define DTCEN          (((volatile __near __bitf_T *)0x2C1)->no3)
#define TRD0EN         (((volatile __near __bitf_T *)0x2C1)->no4)
#define CMPEN          (((volatile __near __bitf_T *)0x2C1)->no5)
#define CTSUEN         (((volatile __near __bitf_T *)0x2C1)->no6)
#define DACEN          (((volatile __near __bitf_T *)0x2C1)->no7)
#define PER2           (*(volatile __near unsigned char  *)0x2C2)
#define PER2_bit       (*(volatile __near __bitf_T *)0x2C2)
#define CAN0EN         (((volatile __near __bitf_T *)0x2C2)->no0)
#define LIN0EN         (((volatile __near __bitf_T *)0x2C2)->no2)
#define LIN1EN         (((volatile __near __bitf_T *)0x2C2)->no3)
#define LIN2EN         (((volatile __near __bitf_T *)0x2C2)->no4)
#define CAN1EN         (((volatile __near __bitf_T *)0x2C2)->no5)
#define AAUEN          (((volatile __near __bitf_T *)0x2C2)->no6)
#define CANCKSEL       (*(volatile __near unsigned char  *)0x2C3)
#define CANCKSEL_bit   (*(volatile __near __bitf_T *)0x2C3)
#define CAN0MCKE       (((volatile __near __bitf_T *)0x2C3)->no0)
#define CAN1MCKE       (((volatile __near __bitf_T *)0x2C3)->no1)
#define LINCKSEL       (*(volatile __near unsigned char  *)0x2C4)
#define LINCKSEL_bit   (*(volatile __near __bitf_T *)0x2C4)
#define LIN0MCK        (((volatile __near __bitf_T *)0x2C4)->no0)
#define LIN1MCK        (((volatile __near __bitf_T *)0x2C4)->no1)
#define LIN2MCK        (((volatile __near __bitf_T *)0x2C4)->no2)
#define LIN0MCKE       (((volatile __near __bitf_T *)0x2C4)->no4)
#define LIN1MCKE       (((volatile __near __bitf_T *)0x2C4)->no5)
#define LIN2MCKE       (((volatile __near __bitf_T *)0x2C4)->no6)
#define RTCCL          (*(volatile __near unsigned char  *)0x2C5)
#define RTCCL_bit      (*(volatile __near __bitf_T *)0x2C5)
#define STPSTC         (*(volatile __near unsigned char  *)0x2C6)
#define STPSTC_bit     (*(volatile __near __bitf_T *)0x2C6)
#define STPSEL         (((volatile __near __bitf_T *)0x2C6)->no0)
#define STPLV          (((volatile __near __bitf_T *)0x2C6)->no4)
#define STPOEN         (((volatile __near __bitf_T *)0x2C6)->no7)
#define ADCKS          (*(volatile __near unsigned char  *)0x2C7)
#define PLLCTL         (*(volatile __near unsigned char  *)0x2C8)
#define PLLCTL_bit     (*(volatile __near __bitf_T *)0x2C8)
#define PLLON          (((volatile __near __bitf_T *)0x2C8)->no0)
#define PLLMUL         (((volatile __near __bitf_T *)0x2C8)->no1)
#define SELPLL         (((volatile __near __bitf_T *)0x2C8)->no2)
#define PLLMULA        (((volatile __near __bitf_T *)0x2C8)->no3)
#define PLLDIV0        (((volatile __near __bitf_T *)0x2C8)->no4)
#define PLLDIV1        (((volatile __near __bitf_T *)0x2C8)->no5)
#define LCKSEL0        (((volatile __near __bitf_T *)0x2C8)->no6)
#define LCKSEL1        (((volatile __near __bitf_T *)0x2C8)->no7)
#define PLLSTS         (*(volatile __near unsigned char  *)0x2C9)
#define PLLSTS_bit     (*(volatile __near __bitf_T *)0x2C9)
#define SELPLLS        (((volatile __near __bitf_T *)0x2C9)->no3)
#define LOCK           (((volatile __near __bitf_T *)0x2C9)->no7)
#define CKSEL          (*(volatile __near unsigned char  *)0x2CA)
#define CKSEL_bit      (*(volatile __near __bitf_T *)0x2CA)
#define SELLOSC        (((volatile __near __bitf_T *)0x2CA)->no0)
#define TRD_CKSEL      (((volatile __near __bitf_T *)0x2CA)->no2)
#define FMAINDIV0      (((volatile __near __bitf_T *)0x2CA)->no5)
#define FMAINDIV1      (((volatile __near __bitf_T *)0x2CA)->no6)
#define FPLLDIV        (((volatile __near __bitf_T *)0x2CA)->no7)
#define MDIV           (*(volatile __near unsigned char  *)0x2CB)
#define POCRES         (*(volatile __near unsigned char  *)0x2CC)
#define POCRES_bit     (*(volatile __near __bitf_T *)0x2CC)
#define POCRES0        (((volatile __near __bitf_T *)0x2CC)->no0)
#define CLKRF          (((volatile __near __bitf_T *)0x2CC)->no4)
#define CLMTES         (*(volatile __near unsigned char  *)0x2CE)
#define CLMTES_bit     (*(volatile __near __bitf_T *)0x2CE)
#define CK1MSK         (((volatile __near __bitf_T *)0x2CE)->no0)
#define CK2MSK         (((volatile __near __bitf_T *)0x2CE)->no1)
#define CLMTEN         (((volatile __near __bitf_T *)0x2CE)->no3)
#define TESEN          (((volatile __near __bitf_T *)0x2CE)->no7)
#define HDTCCR0        (*(volatile __near unsigned char  *)0x2D0)
#define HDTCCR0_bit    (*(volatile __near __bitf_T *)0x2D0)
#define HMODE0         (((volatile __near __bitf_T *)0x2D0)->no0)
#define HRPTSEL0       (((volatile __near __bitf_T *)0x2D0)->no1)
#define HSAMOD0        (((volatile __near __bitf_T *)0x2D0)->no2)
#define HDAMOD0        (((volatile __near __bitf_T *)0x2D0)->no3)
#define HCHNE0         (((volatile __near __bitf_T *)0x2D0)->no4)
#define HRPTINT0       (((volatile __near __bitf_T *)0x2D0)->no5)
#define HSZ0           (((volatile __near __bitf_T *)0x2D0)->no6)
#define HDTCCT0        (*(volatile __near unsigned char  *)0x2D2)
#define HDTCCT0_bit    (*(volatile __near __bitf_T *)0x2D2)
#define HDTRLD0        (*(volatile __near unsigned char  *)0x2D3)
#define HDTRLD0_bit    (*(volatile __near __bitf_T *)0x2D3)
#define HDTSAR0        (*(volatile __near unsigned short *)0x2D4)
#define HDTDAR0        (*(volatile __near unsigned short *)0x2D6)
#define HDTCCR1        (*(volatile __near unsigned char  *)0x2D8)
#define HDTCCR1_bit    (*(volatile __near __bitf_T *)0x2D8)
#define HMODE1         (((volatile __near __bitf_T *)0x2D8)->no0)
#define HRPTSEL1       (((volatile __near __bitf_T *)0x2D8)->no1)
#define HSAMOD1        (((volatile __near __bitf_T *)0x2D8)->no2)
#define HDAMOD1        (((volatile __near __bitf_T *)0x2D8)->no3)
#define HCHNE1         (((volatile __near __bitf_T *)0x2D8)->no4)
#define HRPTINT1       (((volatile __near __bitf_T *)0x2D8)->no5)
#define HSZ1           (((volatile __near __bitf_T *)0x2D8)->no6)
#define HDTCCT1        (*(volatile __near unsigned char  *)0x2DA)
#define HDTCCT1_bit    (*(volatile __near __bitf_T *)0x2DA)
#define HDTRLD1        (*(volatile __near unsigned char  *)0x2DB)
#define HDTRLD1_bit    (*(volatile __near __bitf_T *)0x2DB)
#define HDTSAR1        (*(volatile __near unsigned short *)0x2DC)
#define HDTDAR1        (*(volatile __near unsigned short *)0x2DE)
#define DTCBAR         (*(volatile __near unsigned char  *)0x2E0)
#define SELHS0         (*(volatile __near unsigned char  *)0x2E1)
#define SELHS0_bit     (*(volatile __near __bitf_T *)0x2E1)
#define SELHS1         (*(volatile __near unsigned char  *)0x2E2)
#define SELHS1_bit     (*(volatile __near __bitf_T *)0x2E2)
#define DTCEN0         (*(volatile __near unsigned char  *)0x2E8)
#define DTCEN0_bit     (*(volatile __near __bitf_T *)0x2E8)
#define DTCEN00        (((volatile __near __bitf_T *)0x2E8)->no0)
#define DTCEN01        (((volatile __near __bitf_T *)0x2E8)->no1)
#define DTCEN02        (((volatile __near __bitf_T *)0x2E8)->no2)
#define DTCEN03        (((volatile __near __bitf_T *)0x2E8)->no3)
#define DTCEN04        (((volatile __near __bitf_T *)0x2E8)->no4)
#define DTCEN05        (((volatile __near __bitf_T *)0x2E8)->no5)
#define DTCEN06        (((volatile __near __bitf_T *)0x2E8)->no6)
#define DTCEN1         (*(volatile __near unsigned char  *)0x2E9)
#define DTCEN1_bit     (*(volatile __near __bitf_T *)0x2E9)
#define DTCEN10        (((volatile __near __bitf_T *)0x2E9)->no0)
#define DTCEN11        (((volatile __near __bitf_T *)0x2E9)->no1)
#define DTCEN12        (((volatile __near __bitf_T *)0x2E9)->no2)
#define DTCEN13        (((volatile __near __bitf_T *)0x2E9)->no3)
#define DTCEN14        (((volatile __near __bitf_T *)0x2E9)->no4)
#define DTCEN15        (((volatile __near __bitf_T *)0x2E9)->no5)
#define DTCEN16        (((volatile __near __bitf_T *)0x2E9)->no6)
#define DTCEN17        (((volatile __near __bitf_T *)0x2E9)->no7)
#define DTCEN2         (*(volatile __near unsigned char  *)0x2EA)
#define DTCEN2_bit     (*(volatile __near __bitf_T *)0x2EA)
#define DTCEN20        (((volatile __near __bitf_T *)0x2EA)->no0)
#define DTCEN21        (((volatile __near __bitf_T *)0x2EA)->no1)
#define DTCEN22        (((volatile __near __bitf_T *)0x2EA)->no2)
#define DTCEN23        (((volatile __near __bitf_T *)0x2EA)->no3)
#define DTCEN24        (((volatile __near __bitf_T *)0x2EA)->no4)
#define DTCEN25        (((volatile __near __bitf_T *)0x2EA)->no5)
#define DTCEN26        (((volatile __near __bitf_T *)0x2EA)->no6)
#define DTCEN27        (((volatile __near __bitf_T *)0x2EA)->no7)
#define DTCEN3         (*(volatile __near unsigned char  *)0x2EB)
#define DTCEN3_bit     (*(volatile __near __bitf_T *)0x2EB)
#define DTCEN30        (((volatile __near __bitf_T *)0x2EB)->no0)
#define DTCEN31        (((volatile __near __bitf_T *)0x2EB)->no1)
#define DTCEN32        (((volatile __near __bitf_T *)0x2EB)->no2)
#define DTCEN33        (((volatile __near __bitf_T *)0x2EB)->no3)
#define DTCEN34        (((volatile __near __bitf_T *)0x2EB)->no4)
#define DTCEN35        (((volatile __near __bitf_T *)0x2EB)->no5)
#define DTCEN36        (((volatile __near __bitf_T *)0x2EB)->no6)
#define DTCEN37        (((volatile __near __bitf_T *)0x2EB)->no7)
#define DTCEN4         (*(volatile __near unsigned char  *)0x2EC)
#define DTCEN4_bit     (*(volatile __near __bitf_T *)0x2EC)
#define DTCEN40        (((volatile __near __bitf_T *)0x2EC)->no0)
#define DTCEN41        (((volatile __near __bitf_T *)0x2EC)->no1)
#define DTCEN42        (((volatile __near __bitf_T *)0x2EC)->no2)
#define DTCEN45        (((volatile __near __bitf_T *)0x2EC)->no5)
#define DTCEN46        (((volatile __near __bitf_T *)0x2EC)->no6)
#define DTCEN47        (((volatile __near __bitf_T *)0x2EC)->no7)
#define DTCEN5         (*(volatile __near unsigned char  *)0x2ED)
#define DTCEN5_bit     (*(volatile __near __bitf_T *)0x2ED)
#define DTCEN50        (((volatile __near __bitf_T *)0x2ED)->no0)
#define DTCEN51        (((volatile __near __bitf_T *)0x2ED)->no1)
#define DTCEN52        (((volatile __near __bitf_T *)0x2ED)->no2)
#define DTCEN53        (((volatile __near __bitf_T *)0x2ED)->no3)
#define DTCEN54        (((volatile __near __bitf_T *)0x2ED)->no4)
#define DTCEN55        (((volatile __near __bitf_T *)0x2ED)->no5)
#define DTCEN56        (((volatile __near __bitf_T *)0x2ED)->no6)
#define DTCEN57        (((volatile __near __bitf_T *)0x2ED)->no7)
#define DTCEN6         (*(volatile __near unsigned char  *)0x2EE)
#define DTCEN6_bit     (*(volatile __near __bitf_T *)0x2EE)
#define DTCEN64        (((volatile __near __bitf_T *)0x2EE)->no4)
#define DTCEN65        (((volatile __near __bitf_T *)0x2EE)->no5)
#define DTCEN66        (((volatile __near __bitf_T *)0x2EE)->no6)
#define DTCEN67        (((volatile __near __bitf_T *)0x2EE)->no7)
#define CRC0CTL        (*(volatile __near unsigned char  *)0x2F0)
#define CRC0CTL_bit    (*(volatile __near __bitf_T *)0x2F0)
#define CRC0EN         (((volatile __near __bitf_T *)0x2F0)->no7)
#define PGCRCL         (*(volatile __near unsigned short *)0x2F2)
#define CRCMD          (*(volatile __near unsigned char  *)0x2F9)
#define CRCD           (*(volatile __near unsigned short *)0x2FA)
#define C1NCFGL        (*(volatile __near unsigned short *)0x300)
#define C0NCFGL        (*(volatile __near unsigned short *)0x300)
#define C0NCFGLL       (*(volatile __near unsigned char  *)0x300)
#define C1NCFGLL       (*(volatile __near unsigned char  *)0x300)
#define C0NCFGLH       (*(volatile __near unsigned char  *)0x301)
#define C1NCFGLH       (*(volatile __near unsigned char  *)0x301)
#define C0NCFGH        (*(volatile __near unsigned short *)0x302)
#define C1NCFGH        (*(volatile __near unsigned short *)0x302)
#define C0NCFGHL       (*(volatile __near unsigned char  *)0x302)
#define C1NCFGHL       (*(volatile __near unsigned char  *)0x302)
#define C0NCFGHH       (*(volatile __near unsigned char  *)0x303)
#define C1NCFGHH       (*(volatile __near unsigned char  *)0x303)
#define C1CTRL         (*(volatile __near unsigned short *)0x304)
#define C0CTRL         (*(volatile __near unsigned short *)0x304)
#define C1CTRLL        (*(volatile __near unsigned char  *)0x304)
#define C0CTRLL        (*(volatile __near unsigned char  *)0x304)
#define C1CTRLH        (*(volatile __near unsigned char  *)0x305)
#define C0CTRLH        (*(volatile __near unsigned char  *)0x305)
#define C1CTRH         (*(volatile __near unsigned short *)0x306)
#define C0CTRH         (*(volatile __near unsigned short *)0x306)
#define C1CTRHL        (*(volatile __near unsigned char  *)0x306)
#define C0CTRHL        (*(volatile __near unsigned char  *)0x306)
#define C1CTRHH        (*(volatile __near unsigned char  *)0x307)
#define C0CTRHH        (*(volatile __near unsigned char  *)0x307)
#define C1STSL         (*(volatile __near unsigned short *)0x308)
#define C0STSL         (*(volatile __near unsigned short *)0x308)
#define C1STSLL        (*(volatile __near unsigned char  *)0x308)
#define C0STSLL        (*(volatile __near unsigned char  *)0x308)
#define C1STSLH        (*(volatile __near unsigned char  *)0x309)
#define C0STSLH        (*(volatile __near unsigned char  *)0x309)
#define C0STSH         (*(volatile __near unsigned short *)0x30A)
#define C1STSH         (*(volatile __near unsigned short *)0x30A)
#define C0STSHL        (*(volatile __near unsigned char  *)0x30A)
#define C1STSHL        (*(volatile __near unsigned char  *)0x30A)
#define C0STSHH        (*(volatile __near unsigned char  *)0x30B)
#define C1STSHH        (*(volatile __near unsigned char  *)0x30B)
#define C1ERFLL        (*(volatile __near unsigned short *)0x30C)
#define C0ERFLL        (*(volatile __near unsigned short *)0x30C)
#define C1ERFLLL       (*(volatile __near unsigned char  *)0x30C)
#define C0ERFLLL       (*(volatile __near unsigned char  *)0x30C)
#define C1ERFLLH       (*(volatile __near unsigned char  *)0x30D)
#define C0ERFLLH       (*(volatile __near unsigned char  *)0x30D)
#define C1ERFLH        (*(volatile __near unsigned short *)0x30E)
#define C0ERFLH        (*(volatile __near unsigned short *)0x30E)
#define C0ERFLHL       (*(volatile __near unsigned char  *)0x30E)
#define C1ERFLHL       (*(volatile __near unsigned char  *)0x30E)
#define C1ERFLHH       (*(volatile __near unsigned char  *)0x30F)
#define C0ERFLHH       (*(volatile __near unsigned char  *)0x30F)
#define GIPVL1         (*(volatile __near unsigned short *)0x310)
#define GIPVL0         (*(volatile __near unsigned short *)0x310)
#define GIPVL1L        (*(volatile __near unsigned char  *)0x310)
#define GIPVL0L        (*(volatile __near unsigned char  *)0x310)
#define GIPVL1H        (*(volatile __near unsigned char  *)0x311)
#define GIPVL0H        (*(volatile __near unsigned char  *)0x311)
#define GIPVH1         (*(volatile __near unsigned short *)0x312)
#define GIPVH0         (*(volatile __near unsigned short *)0x312)
#define GIPVH1L        (*(volatile __near unsigned char  *)0x312)
#define GIPVH0L        (*(volatile __near unsigned char  *)0x312)
#define GIPVH1H        (*(volatile __near unsigned char  *)0x313)
#define GIPVH0H        (*(volatile __near unsigned char  *)0x313)
#define GCFGL1         (*(volatile __near unsigned short *)0x314)
#define GCFGL0         (*(volatile __near unsigned short *)0x314)
#define GCFGL0L        (*(volatile __near unsigned char  *)0x314)
#define GCFGL1L        (*(volatile __near unsigned char  *)0x314)
#define GCFGL1H        (*(volatile __near unsigned char  *)0x315)
#define GCFGL0H        (*(volatile __near unsigned char  *)0x315)
#define GCFGH0         (*(volatile __near unsigned short *)0x316)
#define GCFGH1         (*(volatile __near unsigned short *)0x316)
#define GCFGH0L        (*(volatile __near unsigned char  *)0x316)
#define GCFGH1L        (*(volatile __near unsigned char  *)0x316)
#define GCFGH0H        (*(volatile __near unsigned char  *)0x317)
#define GCFGH1H        (*(volatile __near unsigned char  *)0x317)
#define GCTRL1         (*(volatile __near unsigned short *)0x318)
#define GCTRL0         (*(volatile __near unsigned short *)0x318)
#define GCTRL1L        (*(volatile __near unsigned char  *)0x318)
#define GCTRL0L        (*(volatile __near unsigned char  *)0x318)
#define GCTRL1H        (*(volatile __near unsigned char  *)0x319)
#define GCTRL0H        (*(volatile __near unsigned char  *)0x319)
#define GCTRH1         (*(volatile __near unsigned short *)0x31A)
#define GCTRH0         (*(volatile __near unsigned short *)0x31A)
#define GCTRH0L        (*(volatile __near unsigned char  *)0x31A)
#define GCTRH1L        (*(volatile __near unsigned char  *)0x31A)
#define GCTRH1H        (*(volatile __near unsigned char  *)0x31B)
#define GCTRH0H        (*(volatile __near unsigned char  *)0x31B)
#define GSTS1          (*(volatile __near unsigned short *)0x31C)
#define GSTS0          (*(volatile __near unsigned short *)0x31C)
#define GSTS1L         (*(volatile __near unsigned char  *)0x31C)
#define GSTS0L         (*(volatile __near unsigned char  *)0x31C)
#define GERFLL1        (*(volatile __near unsigned short *)0x320)
#define GERFLL0        (*(volatile __near unsigned short *)0x320)
#define GERFLL0L       (*(volatile __near unsigned char  *)0x320)
#define GERFLL1L       (*(volatile __near unsigned char  *)0x320)
#define GERFLH0        (*(volatile __near unsigned short *)0x322)
#define GERFLH1        (*(volatile __near unsigned short *)0x322)
#define GERFLH0L       (*(volatile __near unsigned char  *)0x322)
#define GERFLH1L       (*(volatile __near unsigned char  *)0x322)
#define GTSC1          (*(volatile __near unsigned short *)0x324)
#define GTSC0          (*(volatile __near unsigned short *)0x324)
#define GAFLECTR1      (*(volatile __near unsigned short *)0x328)
#define GAFLECTR0      (*(volatile __near unsigned short *)0x328)
#define GAFLECTR1H     (*(volatile __near unsigned char  *)0x329)
#define GAFLECTR0H     (*(volatile __near unsigned char  *)0x329)
#define GAFLCFG0       (*(volatile __near unsigned short *)0x32E)
#define GAFLCFG1       (*(volatile __near unsigned short *)0x32E)
#define GAFLCFG0L      (*(volatile __near unsigned char  *)0x32E)
#define GAFLCFG1L      (*(volatile __near unsigned char  *)0x32E)
#define RMNB1          (*(volatile __near unsigned short *)0x330)
#define RMNB0          (*(volatile __near unsigned short *)0x330)
#define RMNB1L         (*(volatile __near unsigned char  *)0x330)
#define RMNB0L         (*(volatile __near unsigned char  *)0x330)
#define RMNB1H         (*(volatile __near unsigned char  *)0x331)
#define RMNB0H         (*(volatile __near unsigned char  *)0x331)
#define RMND0          (*(volatile __near unsigned short *)0x334)
#define RMND1          (*(volatile __near unsigned short *)0x334)
#define RMND0L         (*(volatile __near unsigned char  *)0x334)
#define RMND1L         (*(volatile __near unsigned char  *)0x334)
#define RMND1H         (*(volatile __near unsigned char  *)0x335)
#define RMND0H         (*(volatile __near unsigned char  *)0x335)
#define RMIEC1         (*(volatile __near unsigned short *)0x338)
#define RMIEC0         (*(volatile __near unsigned short *)0x338)
#define RMIEC1L        (*(volatile __near unsigned char  *)0x338)
#define RMIEC0L        (*(volatile __near unsigned char  *)0x338)
#define RMIEC0H        (*(volatile __near unsigned char  *)0x339)
#define RMIEC1H        (*(volatile __near unsigned char  *)0x339)
#define RFCC00         (*(volatile __near unsigned short *)0x33C)
#define RFCC01         (*(volatile __near unsigned short *)0x33C)
#define RFCC01L        (*(volatile __near unsigned char  *)0x33C)
#define RFCC00L        (*(volatile __near unsigned char  *)0x33C)
#define RFCC01H        (*(volatile __near unsigned char  *)0x33D)
#define RFCC00H        (*(volatile __near unsigned char  *)0x33D)
#define RFCC10         (*(volatile __near unsigned short *)0x340)
#define RFCC11         (*(volatile __near unsigned short *)0x340)
#define RFCC10L        (*(volatile __near unsigned char  *)0x340)
#define RFCC11L        (*(volatile __near unsigned char  *)0x340)
#define RFCC10H        (*(volatile __near unsigned char  *)0x341)
#define RFCC11H        (*(volatile __near unsigned char  *)0x341)
#define RFSTS01        (*(volatile __near unsigned short *)0x344)
#define RFSTS00        (*(volatile __near unsigned short *)0x344)
#define RFSTS01L       (*(volatile __near unsigned char  *)0x344)
#define RFSTS00L       (*(volatile __near unsigned char  *)0x344)
#define RFSTS01H       (*(volatile __near unsigned char  *)0x345)
#define RFSTS00H       (*(volatile __near unsigned char  *)0x345)
#define RFSTS11        (*(volatile __near unsigned short *)0x348)
#define RFSTS10        (*(volatile __near unsigned short *)0x348)
#define RFSTS11L       (*(volatile __near unsigned char  *)0x348)
#define RFSTS10L       (*(volatile __near unsigned char  *)0x348)
#define RFSTS10H       (*(volatile __near unsigned char  *)0x349)
#define RFSTS11H       (*(volatile __near unsigned char  *)0x349)
#define RFPCTR00       (*(volatile __near unsigned short *)0x34C)
#define RFPCTR01       (*(volatile __near unsigned short *)0x34C)
#define RFPCTR00L      (*(volatile __near unsigned char  *)0x34C)
#define RFPCTR01L      (*(volatile __near unsigned char  *)0x34C)
#define RFPCTR11       (*(volatile __near unsigned short *)0x350)
#define RFPCTR10       (*(volatile __near unsigned short *)0x350)
#define RFPCTR11L      (*(volatile __near unsigned char  *)0x350)
#define RFPCTR10L      (*(volatile __near unsigned char  *)0x350)
#define CFCCL1         (*(volatile __near unsigned short *)0x354)
#define CFCCL0         (*(volatile __near unsigned short *)0x354)
#define CFCCL1L        (*(volatile __near unsigned char  *)0x354)
#define CFCCL0L        (*(volatile __near unsigned char  *)0x354)
#define CFCCL1H        (*(volatile __near unsigned char  *)0x355)
#define CFCCL0H        (*(volatile __near unsigned char  *)0x355)
#define CFCCH0         (*(volatile __near unsigned short *)0x356)
#define CFCCH1         (*(volatile __near unsigned short *)0x356)
#define CFCCH0L        (*(volatile __near unsigned char  *)0x356)
#define CFCCH1L        (*(volatile __near unsigned char  *)0x356)
#define CFCCH0H        (*(volatile __near unsigned char  *)0x357)
#define CFCCH1H        (*(volatile __near unsigned char  *)0x357)
#define CFSTS0         (*(volatile __near unsigned short *)0x358)
#define CFSTS1         (*(volatile __near unsigned short *)0x358)
#define CFSTS1L        (*(volatile __near unsigned char  *)0x358)
#define CFSTS0L        (*(volatile __near unsigned char  *)0x358)
#define CFSTS0H        (*(volatile __near unsigned char  *)0x359)
#define CFSTS1H        (*(volatile __near unsigned char  *)0x359)
#define CFPCTR1        (*(volatile __near unsigned short *)0x35C)
#define CFPCTR0        (*(volatile __near unsigned short *)0x35C)
#define CFPCTR0L       (*(volatile __near unsigned char  *)0x35C)
#define CFPCTR1L       (*(volatile __near unsigned char  *)0x35C)
#define FESTS1         (*(volatile __near unsigned short *)0x360)
#define FESTS0         (*(volatile __near unsigned short *)0x360)
#define FESTS1L        (*(volatile __near unsigned char  *)0x360)
#define FESTS0L        (*(volatile __near unsigned char  *)0x360)
#define FESTS0H        (*(volatile __near unsigned char  *)0x361)
#define FESTS1H        (*(volatile __near unsigned char  *)0x361)
#define FFSTS1         (*(volatile __near unsigned short *)0x364)
#define FFSTS0         (*(volatile __near unsigned short *)0x364)
#define FFSTS0L        (*(volatile __near unsigned char  *)0x364)
#define FFSTS1L        (*(volatile __near unsigned char  *)0x364)
#define FFSTS0H        (*(volatile __near unsigned char  *)0x365)
#define FFSTS1H        (*(volatile __near unsigned char  *)0x365)
#define FMSTS0         (*(volatile __near unsigned short *)0x368)
#define FMSTS1         (*(volatile __near unsigned short *)0x368)
#define FMSTS0L        (*(volatile __near unsigned char  *)0x368)
#define FMSTS1L        (*(volatile __near unsigned char  *)0x368)
#define FMSTS0H        (*(volatile __near unsigned char  *)0x369)
#define FMSTS1H        (*(volatile __near unsigned char  *)0x369)
#define RFISTS0        (*(volatile __near unsigned short *)0x36C)
#define RFISTS1        (*(volatile __near unsigned short *)0x36C)
#define RFISTS0L       (*(volatile __near unsigned char  *)0x36C)
#define RFISTS1L       (*(volatile __near unsigned char  *)0x36C)
#define TMC01          (*(volatile __near unsigned char  *)0x370)
#define TMC00          (*(volatile __near unsigned char  *)0x370)
#define TMC10          (*(volatile __near unsigned char  *)0x371)
#define TMC11          (*(volatile __near unsigned char  *)0x371)
#define TMC20          (*(volatile __near unsigned char  *)0x372)
#define TMC21          (*(volatile __near unsigned char  *)0x372)
#define TMC30          (*(volatile __near unsigned char  *)0x373)
#define TMC31          (*(volatile __near unsigned char  *)0x373)
#define TMSTS01        (*(volatile __near unsigned char  *)0x374)
#define TMSTS00        (*(volatile __near unsigned char  *)0x374)
#define TMSTS10        (*(volatile __near unsigned char  *)0x375)
#define TMSTS11        (*(volatile __near unsigned char  *)0x375)
#define TMSTS21        (*(volatile __near unsigned char  *)0x376)
#define TMSTS20        (*(volatile __near unsigned char  *)0x376)
#define TMSTS31        (*(volatile __near unsigned char  *)0x377)
#define TMSTS30        (*(volatile __near unsigned char  *)0x377)
#define TMTRSTS0       (*(volatile __near unsigned short *)0x378)
#define TMTRSTS1       (*(volatile __near unsigned short *)0x378)
#define TMTRSTS1L      (*(volatile __near unsigned char  *)0x378)
#define TMTRSTS0L      (*(volatile __near unsigned char  *)0x378)
#define TMTARSTS1      (*(volatile __near unsigned short *)0x37C)
#define TMTARSTS0      (*(volatile __near unsigned short *)0x37C)
#define TMTARSTS0L     (*(volatile __near unsigned char  *)0x37C)
#define TMTARSTS1L     (*(volatile __near unsigned char  *)0x37C)
#define TMTCSTS1       (*(volatile __near unsigned short *)0x380)
#define TMTCSTS0       (*(volatile __near unsigned short *)0x380)
#define TMTCSTS1L      (*(volatile __near unsigned char  *)0x380)
#define TMTCSTS0L      (*(volatile __near unsigned char  *)0x380)
#define TMTASTS0       (*(volatile __near unsigned short *)0x384)
#define TMTASTS1       (*(volatile __near unsigned short *)0x384)
#define TMTASTS0L      (*(volatile __near unsigned char  *)0x384)
#define TMTASTS1L      (*(volatile __near unsigned char  *)0x384)
#define TMIEC0         (*(volatile __near unsigned short *)0x388)
#define TMIEC1         (*(volatile __near unsigned short *)0x388)
#define TMIEC0L        (*(volatile __near unsigned char  *)0x388)
#define TMIEC1L        (*(volatile __near unsigned char  *)0x388)
#define THLCC0         (*(volatile __near unsigned short *)0x398)
#define THLCC1         (*(volatile __near unsigned short *)0x398)
#define THLCC1L        (*(volatile __near unsigned char  *)0x398)
#define THLCC0L        (*(volatile __near unsigned char  *)0x398)
#define THLCC1H        (*(volatile __near unsigned char  *)0x399)
#define THLCC0H        (*(volatile __near unsigned char  *)0x399)
#define THLSTS0        (*(volatile __near unsigned short *)0x39C)
#define THLSTS1        (*(volatile __near unsigned short *)0x39C)
#define THLSTS1L       (*(volatile __near unsigned char  *)0x39C)
#define THLSTS0L       (*(volatile __near unsigned char  *)0x39C)
#define THLSTS0H       (*(volatile __near unsigned char  *)0x39D)
#define THLSTS1H       (*(volatile __near unsigned char  *)0x39D)
#define THLPCTR1       (*(volatile __near unsigned short *)0x3A0)
#define THLPCTR0       (*(volatile __near unsigned short *)0x3A0)
#define THLPCTR1L      (*(volatile __near unsigned char  *)0x3A0)
#define THLPCTR0L      (*(volatile __near unsigned char  *)0x3A0)
#define GTINTSTS0      (*(volatile __near unsigned short *)0x3A4)
#define GTINTSTS1      (*(volatile __near unsigned short *)0x3A4)
#define GTINTSTS1L     (*(volatile __near unsigned char  *)0x3A4)
#define GTINTSTS0L     (*(volatile __near unsigned char  *)0x3A4)
#define GTSTCFG1       (*(volatile __near unsigned short *)0x3AA)
#define GTSTCFG0       (*(volatile __near unsigned short *)0x3AA)
#define GTSTCFG1L      (*(volatile __near unsigned char  *)0x3AA)
#define GTSTCFG0L      (*(volatile __near unsigned char  *)0x3AA)
#define GTSTCTR0       (*(volatile __near unsigned short *)0x3AC)
#define GTSTCTR1       (*(volatile __near unsigned short *)0x3AC)
#define GTSTCTR1L      (*(volatile __near unsigned char  *)0x3AC)
#define GTSTCTR0L      (*(volatile __near unsigned char  *)0x3AC)
#define GFDCFG1        (*(volatile __near unsigned short *)0x3B0)
#define GFDCFG0        (*(volatile __near unsigned short *)0x3B0)
#define GFDCFG0L       (*(volatile __near unsigned char  *)0x3B0)
#define GFDCFG1L       (*(volatile __near unsigned char  *)0x3B0)
#define GFDCFG1H       (*(volatile __near unsigned char  *)0x3B1)
#define GFDCFG0H       (*(volatile __near unsigned char  *)0x3B1)
#define GLOCKK1        (*(volatile __near unsigned short *)0x3B8)
#define GLOCKK0        (*(volatile __near unsigned short *)0x3B8)
#define GAFLIGENT0     (*(volatile __near unsigned short *)0x3C0)
#define GAFLIGENT1     (*(volatile __near unsigned short *)0x3C0)
#define GAFLIGENT0L    (*(volatile __near unsigned char  *)0x3C0)
#define GAFLIGENT1L    (*(volatile __near unsigned char  *)0x3C0)
#define GAFLIGCTR0     (*(volatile __near unsigned short *)0x3C4)
#define GAFLIGCTR1     (*(volatile __near unsigned short *)0x3C4)
#define GPFLECTR0      (*(volatile __near unsigned short *)0x3D0)
#define GPFLECTR1      (*(volatile __near unsigned short *)0x3D0)
#define GPFLECTR0H     (*(volatile __near unsigned char  *)0x3D1)
#define GPFLECTR1H     (*(volatile __near unsigned char  *)0x3D1)
#define GPFLCFG0       (*(volatile __near unsigned short *)0x3D6)
#define GPFLCFG1       (*(volatile __near unsigned short *)0x3D6)
#define GPFLCFG1H      (*(volatile __near unsigned char  *)0x3D7)
#define GPFLCFG0H      (*(volatile __near unsigned char  *)0x3D7)
#define GRSTC0         (*(volatile __near unsigned short *)0x3D8)
#define GRSTC1         (*(volatile __near unsigned short *)0x3D8)
#define CFDGRWC1       (*(volatile __near unsigned short *)0x3DC)
#define CFDGRWC0       (*(volatile __near unsigned short *)0x3DC)
#define C1DCFGL        (*(volatile __near unsigned short *)0x400)
#define C0DCFGL        (*(volatile __near unsigned short *)0x400)
#define C1DCFGLL       (*(volatile __near unsigned char  *)0x400)
#define C0DCFGLL       (*(volatile __near unsigned char  *)0x400)
#define C0DCFGLH       (*(volatile __near unsigned char  *)0x401)
#define C1DCFGLH       (*(volatile __near unsigned char  *)0x401)
#define C1DCFGH        (*(volatile __near unsigned short *)0x402)
#define C0DCFGH        (*(volatile __near unsigned short *)0x402)
#define C1DCFGHL       (*(volatile __near unsigned char  *)0x402)
#define C0DCFGHL       (*(volatile __near unsigned char  *)0x402)
#define C0DCFGHH       (*(volatile __near unsigned char  *)0x403)
#define C1DCFGHH       (*(volatile __near unsigned char  *)0x403)
#define C0FDCFGL       (*(volatile __near unsigned short *)0x404)
#define C1FDCFGL       (*(volatile __near unsigned short *)0x404)
#define C0FDCFGLL      (*(volatile __near unsigned char  *)0x404)
#define C1FDCFGLL      (*(volatile __near unsigned char  *)0x404)
#define C0FDCFGLH      (*(volatile __near unsigned char  *)0x405)
#define C1FDCFGLH      (*(volatile __near unsigned char  *)0x405)
#define C0FDCFGH       (*(volatile __near unsigned short *)0x406)
#define C1FDCFGH       (*(volatile __near unsigned short *)0x406)
#define C0FDCFGHL      (*(volatile __near unsigned char  *)0x406)
#define C1FDCFGHL      (*(volatile __near unsigned char  *)0x406)
#define C0FDCFGHH      (*(volatile __near unsigned char  *)0x407)
#define C1FDCFGHH      (*(volatile __near unsigned char  *)0x407)
#define C0FDCTRL       (*(volatile __near unsigned short *)0x408)
#define C1FDCTRL       (*(volatile __near unsigned short *)0x408)
#define C1FDCTRLL      (*(volatile __near unsigned char  *)0x408)
#define C0FDCTRLL      (*(volatile __near unsigned char  *)0x408)
#define C0FDCTRH       (*(volatile __near unsigned short *)0x40A)
#define C1FDCTRH       (*(volatile __near unsigned short *)0x40A)
#define C1FDSTSL       (*(volatile __near unsigned short *)0x40C)
#define C0FDSTSL       (*(volatile __near unsigned short *)0x40C)
#define C0FDSTSLL      (*(volatile __near unsigned char  *)0x40C)
#define C1FDSTSLL      (*(volatile __near unsigned char  *)0x40C)
#define C1FDSTSLH      (*(volatile __near unsigned char  *)0x40D)
#define C0FDSTSLH      (*(volatile __near unsigned char  *)0x40D)
#define C1FDSTSH       (*(volatile __near unsigned short *)0x40E)
#define C0FDSTSH       (*(volatile __near unsigned short *)0x40E)
#define C1FDSTSHL      (*(volatile __near unsigned char  *)0x40E)
#define C0FDSTSHL      (*(volatile __near unsigned char  *)0x40E)
#define C1FDSTSHH      (*(volatile __near unsigned char  *)0x40F)
#define C0FDSTSHH      (*(volatile __near unsigned char  *)0x40F)
#define C0FDCRCL       (*(volatile __near unsigned short *)0x410)
#define C1FDCRCL       (*(volatile __near unsigned short *)0x410)
#define C1FDCRCH       (*(volatile __near unsigned short *)0x412)
#define C0FDCRCH       (*(volatile __near unsigned short *)0x412)
#define GAFLID0L0      (*(volatile __near unsigned short *)0x420)
#define GAFLID0L1      (*(volatile __near unsigned short *)0x420)
#define RMID8L0        (*(volatile __near unsigned short *)0x420)
#define RMID0L1        (*(volatile __near unsigned short *)0x420)
#define RMID8L1        (*(volatile __near unsigned short *)0x420)
#define RMID0L0        (*(volatile __near unsigned short *)0x420)
#define RFID0L0        (*(volatile __near unsigned short *)0x420)
#define RFID0L1        (*(volatile __near unsigned short *)0x420)
#define RMID0L1L       (*(volatile __near unsigned char  *)0x420)
#define GAFLID0L0L     (*(volatile __near unsigned char  *)0x420)
#define GAFLID0L1L     (*(volatile __near unsigned char  *)0x420)
#define RMID0L0L       (*(volatile __near unsigned char  *)0x420)
#define RMID8L0L       (*(volatile __near unsigned char  *)0x420)
#define RMID8L1L       (*(volatile __near unsigned char  *)0x420)
#define RFID0L0L       (*(volatile __near unsigned char  *)0x420)
#define RFID0L1L       (*(volatile __near unsigned char  *)0x420)
#define GAFLID0L0H     (*(volatile __near unsigned char  *)0x421)
#define GAFLID0L1H     (*(volatile __near unsigned char  *)0x421)
#define RMID0L1H       (*(volatile __near unsigned char  *)0x421)
#define RMID0L0H       (*(volatile __near unsigned char  *)0x421)
#define RMID8L0H       (*(volatile __near unsigned char  *)0x421)
#define RMID8L1H       (*(volatile __near unsigned char  *)0x421)
#define RFID0L0H       (*(volatile __near unsigned char  *)0x421)
#define RFID0L1H       (*(volatile __near unsigned char  *)0x421)
#define GAFLID0H1      (*(volatile __near unsigned short *)0x422)
#define RMID0H1        (*(volatile __near unsigned short *)0x422)
#define RMID8H1        (*(volatile __near unsigned short *)0x422)
#define GAFLID0H0      (*(volatile __near unsigned short *)0x422)
#define RMID0H0        (*(volatile __near unsigned short *)0x422)
#define RMID8H0        (*(volatile __near unsigned short *)0x422)
#define RFID0H0        (*(volatile __near unsigned short *)0x422)
#define RFID0H1        (*(volatile __near unsigned short *)0x422)
#define GAFLID0H0L     (*(volatile __near unsigned char  *)0x422)
#define RMID0H0L       (*(volatile __near unsigned char  *)0x422)
#define RMID0H1L       (*(volatile __near unsigned char  *)0x422)
#define RMID8H1L       (*(volatile __near unsigned char  *)0x422)
#define GAFLID0H1L     (*(volatile __near unsigned char  *)0x422)
#define RMID8H0L       (*(volatile __near unsigned char  *)0x422)
#define RFID0H1L       (*(volatile __near unsigned char  *)0x422)
#define RFID0H0L       (*(volatile __near unsigned char  *)0x422)
#define RMID0H1H       (*(volatile __near unsigned char  *)0x423)
#define RMID0H0H       (*(volatile __near unsigned char  *)0x423)
#define RMID8H0H       (*(volatile __near unsigned char  *)0x423)
#define RMID8H1H       (*(volatile __near unsigned char  *)0x423)
#define GAFLID0H0H     (*(volatile __near unsigned char  *)0x423)
#define GAFLID0H1H     (*(volatile __near unsigned char  *)0x423)
#define RFID0H0H       (*(volatile __near unsigned char  *)0x423)
#define RFID0H1H       (*(volatile __near unsigned char  *)0x423)
#define RMPTR0L0       (*(volatile __near unsigned short *)0x424)
#define RMPTR0L1       (*(volatile __near unsigned short *)0x424)
#define RMPTR8L0       (*(volatile __near unsigned short *)0x424)
#define RMPTR8L1       (*(volatile __near unsigned short *)0x424)
#define GAFLM0L1       (*(volatile __near unsigned short *)0x424)
#define GAFLM0L0       (*(volatile __near unsigned short *)0x424)
#define RFPTR0L1       (*(volatile __near unsigned short *)0x424)
#define RFPTR0L0       (*(volatile __near unsigned short *)0x424)
#define RMPTR0L0L      (*(volatile __near unsigned char  *)0x424)
#define RMPTR8L0L      (*(volatile __near unsigned char  *)0x424)
#define RMPTR0L1L      (*(volatile __near unsigned char  *)0x424)
#define GAFLM0L0L      (*(volatile __near unsigned char  *)0x424)
#define GAFLM0L1L      (*(volatile __near unsigned char  *)0x424)
#define RMPTR8L1L      (*(volatile __near unsigned char  *)0x424)
#define RFPTR0L1L      (*(volatile __near unsigned char  *)0x424)
#define RFPTR0L0L      (*(volatile __near unsigned char  *)0x424)
#define RMPTR0L0H      (*(volatile __near unsigned char  *)0x425)
#define RMPTR0L1H      (*(volatile __near unsigned char  *)0x425)
#define RMPTR8L0H      (*(volatile __near unsigned char  *)0x425)
#define RMPTR8L1H      (*(volatile __near unsigned char  *)0x425)
#define GAFLM0L0H      (*(volatile __near unsigned char  *)0x425)
#define GAFLM0L1H      (*(volatile __near unsigned char  *)0x425)
#define RFPTR0L0H      (*(volatile __near unsigned char  *)0x425)
#define RFPTR0L1H      (*(volatile __near unsigned char  *)0x425)
#define RMPTR0H1       (*(volatile __near unsigned short *)0x426)
#define RMPTR0H0       (*(volatile __near unsigned short *)0x426)
#define GAFLM0H0       (*(volatile __near unsigned short *)0x426)
#define RMPTR8H1       (*(volatile __near unsigned short *)0x426)
#define GAFLM0H1       (*(volatile __near unsigned short *)0x426)
#define RMPTR8H0       (*(volatile __near unsigned short *)0x426)
#define RFPTR0H1       (*(volatile __near unsigned short *)0x426)
#define RFPTR0H0       (*(volatile __near unsigned short *)0x426)
#define GAFLM0H1L      (*(volatile __near unsigned char  *)0x426)
#define GAFLM0H0L      (*(volatile __near unsigned char  *)0x426)
#define GAFLM0H1H      (*(volatile __near unsigned char  *)0x427)
#define RMPTR0H1H      (*(volatile __near unsigned char  *)0x427)
#define RMPTR8H1H      (*(volatile __near unsigned char  *)0x427)
#define GAFLM0H0H      (*(volatile __near unsigned char  *)0x427)
#define RMPTR0H0H      (*(volatile __near unsigned char  *)0x427)
#define RMPTR8H0H      (*(volatile __near unsigned char  *)0x427)
#define RFPTR0H1H      (*(volatile __near unsigned char  *)0x427)
#define RFPTR0H0H      (*(volatile __near unsigned char  *)0x427)
#define RMSTS0L0       (*(volatile __near unsigned short *)0x428)
#define RMSTS8L1       (*(volatile __near unsigned short *)0x428)
#define RMSTS0L1       (*(volatile __near unsigned short *)0x428)
#define RMSTS8L0       (*(volatile __near unsigned short *)0x428)
#define GAFLP00L1      (*(volatile __near unsigned short *)0x428)
#define GAFLP00L0      (*(volatile __near unsigned short *)0x428)
#define RFFDSTS0L0     (*(volatile __near unsigned short *)0x428)
#define RFFDSTS0L1     (*(volatile __near unsigned short *)0x428)
#define RMSTS8L1L      (*(volatile __near unsigned char  *)0x428)
#define RMSTS8L0L      (*(volatile __near unsigned char  *)0x428)
#define RMSTS0L1L      (*(volatile __near unsigned char  *)0x428)
#define RMSTS0L0L      (*(volatile __near unsigned char  *)0x428)
#define GAFLP00L1L     (*(volatile __near unsigned char  *)0x428)
#define GAFLP00L0L     (*(volatile __near unsigned char  *)0x428)
#define RFFDSTS0L0L    (*(volatile __near unsigned char  *)0x428)
#define RFFDSTS0L1L    (*(volatile __near unsigned char  *)0x428)
#define RMSTS8L0H      (*(volatile __near unsigned char  *)0x429)
#define RMSTS0L1H      (*(volatile __near unsigned char  *)0x429)
#define RMSTS8L1H      (*(volatile __near unsigned char  *)0x429)
#define RMSTS0L0H      (*(volatile __near unsigned char  *)0x429)
#define GAFLP00L1H     (*(volatile __near unsigned char  *)0x429)
#define GAFLP00L0H     (*(volatile __near unsigned char  *)0x429)
#define RFFDSTS0L0H    (*(volatile __near unsigned char  *)0x429)
#define RFFDSTS0L1H    (*(volatile __near unsigned char  *)0x429)
#define RMSTS0H1       (*(volatile __near unsigned short *)0x42A)
#define RMSTS8H0       (*(volatile __near unsigned short *)0x42A)
#define RMSTS0H0       (*(volatile __near unsigned short *)0x42A)
#define RMSTS8H1       (*(volatile __near unsigned short *)0x42A)
#define RFFDSTS0H1     (*(volatile __near unsigned short *)0x42A)
#define GAFLP00H1      (*(volatile __near unsigned short *)0x42A)
#define RFFDSTS0H0     (*(volatile __near unsigned short *)0x42A)
#define GAFLP00H0      (*(volatile __near unsigned short *)0x42A)
#define RMSTS8H0L      (*(volatile __near unsigned char  *)0x42A)
#define RMSTS0H0L      (*(volatile __near unsigned char  *)0x42A)
#define RMSTS0H1L      (*(volatile __near unsigned char  *)0x42A)
#define RMSTS8H1L      (*(volatile __near unsigned char  *)0x42A)
#define RFFDSTS0H1L    (*(volatile __near unsigned char  *)0x42A)
#define RFFDSTS0H0L    (*(volatile __near unsigned char  *)0x42A)
#define GAFLP00H1L     (*(volatile __near unsigned char  *)0x42A)
#define GAFLP00H0L     (*(volatile __near unsigned char  *)0x42A)
#define RMSTS8H1H      (*(volatile __near unsigned char  *)0x42B)
#define RMSTS8H0H      (*(volatile __near unsigned char  *)0x42B)
#define RMSTS0H0H      (*(volatile __near unsigned char  *)0x42B)
#define RMSTS0H1H      (*(volatile __near unsigned char  *)0x42B)
#define RFFDSTS0H0H    (*(volatile __near unsigned char  *)0x42B)
#define RFFDSTS0H1H    (*(volatile __near unsigned char  *)0x42B)
#define GAFLP00H1H     (*(volatile __near unsigned char  *)0x42B)
#define GAFLP00H0H     (*(volatile __near unsigned char  *)0x42B)
#define RFDF0_0L0      (*(volatile __near unsigned short *)0x42C)
#define RFDF0_0L1      (*(volatile __near unsigned short *)0x42C)
#define RMD8_0L1       (*(volatile __near unsigned short *)0x42C)
#define RMD8_0L0       (*(volatile __near unsigned short *)0x42C)
#define GAFLP10L0      (*(volatile __near unsigned short *)0x42C)
#define GAFLP10L1      (*(volatile __near unsigned short *)0x42C)
#define RMD0_0L0       (*(volatile __near unsigned short *)0x42C)
#define RMD0_0L1       (*(volatile __near unsigned short *)0x42C)
#define RFDF0_0L0L     (*(volatile __near unsigned char  *)0x42C)
#define RMD8_0L0L      (*(volatile __near unsigned char  *)0x42C)
#define RFDF0_0L1L     (*(volatile __near unsigned char  *)0x42C)
#define RMD8_0L1L      (*(volatile __near unsigned char  *)0x42C)
#define GAFLP10L0L     (*(volatile __near unsigned char  *)0x42C)
#define GAFLP10L1L     (*(volatile __near unsigned char  *)0x42C)
#define RMD0_0L0L      (*(volatile __near unsigned char  *)0x42C)
#define RMD0_0L1L      (*(volatile __near unsigned char  *)0x42C)
#define RFDF0_0L1H     (*(volatile __near unsigned char  *)0x42D)
#define RMD8_0L0H      (*(volatile __near unsigned char  *)0x42D)
#define RMD8_0L1H      (*(volatile __near unsigned char  *)0x42D)
#define RFDF0_0L0H     (*(volatile __near unsigned char  *)0x42D)
#define GAFLP10L1H     (*(volatile __near unsigned char  *)0x42D)
#define GAFLP10L0H     (*(volatile __near unsigned char  *)0x42D)
#define RMD0_0L0H      (*(volatile __near unsigned char  *)0x42D)
#define RMD0_0L1H      (*(volatile __near unsigned char  *)0x42D)
#define RFDF0_0H0      (*(volatile __near unsigned short *)0x42E)
#define RMD8_0H1       (*(volatile __near unsigned short *)0x42E)
#define RMD8_0H0       (*(volatile __near unsigned short *)0x42E)
#define RFDF0_0H1      (*(volatile __near unsigned short *)0x42E)
#define RMD0_0H0       (*(volatile __near unsigned short *)0x42E)
#define RMD0_0H1       (*(volatile __near unsigned short *)0x42E)
#define RMD8_0H1L      (*(volatile __near unsigned char  *)0x42E)
#define RMD8_0H0L      (*(volatile __near unsigned char  *)0x42E)
#define RFDF0_0H0L     (*(volatile __near unsigned char  *)0x42E)
#define RFDF0_0H1L     (*(volatile __near unsigned char  *)0x42E)
#define RMD0_0H0L      (*(volatile __near unsigned char  *)0x42E)
#define RMD0_0H1L      (*(volatile __near unsigned char  *)0x42E)
#define RFDF0_0H1H     (*(volatile __near unsigned char  *)0x42F)
#define RFDF0_0H0H     (*(volatile __near unsigned char  *)0x42F)
#define RMD8_0H1H      (*(volatile __near unsigned char  *)0x42F)
#define RMD8_0H0H      (*(volatile __near unsigned char  *)0x42F)
#define RMD0_0H0H      (*(volatile __near unsigned char  *)0x42F)
#define RMD0_0H1H      (*(volatile __near unsigned char  *)0x42F)
#define RMD8_1L1       (*(volatile __near unsigned short *)0x430)
#define RMD8_1L0       (*(volatile __near unsigned short *)0x430)
#define RFDF0_1L1      (*(volatile __near unsigned short *)0x430)
#define RFDF0_1L0      (*(volatile __near unsigned short *)0x430)
#define GAFLID1L1      (*(volatile __near unsigned short *)0x430)
#define GAFLID1L0      (*(volatile __near unsigned short *)0x430)
#define RMD0_1L1       (*(volatile __near unsigned short *)0x430)
#define RMD0_1L0       (*(volatile __near unsigned short *)0x430)
#define RMD8_1L0L      (*(volatile __near unsigned char  *)0x430)
#define RFDF0_1L1L     (*(volatile __near unsigned char  *)0x430)
#define RMD8_1L1L      (*(volatile __near unsigned char  *)0x430)
#define RFDF0_1L0L     (*(volatile __near unsigned char  *)0x430)
#define GAFLID1L0L     (*(volatile __near unsigned char  *)0x430)
#define GAFLID1L1L     (*(volatile __near unsigned char  *)0x430)
#define RMD0_1L1L      (*(volatile __near unsigned char  *)0x430)
#define RMD0_1L0L      (*(volatile __near unsigned char  *)0x430)
#define RMD8_1L0H      (*(volatile __near unsigned char  *)0x431)
#define RMD8_1L1H      (*(volatile __near unsigned char  *)0x431)
#define RFDF0_1L0H     (*(volatile __near unsigned char  *)0x431)
#define RFDF0_1L1H     (*(volatile __near unsigned char  *)0x431)
#define GAFLID1L1H     (*(volatile __near unsigned char  *)0x431)
#define GAFLID1L0H     (*(volatile __near unsigned char  *)0x431)
#define RMD0_1L1H      (*(volatile __near unsigned char  *)0x431)
#define RMD0_1L0H      (*(volatile __near unsigned char  *)0x431)
#define RFDF0_1H0      (*(volatile __near unsigned short *)0x432)
#define RFDF0_1H1      (*(volatile __near unsigned short *)0x432)
#define RMD8_1H1       (*(volatile __near unsigned short *)0x432)
#define GAFLID1H0      (*(volatile __near unsigned short *)0x432)
#define RMD8_1H0       (*(volatile __near unsigned short *)0x432)
#define GAFLID1H1      (*(volatile __near unsigned short *)0x432)
#define RMD0_1H1       (*(volatile __near unsigned short *)0x432)
#define RMD0_1H0       (*(volatile __near unsigned short *)0x432)
#define RFDF0_1H0L     (*(volatile __near unsigned char  *)0x432)
#define RMD8_1H1L      (*(volatile __near unsigned char  *)0x432)
#define RMD8_1H0L      (*(volatile __near unsigned char  *)0x432)
#define RFDF0_1H1L     (*(volatile __near unsigned char  *)0x432)
#define GAFLID1H1L     (*(volatile __near unsigned char  *)0x432)
#define GAFLID1H0L     (*(volatile __near unsigned char  *)0x432)
#define RMD0_1H0L      (*(volatile __near unsigned char  *)0x432)
#define RMD0_1H1L      (*(volatile __near unsigned char  *)0x432)
#define RFDF0_1H0H     (*(volatile __near unsigned char  *)0x433)
#define RMD8_1H0H      (*(volatile __near unsigned char  *)0x433)
#define GAFLID1H0H     (*(volatile __near unsigned char  *)0x433)
#define RMD8_1H1H      (*(volatile __near unsigned char  *)0x433)
#define RFDF0_1H1H     (*(volatile __near unsigned char  *)0x433)
#define GAFLID1H1H     (*(volatile __near unsigned char  *)0x433)
#define RMD0_1H0H      (*(volatile __near unsigned char  *)0x433)
#define RMD0_1H1H      (*(volatile __near unsigned char  *)0x433)
#define RMD8_2L0       (*(volatile __near unsigned short *)0x434)
#define RMD8_2L1       (*(volatile __near unsigned short *)0x434)
#define GAFLM1L1       (*(volatile __near unsigned short *)0x434)
#define GAFLM1L0       (*(volatile __near unsigned short *)0x434)
#define RFDF0_2L1      (*(volatile __near unsigned short *)0x434)
#define RFDF0_2L0      (*(volatile __near unsigned short *)0x434)
#define RMD0_2L1       (*(volatile __near unsigned short *)0x434)
#define RMD0_2L0       (*(volatile __near unsigned short *)0x434)
#define GAFLM1L0L      (*(volatile __near unsigned char  *)0x434)
#define GAFLM1L1L      (*(volatile __near unsigned char  *)0x434)
#define RFDF0_2L1L     (*(volatile __near unsigned char  *)0x434)
#define RMD8_2L0L      (*(volatile __near unsigned char  *)0x434)
#define RMD8_2L1L      (*(volatile __near unsigned char  *)0x434)
#define RFDF0_2L0L     (*(volatile __near unsigned char  *)0x434)
#define RMD0_2L0L      (*(volatile __near unsigned char  *)0x434)
#define RMD0_2L1L      (*(volatile __near unsigned char  *)0x434)
#define GAFLM1L1H      (*(volatile __near unsigned char  *)0x435)
#define GAFLM1L0H      (*(volatile __near unsigned char  *)0x435)
#define RMD8_2L0H      (*(volatile __near unsigned char  *)0x435)
#define RMD8_2L1H      (*(volatile __near unsigned char  *)0x435)
#define RFDF0_2L1H     (*(volatile __near unsigned char  *)0x435)
#define RFDF0_2L0H     (*(volatile __near unsigned char  *)0x435)
#define RMD0_2L0H      (*(volatile __near unsigned char  *)0x435)
#define RMD0_2L1H      (*(volatile __near unsigned char  *)0x435)
#define GAFLM1H1       (*(volatile __near unsigned short *)0x436)
#define GAFLM1H0       (*(volatile __near unsigned short *)0x436)
#define RFDF0_2H0      (*(volatile __near unsigned short *)0x436)
#define RMD8_2H1       (*(volatile __near unsigned short *)0x436)
#define RMD8_2H0       (*(volatile __near unsigned short *)0x436)
#define RFDF0_2H1      (*(volatile __near unsigned short *)0x436)
#define RMD0_2H0       (*(volatile __near unsigned short *)0x436)
#define RMD0_2H1       (*(volatile __near unsigned short *)0x436)
#define GAFLM1H1L      (*(volatile __near unsigned char  *)0x436)
#define RFDF0_2H1L     (*(volatile __near unsigned char  *)0x436)
#define RFDF0_2H0L     (*(volatile __near unsigned char  *)0x436)
#define GAFLM1H0L      (*(volatile __near unsigned char  *)0x436)
#define RMD8_2H0L      (*(volatile __near unsigned char  *)0x436)
#define RMD8_2H1L      (*(volatile __near unsigned char  *)0x436)
#define RMD0_2H0L      (*(volatile __near unsigned char  *)0x436)
#define RMD0_2H1L      (*(volatile __near unsigned char  *)0x436)
#define RFDF0_2H1H     (*(volatile __near unsigned char  *)0x437)
#define RMD8_2H1H      (*(volatile __near unsigned char  *)0x437)
#define RFDF0_2H0H     (*(volatile __near unsigned char  *)0x437)
#define GAFLM1H0H      (*(volatile __near unsigned char  *)0x437)
#define RMD8_2H0H      (*(volatile __near unsigned char  *)0x437)
#define GAFLM1H1H      (*(volatile __near unsigned char  *)0x437)
#define RMD0_2H1H      (*(volatile __near unsigned char  *)0x437)
#define RMD0_2H0H      (*(volatile __near unsigned char  *)0x437)
#define RFDF0_3L1      (*(volatile __near unsigned short *)0x438)
#define RFDF0_3L0      (*(volatile __near unsigned short *)0x438)
#define RMD8_3L1       (*(volatile __near unsigned short *)0x438)
#define RMD8_3L0       (*(volatile __near unsigned short *)0x438)
#define RMD0_3L1       (*(volatile __near unsigned short *)0x438)
#define RMD0_3L0       (*(volatile __near unsigned short *)0x438)
#define GAFLP01L1      (*(volatile __near unsigned short *)0x438)
#define GAFLP01L0      (*(volatile __near unsigned short *)0x438)
#define RFDF0_3L1L     (*(volatile __near unsigned char  *)0x438)
#define RFDF0_3L0L     (*(volatile __near unsigned char  *)0x438)
#define RMD8_3L0L      (*(volatile __near unsigned char  *)0x438)
#define RMD8_3L1L      (*(volatile __near unsigned char  *)0x438)
#define RMD0_3L0L      (*(volatile __near unsigned char  *)0x438)
#define RMD0_3L1L      (*(volatile __near unsigned char  *)0x438)
#define GAFLP01L0L     (*(volatile __near unsigned char  *)0x438)
#define GAFLP01L1L     (*(volatile __near unsigned char  *)0x438)
#define RFDF0_3L0H     (*(volatile __near unsigned char  *)0x439)
#define RFDF0_3L1H     (*(volatile __near unsigned char  *)0x439)
#define RMD8_3L0H      (*(volatile __near unsigned char  *)0x439)
#define RMD8_3L1H      (*(volatile __near unsigned char  *)0x439)
#define RMD0_3L1H      (*(volatile __near unsigned char  *)0x439)
#define RMD0_3L0H      (*(volatile __near unsigned char  *)0x439)
#define GAFLP01L0H     (*(volatile __near unsigned char  *)0x439)
#define GAFLP01L1H     (*(volatile __near unsigned char  *)0x439)
#define RFDF0_3H0      (*(volatile __near unsigned short *)0x43A)
#define RFDF0_3H1      (*(volatile __near unsigned short *)0x43A)
#define RMD8_3H0       (*(volatile __near unsigned short *)0x43A)
#define RMD8_3H1       (*(volatile __near unsigned short *)0x43A)
#define RMD0_3H1       (*(volatile __near unsigned short *)0x43A)
#define RMD0_3H0       (*(volatile __near unsigned short *)0x43A)
#define GAFLP01H1      (*(volatile __near unsigned short *)0x43A)
#define GAFLP01H0      (*(volatile __near unsigned short *)0x43A)
#define RFDF0_3H1L     (*(volatile __near unsigned char  *)0x43A)
#define RFDF0_3H0L     (*(volatile __near unsigned char  *)0x43A)
#define RMD8_3H1L      (*(volatile __near unsigned char  *)0x43A)
#define RMD8_3H0L      (*(volatile __near unsigned char  *)0x43A)
#define RMD0_3H1L      (*(volatile __near unsigned char  *)0x43A)
#define RMD0_3H0L      (*(volatile __near unsigned char  *)0x43A)
#define GAFLP01H1L     (*(volatile __near unsigned char  *)0x43A)
#define GAFLP01H0L     (*(volatile __near unsigned char  *)0x43A)
#define RFDF0_3H0H     (*(volatile __near unsigned char  *)0x43B)
#define RFDF0_3H1H     (*(volatile __near unsigned char  *)0x43B)
#define RMD8_3H1H      (*(volatile __near unsigned char  *)0x43B)
#define RMD8_3H0H      (*(volatile __near unsigned char  *)0x43B)
#define RMD0_3H1H      (*(volatile __near unsigned char  *)0x43B)
#define RMD0_3H0H      (*(volatile __near unsigned char  *)0x43B)
#define GAFLP01H1H     (*(volatile __near unsigned char  *)0x43B)
#define GAFLP01H0H     (*(volatile __near unsigned char  *)0x43B)
#define RFDF0_4L0      (*(volatile __near unsigned short *)0x43C)
#define RMD8_4L0       (*(volatile __near unsigned short *)0x43C)
#define RMD8_4L1       (*(volatile __near unsigned short *)0x43C)
#define RFDF0_4L1      (*(volatile __near unsigned short *)0x43C)
#define GAFLP11L0      (*(volatile __near unsigned short *)0x43C)
#define GAFLP11L1      (*(volatile __near unsigned short *)0x43C)
#define RMD0_4L0       (*(volatile __near unsigned short *)0x43C)
#define RMD0_4L1       (*(volatile __near unsigned short *)0x43C)
#define RMD8_4L0L      (*(volatile __near unsigned char  *)0x43C)
#define RMD8_4L1L      (*(volatile __near unsigned char  *)0x43C)
#define RFDF0_4L1L     (*(volatile __near unsigned char  *)0x43C)
#define RFDF0_4L0L     (*(volatile __near unsigned char  *)0x43C)
#define RMD0_4L1L      (*(volatile __near unsigned char  *)0x43C)
#define GAFLP11L0L     (*(volatile __near unsigned char  *)0x43C)
#define GAFLP11L1L     (*(volatile __near unsigned char  *)0x43C)
#define RMD0_4L0L      (*(volatile __near unsigned char  *)0x43C)
#define RMD8_4L0H      (*(volatile __near unsigned char  *)0x43D)
#define RMD8_4L1H      (*(volatile __near unsigned char  *)0x43D)
#define RFDF0_4L0H     (*(volatile __near unsigned char  *)0x43D)
#define RFDF0_4L1H     (*(volatile __near unsigned char  *)0x43D)
#define GAFLP11L0H     (*(volatile __near unsigned char  *)0x43D)
#define GAFLP11L1H     (*(volatile __near unsigned char  *)0x43D)
#define RMD0_4L1H      (*(volatile __near unsigned char  *)0x43D)
#define RMD0_4L0H      (*(volatile __near unsigned char  *)0x43D)
#define RFDF0_4H0      (*(volatile __near unsigned short *)0x43E)
#define RFDF0_4H1      (*(volatile __near unsigned short *)0x43E)
#define RMD8_4H0       (*(volatile __near unsigned short *)0x43E)
#define RMD8_4H1       (*(volatile __near unsigned short *)0x43E)
#define RMD0_4H0       (*(volatile __near unsigned short *)0x43E)
#define RMD0_4H1       (*(volatile __near unsigned short *)0x43E)
#define RFDF0_4H1L     (*(volatile __near unsigned char  *)0x43E)
#define RFDF0_4H0L     (*(volatile __near unsigned char  *)0x43E)
#define RMD8_4H1L      (*(volatile __near unsigned char  *)0x43E)
#define RMD8_4H0L      (*(volatile __near unsigned char  *)0x43E)
#define RMD0_4H1L      (*(volatile __near unsigned char  *)0x43E)
#define RMD0_4H0L      (*(volatile __near unsigned char  *)0x43E)
#define RFDF0_4H0H     (*(volatile __near unsigned char  *)0x43F)
#define RFDF0_4H1H     (*(volatile __near unsigned char  *)0x43F)
#define RMD8_4H1H      (*(volatile __near unsigned char  *)0x43F)
#define RMD8_4H0H      (*(volatile __near unsigned char  *)0x43F)
#define RMD0_4H1H      (*(volatile __near unsigned char  *)0x43F)
#define RMD0_4H0H      (*(volatile __near unsigned char  *)0x43F)
#define GAFLID2L1      (*(volatile __near unsigned short *)0x440)
#define GAFLID2L0      (*(volatile __near unsigned short *)0x440)
#define RMD8_5L0       (*(volatile __near unsigned short *)0x440)
#define RMD8_5L1       (*(volatile __near unsigned short *)0x440)
#define RFDF0_5L1      (*(volatile __near unsigned short *)0x440)
#define RFDF0_5L0      (*(volatile __near unsigned short *)0x440)
#define RMD0_5L0       (*(volatile __near unsigned short *)0x440)
#define RMD0_5L1       (*(volatile __near unsigned short *)0x440)
#define GAFLID2L1L     (*(volatile __near unsigned char  *)0x440)
#define GAFLID2L0L     (*(volatile __near unsigned char  *)0x440)
#define RMD8_5L0L      (*(volatile __near unsigned char  *)0x440)
#define RMD8_5L1L      (*(volatile __near unsigned char  *)0x440)
#define RFDF0_5L1L     (*(volatile __near unsigned char  *)0x440)
#define RFDF0_5L0L     (*(volatile __near unsigned char  *)0x440)
#define RMD0_5L1L      (*(volatile __near unsigned char  *)0x440)
#define RMD0_5L0L      (*(volatile __near unsigned char  *)0x440)
#define GAFLID2L1H     (*(volatile __near unsigned char  *)0x441)
#define GAFLID2L0H     (*(volatile __near unsigned char  *)0x441)
#define RMD8_5L1H      (*(volatile __near unsigned char  *)0x441)
#define RMD8_5L0H      (*(volatile __near unsigned char  *)0x441)
#define RFDF0_5L1H     (*(volatile __near unsigned char  *)0x441)
#define RFDF0_5L0H     (*(volatile __near unsigned char  *)0x441)
#define RMD0_5L0H      (*(volatile __near unsigned char  *)0x441)
#define RMD0_5L1H      (*(volatile __near unsigned char  *)0x441)
#define GAFLID2H0      (*(volatile __near unsigned short *)0x442)
#define GAFLID2H1      (*(volatile __near unsigned short *)0x442)
#define RFDF0_5H1      (*(volatile __near unsigned short *)0x442)
#define RMD8_5H1       (*(volatile __near unsigned short *)0x442)
#define RFDF0_5H0      (*(volatile __near unsigned short *)0x442)
#define RMD8_5H0       (*(volatile __near unsigned short *)0x442)
#define RMD0_5H0       (*(volatile __near unsigned short *)0x442)
#define RMD0_5H1       (*(volatile __near unsigned short *)0x442)
#define GAFLID2H0L     (*(volatile __near unsigned char  *)0x442)
#define GAFLID2H1L     (*(volatile __near unsigned char  *)0x442)
#define RFDF0_5H0L     (*(volatile __near unsigned char  *)0x442)
#define RFDF0_5H1L     (*(volatile __near unsigned char  *)0x442)
#define RMD8_5H0L      (*(volatile __near unsigned char  *)0x442)
#define RMD8_5H1L      (*(volatile __near unsigned char  *)0x442)
#define RMD0_5H1L      (*(volatile __near unsigned char  *)0x442)
#define RMD0_5H0L      (*(volatile __near unsigned char  *)0x442)
#define GAFLID2H0H     (*(volatile __near unsigned char  *)0x443)
#define GAFLID2H1H     (*(volatile __near unsigned char  *)0x443)
#define RMD8_5H0H      (*(volatile __near unsigned char  *)0x443)
#define RFDF0_5H0H     (*(volatile __near unsigned char  *)0x443)
#define RFDF0_5H1H     (*(volatile __near unsigned char  *)0x443)
#define RMD8_5H1H      (*(volatile __near unsigned char  *)0x443)
#define RMD0_5H1H      (*(volatile __near unsigned char  *)0x443)
#define RMD0_5H0H      (*(volatile __near unsigned char  *)0x443)
#define RMD8_6L1       (*(volatile __near unsigned short *)0x444)
#define RMD8_6L0       (*(volatile __near unsigned short *)0x444)
#define RFDF0_6L0      (*(volatile __near unsigned short *)0x444)
#define GAFLM2L0       (*(volatile __near unsigned short *)0x444)
#define GAFLM2L1       (*(volatile __near unsigned short *)0x444)
#define RFDF0_6L1      (*(volatile __near unsigned short *)0x444)
#define RMD0_6L0       (*(volatile __near unsigned short *)0x444)
#define RMD0_6L1       (*(volatile __near unsigned short *)0x444)
#define RMD8_6L1L      (*(volatile __near unsigned char  *)0x444)
#define RMD8_6L0L      (*(volatile __near unsigned char  *)0x444)
#define GAFLM2L0L      (*(volatile __near unsigned char  *)0x444)
#define GAFLM2L1L      (*(volatile __near unsigned char  *)0x444)
#define RFDF0_6L0L     (*(volatile __near unsigned char  *)0x444)
#define RFDF0_6L1L     (*(volatile __near unsigned char  *)0x444)
#define RMD0_6L0L      (*(volatile __near unsigned char  *)0x444)
#define RMD0_6L1L      (*(volatile __near unsigned char  *)0x444)
#define RMD8_6L1H      (*(volatile __near unsigned char  *)0x445)
#define RMD8_6L0H      (*(volatile __near unsigned char  *)0x445)
#define GAFLM2L0H      (*(volatile __near unsigned char  *)0x445)
#define GAFLM2L1H      (*(volatile __near unsigned char  *)0x445)
#define RFDF0_6L1H     (*(volatile __near unsigned char  *)0x445)
#define RFDF0_6L0H     (*(volatile __near unsigned char  *)0x445)
#define RMD0_6L0H      (*(volatile __near unsigned char  *)0x445)
#define RMD0_6L1H      (*(volatile __near unsigned char  *)0x445)
#define RMD8_6H1       (*(volatile __near unsigned short *)0x446)
#define GAFLM2H0       (*(volatile __near unsigned short *)0x446)
#define RFDF0_6H1      (*(volatile __near unsigned short *)0x446)
#define GAFLM2H1       (*(volatile __near unsigned short *)0x446)
#define RMD8_6H0       (*(volatile __near unsigned short *)0x446)
#define RFDF0_6H0      (*(volatile __near unsigned short *)0x446)
#define RMD0_6H1       (*(volatile __near unsigned short *)0x446)
#define RMD0_6H0       (*(volatile __near unsigned short *)0x446)
#define RMD8_6H1L      (*(volatile __near unsigned char  *)0x446)
#define RMD8_6H0L      (*(volatile __near unsigned char  *)0x446)
#define GAFLM2H0L      (*(volatile __near unsigned char  *)0x446)
#define RFDF0_6H1L     (*(volatile __near unsigned char  *)0x446)
#define RFDF0_6H0L     (*(volatile __near unsigned char  *)0x446)
#define GAFLM2H1L      (*(volatile __near unsigned char  *)0x446)
#define RMD0_6H1L      (*(volatile __near unsigned char  *)0x446)
#define RMD0_6H0L      (*(volatile __near unsigned char  *)0x446)
#define RMD8_6H1H      (*(volatile __near unsigned char  *)0x447)
#define RMD8_6H0H      (*(volatile __near unsigned char  *)0x447)
#define RFDF0_6H1H     (*(volatile __near unsigned char  *)0x447)
#define GAFLM2H1H      (*(volatile __near unsigned char  *)0x447)
#define GAFLM2H0H      (*(volatile __near unsigned char  *)0x447)
#define RFDF0_6H0H     (*(volatile __near unsigned char  *)0x447)
#define RMD0_6H1H      (*(volatile __near unsigned char  *)0x447)
#define RMD0_6H0H      (*(volatile __near unsigned char  *)0x447)
#define RMD8_7L1       (*(volatile __near unsigned short *)0x448)
#define RMD8_7L0       (*(volatile __near unsigned short *)0x448)
#define RMD0_7L1       (*(volatile __near unsigned short *)0x448)
#define RMD0_7L0       (*(volatile __near unsigned short *)0x448)
#define GAFLP02L0      (*(volatile __near unsigned short *)0x448)
#define GAFLP02L1      (*(volatile __near unsigned short *)0x448)
#define RFDF0_7L0      (*(volatile __near unsigned short *)0x448)
#define RFDF0_7L1      (*(volatile __near unsigned short *)0x448)
#define RMD8_7L0L      (*(volatile __near unsigned char  *)0x448)
#define RMD8_7L1L      (*(volatile __near unsigned char  *)0x448)
#define RMD0_7L1L      (*(volatile __near unsigned char  *)0x448)
#define RMD0_7L0L      (*(volatile __near unsigned char  *)0x448)
#define GAFLP02L1L     (*(volatile __near unsigned char  *)0x448)
#define RFDF0_7L0L     (*(volatile __near unsigned char  *)0x448)
#define RFDF0_7L1L     (*(volatile __near unsigned char  *)0x448)
#define GAFLP02L0L     (*(volatile __near unsigned char  *)0x448)
#define RMD8_7L1H      (*(volatile __near unsigned char  *)0x449)
#define RMD8_7L0H      (*(volatile __near unsigned char  *)0x449)
#define RMD0_7L1H      (*(volatile __near unsigned char  *)0x449)
#define RMD0_7L0H      (*(volatile __near unsigned char  *)0x449)
#define GAFLP02L0H     (*(volatile __near unsigned char  *)0x449)
#define GAFLP02L1H     (*(volatile __near unsigned char  *)0x449)
#define RFDF0_7L0H     (*(volatile __near unsigned char  *)0x449)
#define RFDF0_7L1H     (*(volatile __near unsigned char  *)0x449)
#define RMD8_7H0       (*(volatile __near unsigned short *)0x44A)
#define RMD8_7H1       (*(volatile __near unsigned short *)0x44A)
#define RFDF0_7H0      (*(volatile __near unsigned short *)0x44A)
#define RMD0_7H0       (*(volatile __near unsigned short *)0x44A)
#define RMD0_7H1       (*(volatile __near unsigned short *)0x44A)
#define GAFLP02H1      (*(volatile __near unsigned short *)0x44A)
#define RFDF0_7H1      (*(volatile __near unsigned short *)0x44A)
#define GAFLP02H0      (*(volatile __near unsigned short *)0x44A)
#define RMD8_7H0L      (*(volatile __near unsigned char  *)0x44A)
#define RMD8_7H1L      (*(volatile __near unsigned char  *)0x44A)
#define RMD0_7H0L      (*(volatile __near unsigned char  *)0x44A)
#define RMD0_7H1L      (*(volatile __near unsigned char  *)0x44A)
#define RFDF0_7H1L     (*(volatile __near unsigned char  *)0x44A)
#define GAFLP02H1L     (*(volatile __near unsigned char  *)0x44A)
#define RFDF0_7H0L     (*(volatile __near unsigned char  *)0x44A)
#define GAFLP02H0L     (*(volatile __near unsigned char  *)0x44A)
#define RMD8_7H0H      (*(volatile __near unsigned char  *)0x44B)
#define RMD8_7H1H      (*(volatile __near unsigned char  *)0x44B)
#define RMD0_7H0H      (*(volatile __near unsigned char  *)0x44B)
#define RMD0_7H1H      (*(volatile __near unsigned char  *)0x44B)
#define RFDF0_7H1H     (*(volatile __near unsigned char  *)0x44B)
#define RFDF0_7H0H     (*(volatile __near unsigned char  *)0x44B)
#define GAFLP02H1H     (*(volatile __near unsigned char  *)0x44B)
#define GAFLP02H0H     (*(volatile __near unsigned char  *)0x44B)
#define RMD8_8L0       (*(volatile __near unsigned short *)0x44C)
#define RMD8_8L1       (*(volatile __near unsigned short *)0x44C)
#define RMD0_8L1       (*(volatile __near unsigned short *)0x44C)
#define RMD0_8L0       (*(volatile __near unsigned short *)0x44C)
#define GAFLP12L0      (*(volatile __near unsigned short *)0x44C)
#define GAFLP12L1      (*(volatile __near unsigned short *)0x44C)
#define RFDF0_8L0      (*(volatile __near unsigned short *)0x44C)
#define RFDF0_8L1      (*(volatile __near unsigned short *)0x44C)
#define RMD8_8L0L      (*(volatile __near unsigned char  *)0x44C)
#define RMD8_8L1L      (*(volatile __near unsigned char  *)0x44C)
#define RMD0_8L0L      (*(volatile __near unsigned char  *)0x44C)
#define GAFLP12L0L     (*(volatile __near unsigned char  *)0x44C)
#define GAFLP12L1L     (*(volatile __near unsigned char  *)0x44C)
#define RMD0_8L1L      (*(volatile __near unsigned char  *)0x44C)
#define RFDF0_8L0L     (*(volatile __near unsigned char  *)0x44C)
#define RFDF0_8L1L     (*(volatile __near unsigned char  *)0x44C)
#define RMD8_8L1H      (*(volatile __near unsigned char  *)0x44D)
#define RMD8_8L0H      (*(volatile __near unsigned char  *)0x44D)
#define RMD0_8L1H      (*(volatile __near unsigned char  *)0x44D)
#define RMD0_8L0H      (*(volatile __near unsigned char  *)0x44D)
#define GAFLP12L0H     (*(volatile __near unsigned char  *)0x44D)
#define GAFLP12L1H     (*(volatile __near unsigned char  *)0x44D)
#define RFDF0_8L0H     (*(volatile __near unsigned char  *)0x44D)
#define RFDF0_8L1H     (*(volatile __near unsigned char  *)0x44D)
#define RMD8_8H1       (*(volatile __near unsigned short *)0x44E)
#define RMD8_8H0       (*(volatile __near unsigned short *)0x44E)
#define RMD0_8H0       (*(volatile __near unsigned short *)0x44E)
#define RMD0_8H1       (*(volatile __near unsigned short *)0x44E)
#define RFDF0_8H1      (*(volatile __near unsigned short *)0x44E)
#define RFDF0_8H0      (*(volatile __near unsigned short *)0x44E)
#define RMD8_8H0L      (*(volatile __near unsigned char  *)0x44E)
#define RMD8_8H1L      (*(volatile __near unsigned char  *)0x44E)
#define RMD0_8H1L      (*(volatile __near unsigned char  *)0x44E)
#define RMD0_8H0L      (*(volatile __near unsigned char  *)0x44E)
#define RFDF0_8H1L     (*(volatile __near unsigned char  *)0x44E)
#define RFDF0_8H0L     (*(volatile __near unsigned char  *)0x44E)
#define RMD8_8H0H      (*(volatile __near unsigned char  *)0x44F)
#define RMD8_8H1H      (*(volatile __near unsigned char  *)0x44F)
#define RMD0_8H1H      (*(volatile __near unsigned char  *)0x44F)
#define RMD0_8H0H      (*(volatile __near unsigned char  *)0x44F)
#define RFDF0_8H0H     (*(volatile __near unsigned char  *)0x44F)
#define RFDF0_8H1H     (*(volatile __near unsigned char  *)0x44F)
#define RMD8_9L0       (*(volatile __near unsigned short *)0x450)
#define RMD8_9L1       (*(volatile __near unsigned short *)0x450)
#define GAFLID3L1      (*(volatile __near unsigned short *)0x450)
#define GAFLID3L0      (*(volatile __near unsigned short *)0x450)
#define RMD0_9L0       (*(volatile __near unsigned short *)0x450)
#define RMD0_9L1       (*(volatile __near unsigned short *)0x450)
#define RFDF0_9L1      (*(volatile __near unsigned short *)0x450)
#define RFDF0_9L0      (*(volatile __near unsigned short *)0x450)
#define RMD8_9L1L      (*(volatile __near unsigned char  *)0x450)
#define RMD8_9L0L      (*(volatile __near unsigned char  *)0x450)
#define GAFLID3L1L     (*(volatile __near unsigned char  *)0x450)
#define GAFLID3L0L     (*(volatile __near unsigned char  *)0x450)
#define RMD0_9L0L      (*(volatile __near unsigned char  *)0x450)
#define RMD0_9L1L      (*(volatile __near unsigned char  *)0x450)
#define RFDF0_9L0L     (*(volatile __near unsigned char  *)0x450)
#define RFDF0_9L1L     (*(volatile __near unsigned char  *)0x450)
#define RMD8_9L0H      (*(volatile __near unsigned char  *)0x451)
#define RMD8_9L1H      (*(volatile __near unsigned char  *)0x451)
#define GAFLID3L1H     (*(volatile __near unsigned char  *)0x451)
#define GAFLID3L0H     (*(volatile __near unsigned char  *)0x451)
#define RMD0_9L1H      (*(volatile __near unsigned char  *)0x451)
#define RMD0_9L0H      (*(volatile __near unsigned char  *)0x451)
#define RFDF0_9L0H     (*(volatile __near unsigned char  *)0x451)
#define RFDF0_9L1H     (*(volatile __near unsigned char  *)0x451)
#define RMD8_9H1       (*(volatile __near unsigned short *)0x452)
#define GAFLID3H1      (*(volatile __near unsigned short *)0x452)
#define GAFLID3H0      (*(volatile __near unsigned short *)0x452)
#define RMD8_9H0       (*(volatile __near unsigned short *)0x452)
#define RMD0_9H1       (*(volatile __near unsigned short *)0x452)
#define RMD0_9H0       (*(volatile __near unsigned short *)0x452)
#define RFDF0_9H1      (*(volatile __near unsigned short *)0x452)
#define RFDF0_9H0      (*(volatile __near unsigned short *)0x452)
#define RMD8_9H0L      (*(volatile __near unsigned char  *)0x452)
#define GAFLID3H1L     (*(volatile __near unsigned char  *)0x452)
#define GAFLID3H0L     (*(volatile __near unsigned char  *)0x452)
#define RMD8_9H1L      (*(volatile __near unsigned char  *)0x452)
#define RMD0_9H0L      (*(volatile __near unsigned char  *)0x452)
#define RMD0_9H1L      (*(volatile __near unsigned char  *)0x452)
#define RFDF0_9H0L     (*(volatile __near unsigned char  *)0x452)
#define RFDF0_9H1L     (*(volatile __near unsigned char  *)0x452)
#define GAFLID3H1H     (*(volatile __near unsigned char  *)0x453)
#define RMD8_9H0H      (*(volatile __near unsigned char  *)0x453)
#define RMD8_9H1H      (*(volatile __near unsigned char  *)0x453)
#define GAFLID3H0H     (*(volatile __near unsigned char  *)0x453)
#define RMD0_9H0H      (*(volatile __near unsigned char  *)0x453)
#define RMD0_9H1H      (*(volatile __near unsigned char  *)0x453)
#define RFDF0_9H1H     (*(volatile __near unsigned char  *)0x453)
#define RFDF0_9H0H     (*(volatile __near unsigned char  *)0x453)
#define RFDF0_10L1     (*(volatile __near unsigned short *)0x454)
#define GAFLM3L0       (*(volatile __near unsigned short *)0x454)
#define GAFLM3L1       (*(volatile __near unsigned short *)0x454)
#define RMD8_10L0      (*(volatile __near unsigned short *)0x454)
#define RFDF0_10L0     (*(volatile __near unsigned short *)0x454)
#define RMD8_10L1      (*(volatile __near unsigned short *)0x454)
#define RMD0_10L0      (*(volatile __near unsigned short *)0x454)
#define RMD0_10L1      (*(volatile __near unsigned short *)0x454)
#define GAFLM3L0L      (*(volatile __near unsigned char  *)0x454)
#define GAFLM3L1L      (*(volatile __near unsigned char  *)0x454)
#define RFDF0_10L1L    (*(volatile __near unsigned char  *)0x454)
#define RMD8_10L0L     (*(volatile __near unsigned char  *)0x454)
#define RFDF0_10L0L    (*(volatile __near unsigned char  *)0x454)
#define RMD8_10L1L     (*(volatile __near unsigned char  *)0x454)
#define RMD0_10L0L     (*(volatile __near unsigned char  *)0x454)
#define RMD0_10L1L     (*(volatile __near unsigned char  *)0x454)
#define RMD8_10L1H     (*(volatile __near unsigned char  *)0x455)
#define RMD8_10L0H     (*(volatile __near unsigned char  *)0x455)
#define GAFLM3L1H      (*(volatile __near unsigned char  *)0x455)
#define GAFLM3L0H      (*(volatile __near unsigned char  *)0x455)
#define RFDF0_10L0H    (*(volatile __near unsigned char  *)0x455)
#define RFDF0_10L1H    (*(volatile __near unsigned char  *)0x455)
#define RMD0_10L0H     (*(volatile __near unsigned char  *)0x455)
#define RMD0_10L1H     (*(volatile __near unsigned char  *)0x455)
#define RFDF0_10H1     (*(volatile __near unsigned short *)0x456)
#define GAFLM3H0       (*(volatile __near unsigned short *)0x456)
#define RMD8_10H1      (*(volatile __near unsigned short *)0x456)
#define GAFLM3H1       (*(volatile __near unsigned short *)0x456)
#define RFDF0_10H0     (*(volatile __near unsigned short *)0x456)
#define RMD8_10H0      (*(volatile __near unsigned short *)0x456)
#define RMD0_10H1      (*(volatile __near unsigned short *)0x456)
#define RMD0_10H0      (*(volatile __near unsigned short *)0x456)
#define RMD8_10H0L     (*(volatile __near unsigned char  *)0x456)
#define RFDF0_10H1L    (*(volatile __near unsigned char  *)0x456)
#define RFDF0_10H0L    (*(volatile __near unsigned char  *)0x456)
#define GAFLM3H1L      (*(volatile __near unsigned char  *)0x456)
#define GAFLM3H0L      (*(volatile __near unsigned char  *)0x456)
#define RMD8_10H1L     (*(volatile __near unsigned char  *)0x456)
#define RMD0_10H1L     (*(volatile __near unsigned char  *)0x456)
#define RMD0_10H0L     (*(volatile __near unsigned char  *)0x456)
#define GAFLM3H0H      (*(volatile __near unsigned char  *)0x457)
#define GAFLM3H1H      (*(volatile __near unsigned char  *)0x457)
#define RFDF0_10H0H    (*(volatile __near unsigned char  *)0x457)
#define RMD8_10H0H     (*(volatile __near unsigned char  *)0x457)
#define RMD8_10H1H     (*(volatile __near unsigned char  *)0x457)
#define RFDF0_10H1H    (*(volatile __near unsigned char  *)0x457)
#define RMD0_10H1H     (*(volatile __near unsigned char  *)0x457)
#define RMD0_10H0H     (*(volatile __near unsigned char  *)0x457)
#define RFDF0_11L0     (*(volatile __near unsigned short *)0x458)
#define RFDF0_11L1     (*(volatile __near unsigned short *)0x458)
#define RMD8_11L0      (*(volatile __near unsigned short *)0x458)
#define RMD8_11L1      (*(volatile __near unsigned short *)0x458)
#define RMD0_11L0      (*(volatile __near unsigned short *)0x458)
#define RMD0_11L1      (*(volatile __near unsigned short *)0x458)
#define GAFLP03L1      (*(volatile __near unsigned short *)0x458)
#define GAFLP03L0      (*(volatile __near unsigned short *)0x458)
#define RFDF0_11L0L    (*(volatile __near unsigned char  *)0x458)
#define RFDF0_11L1L    (*(volatile __near unsigned char  *)0x458)
#define RMD8_11L0L     (*(volatile __near unsigned char  *)0x458)
#define RMD8_11L1L     (*(volatile __near unsigned char  *)0x458)
#define RMD0_11L0L     (*(volatile __near unsigned char  *)0x458)
#define RMD0_11L1L     (*(volatile __near unsigned char  *)0x458)
#define GAFLP03L1L     (*(volatile __near unsigned char  *)0x458)
#define GAFLP03L0L     (*(volatile __near unsigned char  *)0x458)
#define RFDF0_11L0H    (*(volatile __near unsigned char  *)0x459)
#define RMD8_11L1H     (*(volatile __near unsigned char  *)0x459)
#define RMD8_11L0H     (*(volatile __near unsigned char  *)0x459)
#define RFDF0_11L1H    (*(volatile __near unsigned char  *)0x459)
#define RMD0_11L0H     (*(volatile __near unsigned char  *)0x459)
#define RMD0_11L1H     (*(volatile __near unsigned char  *)0x459)
#define GAFLP03L1H     (*(volatile __near unsigned char  *)0x459)
#define GAFLP03L0H     (*(volatile __near unsigned char  *)0x459)
#define RFDF0_11H0     (*(volatile __near unsigned short *)0x45A)
#define RFDF0_11H1     (*(volatile __near unsigned short *)0x45A)
#define RMD8_11H0      (*(volatile __near unsigned short *)0x45A)
#define RMD8_11H1      (*(volatile __near unsigned short *)0x45A)
#define RMD0_11H0      (*(volatile __near unsigned short *)0x45A)
#define RMD0_11H1      (*(volatile __near unsigned short *)0x45A)
#define GAFLP03H0      (*(volatile __near unsigned short *)0x45A)
#define GAFLP03H1      (*(volatile __near unsigned short *)0x45A)
#define RMD8_11H1L     (*(volatile __near unsigned char  *)0x45A)
#define RFDF0_11H0L    (*(volatile __near unsigned char  *)0x45A)
#define RFDF0_11H1L    (*(volatile __near unsigned char  *)0x45A)
#define RMD8_11H0L     (*(volatile __near unsigned char  *)0x45A)
#define RMD0_11H0L     (*(volatile __near unsigned char  *)0x45A)
#define RMD0_11H1L     (*(volatile __near unsigned char  *)0x45A)
#define GAFLP03H0L     (*(volatile __near unsigned char  *)0x45A)
#define GAFLP03H1L     (*(volatile __near unsigned char  *)0x45A)
#define RFDF0_11H0H    (*(volatile __near unsigned char  *)0x45B)
#define RFDF0_11H1H    (*(volatile __near unsigned char  *)0x45B)
#define RMD8_11H0H     (*(volatile __near unsigned char  *)0x45B)
#define RMD8_11H1H     (*(volatile __near unsigned char  *)0x45B)
#define RMD0_11H0H     (*(volatile __near unsigned char  *)0x45B)
#define RMD0_11H1H     (*(volatile __near unsigned char  *)0x45B)
#define GAFLP03H1H     (*(volatile __near unsigned char  *)0x45B)
#define GAFLP03H0H     (*(volatile __near unsigned char  *)0x45B)
#define RFDF0_12L0     (*(volatile __near unsigned short *)0x45C)
#define RFDF0_12L1     (*(volatile __near unsigned short *)0x45C)
#define RMD8_12L0      (*(volatile __near unsigned short *)0x45C)
#define RMD8_12L1      (*(volatile __near unsigned short *)0x45C)
#define GAFLP13L1      (*(volatile __near unsigned short *)0x45C)
#define GAFLP13L0      (*(volatile __near unsigned short *)0x45C)
#define RMD0_12L0      (*(volatile __near unsigned short *)0x45C)
#define RMD0_12L1      (*(volatile __near unsigned short *)0x45C)
#define RMD8_12L0L     (*(volatile __near unsigned char  *)0x45C)
#define RFDF0_12L1L    (*(volatile __near unsigned char  *)0x45C)
#define RMD8_12L1L     (*(volatile __near unsigned char  *)0x45C)
#define RFDF0_12L0L    (*(volatile __near unsigned char  *)0x45C)
#define GAFLP13L0L     (*(volatile __near unsigned char  *)0x45C)
#define GAFLP13L1L     (*(volatile __near unsigned char  *)0x45C)
#define RMD0_12L0L     (*(volatile __near unsigned char  *)0x45C)
#define RMD0_12L1L     (*(volatile __near unsigned char  *)0x45C)
#define RMD8_12L0H     (*(volatile __near unsigned char  *)0x45D)
#define RMD8_12L1H     (*(volatile __near unsigned char  *)0x45D)
#define RFDF0_12L0H    (*(volatile __near unsigned char  *)0x45D)
#define RFDF0_12L1H    (*(volatile __near unsigned char  *)0x45D)
#define GAFLP13L1H     (*(volatile __near unsigned char  *)0x45D)
#define GAFLP13L0H     (*(volatile __near unsigned char  *)0x45D)
#define RMD0_12L1H     (*(volatile __near unsigned char  *)0x45D)
#define RMD0_12L0H     (*(volatile __near unsigned char  *)0x45D)
#define RMD8_12H1      (*(volatile __near unsigned short *)0x45E)
#define RMD8_12H0      (*(volatile __near unsigned short *)0x45E)
#define RFDF0_12H0     (*(volatile __near unsigned short *)0x45E)
#define RFDF0_12H1     (*(volatile __near unsigned short *)0x45E)
#define RMD0_12H0      (*(volatile __near unsigned short *)0x45E)
#define RMD0_12H1      (*(volatile __near unsigned short *)0x45E)
#define RMD8_12H1L     (*(volatile __near unsigned char  *)0x45E)
#define RMD8_12H0L     (*(volatile __near unsigned char  *)0x45E)
#define RFDF0_12H0L    (*(volatile __near unsigned char  *)0x45E)
#define RFDF0_12H1L    (*(volatile __near unsigned char  *)0x45E)
#define RMD0_12H1L     (*(volatile __near unsigned char  *)0x45E)
#define RMD0_12H0L     (*(volatile __near unsigned char  *)0x45E)
#define RMD8_12H0H     (*(volatile __near unsigned char  *)0x45F)
#define RFDF0_12H0H    (*(volatile __near unsigned char  *)0x45F)
#define RMD8_12H1H     (*(volatile __near unsigned char  *)0x45F)
#define RFDF0_12H1H    (*(volatile __near unsigned char  *)0x45F)
#define RMD0_12H1H     (*(volatile __near unsigned char  *)0x45F)
#define RMD0_12H0H     (*(volatile __near unsigned char  *)0x45F)
#define RFDF0_13L1     (*(volatile __near unsigned short *)0x460)
#define RMD8_13L0      (*(volatile __near unsigned short *)0x460)
#define RMD8_13L1      (*(volatile __near unsigned short *)0x460)
#define GAFLID4L0      (*(volatile __near unsigned short *)0x460)
#define GAFLID4L1      (*(volatile __near unsigned short *)0x460)
#define RFDF0_13L0     (*(volatile __near unsigned short *)0x460)
#define RMD0_13L0      (*(volatile __near unsigned short *)0x460)
#define RMD0_13L1      (*(volatile __near unsigned short *)0x460)
#define RMD8_13L1L     (*(volatile __near unsigned char  *)0x460)
#define RFDF0_13L1L    (*(volatile __near unsigned char  *)0x460)
#define GAFLID4L0L     (*(volatile __near unsigned char  *)0x460)
#define GAFLID4L1L     (*(volatile __near unsigned char  *)0x460)
#define RMD8_13L0L     (*(volatile __near unsigned char  *)0x460)
#define RFDF0_13L0L    (*(volatile __near unsigned char  *)0x460)
#define RMD0_13L0L     (*(volatile __near unsigned char  *)0x460)
#define RMD0_13L1L     (*(volatile __near unsigned char  *)0x460)
#define RMD8_13L1H     (*(volatile __near unsigned char  *)0x461)
#define GAFLID4L0H     (*(volatile __near unsigned char  *)0x461)
#define GAFLID4L1H     (*(volatile __near unsigned char  *)0x461)
#define RMD8_13L0H     (*(volatile __near unsigned char  *)0x461)
#define RFDF0_13L1H    (*(volatile __near unsigned char  *)0x461)
#define RFDF0_13L0H    (*(volatile __near unsigned char  *)0x461)
#define RMD0_13L0H     (*(volatile __near unsigned char  *)0x461)
#define RMD0_13L1H     (*(volatile __near unsigned char  *)0x461)
#define RFDF0_13H1     (*(volatile __near unsigned short *)0x462)
#define RMD8_13H1      (*(volatile __near unsigned short *)0x462)
#define RFDF0_13H0     (*(volatile __near unsigned short *)0x462)
#define RMD8_13H0      (*(volatile __near unsigned short *)0x462)
#define GAFLID4H0      (*(volatile __near unsigned short *)0x462)
#define GAFLID4H1      (*(volatile __near unsigned short *)0x462)
#define RMD0_13H1      (*(volatile __near unsigned short *)0x462)
#define RMD0_13H0      (*(volatile __near unsigned short *)0x462)
#define RFDF0_13H1L    (*(volatile __near unsigned char  *)0x462)
#define RFDF0_13H0L    (*(volatile __near unsigned char  *)0x462)
#define RMD8_13H0L     (*(volatile __near unsigned char  *)0x462)
#define RMD8_13H1L     (*(volatile __near unsigned char  *)0x462)
#define GAFLID4H0L     (*(volatile __near unsigned char  *)0x462)
#define GAFLID4H1L     (*(volatile __near unsigned char  *)0x462)
#define RMD0_13H1L     (*(volatile __near unsigned char  *)0x462)
#define RMD0_13H0L     (*(volatile __near unsigned char  *)0x462)
#define RFDF0_13H1H    (*(volatile __near unsigned char  *)0x463)
#define RFDF0_13H0H    (*(volatile __near unsigned char  *)0x463)
#define RMD8_13H0H     (*(volatile __near unsigned char  *)0x463)
#define RMD8_13H1H     (*(volatile __near unsigned char  *)0x463)
#define GAFLID4H0H     (*(volatile __near unsigned char  *)0x463)
#define GAFLID4H1H     (*(volatile __near unsigned char  *)0x463)
#define RMD0_13H1H     (*(volatile __near unsigned char  *)0x463)
#define RMD0_13H0H     (*(volatile __near unsigned char  *)0x463)
#define GAFLM4L1       (*(volatile __near unsigned short *)0x464)
#define GAFLM4L0       (*(volatile __near unsigned short *)0x464)
#define RFDF0_14L0     (*(volatile __near unsigned short *)0x464)
#define RFDF0_14L1     (*(volatile __near unsigned short *)0x464)
#define RMD8_14L0      (*(volatile __near unsigned short *)0x464)
#define RMD8_14L1      (*(volatile __near unsigned short *)0x464)
#define RMD0_14L0      (*(volatile __near unsigned short *)0x464)
#define RMD0_14L1      (*(volatile __near unsigned short *)0x464)
#define RFDF0_14L1L    (*(volatile __near unsigned char  *)0x464)
#define RMD0_14L1L     (*(volatile __near unsigned char  *)0x464)
#define RMD0_14L0L     (*(volatile __near unsigned char  *)0x464)
#define RMD8_14L1L     (*(volatile __near unsigned char  *)0x464)
#define RMD8_14L0L     (*(volatile __near unsigned char  *)0x464)
#define GAFLM4L1L      (*(volatile __near unsigned char  *)0x464)
#define RFDF0_14L0L    (*(volatile __near unsigned char  *)0x464)
#define GAFLM4L0L      (*(volatile __near unsigned char  *)0x464)
#define RFDF0_14L0H    (*(volatile __near unsigned char  *)0x465)
#define RMD0_14L1H     (*(volatile __near unsigned char  *)0x465)
#define RMD0_14L0H     (*(volatile __near unsigned char  *)0x465)
#define RMD8_14L1H     (*(volatile __near unsigned char  *)0x465)
#define RMD8_14L0H     (*(volatile __near unsigned char  *)0x465)
#define GAFLM4L0H      (*(volatile __near unsigned char  *)0x465)
#define RFDF0_14L1H    (*(volatile __near unsigned char  *)0x465)
#define GAFLM4L1H      (*(volatile __near unsigned char  *)0x465)
#define RMD8_14H0      (*(volatile __near unsigned short *)0x466)
#define RFDF0_14H1     (*(volatile __near unsigned short *)0x466)
#define RMD0_14H0      (*(volatile __near unsigned short *)0x466)
#define RMD8_14H1      (*(volatile __near unsigned short *)0x466)
#define RMD0_14H1      (*(volatile __near unsigned short *)0x466)
#define RFDF0_14H0     (*(volatile __near unsigned short *)0x466)
#define GAFLM4H0       (*(volatile __near unsigned short *)0x466)
#define GAFLM4H1       (*(volatile __near unsigned short *)0x466)
#define RMD8_14H1L     (*(volatile __near unsigned char  *)0x466)
#define RMD8_14H0L     (*(volatile __near unsigned char  *)0x466)
#define RMD0_14H0L     (*(volatile __near unsigned char  *)0x466)
#define RFDF0_14H1L    (*(volatile __near unsigned char  *)0x466)
#define RMD0_14H1L     (*(volatile __near unsigned char  *)0x466)
#define RFDF0_14H0L    (*(volatile __near unsigned char  *)0x466)
#define GAFLM4H1L      (*(volatile __near unsigned char  *)0x466)
#define GAFLM4H0L      (*(volatile __near unsigned char  *)0x466)
#define RMD8_14H0H     (*(volatile __near unsigned char  *)0x467)
#define RFDF0_14H1H    (*(volatile __near unsigned char  *)0x467)
#define RMD0_14H0H     (*(volatile __near unsigned char  *)0x467)
#define RMD0_14H1H     (*(volatile __near unsigned char  *)0x467)
#define RMD8_14H1H     (*(volatile __near unsigned char  *)0x467)
#define RFDF0_14H0H    (*(volatile __near unsigned char  *)0x467)
#define GAFLM4H1H      (*(volatile __near unsigned char  *)0x467)
#define GAFLM4H0H      (*(volatile __near unsigned char  *)0x467)
#define RFDF0_15L0     (*(volatile __near unsigned short *)0x468)
#define GAFLP04L1      (*(volatile __near unsigned short *)0x468)
#define RFDF0_15L1     (*(volatile __near unsigned short *)0x468)
#define RMD0_15L1      (*(volatile __near unsigned short *)0x468)
#define RMD0_15L0      (*(volatile __near unsigned short *)0x468)
#define RMD8_15L0      (*(volatile __near unsigned short *)0x468)
#define RMD8_15L1      (*(volatile __near unsigned short *)0x468)
#define GAFLP04L0      (*(volatile __near unsigned short *)0x468)
#define GAFLP04L0L     (*(volatile __near unsigned char  *)0x468)
#define GAFLP04L1L     (*(volatile __near unsigned char  *)0x468)
#define RMD0_15L1L     (*(volatile __near unsigned char  *)0x468)
#define RMD0_15L0L     (*(volatile __near unsigned char  *)0x468)
#define RFDF0_15L0L    (*(volatile __near unsigned char  *)0x468)
#define RFDF0_15L1L    (*(volatile __near unsigned char  *)0x468)
#define RMD8_15L1L     (*(volatile __near unsigned char  *)0x468)
#define RMD8_15L0L     (*(volatile __near unsigned char  *)0x468)
#define RMD0_15L1H     (*(volatile __near unsigned char  *)0x469)
#define RMD0_15L0H     (*(volatile __near unsigned char  *)0x469)
#define RFDF0_15L0H    (*(volatile __near unsigned char  *)0x469)
#define GAFLP04L1H     (*(volatile __near unsigned char  *)0x469)
#define GAFLP04L0H     (*(volatile __near unsigned char  *)0x469)
#define RFDF0_15L1H    (*(volatile __near unsigned char  *)0x469)
#define RMD8_15L0H     (*(volatile __near unsigned char  *)0x469)
#define RMD8_15L1H     (*(volatile __near unsigned char  *)0x469)
#define RMD8_15H0      (*(volatile __near unsigned short *)0x46A)
#define RMD0_15H0      (*(volatile __near unsigned short *)0x46A)
#define RFDF0_15H1     (*(volatile __near unsigned short *)0x46A)
#define RFDF0_15H0     (*(volatile __near unsigned short *)0x46A)
#define RMD8_15H1      (*(volatile __near unsigned short *)0x46A)
#define RMD0_15H1      (*(volatile __near unsigned short *)0x46A)
#define GAFLP04H1      (*(volatile __near unsigned short *)0x46A)
#define GAFLP04H0      (*(volatile __near unsigned short *)0x46A)
#define RFDF0_15H0L    (*(volatile __near unsigned char  *)0x46A)
#define RMD0_15H1L     (*(volatile __near unsigned char  *)0x46A)
#define RMD0_15H0L     (*(volatile __near unsigned char  *)0x46A)
#define RFDF0_15H1L    (*(volatile __near unsigned char  *)0x46A)
#define GAFLP04H0L     (*(volatile __near unsigned char  *)0x46A)
#define RMD8_15H0L     (*(volatile __near unsigned char  *)0x46A)
#define GAFLP04H1L     (*(volatile __near unsigned char  *)0x46A)
#define RMD8_15H1L     (*(volatile __near unsigned char  *)0x46A)
#define GAFLP04H0H     (*(volatile __near unsigned char  *)0x46B)
#define GAFLP04H1H     (*(volatile __near unsigned char  *)0x46B)
#define RMD0_15H1H     (*(volatile __near unsigned char  *)0x46B)
#define RMD0_15H0H     (*(volatile __near unsigned char  *)0x46B)
#define RFDF0_15H0H    (*(volatile __near unsigned char  *)0x46B)
#define RFDF0_15H1H    (*(volatile __near unsigned char  *)0x46B)
#define RMD8_15H1H     (*(volatile __near unsigned char  *)0x46B)
#define RMD8_15H0H     (*(volatile __near unsigned char  *)0x46B)
#define GAFLP14L1      (*(volatile __near unsigned short *)0x46C)
#define GAFLP14L0      (*(volatile __near unsigned short *)0x46C)
#define RMID9L0        (*(volatile __near unsigned short *)0x46C)
#define RMID1L0        (*(volatile __near unsigned short *)0x46C)
#define RMID1L1        (*(volatile __near unsigned short *)0x46C)
#define RMID9L1        (*(volatile __near unsigned short *)0x46C)
#define RFID1L0        (*(volatile __near unsigned short *)0x46C)
#define RFID1L1        (*(volatile __near unsigned short *)0x46C)
#define GAFLP14L1L     (*(volatile __near unsigned char  *)0x46C)
#define GAFLP14L0L     (*(volatile __near unsigned char  *)0x46C)
#define RMID9L0L       (*(volatile __near unsigned char  *)0x46C)
#define RMID1L1L       (*(volatile __near unsigned char  *)0x46C)
#define RMID1L0L       (*(volatile __near unsigned char  *)0x46C)
#define RMID9L1L       (*(volatile __near unsigned char  *)0x46C)
#define RFID1L1L       (*(volatile __near unsigned char  *)0x46C)
#define RFID1L0L       (*(volatile __near unsigned char  *)0x46C)
#define GAFLP14L1H     (*(volatile __near unsigned char  *)0x46D)
#define GAFLP14L0H     (*(volatile __near unsigned char  *)0x46D)
#define RMID9L0H       (*(volatile __near unsigned char  *)0x46D)
#define RMID1L1H       (*(volatile __near unsigned char  *)0x46D)
#define RMID9L1H       (*(volatile __near unsigned char  *)0x46D)
#define RMID1L0H       (*(volatile __near unsigned char  *)0x46D)
#define RFID1L1H       (*(volatile __near unsigned char  *)0x46D)
#define RFID1L0H       (*(volatile __near unsigned char  *)0x46D)
#define RMID9H1        (*(volatile __near unsigned short *)0x46E)
#define RMID9H0        (*(volatile __near unsigned short *)0x46E)
#define RMID1H0        (*(volatile __near unsigned short *)0x46E)
#define RMID1H1        (*(volatile __near unsigned short *)0x46E)
#define RFID1H1        (*(volatile __near unsigned short *)0x46E)
#define RFID1H0        (*(volatile __near unsigned short *)0x46E)
#define RMID9H1L       (*(volatile __near unsigned char  *)0x46E)
#define RMID1H1L       (*(volatile __near unsigned char  *)0x46E)
#define RMID1H0L       (*(volatile __near unsigned char  *)0x46E)
#define RMID9H0L       (*(volatile __near unsigned char  *)0x46E)
#define RFID1H1L       (*(volatile __near unsigned char  *)0x46E)
#define RFID1H0L       (*(volatile __near unsigned char  *)0x46E)
#define RFID1H0H       (*(volatile __near unsigned char  *)0x46F)
#define RMID9H1H       (*(volatile __near unsigned char  *)0x46F)
#define RMID1H1H       (*(volatile __near unsigned char  *)0x46F)
#define RMID1H0H       (*(volatile __near unsigned char  *)0x46F)
#define RFID1H1H       (*(volatile __near unsigned char  *)0x46F)
#define RMID9H0H       (*(volatile __near unsigned char  *)0x46F)
#define RMPTR1L1       (*(volatile __near unsigned short *)0x470)
#define RFPTR1L0       (*(volatile __near unsigned short *)0x470)
#define RFPTR1L1       (*(volatile __near unsigned short *)0x470)
#define GAFLID5L0      (*(volatile __near unsigned short *)0x470)
#define RMPTR9L0       (*(volatile __near unsigned short *)0x470)
#define RMPTR1L0       (*(volatile __near unsigned short *)0x470)
#define GAFLID5L1      (*(volatile __near unsigned short *)0x470)
#define RMPTR9L1       (*(volatile __near unsigned short *)0x470)
#define RMPTR9L1L      (*(volatile __near unsigned char  *)0x470)
#define GAFLID5L0L     (*(volatile __near unsigned char  *)0x470)
#define RFPTR1L0L      (*(volatile __near unsigned char  *)0x470)
#define RMPTR1L0L      (*(volatile __near unsigned char  *)0x470)
#define RFPTR1L1L      (*(volatile __near unsigned char  *)0x470)
#define RMPTR1L1L      (*(volatile __near unsigned char  *)0x470)
#define GAFLID5L1L     (*(volatile __near unsigned char  *)0x470)
#define RMPTR9L0L      (*(volatile __near unsigned char  *)0x470)
#define RMPTR9L1H      (*(volatile __near unsigned char  *)0x471)
#define GAFLID5L1H     (*(volatile __near unsigned char  *)0x471)
#define RMPTR9L0H      (*(volatile __near unsigned char  *)0x471)
#define RMPTR1L1H      (*(volatile __near unsigned char  *)0x471)
#define RMPTR1L0H      (*(volatile __near unsigned char  *)0x471)
#define RFPTR1L0H      (*(volatile __near unsigned char  *)0x471)
#define RFPTR1L1H      (*(volatile __near unsigned char  *)0x471)
#define GAFLID5L0H     (*(volatile __near unsigned char  *)0x471)
#define RMPTR1H0       (*(volatile __near unsigned short *)0x472)
#define RMPTR1H1       (*(volatile __near unsigned short *)0x472)
#define RMPTR9H0       (*(volatile __near unsigned short *)0x472)
#define RMPTR9H1       (*(volatile __near unsigned short *)0x472)
#define GAFLID5H1      (*(volatile __near unsigned short *)0x472)
#define GAFLID5H0      (*(volatile __near unsigned short *)0x472)
#define RFPTR1H0       (*(volatile __near unsigned short *)0x472)
#define RFPTR1H1       (*(volatile __near unsigned short *)0x472)
#define GAFLID5H1L     (*(volatile __near unsigned char  *)0x472)
#define GAFLID5H0L     (*(volatile __near unsigned char  *)0x472)
#define RMPTR1H0H      (*(volatile __near unsigned char  *)0x473)
#define RMPTR1H1H      (*(volatile __near unsigned char  *)0x473)
#define RMPTR9H0H      (*(volatile __near unsigned char  *)0x473)
#define GAFLID5H0H     (*(volatile __near unsigned char  *)0x473)
#define RFPTR1H0H      (*(volatile __near unsigned char  *)0x473)
#define RFPTR1H1H      (*(volatile __near unsigned char  *)0x473)
#define RMPTR9H1H      (*(volatile __near unsigned char  *)0x473)
#define GAFLID5H1H     (*(volatile __near unsigned char  *)0x473)
#define RFFDSTS1L1     (*(volatile __near unsigned short *)0x474)
#define GAFLM5L0       (*(volatile __near unsigned short *)0x474)
#define GAFLM5L1       (*(volatile __near unsigned short *)0x474)
#define RMSTS1L1       (*(volatile __near unsigned short *)0x474)
#define RMSTS1L0       (*(volatile __near unsigned short *)0x474)
#define RMSTS9L0       (*(volatile __near unsigned short *)0x474)
#define RFFDSTS1L0     (*(volatile __near unsigned short *)0x474)
#define RMSTS9L1       (*(volatile __near unsigned short *)0x474)
#define RMSTS1L1L      (*(volatile __near unsigned char  *)0x474)
#define RMSTS1L0L      (*(volatile __near unsigned char  *)0x474)
#define RFFDSTS1L0L    (*(volatile __near unsigned char  *)0x474)
#define RFFDSTS1L1L    (*(volatile __near unsigned char  *)0x474)
#define RMSTS9L1L      (*(volatile __near unsigned char  *)0x474)
#define RMSTS9L0L      (*(volatile __near unsigned char  *)0x474)
#define GAFLM5L1L      (*(volatile __near unsigned char  *)0x474)
#define GAFLM5L0L      (*(volatile __near unsigned char  *)0x474)
#define RFFDSTS1L1H    (*(volatile __near unsigned char  *)0x475)
#define RMSTS9L1H      (*(volatile __near unsigned char  *)0x475)
#define RFFDSTS1L0H    (*(volatile __near unsigned char  *)0x475)
#define RMSTS9L0H      (*(volatile __near unsigned char  *)0x475)
#define RMSTS1L0H      (*(volatile __near unsigned char  *)0x475)
#define RMSTS1L1H      (*(volatile __near unsigned char  *)0x475)
#define GAFLM5L1H      (*(volatile __near unsigned char  *)0x475)
#define GAFLM5L0H      (*(volatile __near unsigned char  *)0x475)
#define RMSTS1H1       (*(volatile __near unsigned short *)0x476)
#define RMSTS1H0       (*(volatile __near unsigned short *)0x476)
#define RMSTS9H1       (*(volatile __near unsigned short *)0x476)
#define RFFDSTS1H1     (*(volatile __near unsigned short *)0x476)
#define GAFLM5H0       (*(volatile __near unsigned short *)0x476)
#define RFFDSTS1H0     (*(volatile __near unsigned short *)0x476)
#define RMSTS9H0       (*(volatile __near unsigned short *)0x476)
#define GAFLM5H1       (*(volatile __near unsigned short *)0x476)
#define RMSTS9H0L      (*(volatile __near unsigned char  *)0x476)
#define RMSTS9H1L      (*(volatile __near unsigned char  *)0x476)
#define RFFDSTS1H1L    (*(volatile __near unsigned char  *)0x476)
#define RMSTS1H1L      (*(volatile __near unsigned char  *)0x476)
#define GAFLM5H0L      (*(volatile __near unsigned char  *)0x476)
#define RMSTS1H0L      (*(volatile __near unsigned char  *)0x476)
#define RFFDSTS1H0L    (*(volatile __near unsigned char  *)0x476)
#define GAFLM5H1L      (*(volatile __near unsigned char  *)0x476)
#define GAFLM5H1H      (*(volatile __near unsigned char  *)0x477)
#define RMSTS9H1H      (*(volatile __near unsigned char  *)0x477)
#define RMSTS1H0H      (*(volatile __near unsigned char  *)0x477)
#define RMSTS9H0H      (*(volatile __near unsigned char  *)0x477)
#define RFFDSTS1H1H    (*(volatile __near unsigned char  *)0x477)
#define RMSTS1H1H      (*(volatile __near unsigned char  *)0x477)
#define GAFLM5H0H      (*(volatile __near unsigned char  *)0x477)
#define RFFDSTS1H0H    (*(volatile __near unsigned char  *)0x477)
#define RMD9_0L0       (*(volatile __near unsigned short *)0x478)
#define RMD9_0L1       (*(volatile __near unsigned short *)0x478)
#define RMD1_0L0       (*(volatile __near unsigned short *)0x478)
#define GAFLP05L1      (*(volatile __near unsigned short *)0x478)
#define RMD1_0L1       (*(volatile __near unsigned short *)0x478)
#define GAFLP05L0      (*(volatile __near unsigned short *)0x478)
#define RFDF1_0L1      (*(volatile __near unsigned short *)0x478)
#define RFDF1_0L0      (*(volatile __near unsigned short *)0x478)
#define RMD9_0L0L      (*(volatile __near unsigned char  *)0x478)
#define RMD9_0L1L      (*(volatile __near unsigned char  *)0x478)
#define GAFLP05L1L     (*(volatile __near unsigned char  *)0x478)
#define GAFLP05L0L     (*(volatile __near unsigned char  *)0x478)
#define RMD1_0L0L      (*(volatile __near unsigned char  *)0x478)
#define RMD1_0L1L      (*(volatile __near unsigned char  *)0x478)
#define RFDF1_0L0L     (*(volatile __near unsigned char  *)0x478)
#define RFDF1_0L1L     (*(volatile __near unsigned char  *)0x478)
#define RMD9_0L0H      (*(volatile __near unsigned char  *)0x479)
#define RMD1_0L0H      (*(volatile __near unsigned char  *)0x479)
#define GAFLP05L1H     (*(volatile __near unsigned char  *)0x479)
#define RMD9_0L1H      (*(volatile __near unsigned char  *)0x479)
#define GAFLP05L0H     (*(volatile __near unsigned char  *)0x479)
#define RMD1_0L1H      (*(volatile __near unsigned char  *)0x479)
#define RFDF1_0L1H     (*(volatile __near unsigned char  *)0x479)
#define RFDF1_0L0H     (*(volatile __near unsigned char  *)0x479)
#define RMD1_0H0       (*(volatile __near unsigned short *)0x47A)
#define RMD1_0H1       (*(volatile __near unsigned short *)0x47A)
#define GAFLP05H1      (*(volatile __near unsigned short *)0x47A)
#define GAFLP05H0      (*(volatile __near unsigned short *)0x47A)
#define RMD9_0H0       (*(volatile __near unsigned short *)0x47A)
#define RMD9_0H1       (*(volatile __near unsigned short *)0x47A)
#define RFDF1_0H0      (*(volatile __near unsigned short *)0x47A)
#define RFDF1_0H1      (*(volatile __near unsigned short *)0x47A)
#define RMD1_0H0L      (*(volatile __near unsigned char  *)0x47A)
#define GAFLP05H0L     (*(volatile __near unsigned char  *)0x47A)
#define RMD9_0H0L      (*(volatile __near unsigned char  *)0x47A)
#define RMD9_0H1L      (*(volatile __near unsigned char  *)0x47A)
#define GAFLP05H1L     (*(volatile __near unsigned char  *)0x47A)
#define RMD1_0H1L      (*(volatile __near unsigned char  *)0x47A)
#define RFDF1_0H0L     (*(volatile __near unsigned char  *)0x47A)
#define RFDF1_0H1L     (*(volatile __near unsigned char  *)0x47A)
#define RMD9_0H0H      (*(volatile __near unsigned char  *)0x47B)
#define GAFLP05H1H     (*(volatile __near unsigned char  *)0x47B)
#define GAFLP05H0H     (*(volatile __near unsigned char  *)0x47B)
#define RMD9_0H1H      (*(volatile __near unsigned char  *)0x47B)
#define RMD1_0H0H      (*(volatile __near unsigned char  *)0x47B)
#define RMD1_0H1H      (*(volatile __near unsigned char  *)0x47B)
#define RFDF1_0H0H     (*(volatile __near unsigned char  *)0x47B)
#define RFDF1_0H1H     (*(volatile __near unsigned char  *)0x47B)
#define RMD9_1L1       (*(volatile __near unsigned short *)0x47C)
#define RMD1_1L1       (*(volatile __near unsigned short *)0x47C)
#define RMD9_1L0       (*(volatile __near unsigned short *)0x47C)
#define RMD1_1L0       (*(volatile __near unsigned short *)0x47C)
#define GAFLP15L0      (*(volatile __near unsigned short *)0x47C)
#define GAFLP15L1      (*(volatile __near unsigned short *)0x47C)
#define RFDF1_1L1      (*(volatile __near unsigned short *)0x47C)
#define RFDF1_1L0      (*(volatile __near unsigned short *)0x47C)
#define GAFLP15L1L     (*(volatile __near unsigned char  *)0x47C)
#define RMD1_1L1L      (*(volatile __near unsigned char  *)0x47C)
#define GAFLP15L0L     (*(volatile __near unsigned char  *)0x47C)
#define RMD9_1L0L      (*(volatile __near unsigned char  *)0x47C)
#define RMD9_1L1L      (*(volatile __near unsigned char  *)0x47C)
#define RMD1_1L0L      (*(volatile __near unsigned char  *)0x47C)
#define RFDF1_1L1L     (*(volatile __near unsigned char  *)0x47C)
#define RFDF1_1L0L     (*(volatile __near unsigned char  *)0x47C)
#define RMD1_1L1H      (*(volatile __near unsigned char  *)0x47D)
#define RMD9_1L0H      (*(volatile __near unsigned char  *)0x47D)
#define GAFLP15L1H     (*(volatile __near unsigned char  *)0x47D)
#define RMD9_1L1H      (*(volatile __near unsigned char  *)0x47D)
#define GAFLP15L0H     (*(volatile __near unsigned char  *)0x47D)
#define RMD1_1L0H      (*(volatile __near unsigned char  *)0x47D)
#define RFDF1_1L1H     (*(volatile __near unsigned char  *)0x47D)
#define RFDF1_1L0H     (*(volatile __near unsigned char  *)0x47D)
#define RMD9_1H0       (*(volatile __near unsigned short *)0x47E)
#define RMD9_1H1       (*(volatile __near unsigned short *)0x47E)
#define RMD1_1H0       (*(volatile __near unsigned short *)0x47E)
#define RMD1_1H1       (*(volatile __near unsigned short *)0x47E)
#define RFDF1_1H1      (*(volatile __near unsigned short *)0x47E)
#define RFDF1_1H0      (*(volatile __near unsigned short *)0x47E)
#define RMD1_1H0L      (*(volatile __near unsigned char  *)0x47E)
#define RMD9_1H0L      (*(volatile __near unsigned char  *)0x47E)
#define RMD9_1H1L      (*(volatile __near unsigned char  *)0x47E)
#define RMD1_1H1L      (*(volatile __near unsigned char  *)0x47E)
#define RFDF1_1H0L     (*(volatile __near unsigned char  *)0x47E)
#define RFDF1_1H1L     (*(volatile __near unsigned char  *)0x47E)
#define RMD9_1H1H      (*(volatile __near unsigned char  *)0x47F)
#define RMD1_1H1H      (*(volatile __near unsigned char  *)0x47F)
#define RMD1_1H0H      (*(volatile __near unsigned char  *)0x47F)
#define RMD9_1H0H      (*(volatile __near unsigned char  *)0x47F)
#define RFDF1_1H1H     (*(volatile __near unsigned char  *)0x47F)
#define RFDF1_1H0H     (*(volatile __near unsigned char  *)0x47F)
#define RMD1_2L0       (*(volatile __near unsigned short *)0x480)
#define RMD9_2L0       (*(volatile __near unsigned short *)0x480)
#define RMD9_2L1       (*(volatile __near unsigned short *)0x480)
#define RMD1_2L1       (*(volatile __near unsigned short *)0x480)
#define GAFLID6L0      (*(volatile __near unsigned short *)0x480)
#define RFDF1_2L0      (*(volatile __near unsigned short *)0x480)
#define GAFLID6L1      (*(volatile __near unsigned short *)0x480)
#define RFDF1_2L1      (*(volatile __near unsigned short *)0x480)
#define RMD1_2L0L      (*(volatile __near unsigned char  *)0x480)
#define RMD9_2L1L      (*(volatile __near unsigned char  *)0x480)
#define RMD1_2L1L      (*(volatile __near unsigned char  *)0x480)
#define RMD9_2L0L      (*(volatile __near unsigned char  *)0x480)
#define GAFLID6L0L     (*(volatile __near unsigned char  *)0x480)
#define GAFLID6L1L     (*(volatile __near unsigned char  *)0x480)
#define RFDF1_2L1L     (*(volatile __near unsigned char  *)0x480)
#define RFDF1_2L0L     (*(volatile __near unsigned char  *)0x480)
#define RMD1_2L1H      (*(volatile __near unsigned char  *)0x481)
#define RMD9_2L0H      (*(volatile __near unsigned char  *)0x481)
#define RMD9_2L1H      (*(volatile __near unsigned char  *)0x481)
#define RMD1_2L0H      (*(volatile __near unsigned char  *)0x481)
#define GAFLID6L0H     (*(volatile __near unsigned char  *)0x481)
#define GAFLID6L1H     (*(volatile __near unsigned char  *)0x481)
#define RFDF1_2L0H     (*(volatile __near unsigned char  *)0x481)
#define RFDF1_2L1H     (*(volatile __near unsigned char  *)0x481)
#define RMD1_2H1       (*(volatile __near unsigned short *)0x482)
#define RMD9_2H1       (*(volatile __near unsigned short *)0x482)
#define RMD9_2H0       (*(volatile __near unsigned short *)0x482)
#define RMD1_2H0       (*(volatile __near unsigned short *)0x482)
#define GAFLID6H0      (*(volatile __near unsigned short *)0x482)
#define GAFLID6H1      (*(volatile __near unsigned short *)0x482)
#define RFDF1_2H1      (*(volatile __near unsigned short *)0x482)
#define RFDF1_2H0      (*(volatile __near unsigned short *)0x482)
#define RMD9_2H1L      (*(volatile __near unsigned char  *)0x482)
#define RMD9_2H0L      (*(volatile __near unsigned char  *)0x482)
#define RMD1_2H0L      (*(volatile __near unsigned char  *)0x482)
#define RMD1_2H1L      (*(volatile __near unsigned char  *)0x482)
#define RFDF1_2H1L     (*(volatile __near unsigned char  *)0x482)
#define GAFLID6H0L     (*(volatile __near unsigned char  *)0x482)
#define GAFLID6H1L     (*(volatile __near unsigned char  *)0x482)
#define RFDF1_2H0L     (*(volatile __near unsigned char  *)0x482)
#define RMD9_2H1H      (*(volatile __near unsigned char  *)0x483)
#define RMD1_2H1H      (*(volatile __near unsigned char  *)0x483)
#define RMD9_2H0H      (*(volatile __near unsigned char  *)0x483)
#define RMD1_2H0H      (*(volatile __near unsigned char  *)0x483)
#define RFDF1_2H1H     (*(volatile __near unsigned char  *)0x483)
#define RFDF1_2H0H     (*(volatile __near unsigned char  *)0x483)
#define GAFLID6H1H     (*(volatile __near unsigned char  *)0x483)
#define GAFLID6H0H     (*(volatile __near unsigned char  *)0x483)
#define RMD9_3L1       (*(volatile __near unsigned short *)0x484)
#define RMD9_3L0       (*(volatile __near unsigned short *)0x484)
#define RMD1_3L1       (*(volatile __near unsigned short *)0x484)
#define RMD1_3L0       (*(volatile __near unsigned short *)0x484)
#define GAFLM6L1       (*(volatile __near unsigned short *)0x484)
#define RFDF1_3L0      (*(volatile __near unsigned short *)0x484)
#define GAFLM6L0       (*(volatile __near unsigned short *)0x484)
#define RFDF1_3L1      (*(volatile __near unsigned short *)0x484)
#define RMD9_3L0L      (*(volatile __near unsigned char  *)0x484)
#define RMD1_3L1L      (*(volatile __near unsigned char  *)0x484)
#define RMD1_3L0L      (*(volatile __near unsigned char  *)0x484)
#define GAFLM6L1L      (*(volatile __near unsigned char  *)0x484)
#define RMD9_3L1L      (*(volatile __near unsigned char  *)0x484)
#define GAFLM6L0L      (*(volatile __near unsigned char  *)0x484)
#define RFDF1_3L1L     (*(volatile __near unsigned char  *)0x484)
#define RFDF1_3L0L     (*(volatile __near unsigned char  *)0x484)
#define RMD9_3L0H      (*(volatile __near unsigned char  *)0x485)
#define RMD9_3L1H      (*(volatile __near unsigned char  *)0x485)
#define RMD1_3L1H      (*(volatile __near unsigned char  *)0x485)
#define RMD1_3L0H      (*(volatile __near unsigned char  *)0x485)
#define GAFLM6L1H      (*(volatile __near unsigned char  *)0x485)
#define GAFLM6L0H      (*(volatile __near unsigned char  *)0x485)
#define RFDF1_3L0H     (*(volatile __near unsigned char  *)0x485)
#define RFDF1_3L1H     (*(volatile __near unsigned char  *)0x485)
#define GAFLM6H1       (*(volatile __near unsigned short *)0x486)
#define GAFLM6H0       (*(volatile __near unsigned short *)0x486)
#define RMD9_3H1       (*(volatile __near unsigned short *)0x486)
#define RFDF1_3H1      (*(volatile __near unsigned short *)0x486)
#define RMD1_3H0       (*(volatile __near unsigned short *)0x486)
#define RMD9_3H0       (*(volatile __near unsigned short *)0x486)
#define RMD1_3H1       (*(volatile __near unsigned short *)0x486)
#define RFDF1_3H0      (*(volatile __near unsigned short *)0x486)
#define GAFLM6H1L      (*(volatile __near unsigned char  *)0x486)
#define GAFLM6H0L      (*(volatile __near unsigned char  *)0x486)
#define RFDF1_3H0L     (*(volatile __near unsigned char  *)0x486)
#define RMD1_3H0L      (*(volatile __near unsigned char  *)0x486)
#define RMD1_3H1L      (*(volatile __near unsigned char  *)0x486)
#define RMD9_3H0L      (*(volatile __near unsigned char  *)0x486)
#define RMD9_3H1L      (*(volatile __near unsigned char  *)0x486)
#define RFDF1_3H1L     (*(volatile __near unsigned char  *)0x486)
#define RMD9_3H1H      (*(volatile __near unsigned char  *)0x487)
#define RMD9_3H0H      (*(volatile __near unsigned char  *)0x487)
#define RMD1_3H1H      (*(volatile __near unsigned char  *)0x487)
#define RMD1_3H0H      (*(volatile __near unsigned char  *)0x487)
#define RFDF1_3H0H     (*(volatile __near unsigned char  *)0x487)
#define GAFLM6H0H      (*(volatile __near unsigned char  *)0x487)
#define GAFLM6H1H      (*(volatile __near unsigned char  *)0x487)
#define RFDF1_3H1H     (*(volatile __near unsigned char  *)0x487)
#define RFDF1_4L0      (*(volatile __near unsigned short *)0x488)
#define GAFLP06L0      (*(volatile __near unsigned short *)0x488)
#define RMD9_4L1       (*(volatile __near unsigned short *)0x488)
#define GAFLP06L1      (*(volatile __near unsigned short *)0x488)
#define RFDF1_4L1      (*(volatile __near unsigned short *)0x488)
#define RMD9_4L0       (*(volatile __near unsigned short *)0x488)
#define RMD1_4L1       (*(volatile __near unsigned short *)0x488)
#define RMD1_4L0       (*(volatile __near unsigned short *)0x488)
#define RMD9_4L0L      (*(volatile __near unsigned char  *)0x488)
#define RMD1_4L1L      (*(volatile __near unsigned char  *)0x488)
#define RMD9_4L1L      (*(volatile __near unsigned char  *)0x488)
#define GAFLP06L0L     (*(volatile __near unsigned char  *)0x488)
#define GAFLP06L1L     (*(volatile __near unsigned char  *)0x488)
#define RMD1_4L0L      (*(volatile __near unsigned char  *)0x488)
#define RFDF1_4L0L     (*(volatile __near unsigned char  *)0x488)
#define RFDF1_4L1L     (*(volatile __near unsigned char  *)0x488)
#define RFDF1_4L0H     (*(volatile __near unsigned char  *)0x489)
#define RMD1_4L1H      (*(volatile __near unsigned char  *)0x489)
#define RMD9_4L0H      (*(volatile __near unsigned char  *)0x489)
#define GAFLP06L1H     (*(volatile __near unsigned char  *)0x489)
#define GAFLP06L0H     (*(volatile __near unsigned char  *)0x489)
#define RMD1_4L0H      (*(volatile __near unsigned char  *)0x489)
#define RMD9_4L1H      (*(volatile __near unsigned char  *)0x489)
#define RFDF1_4L1H     (*(volatile __near unsigned char  *)0x489)
#define RMD1_4H1       (*(volatile __near unsigned short *)0x48A)
#define RMD9_4H0       (*(volatile __near unsigned short *)0x48A)
#define RFDF1_4H1      (*(volatile __near unsigned short *)0x48A)
#define RMD9_4H1       (*(volatile __near unsigned short *)0x48A)
#define RFDF1_4H0      (*(volatile __near unsigned short *)0x48A)
#define GAFLP06H0      (*(volatile __near unsigned short *)0x48A)
#define RMD1_4H0       (*(volatile __near unsigned short *)0x48A)
#define GAFLP06H1      (*(volatile __near unsigned short *)0x48A)
#define GAFLP06H0L     (*(volatile __near unsigned char  *)0x48A)
#define RMD1_4H1L      (*(volatile __near unsigned char  *)0x48A)
#define RMD1_4H0L      (*(volatile __near unsigned char  *)0x48A)
#define GAFLP06H1L     (*(volatile __near unsigned char  *)0x48A)
#define RFDF1_4H0L     (*(volatile __near unsigned char  *)0x48A)
#define RMD9_4H0L      (*(volatile __near unsigned char  *)0x48A)
#define RMD9_4H1L      (*(volatile __near unsigned char  *)0x48A)
#define RFDF1_4H1L     (*(volatile __near unsigned char  *)0x48A)
#define RMD1_4H1H      (*(volatile __near unsigned char  *)0x48B)
#define RMD1_4H0H      (*(volatile __near unsigned char  *)0x48B)
#define GAFLP06H0H     (*(volatile __near unsigned char  *)0x48B)
#define GAFLP06H1H     (*(volatile __near unsigned char  *)0x48B)
#define RFDF1_4H0H     (*(volatile __near unsigned char  *)0x48B)
#define RMD9_4H0H      (*(volatile __near unsigned char  *)0x48B)
#define RMD9_4H1H      (*(volatile __near unsigned char  *)0x48B)
#define RFDF1_4H1H     (*(volatile __near unsigned char  *)0x48B)
#define RFDF1_5L0      (*(volatile __near unsigned short *)0x48C)
#define RFDF1_5L1      (*(volatile __near unsigned short *)0x48C)
#define GAFLP16L0      (*(volatile __near unsigned short *)0x48C)
#define GAFLP16L1      (*(volatile __near unsigned short *)0x48C)
#define RMD1_5L0       (*(volatile __near unsigned short *)0x48C)
#define RMD9_5L1       (*(volatile __near unsigned short *)0x48C)
#define RMD1_5L1       (*(volatile __near unsigned short *)0x48C)
#define RMD9_5L0       (*(volatile __near unsigned short *)0x48C)
#define RFDF1_5L0L     (*(volatile __near unsigned char  *)0x48C)
#define RFDF1_5L1L     (*(volatile __near unsigned char  *)0x48C)
#define RMD9_5L0L      (*(volatile __near unsigned char  *)0x48C)
#define GAFLP16L0L     (*(volatile __near unsigned char  *)0x48C)
#define RMD9_5L1L      (*(volatile __near unsigned char  *)0x48C)
#define RMD1_5L0L      (*(volatile __near unsigned char  *)0x48C)
#define RMD1_5L1L      (*(volatile __near unsigned char  *)0x48C)
#define GAFLP16L1L     (*(volatile __near unsigned char  *)0x48C)
#define RFDF1_5L0H     (*(volatile __near unsigned char  *)0x48D)
#define RFDF1_5L1H     (*(volatile __near unsigned char  *)0x48D)
#define RMD1_5L0H      (*(volatile __near unsigned char  *)0x48D)
#define RMD9_5L1H      (*(volatile __near unsigned char  *)0x48D)
#define RMD9_5L0H      (*(volatile __near unsigned char  *)0x48D)
#define RMD1_5L1H      (*(volatile __near unsigned char  *)0x48D)
#define GAFLP16L1H     (*(volatile __near unsigned char  *)0x48D)
#define GAFLP16L0H     (*(volatile __near unsigned char  *)0x48D)
#define RFDF1_5H1      (*(volatile __near unsigned short *)0x48E)
#define RFDF1_5H0      (*(volatile __near unsigned short *)0x48E)
#define RMD9_5H1       (*(volatile __near unsigned short *)0x48E)
#define RMD9_5H0       (*(volatile __near unsigned short *)0x48E)
#define RMD1_5H1       (*(volatile __near unsigned short *)0x48E)
#define RMD1_5H0       (*(volatile __near unsigned short *)0x48E)
#define RFDF1_5H1L     (*(volatile __near unsigned char  *)0x48E)
#define RFDF1_5H0L     (*(volatile __near unsigned char  *)0x48E)
#define RMD9_5H1L      (*(volatile __near unsigned char  *)0x48E)
#define RMD9_5H0L      (*(volatile __near unsigned char  *)0x48E)
#define RMD1_5H0L      (*(volatile __near unsigned char  *)0x48E)
#define RMD1_5H1L      (*(volatile __near unsigned char  *)0x48E)
#define RFDF1_5H1H     (*(volatile __near unsigned char  *)0x48F)
#define RFDF1_5H0H     (*(volatile __near unsigned char  *)0x48F)
#define RMD9_5H1H      (*(volatile __near unsigned char  *)0x48F)
#define RMD9_5H0H      (*(volatile __near unsigned char  *)0x48F)
#define RMD1_5H1H      (*(volatile __near unsigned char  *)0x48F)
#define RMD1_5H0H      (*(volatile __near unsigned char  *)0x48F)
#define RFDF1_6L1      (*(volatile __near unsigned short *)0x490)
#define RFDF1_6L0      (*(volatile __near unsigned short *)0x490)
#define RMD1_6L0       (*(volatile __near unsigned short *)0x490)
#define RMD9_6L1       (*(volatile __near unsigned short *)0x490)
#define GAFLID7L0      (*(volatile __near unsigned short *)0x490)
#define GAFLID7L1      (*(volatile __near unsigned short *)0x490)
#define RMD1_6L1       (*(volatile __near unsigned short *)0x490)
#define RMD9_6L0       (*(volatile __near unsigned short *)0x490)
#define RFDF1_6L1L     (*(volatile __near unsigned char  *)0x490)
#define RFDF1_6L0L     (*(volatile __near unsigned char  *)0x490)
#define GAFLID7L0L     (*(volatile __near unsigned char  *)0x490)
#define GAFLID7L1L     (*(volatile __near unsigned char  *)0x490)
#define RMD1_6L1L      (*(volatile __near unsigned char  *)0x490)
#define RMD1_6L0L      (*(volatile __near unsigned char  *)0x490)
#define RMD9_6L1L      (*(volatile __near unsigned char  *)0x490)
#define RMD9_6L0L      (*(volatile __near unsigned char  *)0x490)
#define RFDF1_6L0H     (*(volatile __near unsigned char  *)0x491)
#define RFDF1_6L1H     (*(volatile __near unsigned char  *)0x491)
#define RMD1_6L0H      (*(volatile __near unsigned char  *)0x491)
#define GAFLID7L0H     (*(volatile __near unsigned char  *)0x491)
#define GAFLID7L1H     (*(volatile __near unsigned char  *)0x491)
#define RMD9_6L1H      (*(volatile __near unsigned char  *)0x491)
#define RMD1_6L1H      (*(volatile __near unsigned char  *)0x491)
#define RMD9_6L0H      (*(volatile __near unsigned char  *)0x491)
#define RFDF1_6H1      (*(volatile __near unsigned short *)0x492)
#define RFDF1_6H0      (*(volatile __near unsigned short *)0x492)
#define RMD1_6H1       (*(volatile __near unsigned short *)0x492)
#define RMD1_6H0       (*(volatile __near unsigned short *)0x492)
#define RMD9_6H1       (*(volatile __near unsigned short *)0x492)
#define RMD9_6H0       (*(volatile __near unsigned short *)0x492)
#define GAFLID7H1      (*(volatile __near unsigned short *)0x492)
#define GAFLID7H0      (*(volatile __near unsigned short *)0x492)
#define RFDF1_6H1L     (*(volatile __near unsigned char  *)0x492)
#define RFDF1_6H0L     (*(volatile __near unsigned char  *)0x492)
#define RMD1_6H0L      (*(volatile __near unsigned char  *)0x492)
#define GAFLID7H1L     (*(volatile __near unsigned char  *)0x492)
#define RMD1_6H1L      (*(volatile __near unsigned char  *)0x492)
#define RMD9_6H0L      (*(volatile __near unsigned char  *)0x492)
#define GAFLID7H0L     (*(volatile __near unsigned char  *)0x492)
#define RMD9_6H1L      (*(volatile __near unsigned char  *)0x492)
#define RFDF1_6H0H     (*(volatile __near unsigned char  *)0x493)
#define RFDF1_6H1H     (*(volatile __near unsigned char  *)0x493)
#define RMD1_6H0H      (*(volatile __near unsigned char  *)0x493)
#define RMD1_6H1H      (*(volatile __near unsigned char  *)0x493)
#define GAFLID7H1H     (*(volatile __near unsigned char  *)0x493)
#define RMD9_6H0H      (*(volatile __near unsigned char  *)0x493)
#define RMD9_6H1H      (*(volatile __near unsigned char  *)0x493)
#define GAFLID7H0H     (*(volatile __near unsigned char  *)0x493)
#define RFDF1_7L1      (*(volatile __near unsigned short *)0x494)
#define RFDF1_7L0      (*(volatile __near unsigned short *)0x494)
#define RMD1_7L0       (*(volatile __near unsigned short *)0x494)
#define RMD1_7L1       (*(volatile __near unsigned short *)0x494)
#define GAFLM7L1       (*(volatile __near unsigned short *)0x494)
#define GAFLM7L0       (*(volatile __near unsigned short *)0x494)
#define RMD9_7L0       (*(volatile __near unsigned short *)0x494)
#define RMD9_7L1       (*(volatile __near unsigned short *)0x494)
#define RFDF1_7L0L     (*(volatile __near unsigned char  *)0x494)
#define RFDF1_7L1L     (*(volatile __near unsigned char  *)0x494)
#define RMD1_7L1L      (*(volatile __near unsigned char  *)0x494)
#define GAFLM7L0L      (*(volatile __near unsigned char  *)0x494)
#define RMD1_7L0L      (*(volatile __near unsigned char  *)0x494)
#define GAFLM7L1L      (*(volatile __near unsigned char  *)0x494)
#define RMD9_7L0L      (*(volatile __near unsigned char  *)0x494)
#define RMD9_7L1L      (*(volatile __near unsigned char  *)0x494)
#define RFDF1_7L0H     (*(volatile __near unsigned char  *)0x495)
#define RFDF1_7L1H     (*(volatile __near unsigned char  *)0x495)
#define GAFLM7L1H      (*(volatile __near unsigned char  *)0x495)
#define RMD1_7L1H      (*(volatile __near unsigned char  *)0x495)
#define RMD1_7L0H      (*(volatile __near unsigned char  *)0x495)
#define GAFLM7L0H      (*(volatile __near unsigned char  *)0x495)
#define RMD9_7L1H      (*(volatile __near unsigned char  *)0x495)
#define RMD9_7L0H      (*(volatile __near unsigned char  *)0x495)
#define RFDF1_7H1      (*(volatile __near unsigned short *)0x496)
#define RFDF1_7H0      (*(volatile __near unsigned short *)0x496)
#define GAFLM7H1       (*(volatile __near unsigned short *)0x496)
#define GAFLM7H0       (*(volatile __near unsigned short *)0x496)
#define RMD1_7H0       (*(volatile __near unsigned short *)0x496)
#define RMD1_7H1       (*(volatile __near unsigned short *)0x496)
#define RMD9_7H0       (*(volatile __near unsigned short *)0x496)
#define RMD9_7H1       (*(volatile __near unsigned short *)0x496)
#define RFDF1_7H0L     (*(volatile __near unsigned char  *)0x496)
#define RFDF1_7H1L     (*(volatile __near unsigned char  *)0x496)
#define GAFLM7H1L      (*(volatile __near unsigned char  *)0x496)
#define GAFLM7H0L      (*(volatile __near unsigned char  *)0x496)
#define RMD1_7H0L      (*(volatile __near unsigned char  *)0x496)
#define RMD1_7H1L      (*(volatile __near unsigned char  *)0x496)
#define RMD9_7H0L      (*(volatile __near unsigned char  *)0x496)
#define RMD9_7H1L      (*(volatile __near unsigned char  *)0x496)
#define RFDF1_7H0H     (*(volatile __near unsigned char  *)0x497)
#define RFDF1_7H1H     (*(volatile __near unsigned char  *)0x497)
#define GAFLM7H1H      (*(volatile __near unsigned char  *)0x497)
#define GAFLM7H0H      (*(volatile __near unsigned char  *)0x497)
#define RMD1_7H0H      (*(volatile __near unsigned char  *)0x497)
#define RMD1_7H1H      (*(volatile __near unsigned char  *)0x497)
#define RMD9_7H0H      (*(volatile __near unsigned char  *)0x497)
#define RMD9_7H1H      (*(volatile __near unsigned char  *)0x497)
#define RFDF1_8L0      (*(volatile __near unsigned short *)0x498)
#define RFDF1_8L1      (*(volatile __near unsigned short *)0x498)
#define GAFLP07L0      (*(volatile __near unsigned short *)0x498)
#define GAFLP07L1      (*(volatile __near unsigned short *)0x498)
#define RMD1_8L0       (*(volatile __near unsigned short *)0x498)
#define RMD1_8L1       (*(volatile __near unsigned short *)0x498)
#define RMD9_8L0       (*(volatile __near unsigned short *)0x498)
#define RMD9_8L1       (*(volatile __near unsigned short *)0x498)
#define RFDF1_8L0L     (*(volatile __near unsigned char  *)0x498)
#define RFDF1_8L1L     (*(volatile __near unsigned char  *)0x498)
#define GAFLP07L1L     (*(volatile __near unsigned char  *)0x498)
#define RMD1_8L0L      (*(volatile __near unsigned char  *)0x498)
#define RMD1_8L1L      (*(volatile __near unsigned char  *)0x498)
#define GAFLP07L0L     (*(volatile __near unsigned char  *)0x498)
#define RMD9_8L1L      (*(volatile __near unsigned char  *)0x498)
#define RMD9_8L0L      (*(volatile __near unsigned char  *)0x498)
#define RFDF1_8L0H     (*(volatile __near unsigned char  *)0x499)
#define RFDF1_8L1H     (*(volatile __near unsigned char  *)0x499)
#define GAFLP07L1H     (*(volatile __near unsigned char  *)0x499)
#define RMD1_8L1H      (*(volatile __near unsigned char  *)0x499)
#define GAFLP07L0H     (*(volatile __near unsigned char  *)0x499)
#define RMD1_8L0H      (*(volatile __near unsigned char  *)0x499)
#define RMD9_8L1H      (*(volatile __near unsigned char  *)0x499)
#define RMD9_8L0H      (*(volatile __near unsigned char  *)0x499)
#define RFDF1_8H0      (*(volatile __near unsigned short *)0x49A)
#define RFDF1_8H1      (*(volatile __near unsigned short *)0x49A)
#define RMD1_8H0       (*(volatile __near unsigned short *)0x49A)
#define RMD1_8H1       (*(volatile __near unsigned short *)0x49A)
#define GAFLP07H0      (*(volatile __near unsigned short *)0x49A)
#define GAFLP07H1      (*(volatile __near unsigned short *)0x49A)
#define RMD9_8H1       (*(volatile __near unsigned short *)0x49A)
#define RMD9_8H0       (*(volatile __near unsigned short *)0x49A)
#define RFDF1_8H0L     (*(volatile __near unsigned char  *)0x49A)
#define RFDF1_8H1L     (*(volatile __near unsigned char  *)0x49A)
#define RMD1_8H0L      (*(volatile __near unsigned char  *)0x49A)
#define RMD1_8H1L      (*(volatile __near unsigned char  *)0x49A)
#define GAFLP07H1L     (*(volatile __near unsigned char  *)0x49A)
#define GAFLP07H0L     (*(volatile __near unsigned char  *)0x49A)
#define RMD9_8H1L      (*(volatile __near unsigned char  *)0x49A)
#define RMD9_8H0L      (*(volatile __near unsigned char  *)0x49A)
#define RFDF1_8H1H     (*(volatile __near unsigned char  *)0x49B)
#define RFDF1_8H0H     (*(volatile __near unsigned char  *)0x49B)
#define RMD1_8H0H      (*(volatile __near unsigned char  *)0x49B)
#define RMD1_8H1H      (*(volatile __near unsigned char  *)0x49B)
#define GAFLP07H0H     (*(volatile __near unsigned char  *)0x49B)
#define GAFLP07H1H     (*(volatile __near unsigned char  *)0x49B)
#define RMD9_8H1H      (*(volatile __near unsigned char  *)0x49B)
#define RMD9_8H0H      (*(volatile __near unsigned char  *)0x49B)
#define RFDF1_9L1      (*(volatile __near unsigned short *)0x49C)
#define RFDF1_9L0      (*(volatile __near unsigned short *)0x49C)
#define GAFLP17L1      (*(volatile __near unsigned short *)0x49C)
#define GAFLP17L0      (*(volatile __near unsigned short *)0x49C)
#define RMD1_9L1       (*(volatile __near unsigned short *)0x49C)
#define RMD1_9L0       (*(volatile __near unsigned short *)0x49C)
#define RMD9_9L0       (*(volatile __near unsigned short *)0x49C)
#define RMD9_9L1       (*(volatile __near unsigned short *)0x49C)
#define RFDF1_9L0L     (*(volatile __near unsigned char  *)0x49C)
#define RFDF1_9L1L     (*(volatile __near unsigned char  *)0x49C)
#define GAFLP17L0L     (*(volatile __near unsigned char  *)0x49C)
#define GAFLP17L1L     (*(volatile __near unsigned char  *)0x49C)
#define RMD1_9L0L      (*(volatile __near unsigned char  *)0x49C)
#define RMD1_9L1L      (*(volatile __near unsigned char  *)0x49C)
#define RMD9_9L1L      (*(volatile __near unsigned char  *)0x49C)
#define RMD9_9L0L      (*(volatile __near unsigned char  *)0x49C)
#define RFDF1_9L1H     (*(volatile __near unsigned char  *)0x49D)
#define RFDF1_9L0H     (*(volatile __near unsigned char  *)0x49D)
#define GAFLP17L1H     (*(volatile __near unsigned char  *)0x49D)
#define RMD1_9L0H      (*(volatile __near unsigned char  *)0x49D)
#define RMD1_9L1H      (*(volatile __near unsigned char  *)0x49D)
#define GAFLP17L0H     (*(volatile __near unsigned char  *)0x49D)
#define RMD9_9L1H      (*(volatile __near unsigned char  *)0x49D)
#define RMD9_9L0H      (*(volatile __near unsigned char  *)0x49D)
#define RFDF1_9H1      (*(volatile __near unsigned short *)0x49E)
#define RFDF1_9H0      (*(volatile __near unsigned short *)0x49E)
#define RMD1_9H0       (*(volatile __near unsigned short *)0x49E)
#define RMD1_9H1       (*(volatile __near unsigned short *)0x49E)
#define RMD9_9H1       (*(volatile __near unsigned short *)0x49E)
#define RMD9_9H0       (*(volatile __near unsigned short *)0x49E)
#define RFDF1_9H1L     (*(volatile __near unsigned char  *)0x49E)
#define RFDF1_9H0L     (*(volatile __near unsigned char  *)0x49E)
#define RMD1_9H0L      (*(volatile __near unsigned char  *)0x49E)
#define RMD1_9H1L      (*(volatile __near unsigned char  *)0x49E)
#define RMD9_9H0L      (*(volatile __near unsigned char  *)0x49E)
#define RMD9_9H1L      (*(volatile __near unsigned char  *)0x49E)
#define RFDF1_9H1H     (*(volatile __near unsigned char  *)0x49F)
#define RFDF1_9H0H     (*(volatile __near unsigned char  *)0x49F)
#define RMD1_9H1H      (*(volatile __near unsigned char  *)0x49F)
#define RMD1_9H0H      (*(volatile __near unsigned char  *)0x49F)
#define RMD9_9H0H      (*(volatile __near unsigned char  *)0x49F)
#define RMD9_9H1H      (*(volatile __near unsigned char  *)0x49F)
#define RFDF1_10L0     (*(volatile __near unsigned short *)0x4A0)
#define RFDF1_10L1     (*(volatile __near unsigned short *)0x4A0)
#define RMD9_10L1      (*(volatile __near unsigned short *)0x4A0)
#define RMD9_10L0      (*(volatile __near unsigned short *)0x4A0)
#define RMD1_10L0      (*(volatile __near unsigned short *)0x4A0)
#define GAFLID8L0      (*(volatile __near unsigned short *)0x4A0)
#define GAFLID8L1      (*(volatile __near unsigned short *)0x4A0)
#define RMD1_10L1      (*(volatile __near unsigned short *)0x4A0)
#define RFDF1_10L0L    (*(volatile __near unsigned char  *)0x4A0)
#define RFDF1_10L1L    (*(volatile __near unsigned char  *)0x4A0)
#define RMD9_10L1L     (*(volatile __near unsigned char  *)0x4A0)
#define RMD9_10L0L     (*(volatile __near unsigned char  *)0x4A0)
#define GAFLID8L1L     (*(volatile __near unsigned char  *)0x4A0)
#define GAFLID8L0L     (*(volatile __near unsigned char  *)0x4A0)
#define RMD1_10L0L     (*(volatile __near unsigned char  *)0x4A0)
#define RMD1_10L1L     (*(volatile __near unsigned char  *)0x4A0)
#define RFDF1_10L0H    (*(volatile __near unsigned char  *)0x4A1)
#define RFDF1_10L1H    (*(volatile __near unsigned char  *)0x4A1)
#define RMD9_10L0H     (*(volatile __near unsigned char  *)0x4A1)
#define RMD9_10L1H     (*(volatile __near unsigned char  *)0x4A1)
#define GAFLID8L1H     (*(volatile __near unsigned char  *)0x4A1)
#define GAFLID8L0H     (*(volatile __near unsigned char  *)0x4A1)
#define RMD1_10L0H     (*(volatile __near unsigned char  *)0x4A1)
#define RMD1_10L1H     (*(volatile __near unsigned char  *)0x4A1)
#define RFDF1_10H0     (*(volatile __near unsigned short *)0x4A2)
#define RFDF1_10H1     (*(volatile __near unsigned short *)0x4A2)
#define RMD1_10H0      (*(volatile __near unsigned short *)0x4A2)
#define RMD1_10H1      (*(volatile __near unsigned short *)0x4A2)
#define RMD9_10H0      (*(volatile __near unsigned short *)0x4A2)
#define GAFLID8H0      (*(volatile __near unsigned short *)0x4A2)
#define RMD9_10H1      (*(volatile __near unsigned short *)0x4A2)
#define GAFLID8H1      (*(volatile __near unsigned short *)0x4A2)
#define RFDF1_10H1L    (*(volatile __near unsigned char  *)0x4A2)
#define RFDF1_10H0L    (*(volatile __near unsigned char  *)0x4A2)
#define RMD9_10H1L     (*(volatile __near unsigned char  *)0x4A2)
#define GAFLID8H0L     (*(volatile __near unsigned char  *)0x4A2)
#define RMD1_10H0L     (*(volatile __near unsigned char  *)0x4A2)
#define RMD1_10H1L     (*(volatile __near unsigned char  *)0x4A2)
#define RMD9_10H0L     (*(volatile __near unsigned char  *)0x4A2)
#define GAFLID8H1L     (*(volatile __near unsigned char  *)0x4A2)
#define RFDF1_10H0H    (*(volatile __near unsigned char  *)0x4A3)
#define RFDF1_10H1H    (*(volatile __near unsigned char  *)0x4A3)
#define RMD9_10H1H     (*(volatile __near unsigned char  *)0x4A3)
#define RMD1_10H1H     (*(volatile __near unsigned char  *)0x4A3)
#define RMD9_10H0H     (*(volatile __near unsigned char  *)0x4A3)
#define RMD1_10H0H     (*(volatile __near unsigned char  *)0x4A3)
#define GAFLID8H0H     (*(volatile __near unsigned char  *)0x4A3)
#define GAFLID8H1H     (*(volatile __near unsigned char  *)0x4A3)
#define RFDF1_11L1     (*(volatile __near unsigned short *)0x4A4)
#define RFDF1_11L0     (*(volatile __near unsigned short *)0x4A4)
#define RMD9_11L1      (*(volatile __near unsigned short *)0x4A4)
#define RMD9_11L0      (*(volatile __near unsigned short *)0x4A4)
#define GAFLM8L1       (*(volatile __near unsigned short *)0x4A4)
#define GAFLM8L0       (*(volatile __near unsigned short *)0x4A4)
#define RMD1_11L1      (*(volatile __near unsigned short *)0x4A4)
#define RMD1_11L0      (*(volatile __near unsigned short *)0x4A4)
#define RFDF1_11L1L    (*(volatile __near unsigned char  *)0x4A4)
#define RFDF1_11L0L    (*(volatile __near unsigned char  *)0x4A4)
#define RMD9_11L1L     (*(volatile __near unsigned char  *)0x4A4)
#define RMD9_11L0L     (*(volatile __near unsigned char  *)0x4A4)
#define GAFLM8L1L      (*(volatile __near unsigned char  *)0x4A4)
#define GAFLM8L0L      (*(volatile __near unsigned char  *)0x4A4)
#define RMD1_11L1L     (*(volatile __near unsigned char  *)0x4A4)
#define RMD1_11L0L     (*(volatile __near unsigned char  *)0x4A4)
#define RFDF1_11L1H    (*(volatile __near unsigned char  *)0x4A5)
#define RFDF1_11L0H    (*(volatile __near unsigned char  *)0x4A5)
#define RMD9_11L1H     (*(volatile __near unsigned char  *)0x4A5)
#define RMD9_11L0H     (*(volatile __near unsigned char  *)0x4A5)
#define GAFLM8L1H      (*(volatile __near unsigned char  *)0x4A5)
#define GAFLM8L0H      (*(volatile __near unsigned char  *)0x4A5)
#define RMD1_11L0H     (*(volatile __near unsigned char  *)0x4A5)
#define RMD1_11L1H     (*(volatile __near unsigned char  *)0x4A5)
#define RFDF1_11H1     (*(volatile __near unsigned short *)0x4A6)
#define RFDF1_11H0     (*(volatile __near unsigned short *)0x4A6)
#define RMD9_11H1      (*(volatile __near unsigned short *)0x4A6)
#define RMD9_11H0      (*(volatile __near unsigned short *)0x4A6)
#define GAFLM8H1       (*(volatile __near unsigned short *)0x4A6)
#define GAFLM8H0       (*(volatile __near unsigned short *)0x4A6)
#define RMD1_11H0      (*(volatile __near unsigned short *)0x4A6)
#define RMD1_11H1      (*(volatile __near unsigned short *)0x4A6)
#define RFDF1_11H1L    (*(volatile __near unsigned char  *)0x4A6)
#define RFDF1_11H0L    (*(volatile __near unsigned char  *)0x4A6)
#define RMD9_11H1L     (*(volatile __near unsigned char  *)0x4A6)
#define RMD9_11H0L     (*(volatile __near unsigned char  *)0x4A6)
#define GAFLM8H1L      (*(volatile __near unsigned char  *)0x4A6)
#define GAFLM8H0L      (*(volatile __near unsigned char  *)0x4A6)
#define RMD1_11H0L     (*(volatile __near unsigned char  *)0x4A6)
#define RMD1_11H1L     (*(volatile __near unsigned char  *)0x4A6)
#define RFDF1_11H0H    (*(volatile __near unsigned char  *)0x4A7)
#define RFDF1_11H1H    (*(volatile __near unsigned char  *)0x4A7)
#define RMD9_11H1H     (*(volatile __near unsigned char  *)0x4A7)
#define RMD9_11H0H     (*(volatile __near unsigned char  *)0x4A7)
#define GAFLM8H1H      (*(volatile __near unsigned char  *)0x4A7)
#define GAFLM8H0H      (*(volatile __near unsigned char  *)0x4A7)
#define RMD1_11H0H     (*(volatile __near unsigned char  *)0x4A7)
#define RMD1_11H1H     (*(volatile __near unsigned char  *)0x4A7)
#define RFDF1_12L0     (*(volatile __near unsigned short *)0x4A8)
#define RFDF1_12L1     (*(volatile __near unsigned short *)0x4A8)
#define RMD9_12L0      (*(volatile __near unsigned short *)0x4A8)
#define GAFLP08L1      (*(volatile __near unsigned short *)0x4A8)
#define RMD9_12L1      (*(volatile __near unsigned short *)0x4A8)
#define GAFLP08L0      (*(volatile __near unsigned short *)0x4A8)
#define RMD1_12L0      (*(volatile __near unsigned short *)0x4A8)
#define RMD1_12L1      (*(volatile __near unsigned short *)0x4A8)
#define RFDF1_12L0L    (*(volatile __near unsigned char  *)0x4A8)
#define RFDF1_12L1L    (*(volatile __near unsigned char  *)0x4A8)
#define RMD9_12L1L     (*(volatile __near unsigned char  *)0x4A8)
#define RMD9_12L0L     (*(volatile __near unsigned char  *)0x4A8)
#define GAFLP08L1L     (*(volatile __near unsigned char  *)0x4A8)
#define GAFLP08L0L     (*(volatile __near unsigned char  *)0x4A8)
#define RMD1_12L0L     (*(volatile __near unsigned char  *)0x4A8)
#define RMD1_12L1L     (*(volatile __near unsigned char  *)0x4A8)
#define RFDF1_12L0H    (*(volatile __near unsigned char  *)0x4A9)
#define RFDF1_12L1H    (*(volatile __near unsigned char  *)0x4A9)
#define RMD9_12L1H     (*(volatile __near unsigned char  *)0x4A9)
#define RMD9_12L0H     (*(volatile __near unsigned char  *)0x4A9)
#define GAFLP08L1H     (*(volatile __near unsigned char  *)0x4A9)
#define GAFLP08L0H     (*(volatile __near unsigned char  *)0x4A9)
#define RMD1_12L0H     (*(volatile __near unsigned char  *)0x4A9)
#define RMD1_12L1H     (*(volatile __near unsigned char  *)0x4A9)
#define RFDF1_12H1     (*(volatile __near unsigned short *)0x4AA)
#define RFDF1_12H0     (*(volatile __near unsigned short *)0x4AA)
#define RMD9_12H1      (*(volatile __near unsigned short *)0x4AA)
#define RMD9_12H0      (*(volatile __near unsigned short *)0x4AA)
#define GAFLP08H1      (*(volatile __near unsigned short *)0x4AA)
#define GAFLP08H0      (*(volatile __near unsigned short *)0x4AA)
#define RMD1_12H0      (*(volatile __near unsigned short *)0x4AA)
#define RMD1_12H1      (*(volatile __near unsigned short *)0x4AA)
#define RFDF1_12H0L    (*(volatile __near unsigned char  *)0x4AA)
#define RFDF1_12H1L    (*(volatile __near unsigned char  *)0x4AA)
#define RMD9_12H1L     (*(volatile __near unsigned char  *)0x4AA)
#define GAFLP08H1L     (*(volatile __near unsigned char  *)0x4AA)
#define RMD9_12H0L     (*(volatile __near unsigned char  *)0x4AA)
#define GAFLP08H0L     (*(volatile __near unsigned char  *)0x4AA)
#define RMD1_12H0L     (*(volatile __near unsigned char  *)0x4AA)
#define RMD1_12H1L     (*(volatile __near unsigned char  *)0x4AA)
#define RFDF1_12H1H    (*(volatile __near unsigned char  *)0x4AB)
#define RFDF1_12H0H    (*(volatile __near unsigned char  *)0x4AB)
#define RMD9_12H0H     (*(volatile __near unsigned char  *)0x4AB)
#define RMD9_12H1H     (*(volatile __near unsigned char  *)0x4AB)
#define GAFLP08H1H     (*(volatile __near unsigned char  *)0x4AB)
#define GAFLP08H0H     (*(volatile __near unsigned char  *)0x4AB)
#define RMD1_12H0H     (*(volatile __near unsigned char  *)0x4AB)
#define RMD1_12H1H     (*(volatile __near unsigned char  *)0x4AB)
#define RFDF1_13L1     (*(volatile __near unsigned short *)0x4AC)
#define RFDF1_13L0     (*(volatile __near unsigned short *)0x4AC)
#define RMD9_13L1      (*(volatile __near unsigned short *)0x4AC)
#define RMD9_13L0      (*(volatile __near unsigned short *)0x4AC)
#define RMD1_13L1      (*(volatile __near unsigned short *)0x4AC)
#define GAFLP18L1      (*(volatile __near unsigned short *)0x4AC)
#define GAFLP18L0      (*(volatile __near unsigned short *)0x4AC)
#define RMD1_13L0      (*(volatile __near unsigned short *)0x4AC)
#define RFDF1_13L1L    (*(volatile __near unsigned char  *)0x4AC)
#define RFDF1_13L0L    (*(volatile __near unsigned char  *)0x4AC)
#define RMD9_13L0L     (*(volatile __near unsigned char  *)0x4AC)
#define RMD9_13L1L     (*(volatile __near unsigned char  *)0x4AC)
#define RMD1_13L0L     (*(volatile __near unsigned char  *)0x4AC)
#define GAFLP18L1L     (*(volatile __near unsigned char  *)0x4AC)
#define GAFLP18L0L     (*(volatile __near unsigned char  *)0x4AC)
#define RMD1_13L1L     (*(volatile __near unsigned char  *)0x4AC)
#define RFDF1_13L1H    (*(volatile __near unsigned char  *)0x4AD)
#define RFDF1_13L0H    (*(volatile __near unsigned char  *)0x4AD)
#define RMD9_13L0H     (*(volatile __near unsigned char  *)0x4AD)
#define RMD9_13L1H     (*(volatile __near unsigned char  *)0x4AD)
#define RMD1_13L0H     (*(volatile __near unsigned char  *)0x4AD)
#define GAFLP18L0H     (*(volatile __near unsigned char  *)0x4AD)
#define GAFLP18L1H     (*(volatile __near unsigned char  *)0x4AD)
#define RMD1_13L1H     (*(volatile __near unsigned char  *)0x4AD)
#define RFDF1_13H1     (*(volatile __near unsigned short *)0x4AE)
#define RFDF1_13H0     (*(volatile __near unsigned short *)0x4AE)
#define RMD9_13H0      (*(volatile __near unsigned short *)0x4AE)
#define RMD9_13H1      (*(volatile __near unsigned short *)0x4AE)
#define RMD1_13H1      (*(volatile __near unsigned short *)0x4AE)
#define RMD1_13H0      (*(volatile __near unsigned short *)0x4AE)
#define RFDF1_13H1L    (*(volatile __near unsigned char  *)0x4AE)
#define RFDF1_13H0L    (*(volatile __near unsigned char  *)0x4AE)
#define RMD9_13H0L     (*(volatile __near unsigned char  *)0x4AE)
#define RMD9_13H1L     (*(volatile __near unsigned char  *)0x4AE)
#define RMD1_13H0L     (*(volatile __near unsigned char  *)0x4AE)
#define RMD1_13H1L     (*(volatile __near unsigned char  *)0x4AE)
#define RFDF1_13H1H    (*(volatile __near unsigned char  *)0x4AF)
#define RFDF1_13H0H    (*(volatile __near unsigned char  *)0x4AF)
#define RMD9_13H1H     (*(volatile __near unsigned char  *)0x4AF)
#define RMD9_13H0H     (*(volatile __near unsigned char  *)0x4AF)
#define RMD1_13H0H     (*(volatile __near unsigned char  *)0x4AF)
#define RMD1_13H1H     (*(volatile __near unsigned char  *)0x4AF)
#define RFDF1_14L1     (*(volatile __near unsigned short *)0x4B0)
#define RFDF1_14L0     (*(volatile __near unsigned short *)0x4B0)
#define RMD9_14L1      (*(volatile __near unsigned short *)0x4B0)
#define RMD9_14L0      (*(volatile __near unsigned short *)0x4B0)
#define GAFLID9L1      (*(volatile __near unsigned short *)0x4B0)
#define RMD1_14L1      (*(volatile __near unsigned short *)0x4B0)
#define RMD1_14L0      (*(volatile __near unsigned short *)0x4B0)
#define GAFLID9L0      (*(volatile __near unsigned short *)0x4B0)
#define RFDF1_14L0L    (*(volatile __near unsigned char  *)0x4B0)
#define RFDF1_14L1L    (*(volatile __near unsigned char  *)0x4B0)
#define RMD9_14L1L     (*(volatile __near unsigned char  *)0x4B0)
#define GAFLID9L1L     (*(volatile __near unsigned char  *)0x4B0)
#define RMD9_14L0L     (*(volatile __near unsigned char  *)0x4B0)
#define RMD1_14L1L     (*(volatile __near unsigned char  *)0x4B0)
#define RMD1_14L0L     (*(volatile __near unsigned char  *)0x4B0)
#define GAFLID9L0L     (*(volatile __near unsigned char  *)0x4B0)
#define RFDF1_14L1H    (*(volatile __near unsigned char  *)0x4B1)
#define RFDF1_14L0H    (*(volatile __near unsigned char  *)0x4B1)
#define GAFLID9L1H     (*(volatile __near unsigned char  *)0x4B1)
#define RMD9_14L0H     (*(volatile __near unsigned char  *)0x4B1)
#define RMD9_14L1H     (*(volatile __near unsigned char  *)0x4B1)
#define RMD1_14L1H     (*(volatile __near unsigned char  *)0x4B1)
#define RMD1_14L0H     (*(volatile __near unsigned char  *)0x4B1)
#define GAFLID9L0H     (*(volatile __near unsigned char  *)0x4B1)
#define RFDF1_14H1     (*(volatile __near unsigned short *)0x4B2)
#define RFDF1_14H0     (*(volatile __near unsigned short *)0x4B2)
#define RMD9_14H1      (*(volatile __near unsigned short *)0x4B2)
#define RMD9_14H0      (*(volatile __near unsigned short *)0x4B2)
#define GAFLID9H0      (*(volatile __near unsigned short *)0x4B2)
#define GAFLID9H1      (*(volatile __near unsigned short *)0x4B2)
#define RMD1_14H1      (*(volatile __near unsigned short *)0x4B2)
#define RMD1_14H0      (*(volatile __near unsigned short *)0x4B2)
#define RFDF1_14H1L    (*(volatile __near unsigned char  *)0x4B2)
#define RFDF1_14H0L    (*(volatile __near unsigned char  *)0x4B2)
#define RMD9_14H1L     (*(volatile __near unsigned char  *)0x4B2)
#define RMD9_14H0L     (*(volatile __near unsigned char  *)0x4B2)
#define GAFLID9H0L     (*(volatile __near unsigned char  *)0x4B2)
#define RMD1_14H0L     (*(volatile __near unsigned char  *)0x4B2)
#define GAFLID9H1L     (*(volatile __near unsigned char  *)0x4B2)
#define RMD1_14H1L     (*(volatile __near unsigned char  *)0x4B2)
#define RFDF1_14H0H    (*(volatile __near unsigned char  *)0x4B3)
#define RFDF1_14H1H    (*(volatile __near unsigned char  *)0x4B3)
#define RMD9_14H1H     (*(volatile __near unsigned char  *)0x4B3)
#define RMD9_14H0H     (*(volatile __near unsigned char  *)0x4B3)
#define GAFLID9H0H     (*(volatile __near unsigned char  *)0x4B3)
#define GAFLID9H1H     (*(volatile __near unsigned char  *)0x4B3)
#define RMD1_14H1H     (*(volatile __near unsigned char  *)0x4B3)
#define RMD1_14H0H     (*(volatile __near unsigned char  *)0x4B3)
#define RFDF1_15L1     (*(volatile __near unsigned short *)0x4B4)
#define RFDF1_15L0     (*(volatile __near unsigned short *)0x4B4)
#define RMD9_15L0      (*(volatile __near unsigned short *)0x4B4)
#define RMD9_15L1      (*(volatile __near unsigned short *)0x4B4)
#define GAFLM9L0       (*(volatile __near unsigned short *)0x4B4)
#define RMD1_15L0      (*(volatile __near unsigned short *)0x4B4)
#define RMD1_15L1      (*(volatile __near unsigned short *)0x4B4)
#define GAFLM9L1       (*(volatile __near unsigned short *)0x4B4)
#define RFDF1_15L1L    (*(volatile __near unsigned char  *)0x4B4)
#define RFDF1_15L0L    (*(volatile __near unsigned char  *)0x4B4)
#define RMD9_15L1L     (*(volatile __near unsigned char  *)0x4B4)
#define RMD9_15L0L     (*(volatile __near unsigned char  *)0x4B4)
#define GAFLM9L0L      (*(volatile __near unsigned char  *)0x4B4)
#define GAFLM9L1L      (*(volatile __near unsigned char  *)0x4B4)
#define RMD1_15L1L     (*(volatile __near unsigned char  *)0x4B4)
#define RMD1_15L0L     (*(volatile __near unsigned char  *)0x4B4)
#define RFDF1_15L1H    (*(volatile __near unsigned char  *)0x4B5)
#define RFDF1_15L0H    (*(volatile __near unsigned char  *)0x4B5)
#define RMD1_15L1H     (*(volatile __near unsigned char  *)0x4B5)
#define RMD1_15L0H     (*(volatile __near unsigned char  *)0x4B5)
#define GAFLM9L1H      (*(volatile __near unsigned char  *)0x4B5)
#define RMD9_15L0H     (*(volatile __near unsigned char  *)0x4B5)
#define RMD9_15L1H     (*(volatile __near unsigned char  *)0x4B5)
#define GAFLM9L0H      (*(volatile __near unsigned char  *)0x4B5)
#define RFDF1_15H1     (*(volatile __near unsigned short *)0x4B6)
#define RFDF1_15H0     (*(volatile __near unsigned short *)0x4B6)
#define GAFLM9H1       (*(volatile __near unsigned short *)0x4B6)
#define RMD1_15H1      (*(volatile __near unsigned short *)0x4B6)
#define RMD9_15H0      (*(volatile __near unsigned short *)0x4B6)
#define RMD9_15H1      (*(volatile __near unsigned short *)0x4B6)
#define RMD1_15H0      (*(volatile __near unsigned short *)0x4B6)
#define GAFLM9H0       (*(volatile __near unsigned short *)0x4B6)
#define RFDF1_15H0L    (*(volatile __near unsigned char  *)0x4B6)
#define RFDF1_15H1L    (*(volatile __near unsigned char  *)0x4B6)
#define RMD1_15H1L     (*(volatile __near unsigned char  *)0x4B6)
#define RMD9_15H0L     (*(volatile __near unsigned char  *)0x4B6)
#define RMD9_15H1L     (*(volatile __near unsigned char  *)0x4B6)
#define RMD1_15H0L     (*(volatile __near unsigned char  *)0x4B6)
#define GAFLM9H0L      (*(volatile __near unsigned char  *)0x4B6)
#define GAFLM9H1L      (*(volatile __near unsigned char  *)0x4B6)
#define RFDF1_15H0H    (*(volatile __near unsigned char  *)0x4B7)
#define RFDF1_15H1H    (*(volatile __near unsigned char  *)0x4B7)
#define GAFLM9H1H      (*(volatile __near unsigned char  *)0x4B7)
#define RMD1_15H1H     (*(volatile __near unsigned char  *)0x4B7)
#define RMD9_15H0H     (*(volatile __near unsigned char  *)0x4B7)
#define RMD9_15H1H     (*(volatile __near unsigned char  *)0x4B7)
#define RMD1_15H0H     (*(volatile __near unsigned char  *)0x4B7)
#define GAFLM9H0H      (*(volatile __near unsigned char  *)0x4B7)
#define CFIDL0         (*(volatile __near unsigned short *)0x4B8)
#define CFIDL1         (*(volatile __near unsigned short *)0x4B8)
#define GAFLP09L1      (*(volatile __near unsigned short *)0x4B8)
#define RMID2L1        (*(volatile __near unsigned short *)0x4B8)
#define RMID10L1       (*(volatile __near unsigned short *)0x4B8)
#define RMID10L0       (*(volatile __near unsigned short *)0x4B8)
#define RMID2L0        (*(volatile __near unsigned short *)0x4B8)
#define GAFLP09L0      (*(volatile __near unsigned short *)0x4B8)
#define CFIDL0L        (*(volatile __near unsigned char  *)0x4B8)
#define CFIDL1L        (*(volatile __near unsigned char  *)0x4B8)
#define GAFLP09L0L     (*(volatile __near unsigned char  *)0x4B8)
#define GAFLP09L1L     (*(volatile __near unsigned char  *)0x4B8)
#define RMID2L1L       (*(volatile __near unsigned char  *)0x4B8)
#define RMID2L0L       (*(volatile __near unsigned char  *)0x4B8)
#define RMID10L0L      (*(volatile __near unsigned char  *)0x4B8)
#define RMID10L1L      (*(volatile __near unsigned char  *)0x4B8)
#define GAFLP09L0H     (*(volatile __near unsigned char  *)0x4B9)
#define RMID10L0H      (*(volatile __near unsigned char  *)0x4B9)
#define RMID2L1H       (*(volatile __near unsigned char  *)0x4B9)
#define RMID2L0H       (*(volatile __near unsigned char  *)0x4B9)
#define CFIDL1H        (*(volatile __near unsigned char  *)0x4B9)
#define RMID10L1H      (*(volatile __near unsigned char  *)0x4B9)
#define GAFLP09L1H     (*(volatile __near unsigned char  *)0x4B9)
#define CFIDL0H        (*(volatile __near unsigned char  *)0x4B9)
#define RMID10H1       (*(volatile __near unsigned short *)0x4BA)
#define GAFLP09H0      (*(volatile __near unsigned short *)0x4BA)
#define CFIDH0         (*(volatile __near unsigned short *)0x4BA)
#define CFIDH1         (*(volatile __near unsigned short *)0x4BA)
#define RMID10H0       (*(volatile __near unsigned short *)0x4BA)
#define GAFLP09H1      (*(volatile __near unsigned short *)0x4BA)
#define RMID2H0        (*(volatile __near unsigned short *)0x4BA)
#define RMID2H1        (*(volatile __near unsigned short *)0x4BA)
#define RMID10H0L      (*(volatile __near unsigned char  *)0x4BA)
#define GAFLP09H0L     (*(volatile __near unsigned char  *)0x4BA)
#define CFIDH0L        (*(volatile __near unsigned char  *)0x4BA)
#define GAFLP09H1L     (*(volatile __near unsigned char  *)0x4BA)
#define RMID2H1L       (*(volatile __near unsigned char  *)0x4BA)
#define RMID2H0L       (*(volatile __near unsigned char  *)0x4BA)
#define RMID10H1L      (*(volatile __near unsigned char  *)0x4BA)
#define CFIDH1L        (*(volatile __near unsigned char  *)0x4BA)
#define RMID10H1H      (*(volatile __near unsigned char  *)0x4BB)
#define RMID10H0H      (*(volatile __near unsigned char  *)0x4BB)
#define CFIDH0H        (*(volatile __near unsigned char  *)0x4BB)
#define RMID2H0H       (*(volatile __near unsigned char  *)0x4BB)
#define GAFLP09H0H     (*(volatile __near unsigned char  *)0x4BB)
#define GAFLP09H1H     (*(volatile __near unsigned char  *)0x4BB)
#define RMID2H1H       (*(volatile __near unsigned char  *)0x4BB)
#define CFIDH1H        (*(volatile __near unsigned char  *)0x4BB)
#define RMPTR2L1       (*(volatile __near unsigned short *)0x4BC)
#define RMPTR2L0       (*(volatile __near unsigned short *)0x4BC)
#define GAFLP19L0      (*(volatile __near unsigned short *)0x4BC)
#define RMPTR10L1      (*(volatile __near unsigned short *)0x4BC)
#define RMPTR10L0      (*(volatile __near unsigned short *)0x4BC)
#define GAFLP19L1      (*(volatile __near unsigned short *)0x4BC)
#define CFPTRL1        (*(volatile __near unsigned short *)0x4BC)
#define CFPTRL0        (*(volatile __near unsigned short *)0x4BC)
#define RMPTR2L1L      (*(volatile __near unsigned char  *)0x4BC)
#define RMPTR2L0L      (*(volatile __near unsigned char  *)0x4BC)
#define GAFLP19L0L     (*(volatile __near unsigned char  *)0x4BC)
#define RMPTR10L1L     (*(volatile __near unsigned char  *)0x4BC)
#define RMPTR10L0L     (*(volatile __near unsigned char  *)0x4BC)
#define GAFLP19L1L     (*(volatile __near unsigned char  *)0x4BC)
#define CFPTRL1L       (*(volatile __near unsigned char  *)0x4BC)
#define CFPTRL0L       (*(volatile __near unsigned char  *)0x4BC)
#define RMPTR2L0H      (*(volatile __near unsigned char  *)0x4BD)
#define GAFLP19L0H     (*(volatile __near unsigned char  *)0x4BD)
#define RMPTR2L1H      (*(volatile __near unsigned char  *)0x4BD)
#define RMPTR10L1H     (*(volatile __near unsigned char  *)0x4BD)
#define RMPTR10L0H     (*(volatile __near unsigned char  *)0x4BD)
#define GAFLP19L1H     (*(volatile __near unsigned char  *)0x4BD)
#define CFPTRL1H       (*(volatile __near unsigned char  *)0x4BD)
#define CFPTRL0H       (*(volatile __near unsigned char  *)0x4BD)
#define RMPTR10H1      (*(volatile __near unsigned short *)0x4BE)
#define RMPTR10H0      (*(volatile __near unsigned short *)0x4BE)
#define RMPTR2H1       (*(volatile __near unsigned short *)0x4BE)
#define RMPTR2H0       (*(volatile __near unsigned short *)0x4BE)
#define CFPTRH1        (*(volatile __near unsigned short *)0x4BE)
#define CFPTRH0        (*(volatile __near unsigned short *)0x4BE)
#define RMPTR10H1H     (*(volatile __near unsigned char  *)0x4BF)
#define RMPTR10H0H     (*(volatile __near unsigned char  *)0x4BF)
#define RMPTR2H0H      (*(volatile __near unsigned char  *)0x4BF)
#define RMPTR2H1H      (*(volatile __near unsigned char  *)0x4BF)
#define CFPTRH0H       (*(volatile __near unsigned char  *)0x4BF)
#define CFPTRH1H       (*(volatile __near unsigned char  *)0x4BF)
#define CFFDCSTSL0     (*(volatile __near unsigned short *)0x4C0)
#define CFFDCSTSL1     (*(volatile __near unsigned short *)0x4C0)
#define RMSTS10L0      (*(volatile __near unsigned short *)0x4C0)
#define RMSTS10L1      (*(volatile __near unsigned short *)0x4C0)
#define GAFLID10L0     (*(volatile __near unsigned short *)0x4C0)
#define GAFLID10L1     (*(volatile __near unsigned short *)0x4C0)
#define RMSTS2L1       (*(volatile __near unsigned short *)0x4C0)
#define RMSTS2L0       (*(volatile __near unsigned short *)0x4C0)
#define CFFDCSTSL0L    (*(volatile __near unsigned char  *)0x4C0)
#define CFFDCSTSL1L    (*(volatile __near unsigned char  *)0x4C0)
#define GAFLID10L0L    (*(volatile __near unsigned char  *)0x4C0)
#define RMSTS2L0L      (*(volatile __near unsigned char  *)0x4C0)
#define RMSTS2L1L      (*(volatile __near unsigned char  *)0x4C0)
#define GAFLID10L1L    (*(volatile __near unsigned char  *)0x4C0)
#define RMSTS10L1L     (*(volatile __near unsigned char  *)0x4C0)
#define RMSTS10L0L     (*(volatile __near unsigned char  *)0x4C0)
#define RMSTS10L0H     (*(volatile __near unsigned char  *)0x4C1)
#define GAFLID10L0H    (*(volatile __near unsigned char  *)0x4C1)
#define CFFDCSTSL0H    (*(volatile __near unsigned char  *)0x4C1)
#define CFFDCSTSL1H    (*(volatile __near unsigned char  *)0x4C1)
#define RMSTS10L1H     (*(volatile __near unsigned char  *)0x4C1)
#define RMSTS2L1H      (*(volatile __near unsigned char  *)0x4C1)
#define RMSTS2L0H      (*(volatile __near unsigned char  *)0x4C1)
#define GAFLID10L1H    (*(volatile __near unsigned char  *)0x4C1)
#define RMSTS10H1      (*(volatile __near unsigned short *)0x4C2)
#define RMSTS2H1       (*(volatile __near unsigned short *)0x4C2)
#define RMSTS2H0       (*(volatile __near unsigned short *)0x4C2)
#define CFFDCSTSH1     (*(volatile __near unsigned short *)0x4C2)
#define GAFLID10H1     (*(volatile __near unsigned short *)0x4C2)
#define CFFDCSTSH0     (*(volatile __near unsigned short *)0x4C2)
#define GAFLID10H0     (*(volatile __near unsigned short *)0x4C2)
#define RMSTS10H0      (*(volatile __near unsigned short *)0x4C2)
#define RMSTS10H1L     (*(volatile __near unsigned char  *)0x4C2)
#define RMSTS2H0L      (*(volatile __near unsigned char  *)0x4C2)
#define GAFLID10H1L    (*(volatile __near unsigned char  *)0x4C2)
#define RMSTS2H1L      (*(volatile __near unsigned char  *)0x4C2)
#define RMSTS10H0L     (*(volatile __near unsigned char  *)0x4C2)
#define CFFDCSTSH1L    (*(volatile __near unsigned char  *)0x4C2)
#define GAFLID10H0L    (*(volatile __near unsigned char  *)0x4C2)
#define CFFDCSTSH0L    (*(volatile __near unsigned char  *)0x4C2)
#define RMSTS2H0H      (*(volatile __near unsigned char  *)0x4C3)
#define GAFLID10H1H    (*(volatile __near unsigned char  *)0x4C3)
#define GAFLID10H0H    (*(volatile __near unsigned char  *)0x4C3)
#define CFFDCSTSH0H    (*(volatile __near unsigned char  *)0x4C3)
#define CFFDCSTSH1H    (*(volatile __near unsigned char  *)0x4C3)
#define RMSTS2H1H      (*(volatile __near unsigned char  *)0x4C3)
#define RMSTS10H1H     (*(volatile __near unsigned char  *)0x4C3)
#define RMSTS10H0H     (*(volatile __near unsigned char  *)0x4C3)
#define CFDF0L0        (*(volatile __near unsigned short *)0x4C4)
#define CFDF0L1        (*(volatile __near unsigned short *)0x4C4)
#define GAFLM10L0      (*(volatile __near unsigned short *)0x4C4)
#define GAFLM10L1      (*(volatile __near unsigned short *)0x4C4)
#define RMD2_0L0       (*(volatile __near unsigned short *)0x4C4)
#define RMD2_0L1       (*(volatile __near unsigned short *)0x4C4)
#define RMD10_0L0      (*(volatile __near unsigned short *)0x4C4)
#define RMD10_0L1      (*(volatile __near unsigned short *)0x4C4)
#define CFDF0L0L       (*(volatile __near unsigned char  *)0x4C4)
#define GAFLM10L0L     (*(volatile __near unsigned char  *)0x4C4)
#define GAFLM10L1L     (*(volatile __near unsigned char  *)0x4C4)
#define CFDF0L1L       (*(volatile __near unsigned char  *)0x4C4)
#define RMD2_0L0L      (*(volatile __near unsigned char  *)0x4C4)
#define RMD2_0L1L      (*(volatile __near unsigned char  *)0x4C4)
#define RMD10_0L0L     (*(volatile __near unsigned char  *)0x4C4)
#define RMD10_0L1L     (*(volatile __near unsigned char  *)0x4C4)
#define CFDF0L0H       (*(volatile __near unsigned char  *)0x4C5)
#define CFDF0L1H       (*(volatile __near unsigned char  *)0x4C5)
#define RMD2_0L0H      (*(volatile __near unsigned char  *)0x4C5)
#define RMD2_0L1H      (*(volatile __near unsigned char  *)0x4C5)
#define RMD10_0L0H     (*(volatile __near unsigned char  *)0x4C5)
#define GAFLM10L0H     (*(volatile __near unsigned char  *)0x4C5)
#define GAFLM10L1H     (*(volatile __near unsigned char  *)0x4C5)
#define RMD10_0L1H     (*(volatile __near unsigned char  *)0x4C5)
#define CFDF0H1        (*(volatile __near unsigned short *)0x4C6)
#define RMD2_0H1       (*(volatile __near unsigned short *)0x4C6)
#define GAFLM10H1      (*(volatile __near unsigned short *)0x4C6)
#define RMD10_0H1      (*(volatile __near unsigned short *)0x4C6)
#define GAFLM10H0      (*(volatile __near unsigned short *)0x4C6)
#define RMD10_0H0      (*(volatile __near unsigned short *)0x4C6)
#define RMD2_0H0       (*(volatile __near unsigned short *)0x4C6)
#define CFDF0H0        (*(volatile __near unsigned short *)0x4C6)
#define CFDF0H0L       (*(volatile __near unsigned char  *)0x4C6)
#define CFDF0H1L       (*(volatile __near unsigned char  *)0x4C6)
#define GAFLM10H0L     (*(volatile __near unsigned char  *)0x4C6)
#define RMD10_0H1L     (*(volatile __near unsigned char  *)0x4C6)
#define RMD2_0H1L      (*(volatile __near unsigned char  *)0x4C6)
#define RMD2_0H0L      (*(volatile __near unsigned char  *)0x4C6)
#define GAFLM10H1L     (*(volatile __near unsigned char  *)0x4C6)
#define RMD10_0H0L     (*(volatile __near unsigned char  *)0x4C6)
#define CFDF0H0H       (*(volatile __near unsigned char  *)0x4C7)
#define CFDF0H1H       (*(volatile __near unsigned char  *)0x4C7)
#define GAFLM10H0H     (*(volatile __near unsigned char  *)0x4C7)
#define RMD10_0H1H     (*(volatile __near unsigned char  *)0x4C7)
#define RMD10_0H0H     (*(volatile __near unsigned char  *)0x4C7)
#define RMD2_0H1H      (*(volatile __near unsigned char  *)0x4C7)
#define GAFLM10H1H     (*(volatile __near unsigned char  *)0x4C7)
#define RMD2_0H0H      (*(volatile __near unsigned char  *)0x4C7)
#define RMD10_1L1      (*(volatile __near unsigned short *)0x4C8)
#define CFDF1L1        (*(volatile __near unsigned short *)0x4C8)
#define RMD10_1L0      (*(volatile __near unsigned short *)0x4C8)
#define GAFLP010L1     (*(volatile __near unsigned short *)0x4C8)
#define GAFLP010L0     (*(volatile __near unsigned short *)0x4C8)
#define RMD2_1L1       (*(volatile __near unsigned short *)0x4C8)
#define RMD2_1L0       (*(volatile __near unsigned short *)0x4C8)
#define CFDF1L0        (*(volatile __near unsigned short *)0x4C8)
#define CFDF1L1L       (*(volatile __near unsigned char  *)0x4C8)
#define RMD2_1L0L      (*(volatile __near unsigned char  *)0x4C8)
#define GAFLP010L0L    (*(volatile __near unsigned char  *)0x4C8)
#define RMD2_1L1L      (*(volatile __near unsigned char  *)0x4C8)
#define RMD10_1L1L     (*(volatile __near unsigned char  *)0x4C8)
#define RMD10_1L0L     (*(volatile __near unsigned char  *)0x4C8)
#define GAFLP010L1L    (*(volatile __near unsigned char  *)0x4C8)
#define CFDF1L0L       (*(volatile __near unsigned char  *)0x4C8)
#define RMD10_1L0H     (*(volatile __near unsigned char  *)0x4C9)
#define GAFLP010L0H    (*(volatile __near unsigned char  *)0x4C9)
#define GAFLP010L1H    (*(volatile __near unsigned char  *)0x4C9)
#define RMD10_1L1H     (*(volatile __near unsigned char  *)0x4C9)
#define RMD2_1L1H      (*(volatile __near unsigned char  *)0x4C9)
#define RMD2_1L0H      (*(volatile __near unsigned char  *)0x4C9)
#define CFDF1L0H       (*(volatile __near unsigned char  *)0x4C9)
#define CFDF1L1H       (*(volatile __near unsigned char  *)0x4C9)
#define RMD2_1H0       (*(volatile __near unsigned short *)0x4CA)
#define RMD2_1H1       (*(volatile __near unsigned short *)0x4CA)
#define RMD10_1H0      (*(volatile __near unsigned short *)0x4CA)
#define CFDF1H1        (*(volatile __near unsigned short *)0x4CA)
#define GAFLP010H1     (*(volatile __near unsigned short *)0x4CA)
#define RMD10_1H1      (*(volatile __near unsigned short *)0x4CA)
#define CFDF1H0        (*(volatile __near unsigned short *)0x4CA)
#define GAFLP010H0     (*(volatile __near unsigned short *)0x4CA)
#define GAFLP010H0L    (*(volatile __near unsigned char  *)0x4CA)
#define GAFLP010H1L    (*(volatile __near unsigned char  *)0x4CA)
#define RMD10_1H1L     (*(volatile __near unsigned char  *)0x4CA)
#define RMD2_1H1L      (*(volatile __near unsigned char  *)0x4CA)
#define CFDF1H0L       (*(volatile __near unsigned char  *)0x4CA)
#define CFDF1H1L       (*(volatile __near unsigned char  *)0x4CA)
#define RMD2_1H0L      (*(volatile __near unsigned char  *)0x4CA)
#define RMD10_1H0L     (*(volatile __near unsigned char  *)0x4CA)
#define GAFLP010H0H    (*(volatile __near unsigned char  *)0x4CB)
#define GAFLP010H1H    (*(volatile __near unsigned char  *)0x4CB)
#define RMD2_1H0H      (*(volatile __near unsigned char  *)0x4CB)
#define RMD2_1H1H      (*(volatile __near unsigned char  *)0x4CB)
#define CFDF1H0H       (*(volatile __near unsigned char  *)0x4CB)
#define RMD10_1H1H     (*(volatile __near unsigned char  *)0x4CB)
#define CFDF1H1H       (*(volatile __near unsigned char  *)0x4CB)
#define RMD10_1H0H     (*(volatile __near unsigned char  *)0x4CB)
#define GAFLP110L1     (*(volatile __near unsigned short *)0x4CC)
#define GAFLP110L0     (*(volatile __near unsigned short *)0x4CC)
#define RMD2_2L0       (*(volatile __near unsigned short *)0x4CC)
#define RMD10_2L1      (*(volatile __near unsigned short *)0x4CC)
#define RMD2_2L1       (*(volatile __near unsigned short *)0x4CC)
#define CFDF2L0        (*(volatile __near unsigned short *)0x4CC)
#define CFDF2L1        (*(volatile __near unsigned short *)0x4CC)
#define RMD10_2L0      (*(volatile __near unsigned short *)0x4CC)
#define GAFLP110L0L    (*(volatile __near unsigned char  *)0x4CC)
#define GAFLP110L1L    (*(volatile __near unsigned char  *)0x4CC)
#define RMD10_2L1L     (*(volatile __near unsigned char  *)0x4CC)
#define RMD2_2L0L      (*(volatile __near unsigned char  *)0x4CC)
#define RMD2_2L1L      (*(volatile __near unsigned char  *)0x4CC)
#define CFDF2L0L       (*(volatile __near unsigned char  *)0x4CC)
#define RMD10_2L0L     (*(volatile __near unsigned char  *)0x4CC)
#define CFDF2L1L       (*(volatile __near unsigned char  *)0x4CC)
#define GAFLP110L1H    (*(volatile __near unsigned char  *)0x4CD)
#define GAFLP110L0H    (*(volatile __near unsigned char  *)0x4CD)
#define CFDF2L0H       (*(volatile __near unsigned char  *)0x4CD)
#define RMD10_2L0H     (*(volatile __near unsigned char  *)0x4CD)
#define RMD10_2L1H     (*(volatile __near unsigned char  *)0x4CD)
#define CFDF2L1H       (*(volatile __near unsigned char  *)0x4CD)
#define RMD2_2L0H      (*(volatile __near unsigned char  *)0x4CD)
#define RMD2_2L1H      (*(volatile __near unsigned char  *)0x4CD)
#define RMD10_2H0      (*(volatile __near unsigned short *)0x4CE)
#define RMD2_2H1       (*(volatile __near unsigned short *)0x4CE)
#define CFDF2H0        (*(volatile __near unsigned short *)0x4CE)
#define RMD2_2H0       (*(volatile __near unsigned short *)0x4CE)
#define CFDF2H1        (*(volatile __near unsigned short *)0x4CE)
#define RMD10_2H1      (*(volatile __near unsigned short *)0x4CE)
#define RMD10_2H1L     (*(volatile __near unsigned char  *)0x4CE)
#define RMD10_2H0L     (*(volatile __near unsigned char  *)0x4CE)
#define CFDF2H0L       (*(volatile __near unsigned char  *)0x4CE)
#define RMD2_2H1L      (*(volatile __near unsigned char  *)0x4CE)
#define CFDF2H1L       (*(volatile __near unsigned char  *)0x4CE)
#define RMD2_2H0L      (*(volatile __near unsigned char  *)0x4CE)
#define CFDF2H0H       (*(volatile __near unsigned char  *)0x4CF)
#define RMD10_2H0H     (*(volatile __near unsigned char  *)0x4CF)
#define CFDF2H1H       (*(volatile __near unsigned char  *)0x4CF)
#define RMD10_2H1H     (*(volatile __near unsigned char  *)0x4CF)
#define RMD2_2H0H      (*(volatile __near unsigned char  *)0x4CF)
#define RMD2_2H1H      (*(volatile __near unsigned char  *)0x4CF)
#define GAFLID11L0     (*(volatile __near unsigned short *)0x4D0)
#define RMD2_3L1       (*(volatile __near unsigned short *)0x4D0)
#define CFDF3L0        (*(volatile __near unsigned short *)0x4D0)
#define RMD2_3L0       (*(volatile __near unsigned short *)0x4D0)
#define CFDF3L1        (*(volatile __near unsigned short *)0x4D0)
#define GAFLID11L1     (*(volatile __near unsigned short *)0x4D0)
#define RMD10_3L1      (*(volatile __near unsigned short *)0x4D0)
#define RMD10_3L0      (*(volatile __near unsigned short *)0x4D0)
#define RMD2_3L1L      (*(volatile __near unsigned char  *)0x4D0)
#define RMD2_3L0L      (*(volatile __near unsigned char  *)0x4D0)
#define GAFLID11L1L    (*(volatile __near unsigned char  *)0x4D0)
#define GAFLID11L0L    (*(volatile __near unsigned char  *)0x4D0)
#define RMD10_3L1L     (*(volatile __near unsigned char  *)0x4D0)
#define RMD10_3L0L     (*(volatile __near unsigned char  *)0x4D0)
#define CFDF3L1L       (*(volatile __near unsigned char  *)0x4D0)
#define CFDF3L0L       (*(volatile __near unsigned char  *)0x4D0)
#define GAFLID11L0H    (*(volatile __near unsigned char  *)0x4D1)
#define RMD2_3L1H      (*(volatile __near unsigned char  *)0x4D1)
#define RMD2_3L0H      (*(volatile __near unsigned char  *)0x4D1)
#define GAFLID11L1H    (*(volatile __near unsigned char  *)0x4D1)
#define RMD10_3L0H     (*(volatile __near unsigned char  *)0x4D1)
#define RMD10_3L1H     (*(volatile __near unsigned char  *)0x4D1)
#define CFDF3L1H       (*(volatile __near unsigned char  *)0x4D1)
#define CFDF3L0H       (*(volatile __near unsigned char  *)0x4D1)
#define GAFLID11H0     (*(volatile __near unsigned short *)0x4D2)
#define GAFLID11H1     (*(volatile __near unsigned short *)0x4D2)
#define RMD10_3H1      (*(volatile __near unsigned short *)0x4D2)
#define CFDF3H1        (*(volatile __near unsigned short *)0x4D2)
#define RMD10_3H0      (*(volatile __near unsigned short *)0x4D2)
#define CFDF3H0        (*(volatile __near unsigned short *)0x4D2)
#define RMD2_3H1       (*(volatile __near unsigned short *)0x4D2)
#define RMD2_3H0       (*(volatile __near unsigned short *)0x4D2)
#define GAFLID11H1L    (*(volatile __near unsigned char  *)0x4D2)
#define GAFLID11H0L    (*(volatile __near unsigned char  *)0x4D2)
#define RMD10_3H1L     (*(volatile __near unsigned char  *)0x4D2)
#define CFDF3H0L       (*(volatile __near unsigned char  *)0x4D2)
#define RMD10_3H0L     (*(volatile __near unsigned char  *)0x4D2)
#define CFDF3H1L       (*(volatile __near unsigned char  *)0x4D2)
#define RMD2_3H1L      (*(volatile __near unsigned char  *)0x4D2)
#define RMD2_3H0L      (*(volatile __near unsigned char  *)0x4D2)
#define GAFLID11H1H    (*(volatile __near unsigned char  *)0x4D3)
#define GAFLID11H0H    (*(volatile __near unsigned char  *)0x4D3)
#define RMD2_3H1H      (*(volatile __near unsigned char  *)0x4D3)
#define RMD2_3H0H      (*(volatile __near unsigned char  *)0x4D3)
#define CFDF3H0H       (*(volatile __near unsigned char  *)0x4D3)
#define RMD10_3H1H     (*(volatile __near unsigned char  *)0x4D3)
#define RMD10_3H0H     (*(volatile __near unsigned char  *)0x4D3)
#define CFDF3H1H       (*(volatile __near unsigned char  *)0x4D3)
#define RMD2_4L0       (*(volatile __near unsigned short *)0x4D4)
#define RMD2_4L1       (*(volatile __near unsigned short *)0x4D4)
#define RMD10_4L1      (*(volatile __near unsigned short *)0x4D4)
#define RMD10_4L0      (*(volatile __near unsigned short *)0x4D4)
#define GAFLM11L0      (*(volatile __near unsigned short *)0x4D4)
#define GAFLM11L1      (*(volatile __near unsigned short *)0x4D4)
#define CFDF4L0        (*(volatile __near unsigned short *)0x4D4)
#define CFDF4L1        (*(volatile __near unsigned short *)0x4D4)
#define RMD10_4L1L     (*(volatile __near unsigned char  *)0x4D4)
#define RMD2_4L1L      (*(volatile __near unsigned char  *)0x4D4)
#define GAFLM11L0L     (*(volatile __near unsigned char  *)0x4D4)
#define RMD10_4L0L     (*(volatile __near unsigned char  *)0x4D4)
#define CFDF4L0L       (*(volatile __near unsigned char  *)0x4D4)
#define CFDF4L1L       (*(volatile __near unsigned char  *)0x4D4)
#define GAFLM11L1L     (*(volatile __near unsigned char  *)0x4D4)
#define RMD2_4L0L      (*(volatile __near unsigned char  *)0x4D4)
#define GAFLM11L1H     (*(volatile __near unsigned char  *)0x4D5)
#define RMD2_4L1H      (*(volatile __near unsigned char  *)0x4D5)
#define RMD10_4L1H     (*(volatile __near unsigned char  *)0x4D5)
#define RMD2_4L0H      (*(volatile __near unsigned char  *)0x4D5)
#define GAFLM11L0H     (*(volatile __near unsigned char  *)0x4D5)
#define CFDF4L0H       (*(volatile __near unsigned char  *)0x4D5)
#define RMD10_4L0H     (*(volatile __near unsigned char  *)0x4D5)
#define CFDF4L1H       (*(volatile __near unsigned char  *)0x4D5)
#define RMD2_4H0       (*(volatile __near unsigned short *)0x4D6)
#define RMD10_4H0      (*(volatile __near unsigned short *)0x4D6)
#define CFDF4H0        (*(volatile __near unsigned short *)0x4D6)
#define CFDF4H1        (*(volatile __near unsigned short *)0x4D6)
#define RMD10_4H1      (*(volatile __near unsigned short *)0x4D6)
#define GAFLM11H0      (*(volatile __near unsigned short *)0x4D6)
#define GAFLM11H1      (*(volatile __near unsigned short *)0x4D6)
#define RMD2_4H1       (*(volatile __near unsigned short *)0x4D6)
#define RMD10_4H0L     (*(volatile __near unsigned char  *)0x4D6)
#define RMD10_4H1L     (*(volatile __near unsigned char  *)0x4D6)
#define GAFLM11H1L     (*(volatile __near unsigned char  *)0x4D6)
#define CFDF4H1L       (*(volatile __near unsigned char  *)0x4D6)
#define CFDF4H0L       (*(volatile __near unsigned char  *)0x4D6)
#define GAFLM11H0L     (*(volatile __near unsigned char  *)0x4D6)
#define RMD2_4H1L      (*(volatile __near unsigned char  *)0x4D6)
#define RMD2_4H0L      (*(volatile __near unsigned char  *)0x4D6)
#define RMD2_4H0H      (*(volatile __near unsigned char  *)0x4D7)
#define RMD10_4H0H     (*(volatile __near unsigned char  *)0x4D7)
#define RMD10_4H1H     (*(volatile __near unsigned char  *)0x4D7)
#define CFDF4H1H       (*(volatile __near unsigned char  *)0x4D7)
#define GAFLM11H0H     (*(volatile __near unsigned char  *)0x4D7)
#define CFDF4H0H       (*(volatile __near unsigned char  *)0x4D7)
#define GAFLM11H1H     (*(volatile __near unsigned char  *)0x4D7)
#define RMD2_4H1H      (*(volatile __near unsigned char  *)0x4D7)
#define CFDF5L1        (*(volatile __near unsigned short *)0x4D8)
#define RMD10_5L1      (*(volatile __near unsigned short *)0x4D8)
#define RMD2_5L1       (*(volatile __near unsigned short *)0x4D8)
#define RMD2_5L0       (*(volatile __near unsigned short *)0x4D8)
#define CFDF5L0        (*(volatile __near unsigned short *)0x4D8)
#define GAFLP011L0     (*(volatile __near unsigned short *)0x4D8)
#define RMD10_5L0      (*(volatile __near unsigned short *)0x4D8)
#define GAFLP011L1     (*(volatile __near unsigned short *)0x4D8)
#define CFDF5L1L       (*(volatile __near unsigned char  *)0x4D8)
#define RMD10_5L1L     (*(volatile __near unsigned char  *)0x4D8)
#define RMD2_5L1L      (*(volatile __near unsigned char  *)0x4D8)
#define RMD2_5L0L      (*(volatile __near unsigned char  *)0x4D8)
#define GAFLP011L1L    (*(volatile __near unsigned char  *)0x4D8)
#define GAFLP011L0L    (*(volatile __near unsigned char  *)0x4D8)
#define CFDF5L0L       (*(volatile __near unsigned char  *)0x4D8)
#define RMD10_5L0L     (*(volatile __near unsigned char  *)0x4D8)
#define CFDF5L1H       (*(volatile __near unsigned char  *)0x4D9)
#define RMD10_5L1H     (*(volatile __near unsigned char  *)0x4D9)
#define CFDF5L0H       (*(volatile __near unsigned char  *)0x4D9)
#define RMD10_5L0H     (*(volatile __near unsigned char  *)0x4D9)
#define GAFLP011L1H    (*(volatile __near unsigned char  *)0x4D9)
#define RMD2_5L0H      (*(volatile __near unsigned char  *)0x4D9)
#define GAFLP011L0H    (*(volatile __near unsigned char  *)0x4D9)
#define RMD2_5L1H      (*(volatile __near unsigned char  *)0x4D9)
#define CFDF5H0        (*(volatile __near unsigned short *)0x4DA)
#define CFDF5H1        (*(volatile __near unsigned short *)0x4DA)
#define GAFLP011H0     (*(volatile __near unsigned short *)0x4DA)
#define RMD10_5H1      (*(volatile __near unsigned short *)0x4DA)
#define GAFLP011H1     (*(volatile __near unsigned short *)0x4DA)
#define RMD10_5H0      (*(volatile __near unsigned short *)0x4DA)
#define RMD2_5H1       (*(volatile __near unsigned short *)0x4DA)
#define RMD2_5H0       (*(volatile __near unsigned short *)0x4DA)
#define CFDF5H1L       (*(volatile __near unsigned char  *)0x4DA)
#define RMD10_5H1L     (*(volatile __near unsigned char  *)0x4DA)
#define GAFLP011H1L    (*(volatile __near unsigned char  *)0x4DA)
#define CFDF5H0L       (*(volatile __near unsigned char  *)0x4DA)
#define RMD10_5H0L     (*(volatile __near unsigned char  *)0x4DA)
#define RMD2_5H0L      (*(volatile __near unsigned char  *)0x4DA)
#define GAFLP011H0L    (*(volatile __near unsigned char  *)0x4DA)
#define RMD2_5H1L      (*(volatile __near unsigned char  *)0x4DA)
#define CFDF5H1H       (*(volatile __near unsigned char  *)0x4DB)
#define RMD10_5H1H     (*(volatile __near unsigned char  *)0x4DB)
#define CFDF5H0H       (*(volatile __near unsigned char  *)0x4DB)
#define GAFLP011H1H    (*(volatile __near unsigned char  *)0x4DB)
#define RMD2_5H1H      (*(volatile __near unsigned char  *)0x4DB)
#define RMD2_5H0H      (*(volatile __near unsigned char  *)0x4DB)
#define GAFLP011H0H    (*(volatile __near unsigned char  *)0x4DB)
#define RMD10_5H0H     (*(volatile __near unsigned char  *)0x4DB)
#define GAFLP111L1     (*(volatile __near unsigned short *)0x4DC)
#define GAFLP111L0     (*(volatile __near unsigned short *)0x4DC)
#define CFDF6L1        (*(volatile __near unsigned short *)0x4DC)
#define RMD10_6L0      (*(volatile __near unsigned short *)0x4DC)
#define CFDF6L0        (*(volatile __near unsigned short *)0x4DC)
#define RMD10_6L1      (*(volatile __near unsigned short *)0x4DC)
#define RMD2_6L0       (*(volatile __near unsigned short *)0x4DC)
#define RMD2_6L1       (*(volatile __near unsigned short *)0x4DC)
#define GAFLP111L1L    (*(volatile __near unsigned char  *)0x4DC)
#define GAFLP111L0L    (*(volatile __near unsigned char  *)0x4DC)
#define RMD10_6L0L     (*(volatile __near unsigned char  *)0x4DC)
#define CFDF6L1L       (*(volatile __near unsigned char  *)0x4DC)
#define CFDF6L0L       (*(volatile __near unsigned char  *)0x4DC)
#define RMD10_6L1L     (*(volatile __near unsigned char  *)0x4DC)
#define RMD2_6L0L      (*(volatile __near unsigned char  *)0x4DC)
#define RMD2_6L1L      (*(volatile __near unsigned char  *)0x4DC)
#define GAFLP111L1H    (*(volatile __near unsigned char  *)0x4DD)
#define GAFLP111L0H    (*(volatile __near unsigned char  *)0x4DD)
#define CFDF6L1H       (*(volatile __near unsigned char  *)0x4DD)
#define RMD10_6L0H     (*(volatile __near unsigned char  *)0x4DD)
#define CFDF6L0H       (*(volatile __near unsigned char  *)0x4DD)
#define RMD10_6L1H     (*(volatile __near unsigned char  *)0x4DD)
#define RMD2_6L1H      (*(volatile __near unsigned char  *)0x4DD)
#define RMD2_6L0H      (*(volatile __near unsigned char  *)0x4DD)
#define CFDF6H1        (*(volatile __near unsigned short *)0x4DE)
#define CFDF6H0        (*(volatile __near unsigned short *)0x4DE)
#define RMD10_6H0      (*(volatile __near unsigned short *)0x4DE)
#define RMD10_6H1      (*(volatile __near unsigned short *)0x4DE)
#define RMD2_6H0       (*(volatile __near unsigned short *)0x4DE)
#define RMD2_6H1       (*(volatile __near unsigned short *)0x4DE)
#define CFDF6H1L       (*(volatile __near unsigned char  *)0x4DE)
#define CFDF6H0L       (*(volatile __near unsigned char  *)0x4DE)
#define RMD10_6H1L     (*(volatile __near unsigned char  *)0x4DE)
#define RMD10_6H0L     (*(volatile __near unsigned char  *)0x4DE)
#define RMD2_6H1L      (*(volatile __near unsigned char  *)0x4DE)
#define RMD2_6H0L      (*(volatile __near unsigned char  *)0x4DE)
#define CFDF6H1H       (*(volatile __near unsigned char  *)0x4DF)
#define CFDF6H0H       (*(volatile __near unsigned char  *)0x4DF)
#define RMD10_6H1H     (*(volatile __near unsigned char  *)0x4DF)
#define RMD10_6H0H     (*(volatile __near unsigned char  *)0x4DF)
#define RMD2_6H0H      (*(volatile __near unsigned char  *)0x4DF)
#define RMD2_6H1H      (*(volatile __near unsigned char  *)0x4DF)
#define RMD10_7L0      (*(volatile __near unsigned short *)0x4E0)
#define CFDF7L1        (*(volatile __near unsigned short *)0x4E0)
#define GAFLID12L0     (*(volatile __near unsigned short *)0x4E0)
#define CFDF7L0        (*(volatile __near unsigned short *)0x4E0)
#define GAFLID12L1     (*(volatile __near unsigned short *)0x4E0)
#define RMD10_7L1      (*(volatile __near unsigned short *)0x4E0)
#define RMD2_7L1       (*(volatile __near unsigned short *)0x4E0)
#define RMD2_7L0       (*(volatile __near unsigned short *)0x4E0)
#define CFDF7L0L       (*(volatile __near unsigned char  *)0x4E0)
#define RMD10_7L1L     (*(volatile __near unsigned char  *)0x4E0)
#define GAFLID12L0L    (*(volatile __near unsigned char  *)0x4E0)
#define GAFLID12L1L    (*(volatile __near unsigned char  *)0x4E0)
#define CFDF7L1L       (*(volatile __near unsigned char  *)0x4E0)
#define RMD10_7L0L     (*(volatile __near unsigned char  *)0x4E0)
#define RMD2_7L0L      (*(volatile __near unsigned char  *)0x4E0)
#define RMD2_7L1L      (*(volatile __near unsigned char  *)0x4E0)
#define GAFLID12L0H    (*(volatile __near unsigned char  *)0x4E1)
#define GAFLID12L1H    (*(volatile __near unsigned char  *)0x4E1)
#define CFDF7L1H       (*(volatile __near unsigned char  *)0x4E1)
#define RMD10_7L0H     (*(volatile __near unsigned char  *)0x4E1)
#define RMD10_7L1H     (*(volatile __near unsigned char  *)0x4E1)
#define CFDF7L0H       (*(volatile __near unsigned char  *)0x4E1)
#define RMD2_7L0H      (*(volatile __near unsigned char  *)0x4E1)
#define RMD2_7L1H      (*(volatile __near unsigned char  *)0x4E1)
#define GAFLID12H1     (*(volatile __near unsigned short *)0x4E2)
#define CFDF7H0        (*(volatile __near unsigned short *)0x4E2)
#define GAFLID12H0     (*(volatile __near unsigned short *)0x4E2)
#define RMD10_7H1      (*(volatile __near unsigned short *)0x4E2)
#define RMD10_7H0      (*(volatile __near unsigned short *)0x4E2)
#define CFDF7H1        (*(volatile __near unsigned short *)0x4E2)
#define RMD2_7H0       (*(volatile __near unsigned short *)0x4E2)
#define RMD2_7H1       (*(volatile __near unsigned short *)0x4E2)
#define GAFLID12H0L    (*(volatile __near unsigned char  *)0x4E2)
#define RMD10_7H1L     (*(volatile __near unsigned char  *)0x4E2)
#define GAFLID12H1L    (*(volatile __near unsigned char  *)0x4E2)
#define RMD10_7H0L     (*(volatile __near unsigned char  *)0x4E2)
#define CFDF7H1L       (*(volatile __near unsigned char  *)0x4E2)
#define CFDF7H0L       (*(volatile __near unsigned char  *)0x4E2)
#define RMD2_7H0L      (*(volatile __near unsigned char  *)0x4E2)
#define RMD2_7H1L      (*(volatile __near unsigned char  *)0x4E2)
#define CFDF7H1H       (*(volatile __near unsigned char  *)0x4E3)
#define CFDF7H0H       (*(volatile __near unsigned char  *)0x4E3)
#define RMD10_7H1H     (*(volatile __near unsigned char  *)0x4E3)
#define RMD10_7H0H     (*(volatile __near unsigned char  *)0x4E3)
#define GAFLID12H0H    (*(volatile __near unsigned char  *)0x4E3)
#define GAFLID12H1H    (*(volatile __near unsigned char  *)0x4E3)
#define RMD2_7H0H      (*(volatile __near unsigned char  *)0x4E3)
#define RMD2_7H1H      (*(volatile __near unsigned char  *)0x4E3)
#define RMD10_8L0      (*(volatile __near unsigned short *)0x4E4)
#define CFDF8L0        (*(volatile __near unsigned short *)0x4E4)
#define CFDF8L1        (*(volatile __near unsigned short *)0x4E4)
#define GAFLM12L0      (*(volatile __near unsigned short *)0x4E4)
#define GAFLM12L1      (*(volatile __near unsigned short *)0x4E4)
#define RMD2_8L1       (*(volatile __near unsigned short *)0x4E4)
#define RMD2_8L0       (*(volatile __near unsigned short *)0x4E4)
#define RMD10_8L1      (*(volatile __near unsigned short *)0x4E4)
#define CFDF8L0L       (*(volatile __near unsigned char  *)0x4E4)
#define GAFLM12L0L     (*(volatile __near unsigned char  *)0x4E4)
#define GAFLM12L1L     (*(volatile __near unsigned char  *)0x4E4)
#define CFDF8L1L       (*(volatile __near unsigned char  *)0x4E4)
#define RMD2_8L0L      (*(volatile __near unsigned char  *)0x4E4)
#define RMD2_8L1L      (*(volatile __near unsigned char  *)0x4E4)
#define RMD10_8L1L     (*(volatile __near unsigned char  *)0x4E4)
#define RMD10_8L0L     (*(volatile __near unsigned char  *)0x4E4)
#define CFDF8L0H       (*(volatile __near unsigned char  *)0x4E5)
#define GAFLM12L0H     (*(volatile __near unsigned char  *)0x4E5)
#define GAFLM12L1H     (*(volatile __near unsigned char  *)0x4E5)
#define CFDF8L1H       (*(volatile __near unsigned char  *)0x4E5)
#define RMD2_8L1H      (*(volatile __near unsigned char  *)0x4E5)
#define RMD2_8L0H      (*(volatile __near unsigned char  *)0x4E5)
#define RMD10_8L0H     (*(volatile __near unsigned char  *)0x4E5)
#define RMD10_8L1H     (*(volatile __near unsigned char  *)0x4E5)
#define CFDF8H0        (*(volatile __near unsigned short *)0x4E6)
#define GAFLM12H0      (*(volatile __near unsigned short *)0x4E6)
#define GAFLM12H1      (*(volatile __near unsigned short *)0x4E6)
#define CFDF8H1        (*(volatile __near unsigned short *)0x4E6)
#define RMD10_8H0      (*(volatile __near unsigned short *)0x4E6)
#define RMD10_8H1      (*(volatile __near unsigned short *)0x4E6)
#define RMD2_8H0       (*(volatile __near unsigned short *)0x4E6)
#define RMD2_8H1       (*(volatile __near unsigned short *)0x4E6)
#define RMD10_8H0L     (*(volatile __near unsigned char  *)0x4E6)
#define RMD10_8H1L     (*(volatile __near unsigned char  *)0x4E6)
#define CFDF8H0L       (*(volatile __near unsigned char  *)0x4E6)
#define CFDF8H1L       (*(volatile __near unsigned char  *)0x4E6)
#define RMD2_8H0L      (*(volatile __near unsigned char  *)0x4E6)
#define RMD2_8H1L      (*(volatile __near unsigned char  *)0x4E6)
#define GAFLM12H0L     (*(volatile __near unsigned char  *)0x4E6)
#define GAFLM12H1L     (*(volatile __near unsigned char  *)0x4E6)
#define CFDF8H0H       (*(volatile __near unsigned char  *)0x4E7)
#define RMD2_8H0H      (*(volatile __near unsigned char  *)0x4E7)
#define RMD2_8H1H      (*(volatile __near unsigned char  *)0x4E7)
#define GAFLM12H1H     (*(volatile __near unsigned char  *)0x4E7)
#define GAFLM12H0H     (*(volatile __near unsigned char  *)0x4E7)
#define RMD10_8H0H     (*(volatile __near unsigned char  *)0x4E7)
#define CFDF8H1H       (*(volatile __near unsigned char  *)0x4E7)
#define RMD10_8H1H     (*(volatile __near unsigned char  *)0x4E7)
#define CFDF9L0        (*(volatile __near unsigned short *)0x4E8)
#define CFDF9L1        (*(volatile __near unsigned short *)0x4E8)
#define GAFLP012L0     (*(volatile __near unsigned short *)0x4E8)
#define GAFLP012L1     (*(volatile __near unsigned short *)0x4E8)
#define RMD10_9L1      (*(volatile __near unsigned short *)0x4E8)
#define RMD2_9L1       (*(volatile __near unsigned short *)0x4E8)
#define RMD2_9L0       (*(volatile __near unsigned short *)0x4E8)
#define RMD10_9L0      (*(volatile __near unsigned short *)0x4E8)
#define GAFLP012L0L    (*(volatile __near unsigned char  *)0x4E8)
#define RMD10_9L0L     (*(volatile __near unsigned char  *)0x4E8)
#define CFDF9L1L       (*(volatile __near unsigned char  *)0x4E8)
#define CFDF9L0L       (*(volatile __near unsigned char  *)0x4E8)
#define RMD10_9L1L     (*(volatile __near unsigned char  *)0x4E8)
#define GAFLP012L1L    (*(volatile __near unsigned char  *)0x4E8)
#define RMD2_9L0L      (*(volatile __near unsigned char  *)0x4E8)
#define RMD2_9L1L      (*(volatile __near unsigned char  *)0x4E8)
#define GAFLP012L1H    (*(volatile __near unsigned char  *)0x4E9)
#define RMD2_9L1H      (*(volatile __near unsigned char  *)0x4E9)
#define GAFLP012L0H    (*(volatile __near unsigned char  *)0x4E9)
#define RMD10_9L0H     (*(volatile __near unsigned char  *)0x4E9)
#define CFDF9L1H       (*(volatile __near unsigned char  *)0x4E9)
#define RMD10_9L1H     (*(volatile __near unsigned char  *)0x4E9)
#define CFDF9L0H       (*(volatile __near unsigned char  *)0x4E9)
#define RMD2_9L0H      (*(volatile __near unsigned char  *)0x4E9)
#define GAFLP012H1     (*(volatile __near unsigned short *)0x4EA)
#define CFDF9H0        (*(volatile __near unsigned short *)0x4EA)
#define RMD10_9H0      (*(volatile __near unsigned short *)0x4EA)
#define RMD2_9H0       (*(volatile __near unsigned short *)0x4EA)
#define GAFLP012H0     (*(volatile __near unsigned short *)0x4EA)
#define CFDF9H1        (*(volatile __near unsigned short *)0x4EA)
#define RMD2_9H1       (*(volatile __near unsigned short *)0x4EA)
#define RMD10_9H1      (*(volatile __near unsigned short *)0x4EA)
#define RMD10_9H0L     (*(volatile __near unsigned char  *)0x4EA)
#define RMD10_9H1L     (*(volatile __near unsigned char  *)0x4EA)
#define GAFLP012H0L    (*(volatile __near unsigned char  *)0x4EA)
#define GAFLP012H1L    (*(volatile __near unsigned char  *)0x4EA)
#define CFDF9H1L       (*(volatile __near unsigned char  *)0x4EA)
#define CFDF9H0L       (*(volatile __near unsigned char  *)0x4EA)
#define RMD2_9H0L      (*(volatile __near unsigned char  *)0x4EA)
#define RMD2_9H1L      (*(volatile __near unsigned char  *)0x4EA)
#define CFDF9H1H       (*(volatile __near unsigned char  *)0x4EB)
#define CFDF9H0H       (*(volatile __near unsigned char  *)0x4EB)
#define RMD2_9H0H      (*(volatile __near unsigned char  *)0x4EB)
#define RMD10_9H0H     (*(volatile __near unsigned char  *)0x4EB)
#define RMD10_9H1H     (*(volatile __near unsigned char  *)0x4EB)
#define GAFLP012H0H    (*(volatile __near unsigned char  *)0x4EB)
#define GAFLP012H1H    (*(volatile __near unsigned char  *)0x4EB)
#define RMD2_9H1H      (*(volatile __near unsigned char  *)0x4EB)
#define RMD2_10L1      (*(volatile __near unsigned short *)0x4EC)
#define RMD2_10L0      (*(volatile __near unsigned short *)0x4EC)
#define CFDF10L1       (*(volatile __near unsigned short *)0x4EC)
#define CFDF10L0       (*(volatile __near unsigned short *)0x4EC)
#define RMD10_10L0     (*(volatile __near unsigned short *)0x4EC)
#define GAFLP112L1     (*(volatile __near unsigned short *)0x4EC)
#define GAFLP112L0     (*(volatile __near unsigned short *)0x4EC)
#define RMD10_10L1     (*(volatile __near unsigned short *)0x4EC)
#define GAFLP112L1L    (*(volatile __near unsigned char  *)0x4EC)
#define RMD10_10L0L    (*(volatile __near unsigned char  *)0x4EC)
#define RMD2_10L0L     (*(volatile __near unsigned char  *)0x4EC)
#define RMD10_10L1L    (*(volatile __near unsigned char  *)0x4EC)
#define RMD2_10L1L     (*(volatile __near unsigned char  *)0x4EC)
#define CFDF10L0L      (*(volatile __near unsigned char  *)0x4EC)
#define GAFLP112L0L    (*(volatile __near unsigned char  *)0x4EC)
#define CFDF10L1L      (*(volatile __near unsigned char  *)0x4EC)
#define GAFLP112L0H    (*(volatile __near unsigned char  *)0x4ED)
#define CFDF10L0H      (*(volatile __near unsigned char  *)0x4ED)
#define CFDF10L1H      (*(volatile __near unsigned char  *)0x4ED)
#define RMD2_10L0H     (*(volatile __near unsigned char  *)0x4ED)
#define GAFLP112L1H    (*(volatile __near unsigned char  *)0x4ED)
#define RMD2_10L1H     (*(volatile __near unsigned char  *)0x4ED)
#define RMD10_10L0H    (*(volatile __near unsigned char  *)0x4ED)
#define RMD10_10L1H    (*(volatile __near unsigned char  *)0x4ED)
#define CFDF10H1       (*(volatile __near unsigned short *)0x4EE)
#define RMD2_10H0      (*(volatile __near unsigned short *)0x4EE)
#define RMD2_10H1      (*(volatile __near unsigned short *)0x4EE)
#define CFDF10H0       (*(volatile __near unsigned short *)0x4EE)
#define RMD10_10H1     (*(volatile __near unsigned short *)0x4EE)
#define RMD10_10H0     (*(volatile __near unsigned short *)0x4EE)
#define CFDF10H0L      (*(volatile __near unsigned char  *)0x4EE)
#define CFDF10H1L      (*(volatile __near unsigned char  *)0x4EE)
#define RMD2_10H0L     (*(volatile __near unsigned char  *)0x4EE)
#define RMD2_10H1L     (*(volatile __near unsigned char  *)0x4EE)
#define RMD10_10H0L    (*(volatile __near unsigned char  *)0x4EE)
#define RMD10_10H1L    (*(volatile __near unsigned char  *)0x4EE)
#define RMD10_10H0H    (*(volatile __near unsigned char  *)0x4EF)
#define CFDF10H0H      (*(volatile __near unsigned char  *)0x4EF)
#define RMD2_10H1H     (*(volatile __near unsigned char  *)0x4EF)
#define CFDF10H1H      (*(volatile __near unsigned char  *)0x4EF)
#define RMD10_10H1H    (*(volatile __near unsigned char  *)0x4EF)
#define RMD2_10H0H     (*(volatile __near unsigned char  *)0x4EF)
#define RMD2_11L0      (*(volatile __near unsigned short *)0x4F0)
#define CFDF11L1       (*(volatile __near unsigned short *)0x4F0)
#define RMD10_11L1     (*(volatile __near unsigned short *)0x4F0)
#define RMD10_11L0     (*(volatile __near unsigned short *)0x4F0)
#define GAFLID13L1     (*(volatile __near unsigned short *)0x4F0)
#define GAFLID13L0     (*(volatile __near unsigned short *)0x4F0)
#define CFDF11L0       (*(volatile __near unsigned short *)0x4F0)
#define RMD2_11L1      (*(volatile __near unsigned short *)0x4F0)
#define GAFLID13L0L    (*(volatile __near unsigned char  *)0x4F0)
#define CFDF11L1L      (*(volatile __near unsigned char  *)0x4F0)
#define CFDF11L0L      (*(volatile __near unsigned char  *)0x4F0)
#define RMD10_11L1L    (*(volatile __near unsigned char  *)0x4F0)
#define RMD10_11L0L    (*(volatile __near unsigned char  *)0x4F0)
#define GAFLID13L1L    (*(volatile __near unsigned char  *)0x4F0)
#define RMD2_11L1L     (*(volatile __near unsigned char  *)0x4F0)
#define RMD2_11L0L     (*(volatile __near unsigned char  *)0x4F0)
#define RMD10_11L1H    (*(volatile __near unsigned char  *)0x4F1)
#define GAFLID13L1H    (*(volatile __near unsigned char  *)0x4F1)
#define RMD10_11L0H    (*(volatile __near unsigned char  *)0x4F1)
#define GAFLID13L0H    (*(volatile __near unsigned char  *)0x4F1)
#define RMD2_11L1H     (*(volatile __near unsigned char  *)0x4F1)
#define RMD2_11L0H     (*(volatile __near unsigned char  *)0x4F1)
#define CFDF11L1H      (*(volatile __near unsigned char  *)0x4F1)
#define CFDF11L0H      (*(volatile __near unsigned char  *)0x4F1)
#define GAFLID13H0     (*(volatile __near unsigned short *)0x4F2)
#define GAFLID13H1     (*(volatile __near unsigned short *)0x4F2)
#define RMD10_11H0     (*(volatile __near unsigned short *)0x4F2)
#define CFDF11H1       (*(volatile __near unsigned short *)0x4F2)
#define RMD2_11H1      (*(volatile __near unsigned short *)0x4F2)
#define RMD2_11H0      (*(volatile __near unsigned short *)0x4F2)
#define CFDF11H0       (*(volatile __near unsigned short *)0x4F2)
#define RMD10_11H1     (*(volatile __near unsigned short *)0x4F2)
#define GAFLID13H0L    (*(volatile __near unsigned char  *)0x4F2)
#define CFDF11H1L      (*(volatile __near unsigned char  *)0x4F2)
#define CFDF11H0L      (*(volatile __near unsigned char  *)0x4F2)
#define RMD10_11H1L    (*(volatile __near unsigned char  *)0x4F2)
#define RMD2_11H1L     (*(volatile __near unsigned char  *)0x4F2)
#define RMD10_11H0L    (*(volatile __near unsigned char  *)0x4F2)
#define GAFLID13H1L    (*(volatile __near unsigned char  *)0x4F2)
#define RMD2_11H0L     (*(volatile __near unsigned char  *)0x4F2)
#define GAFLID13H0H    (*(volatile __near unsigned char  *)0x4F3)
#define GAFLID13H1H    (*(volatile __near unsigned char  *)0x4F3)
#define CFDF11H0H      (*(volatile __near unsigned char  *)0x4F3)
#define CFDF11H1H      (*(volatile __near unsigned char  *)0x4F3)
#define RMD2_11H0H     (*(volatile __near unsigned char  *)0x4F3)
#define RMD2_11H1H     (*(volatile __near unsigned char  *)0x4F3)
#define RMD10_11H0H    (*(volatile __near unsigned char  *)0x4F3)
#define RMD10_11H1H    (*(volatile __near unsigned char  *)0x4F3)
#define RMD2_12L1      (*(volatile __near unsigned short *)0x4F4)
#define RMD2_12L0      (*(volatile __near unsigned short *)0x4F4)
#define GAFLM13L1      (*(volatile __near unsigned short *)0x4F4)
#define CFDF12L0       (*(volatile __near unsigned short *)0x4F4)
#define CFDF12L1       (*(volatile __near unsigned short *)0x4F4)
#define GAFLM13L0      (*(volatile __near unsigned short *)0x4F4)
#define RMD10_12L1     (*(volatile __near unsigned short *)0x4F4)
#define RMD10_12L0     (*(volatile __near unsigned short *)0x4F4)
#define RMD2_12L0L     (*(volatile __near unsigned char  *)0x4F4)
#define GAFLM13L1L     (*(volatile __near unsigned char  *)0x4F4)
#define GAFLM13L0L     (*(volatile __near unsigned char  *)0x4F4)
#define RMD2_12L1L     (*(volatile __near unsigned char  *)0x4F4)
#define RMD10_12L1L    (*(volatile __near unsigned char  *)0x4F4)
#define RMD10_12L0L    (*(volatile __near unsigned char  *)0x4F4)
#define CFDF12L0L      (*(volatile __near unsigned char  *)0x4F4)
#define CFDF12L1L      (*(volatile __near unsigned char  *)0x4F4)
#define RMD10_12L0H    (*(volatile __near unsigned char  *)0x4F5)
#define RMD10_12L1H    (*(volatile __near unsigned char  *)0x4F5)
#define RMD2_12L0H     (*(volatile __near unsigned char  *)0x4F5)
#define CFDF12L1H      (*(volatile __near unsigned char  *)0x4F5)
#define GAFLM13L0H     (*(volatile __near unsigned char  *)0x4F5)
#define CFDF12L0H      (*(volatile __near unsigned char  *)0x4F5)
#define GAFLM13L1H     (*(volatile __near unsigned char  *)0x4F5)
#define RMD2_12L1H     (*(volatile __near unsigned char  *)0x4F5)
#define RMD10_12H1     (*(volatile __near unsigned short *)0x4F6)
#define CFDF12H1       (*(volatile __near unsigned short *)0x4F6)
#define RMD10_12H0     (*(volatile __near unsigned short *)0x4F6)
#define GAFLM13H0      (*(volatile __near unsigned short *)0x4F6)
#define GAFLM13H1      (*(volatile __near unsigned short *)0x4F6)
#define CFDF12H0       (*(volatile __near unsigned short *)0x4F6)
#define RMD2_12H1      (*(volatile __near unsigned short *)0x4F6)
#define RMD2_12H0      (*(volatile __near unsigned short *)0x4F6)
#define RMD10_12H1L    (*(volatile __near unsigned char  *)0x4F6)
#define CFDF12H0L      (*(volatile __near unsigned char  *)0x4F6)
#define GAFLM13H0L     (*(volatile __near unsigned char  *)0x4F6)
#define GAFLM13H1L     (*(volatile __near unsigned char  *)0x4F6)
#define RMD2_12H1L     (*(volatile __near unsigned char  *)0x4F6)
#define RMD2_12H0L     (*(volatile __near unsigned char  *)0x4F6)
#define CFDF12H1L      (*(volatile __near unsigned char  *)0x4F6)
#define RMD10_12H0L    (*(volatile __near unsigned char  *)0x4F6)
#define CFDF12H0H      (*(volatile __near unsigned char  *)0x4F7)
#define GAFLM13H0H     (*(volatile __near unsigned char  *)0x4F7)
#define CFDF12H1H      (*(volatile __near unsigned char  *)0x4F7)
#define RMD2_12H0H     (*(volatile __near unsigned char  *)0x4F7)
#define RMD2_12H1H     (*(volatile __near unsigned char  *)0x4F7)
#define RMD10_12H1H    (*(volatile __near unsigned char  *)0x4F7)
#define RMD10_12H0H    (*(volatile __near unsigned char  *)0x4F7)
#define GAFLM13H1H     (*(volatile __near unsigned char  *)0x4F7)
#define RMD10_13L1     (*(volatile __near unsigned short *)0x4F8)
#define RMD10_13L0     (*(volatile __near unsigned short *)0x4F8)
#define RMD2_13L1      (*(volatile __near unsigned short *)0x4F8)
#define GAFLP013L1     (*(volatile __near unsigned short *)0x4F8)
#define CFDF13L1       (*(volatile __near unsigned short *)0x4F8)
#define CFDF13L0       (*(volatile __near unsigned short *)0x4F8)
#define GAFLP013L0     (*(volatile __near unsigned short *)0x4F8)
#define RMD2_13L0      (*(volatile __near unsigned short *)0x4F8)
#define RMD2_13L1L     (*(volatile __near unsigned char  *)0x4F8)
#define RMD2_13L0L     (*(volatile __near unsigned char  *)0x4F8)
#define CFDF13L0L      (*(volatile __near unsigned char  *)0x4F8)
#define GAFLP013L1L    (*(volatile __near unsigned char  *)0x4F8)
#define RMD10_13L0L    (*(volatile __near unsigned char  *)0x4F8)
#define GAFLP013L0L    (*(volatile __near unsigned char  *)0x4F8)
#define CFDF13L1L      (*(volatile __near unsigned char  *)0x4F8)
#define RMD10_13L1L    (*(volatile __near unsigned char  *)0x4F8)
#define RMD2_13L1H     (*(volatile __near unsigned char  *)0x4F9)
#define RMD2_13L0H     (*(volatile __near unsigned char  *)0x4F9)
#define CFDF13L0H      (*(volatile __near unsigned char  *)0x4F9)
#define GAFLP013L0H    (*(volatile __near unsigned char  *)0x4F9)
#define GAFLP013L1H    (*(volatile __near unsigned char  *)0x4F9)
#define CFDF13L1H      (*(volatile __near unsigned char  *)0x4F9)
#define RMD10_13L0H    (*(volatile __near unsigned char  *)0x4F9)
#define RMD10_13L1H    (*(volatile __near unsigned char  *)0x4F9)
#define RMD2_13H1      (*(volatile __near unsigned short *)0x4FA)
#define CFDF13H1       (*(volatile __near unsigned short *)0x4FA)
#define RMD2_13H0      (*(volatile __near unsigned short *)0x4FA)
#define RMD10_13H0     (*(volatile __near unsigned short *)0x4FA)
#define RMD10_13H1     (*(volatile __near unsigned short *)0x4FA)
#define GAFLP013H1     (*(volatile __near unsigned short *)0x4FA)
#define CFDF13H0       (*(volatile __near unsigned short *)0x4FA)
#define GAFLP013H0     (*(volatile __near unsigned short *)0x4FA)
#define RMD2_13H1L     (*(volatile __near unsigned char  *)0x4FA)
#define CFDF13H1L      (*(volatile __near unsigned char  *)0x4FA)
#define RMD2_13H0L     (*(volatile __near unsigned char  *)0x4FA)
#define CFDF13H0L      (*(volatile __near unsigned char  *)0x4FA)
#define GAFLP013H1L    (*(volatile __near unsigned char  *)0x4FA)
#define RMD10_13H1L    (*(volatile __near unsigned char  *)0x4FA)
#define RMD10_13H0L    (*(volatile __near unsigned char  *)0x4FA)
#define GAFLP013H0L    (*(volatile __near unsigned char  *)0x4FA)
#define RMD10_13H1H    (*(volatile __near unsigned char  *)0x4FB)
#define RMD10_13H0H    (*(volatile __near unsigned char  *)0x4FB)
#define GAFLP013H0H    (*(volatile __near unsigned char  *)0x4FB)
#define CFDF13H1H      (*(volatile __near unsigned char  *)0x4FB)
#define GAFLP013H1H    (*(volatile __near unsigned char  *)0x4FB)
#define CFDF13H0H      (*(volatile __near unsigned char  *)0x4FB)
#define RMD2_13H0H     (*(volatile __near unsigned char  *)0x4FB)
#define RMD2_13H1H     (*(volatile __near unsigned char  *)0x4FB)
#define RMD2_14L1      (*(volatile __near unsigned short *)0x4FC)
#define CFDF14L1       (*(volatile __near unsigned short *)0x4FC)
#define CFDF14L0       (*(volatile __near unsigned short *)0x4FC)
#define RMD2_14L0      (*(volatile __near unsigned short *)0x4FC)
#define RMD10_14L0     (*(volatile __near unsigned short *)0x4FC)
#define RMD10_14L1     (*(volatile __near unsigned short *)0x4FC)
#define GAFLP113L0     (*(volatile __near unsigned short *)0x4FC)
#define GAFLP113L1     (*(volatile __near unsigned short *)0x4FC)
#define RMD10_14L1L    (*(volatile __near unsigned char  *)0x4FC)
#define RMD2_14L0L     (*(volatile __near unsigned char  *)0x4FC)
#define GAFLP113L1L    (*(volatile __near unsigned char  *)0x4FC)
#define RMD10_14L0L    (*(volatile __near unsigned char  *)0x4FC)
#define CFDF14L0L      (*(volatile __near unsigned char  *)0x4FC)
#define CFDF14L1L      (*(volatile __near unsigned char  *)0x4FC)
#define GAFLP113L0L    (*(volatile __near unsigned char  *)0x4FC)
#define RMD2_14L1L     (*(volatile __near unsigned char  *)0x4FC)
#define RMD10_14L1H    (*(volatile __near unsigned char  *)0x4FD)
#define RMD10_14L0H    (*(volatile __near unsigned char  *)0x4FD)
#define RMD2_14L0H     (*(volatile __near unsigned char  *)0x4FD)
#define GAFLP113L0H    (*(volatile __near unsigned char  *)0x4FD)
#define CFDF14L0H      (*(volatile __near unsigned char  *)0x4FD)
#define CFDF14L1H      (*(volatile __near unsigned char  *)0x4FD)
#define GAFLP113L1H    (*(volatile __near unsigned char  *)0x4FD)
#define RMD2_14L1H     (*(volatile __near unsigned char  *)0x4FD)
#define RMD10_14H1     (*(volatile __near unsigned short *)0x4FE)
#define RMD10_14H0     (*(volatile __near unsigned short *)0x4FE)
#define RMD2_14H1      (*(volatile __near unsigned short *)0x4FE)
#define CFDF14H0       (*(volatile __near unsigned short *)0x4FE)
#define RMD2_14H0      (*(volatile __near unsigned short *)0x4FE)
#define CFDF14H1       (*(volatile __near unsigned short *)0x4FE)
#define RMD10_14H0L    (*(volatile __near unsigned char  *)0x4FE)
#define RMD2_14H1L     (*(volatile __near unsigned char  *)0x4FE)
#define RMD2_14H0L     (*(volatile __near unsigned char  *)0x4FE)
#define RMD10_14H1L    (*(volatile __near unsigned char  *)0x4FE)
#define CFDF14H1L      (*(volatile __near unsigned char  *)0x4FE)
#define CFDF14H0L      (*(volatile __near unsigned char  *)0x4FE)
#define CFDF14H0H      (*(volatile __near unsigned char  *)0x4FF)
#define RMD2_14H0H     (*(volatile __near unsigned char  *)0x4FF)
#define RMD2_14H1H     (*(volatile __near unsigned char  *)0x4FF)
#define RMD10_14H0H    (*(volatile __near unsigned char  *)0x4FF)
#define RMD10_14H1H    (*(volatile __near unsigned char  *)0x4FF)
#define CFDF14H1H      (*(volatile __near unsigned char  *)0x4FF)
#define CFDF15L0       (*(volatile __near unsigned short *)0x500)
#define RMD10_15L1     (*(volatile __near unsigned short *)0x500)
#define RMD10_15L0     (*(volatile __near unsigned short *)0x500)
#define CFDF15L1       (*(volatile __near unsigned short *)0x500)
#define GAFLID14L1     (*(volatile __near unsigned short *)0x500)
#define RMD2_15L1      (*(volatile __near unsigned short *)0x500)
#define RMD2_15L0      (*(volatile __near unsigned short *)0x500)
#define GAFLID14L0     (*(volatile __near unsigned short *)0x500)
#define CFDF15L1L      (*(volatile __near unsigned char  *)0x500)
#define RMD10_15L1L    (*(volatile __near unsigned char  *)0x500)
#define RMD10_15L0L    (*(volatile __near unsigned char  *)0x500)
#define CFDF15L0L      (*(volatile __near unsigned char  *)0x500)
#define RMD2_15L1L     (*(volatile __near unsigned char  *)0x500)
#define GAFLID14L1L    (*(volatile __near unsigned char  *)0x500)
#define RMD2_15L0L     (*(volatile __near unsigned char  *)0x500)
#define GAFLID14L0L    (*(volatile __near unsigned char  *)0x500)
#define RMD10_15L1H    (*(volatile __near unsigned char  *)0x501)
#define RMD10_15L0H    (*(volatile __near unsigned char  *)0x501)
#define CFDF15L1H      (*(volatile __near unsigned char  *)0x501)
#define CFDF15L0H      (*(volatile __near unsigned char  *)0x501)
#define GAFLID14L1H    (*(volatile __near unsigned char  *)0x501)
#define RMD2_15L0H     (*(volatile __near unsigned char  *)0x501)
#define RMD2_15L1H     (*(volatile __near unsigned char  *)0x501)
#define GAFLID14L0H    (*(volatile __near unsigned char  *)0x501)
#define RMD10_15H1     (*(volatile __near unsigned short *)0x502)
#define CFDF15H0       (*(volatile __near unsigned short *)0x502)
#define CFDF15H1       (*(volatile __near unsigned short *)0x502)
#define RMD2_15H1      (*(volatile __near unsigned short *)0x502)
#define RMD2_15H0      (*(volatile __near unsigned short *)0x502)
#define RMD10_15H0     (*(volatile __near unsigned short *)0x502)
#define GAFLID14H0     (*(volatile __near unsigned short *)0x502)
#define GAFLID14H1     (*(volatile __near unsigned short *)0x502)
#define RMD10_15H1L    (*(volatile __near unsigned char  *)0x502)
#define CFDF15H0L      (*(volatile __near unsigned char  *)0x502)
#define CFDF15H1L      (*(volatile __near unsigned char  *)0x502)
#define RMD10_15H0L    (*(volatile __near unsigned char  *)0x502)
#define GAFLID14H0L    (*(volatile __near unsigned char  *)0x502)
#define RMD2_15H1L     (*(volatile __near unsigned char  *)0x502)
#define GAFLID14H1L    (*(volatile __near unsigned char  *)0x502)
#define RMD2_15H0L     (*(volatile __near unsigned char  *)0x502)
#define RMD10_15H1H    (*(volatile __near unsigned char  *)0x503)
#define CFDF15H1H      (*(volatile __near unsigned char  *)0x503)
#define CFDF15H0H      (*(volatile __near unsigned char  *)0x503)
#define RMD10_15H0H    (*(volatile __near unsigned char  *)0x503)
#define RMD2_15H1H     (*(volatile __near unsigned char  *)0x503)
#define GAFLID14H1H    (*(volatile __near unsigned char  *)0x503)
#define RMD2_15H0H     (*(volatile __near unsigned char  *)0x503)
#define GAFLID14H0H    (*(volatile __near unsigned char  *)0x503)
#define GAFLM14L1      (*(volatile __near unsigned short *)0x504)
#define TMID0L0        (*(volatile __near unsigned short *)0x504)
#define GAFLM14L0      (*(volatile __near unsigned short *)0x504)
#define RMID3L1        (*(volatile __near unsigned short *)0x504)
#define RMID3L0        (*(volatile __near unsigned short *)0x504)
#define RMID11L0       (*(volatile __near unsigned short *)0x504)
#define RMID11L1       (*(volatile __near unsigned short *)0x504)
#define TMID0L1        (*(volatile __near unsigned short *)0x504)
#define GAFLM14L0L     (*(volatile __near unsigned char  *)0x504)
#define RMID3L0L       (*(volatile __near unsigned char  *)0x504)
#define TMID0L0L       (*(volatile __near unsigned char  *)0x504)
#define RMID3L1L       (*(volatile __near unsigned char  *)0x504)
#define TMID0L1L       (*(volatile __near unsigned char  *)0x504)
#define RMID11L0L      (*(volatile __near unsigned char  *)0x504)
#define GAFLM14L1L     (*(volatile __near unsigned char  *)0x504)
#define RMID11L1L      (*(volatile __near unsigned char  *)0x504)
#define RMID11L0H      (*(volatile __near unsigned char  *)0x505)
#define RMID11L1H      (*(volatile __near unsigned char  *)0x505)
#define RMID3L0H       (*(volatile __near unsigned char  *)0x505)
#define RMID3L1H       (*(volatile __near unsigned char  *)0x505)
#define GAFLM14L0H     (*(volatile __near unsigned char  *)0x505)
#define GAFLM14L1H     (*(volatile __near unsigned char  *)0x505)
#define TMID0L0H       (*(volatile __near unsigned char  *)0x505)
#define TMID0L1H       (*(volatile __near unsigned char  *)0x505)
#define GAFLM14H0      (*(volatile __near unsigned short *)0x506)
#define RMID3H0        (*(volatile __near unsigned short *)0x506)
#define RMID3H1        (*(volatile __near unsigned short *)0x506)
#define RMID11H0       (*(volatile __near unsigned short *)0x506)
#define TMID0H0        (*(volatile __near unsigned short *)0x506)
#define TMID0H1        (*(volatile __near unsigned short *)0x506)
#define RMID11H1       (*(volatile __near unsigned short *)0x506)
#define GAFLM14H1      (*(volatile __near unsigned short *)0x506)
#define RMID3H1L       (*(volatile __near unsigned char  *)0x506)
#define RMID11H1L      (*(volatile __near unsigned char  *)0x506)
#define GAFLM14H1L     (*(volatile __near unsigned char  *)0x506)
#define GAFLM14H0L     (*(volatile __near unsigned char  *)0x506)
#define RMID11H0L      (*(volatile __near unsigned char  *)0x506)
#define TMID0H1L       (*(volatile __near unsigned char  *)0x506)
#define TMID0H0L       (*(volatile __near unsigned char  *)0x506)
#define RMID3H0L       (*(volatile __near unsigned char  *)0x506)
#define RMID11H1H      (*(volatile __near unsigned char  *)0x507)
#define RMID11H0H      (*(volatile __near unsigned char  *)0x507)
#define RMID3H1H       (*(volatile __near unsigned char  *)0x507)
#define RMID3H0H       (*(volatile __near unsigned char  *)0x507)
#define TMID0H1H       (*(volatile __near unsigned char  *)0x507)
#define GAFLM14H1H     (*(volatile __near unsigned char  *)0x507)
#define TMID0H0H       (*(volatile __near unsigned char  *)0x507)
#define GAFLM14H0H     (*(volatile __near unsigned char  *)0x507)
#define RMPTR11L0      (*(volatile __near unsigned short *)0x508)
#define RMPTR11L1      (*(volatile __near unsigned short *)0x508)
#define GAFLP014L0     (*(volatile __near unsigned short *)0x508)
#define GAFLP014L1     (*(volatile __near unsigned short *)0x508)
#define RMPTR3L1       (*(volatile __near unsigned short *)0x508)
#define RMPTR3L0       (*(volatile __near unsigned short *)0x508)
#define RMPTR11L0L     (*(volatile __near unsigned char  *)0x508)
#define RMPTR11L1L     (*(volatile __near unsigned char  *)0x508)
#define GAFLP014L1L    (*(volatile __near unsigned char  *)0x508)
#define GAFLP014L0L    (*(volatile __near unsigned char  *)0x508)
#define RMPTR3L1L      (*(volatile __near unsigned char  *)0x508)
#define RMPTR3L0L      (*(volatile __near unsigned char  *)0x508)
#define GAFLP014L0H    (*(volatile __near unsigned char  *)0x509)
#define RMPTR11L0H     (*(volatile __near unsigned char  *)0x509)
#define GAFLP014L1H    (*(volatile __near unsigned char  *)0x509)
#define RMPTR11L1H     (*(volatile __near unsigned char  *)0x509)
#define RMPTR3L1H      (*(volatile __near unsigned char  *)0x509)
#define RMPTR3L0H      (*(volatile __near unsigned char  *)0x509)
#define RMPTR11H0      (*(volatile __near unsigned short *)0x50A)
#define RMPTR11H1      (*(volatile __near unsigned short *)0x50A)
#define TMPTR0H1       (*(volatile __near unsigned short *)0x50A)
#define TMPTR0H0       (*(volatile __near unsigned short *)0x50A)
#define GAFLP014H1     (*(volatile __near unsigned short *)0x50A)
#define GAFLP014H0     (*(volatile __near unsigned short *)0x50A)
#define RMPTR3H1       (*(volatile __near unsigned short *)0x50A)
#define RMPTR3H0       (*(volatile __near unsigned short *)0x50A)
#define GAFLP014H1L    (*(volatile __near unsigned char  *)0x50A)
#define GAFLP014H0L    (*(volatile __near unsigned char  *)0x50A)
#define TMPTR0H1H      (*(volatile __near unsigned char  *)0x50B)
#define GAFLP014H1H    (*(volatile __near unsigned char  *)0x50B)
#define GAFLP014H0H    (*(volatile __near unsigned char  *)0x50B)
#define TMPTR0H0H      (*(volatile __near unsigned char  *)0x50B)
#define RMPTR11H1H     (*(volatile __near unsigned char  *)0x50B)
#define RMPTR11H0H     (*(volatile __near unsigned char  *)0x50B)
#define RMPTR3H0H      (*(volatile __near unsigned char  *)0x50B)
#define RMPTR3H1H      (*(volatile __near unsigned char  *)0x50B)
#define TMFDCTR0L1     (*(volatile __near unsigned short *)0x50C)
#define TMFDCTR0L0     (*(volatile __near unsigned short *)0x50C)
#define GAFLP114L0     (*(volatile __near unsigned short *)0x50C)
#define GAFLP114L1     (*(volatile __near unsigned short *)0x50C)
#define RMSTS3L1       (*(volatile __near unsigned short *)0x50C)
#define RMSTS11L1      (*(volatile __near unsigned short *)0x50C)
#define RMSTS11L0      (*(volatile __near unsigned short *)0x50C)
#define RMSTS3L0       (*(volatile __near unsigned short *)0x50C)
#define TMFDCTR0L1L    (*(volatile __near unsigned char  *)0x50C)
#define TMFDCTR0L0L    (*(volatile __near unsigned char  *)0x50C)
#define RMSTS11L0L     (*(volatile __near unsigned char  *)0x50C)
#define GAFLP114L0L    (*(volatile __near unsigned char  *)0x50C)
#define GAFLP114L1L    (*(volatile __near unsigned char  *)0x50C)
#define RMSTS3L1L      (*(volatile __near unsigned char  *)0x50C)
#define RMSTS3L0L      (*(volatile __near unsigned char  *)0x50C)
#define RMSTS11L1L     (*(volatile __near unsigned char  *)0x50C)
#define TMFDCTR0L1H    (*(volatile __near unsigned char  *)0x50D)
#define TMFDCTR0L0H    (*(volatile __near unsigned char  *)0x50D)
#define RMSTS3L0H      (*(volatile __near unsigned char  *)0x50D)
#define RMSTS3L1H      (*(volatile __near unsigned char  *)0x50D)
#define GAFLP114L0H    (*(volatile __near unsigned char  *)0x50D)
#define RMSTS11L0H     (*(volatile __near unsigned char  *)0x50D)
#define RMSTS11L1H     (*(volatile __near unsigned char  *)0x50D)
#define GAFLP114L1H    (*(volatile __near unsigned char  *)0x50D)
#define TMFDCTR0H0     (*(volatile __near unsigned short *)0x50E)
#define TMFDCTR0H1     (*(volatile __near unsigned short *)0x50E)
#define RMSTS11H0      (*(volatile __near unsigned short *)0x50E)
#define RMSTS3H0       (*(volatile __near unsigned short *)0x50E)
#define RMSTS3H1       (*(volatile __near unsigned short *)0x50E)
#define RMSTS11H1      (*(volatile __near unsigned short *)0x50E)
#define TMFDCTR0H1L    (*(volatile __near unsigned char  *)0x50E)
#define TMFDCTR0H0L    (*(volatile __near unsigned char  *)0x50E)
#define RMSTS11H0L     (*(volatile __near unsigned char  *)0x50E)
#define RMSTS3H0L      (*(volatile __near unsigned char  *)0x50E)
#define RMSTS3H1L      (*(volatile __near unsigned char  *)0x50E)
#define RMSTS11H1L     (*(volatile __near unsigned char  *)0x50E)
#define TMFDCTR0H0H    (*(volatile __near unsigned char  *)0x50F)
#define TMFDCTR0H1H    (*(volatile __near unsigned char  *)0x50F)
#define RMSTS11H0H     (*(volatile __near unsigned char  *)0x50F)
#define RMSTS3H0H      (*(volatile __near unsigned char  *)0x50F)
#define RMSTS11H1H     (*(volatile __near unsigned char  *)0x50F)
#define RMSTS3H1H      (*(volatile __near unsigned char  *)0x50F)
#define TMDF0_0L1      (*(volatile __near unsigned short *)0x510)
#define TMDF0_0L0      (*(volatile __near unsigned short *)0x510)
#define RMD11_0L1      (*(volatile __near unsigned short *)0x510)
#define GAFLID15L0     (*(volatile __near unsigned short *)0x510)
#define RMD11_0L0      (*(volatile __near unsigned short *)0x510)
#define RMD3_0L0       (*(volatile __near unsigned short *)0x510)
#define RMD3_0L1       (*(volatile __near unsigned short *)0x510)
#define GAFLID15L1     (*(volatile __near unsigned short *)0x510)
#define RMD11_0L1L     (*(volatile __near unsigned char  *)0x510)
#define RMD11_0L0L     (*(volatile __near unsigned char  *)0x510)
#define RMD3_0L0L      (*(volatile __near unsigned char  *)0x510)
#define TMDF0_0L1L     (*(volatile __near unsigned char  *)0x510)
#define RMD3_0L1L      (*(volatile __near unsigned char  *)0x510)
#define TMDF0_0L0L     (*(volatile __near unsigned char  *)0x510)
#define GAFLID15L0L    (*(volatile __near unsigned char  *)0x510)
#define GAFLID15L1L    (*(volatile __near unsigned char  *)0x510)
#define TMDF0_0L0H     (*(volatile __near unsigned char  *)0x511)
#define RMD3_0L1H      (*(volatile __near unsigned char  *)0x511)
#define RMD3_0L0H      (*(volatile __near unsigned char  *)0x511)
#define TMDF0_0L1H     (*(volatile __near unsigned char  *)0x511)
#define GAFLID15L0H    (*(volatile __near unsigned char  *)0x511)
#define RMD11_0L0H     (*(volatile __near unsigned char  *)0x511)
#define GAFLID15L1H    (*(volatile __near unsigned char  *)0x511)
#define RMD11_0L1H     (*(volatile __near unsigned char  *)0x511)
#define TMDF0_0H1      (*(volatile __near unsigned short *)0x512)
#define RMD3_0H0       (*(volatile __near unsigned short *)0x512)
#define RMD11_0H1      (*(volatile __near unsigned short *)0x512)
#define GAFLID15H1     (*(volatile __near unsigned short *)0x512)
#define TMDF0_0H0      (*(volatile __near unsigned short *)0x512)
#define RMD3_0H1       (*(volatile __near unsigned short *)0x512)
#define GAFLID15H0     (*(volatile __near unsigned short *)0x512)
#define RMD11_0H0      (*(volatile __near unsigned short *)0x512)
#define GAFLID15H1L    (*(volatile __near unsigned char  *)0x512)
#define RMD3_0H1L      (*(volatile __near unsigned char  *)0x512)
#define RMD3_0H0L      (*(volatile __near unsigned char  *)0x512)
#define RMD11_0H1L     (*(volatile __near unsigned char  *)0x512)
#define GAFLID15H0L    (*(volatile __near unsigned char  *)0x512)
#define RMD11_0H0L     (*(volatile __near unsigned char  *)0x512)
#define TMDF0_0H0L     (*(volatile __near unsigned char  *)0x512)
#define TMDF0_0H1L     (*(volatile __near unsigned char  *)0x512)
#define RMD3_0H0H      (*(volatile __near unsigned char  *)0x513)
#define GAFLID15H1H    (*(volatile __near unsigned char  *)0x513)
#define GAFLID15H0H    (*(volatile __near unsigned char  *)0x513)
#define RMD11_0H1H     (*(volatile __near unsigned char  *)0x513)
#define RMD3_0H1H      (*(volatile __near unsigned char  *)0x513)
#define TMDF0_0H0H     (*(volatile __near unsigned char  *)0x513)
#define RMD11_0H0H     (*(volatile __near unsigned char  *)0x513)
#define TMDF0_0H1H     (*(volatile __near unsigned char  *)0x513)
#define RMD3_1L0       (*(volatile __near unsigned short *)0x514)
#define TMDF0_1L1      (*(volatile __near unsigned short *)0x514)
#define TMDF0_1L0      (*(volatile __near unsigned short *)0x514)
#define RMD11_1L0      (*(volatile __near unsigned short *)0x514)
#define GAFLM15L0      (*(volatile __near unsigned short *)0x514)
#define GAFLM15L1      (*(volatile __near unsigned short *)0x514)
#define RMD11_1L1      (*(volatile __near unsigned short *)0x514)
#define RMD3_1L1       (*(volatile __near unsigned short *)0x514)
#define GAFLM15L0L     (*(volatile __near unsigned char  *)0x514)
#define TMDF0_1L0L     (*(volatile __near unsigned char  *)0x514)
#define TMDF0_1L1L     (*(volatile __near unsigned char  *)0x514)
#define RMD11_1L0L     (*(volatile __near unsigned char  *)0x514)
#define GAFLM15L1L     (*(volatile __near unsigned char  *)0x514)
#define RMD11_1L1L     (*(volatile __near unsigned char  *)0x514)
#define RMD3_1L0L      (*(volatile __near unsigned char  *)0x514)
#define RMD3_1L1L      (*(volatile __near unsigned char  *)0x514)
#define GAFLM15L0H     (*(volatile __near unsigned char  *)0x515)
#define TMDF0_1L0H     (*(volatile __near unsigned char  *)0x515)
#define GAFLM15L1H     (*(volatile __near unsigned char  *)0x515)
#define TMDF0_1L1H     (*(volatile __near unsigned char  *)0x515)
#define RMD3_1L0H      (*(volatile __near unsigned char  *)0x515)
#define RMD11_1L0H     (*(volatile __near unsigned char  *)0x515)
#define RMD3_1L1H      (*(volatile __near unsigned char  *)0x515)
#define RMD11_1L1H     (*(volatile __near unsigned char  *)0x515)
#define TMDF0_1H0      (*(volatile __near unsigned short *)0x516)
#define GAFLM15H1      (*(volatile __near unsigned short *)0x516)
#define GAFLM15H0      (*(volatile __near unsigned short *)0x516)
#define RMD3_1H1       (*(volatile __near unsigned short *)0x516)
#define RMD11_1H0      (*(volatile __near unsigned short *)0x516)
#define RMD11_1H1      (*(volatile __near unsigned short *)0x516)
#define TMDF0_1H1      (*(volatile __near unsigned short *)0x516)
#define RMD3_1H0       (*(volatile __near unsigned short *)0x516)
#define GAFLM15H1L     (*(volatile __near unsigned char  *)0x516)
#define RMD11_1H1L     (*(volatile __near unsigned char  *)0x516)
#define GAFLM15H0L     (*(volatile __near unsigned char  *)0x516)
#define RMD11_1H0L     (*(volatile __near unsigned char  *)0x516)
#define TMDF0_1H1L     (*(volatile __near unsigned char  *)0x516)
#define TMDF0_1H0L     (*(volatile __near unsigned char  *)0x516)
#define RMD3_1H0L      (*(volatile __near unsigned char  *)0x516)
#define RMD3_1H1L      (*(volatile __near unsigned char  *)0x516)
#define TMDF0_1H0H     (*(volatile __near unsigned char  *)0x517)
#define RMD11_1H0H     (*(volatile __near unsigned char  *)0x517)
#define TMDF0_1H1H     (*(volatile __near unsigned char  *)0x517)
#define GAFLM15H0H     (*(volatile __near unsigned char  *)0x517)
#define GAFLM15H1H     (*(volatile __near unsigned char  *)0x517)
#define RMD11_1H1H     (*(volatile __near unsigned char  *)0x517)
#define RMD3_1H1H      (*(volatile __near unsigned char  *)0x517)
#define RMD3_1H0H      (*(volatile __near unsigned char  *)0x517)
#define TMDF0_2L1      (*(volatile __near unsigned short *)0x518)
#define TMDF0_2L0      (*(volatile __near unsigned short *)0x518)
#define RMD11_2L1      (*(volatile __near unsigned short *)0x518)
#define RMD11_2L0      (*(volatile __near unsigned short *)0x518)
#define GAFLP015L0     (*(volatile __near unsigned short *)0x518)
#define GAFLP015L1     (*(volatile __near unsigned short *)0x518)
#define RMD3_2L0       (*(volatile __near unsigned short *)0x518)
#define RMD3_2L1       (*(volatile __near unsigned short *)0x518)
#define TMDF0_2L1L     (*(volatile __near unsigned char  *)0x518)
#define RMD11_2L1L     (*(volatile __near unsigned char  *)0x518)
#define RMD11_2L0L     (*(volatile __near unsigned char  *)0x518)
#define TMDF0_2L0L     (*(volatile __near unsigned char  *)0x518)
#define GAFLP015L1L    (*(volatile __near unsigned char  *)0x518)
#define GAFLP015L0L    (*(volatile __near unsigned char  *)0x518)
#define RMD3_2L0L      (*(volatile __near unsigned char  *)0x518)
#define RMD3_2L1L      (*(volatile __near unsigned char  *)0x518)
#define TMDF0_2L1H     (*(volatile __near unsigned char  *)0x519)
#define TMDF0_2L0H     (*(volatile __near unsigned char  *)0x519)
#define RMD11_2L0H     (*(volatile __near unsigned char  *)0x519)
#define RMD11_2L1H     (*(volatile __near unsigned char  *)0x519)
#define GAFLP015L1H    (*(volatile __near unsigned char  *)0x519)
#define GAFLP015L0H    (*(volatile __near unsigned char  *)0x519)
#define RMD3_2L0H      (*(volatile __near unsigned char  *)0x519)
#define RMD3_2L1H      (*(volatile __near unsigned char  *)0x519)
#define RMD11_2H1      (*(volatile __near unsigned short *)0x51A)
#define GAFLP015H1     (*(volatile __near unsigned short *)0x51A)
#define TMDF0_2H1      (*(volatile __near unsigned short *)0x51A)
#define GAFLP015H0     (*(volatile __near unsigned short *)0x51A)
#define TMDF0_2H0      (*(volatile __near unsigned short *)0x51A)
#define RMD11_2H0      (*(volatile __near unsigned short *)0x51A)
#define RMD3_2H0       (*(volatile __near unsigned short *)0x51A)
#define RMD3_2H1       (*(volatile __near unsigned short *)0x51A)
#define TMDF0_2H0L     (*(volatile __near unsigned char  *)0x51A)
#define TMDF0_2H1L     (*(volatile __near unsigned char  *)0x51A)
#define GAFLP015H1L    (*(volatile __near unsigned char  *)0x51A)
#define RMD11_2H1L     (*(volatile __near unsigned char  *)0x51A)
#define RMD11_2H0L     (*(volatile __near unsigned char  *)0x51A)
#define GAFLP015H0L    (*(volatile __near unsigned char  *)0x51A)
#define RMD3_2H0L      (*(volatile __near unsigned char  *)0x51A)
#define RMD3_2H1L      (*(volatile __near unsigned char  *)0x51A)
#define GAFLP015H0H    (*(volatile __near unsigned char  *)0x51B)
#define RMD11_2H0H     (*(volatile __near unsigned char  *)0x51B)
#define RMD11_2H1H     (*(volatile __near unsigned char  *)0x51B)
#define GAFLP015H1H    (*(volatile __near unsigned char  *)0x51B)
#define TMDF0_2H0H     (*(volatile __near unsigned char  *)0x51B)
#define TMDF0_2H1H     (*(volatile __near unsigned char  *)0x51B)
#define RMD3_2H0H      (*(volatile __near unsigned char  *)0x51B)
#define RMD3_2H1H      (*(volatile __near unsigned char  *)0x51B)
#define RMD11_3L1      (*(volatile __near unsigned short *)0x51C)
#define RMD11_3L0      (*(volatile __near unsigned short *)0x51C)
#define GAFLP115L0     (*(volatile __near unsigned short *)0x51C)
#define TMDF0_3L1      (*(volatile __near unsigned short *)0x51C)
#define TMDF0_3L0      (*(volatile __near unsigned short *)0x51C)
#define GAFLP115L1     (*(volatile __near unsigned short *)0x51C)
#define RMD3_3L0       (*(volatile __near unsigned short *)0x51C)
#define RMD3_3L1       (*(volatile __near unsigned short *)0x51C)
#define RMD11_3L0L     (*(volatile __near unsigned char  *)0x51C)
#define RMD11_3L1L     (*(volatile __near unsigned char  *)0x51C)
#define GAFLP115L1L    (*(volatile __near unsigned char  *)0x51C)
#define TMDF0_3L1L     (*(volatile __near unsigned char  *)0x51C)
#define TMDF0_3L0L     (*(volatile __near unsigned char  *)0x51C)
#define GAFLP115L0L    (*(volatile __near unsigned char  *)0x51C)
#define RMD3_3L0L      (*(volatile __near unsigned char  *)0x51C)
#define RMD3_3L1L      (*(volatile __near unsigned char  *)0x51C)
#define RMD11_3L1H     (*(volatile __near unsigned char  *)0x51D)
#define RMD11_3L0H     (*(volatile __near unsigned char  *)0x51D)
#define GAFLP115L0H    (*(volatile __near unsigned char  *)0x51D)
#define GAFLP115L1H    (*(volatile __near unsigned char  *)0x51D)
#define TMDF0_3L1H     (*(volatile __near unsigned char  *)0x51D)
#define TMDF0_3L0H     (*(volatile __near unsigned char  *)0x51D)
#define RMD3_3L0H      (*(volatile __near unsigned char  *)0x51D)
#define RMD3_3L1H      (*(volatile __near unsigned char  *)0x51D)
#define RMD11_3H1      (*(volatile __near unsigned short *)0x51E)
#define RMD11_3H0      (*(volatile __near unsigned short *)0x51E)
#define TMDF0_3H0      (*(volatile __near unsigned short *)0x51E)
#define TMDF0_3H1      (*(volatile __near unsigned short *)0x51E)
#define RMD3_3H1       (*(volatile __near unsigned short *)0x51E)
#define RMD3_3H0       (*(volatile __near unsigned short *)0x51E)
#define RMD11_3H0L     (*(volatile __near unsigned char  *)0x51E)
#define RMD11_3H1L     (*(volatile __near unsigned char  *)0x51E)
#define TMDF0_3H0L     (*(volatile __near unsigned char  *)0x51E)
#define TMDF0_3H1L     (*(volatile __near unsigned char  *)0x51E)
#define RMD3_3H0L      (*(volatile __near unsigned char  *)0x51E)
#define RMD3_3H1L      (*(volatile __near unsigned char  *)0x51E)
#define RMD11_3H0H     (*(volatile __near unsigned char  *)0x51F)
#define TMDF0_3H1H     (*(volatile __near unsigned char  *)0x51F)
#define RMD11_3H1H     (*(volatile __near unsigned char  *)0x51F)
#define TMDF0_3H0H     (*(volatile __near unsigned char  *)0x51F)
#define RMD3_3H1H      (*(volatile __near unsigned char  *)0x51F)
#define RMD3_3H0H      (*(volatile __near unsigned char  *)0x51F)
#define RMD11_4L0      (*(volatile __near unsigned short *)0x520)
#define TMDF0_4L0      (*(volatile __near unsigned short *)0x520)
#define RMD11_4L1      (*(volatile __near unsigned short *)0x520)
#define GPFLID0L1      (*(volatile __near unsigned short *)0x520)
#define TMDF0_4L1      (*(volatile __near unsigned short *)0x520)
#define GPFLID0L0      (*(volatile __near unsigned short *)0x520)
#define RMD3_4L0       (*(volatile __near unsigned short *)0x520)
#define RMD3_4L1       (*(volatile __near unsigned short *)0x520)
#define TMDF0_4L0L     (*(volatile __near unsigned char  *)0x520)
#define GPFLID0L1L     (*(volatile __near unsigned char  *)0x520)
#define GPFLID0L0L     (*(volatile __near unsigned char  *)0x520)
#define RMD11_4L1L     (*(volatile __near unsigned char  *)0x520)
#define RMD11_4L0L     (*(volatile __near unsigned char  *)0x520)
#define TMDF0_4L1L     (*(volatile __near unsigned char  *)0x520)
#define RMD3_4L0L      (*(volatile __near unsigned char  *)0x520)
#define RMD3_4L1L      (*(volatile __near unsigned char  *)0x520)
#define TMDF0_4L0H     (*(volatile __near unsigned char  *)0x521)
#define RMD11_4L1H     (*(volatile __near unsigned char  *)0x521)
#define TMDF0_4L1H     (*(volatile __near unsigned char  *)0x521)
#define RMD11_4L0H     (*(volatile __near unsigned char  *)0x521)
#define GPFLID0L1H     (*(volatile __near unsigned char  *)0x521)
#define GPFLID0L0H     (*(volatile __near unsigned char  *)0x521)
#define RMD3_4L0H      (*(volatile __near unsigned char  *)0x521)
#define RMD3_4L1H      (*(volatile __near unsigned char  *)0x521)
#define TMDF0_4H1      (*(volatile __near unsigned short *)0x522)
#define TMDF0_4H0      (*(volatile __near unsigned short *)0x522)
#define RMD11_4H1      (*(volatile __near unsigned short *)0x522)
#define RMD11_4H0      (*(volatile __near unsigned short *)0x522)
#define GPFLID0H1      (*(volatile __near unsigned short *)0x522)
#define GPFLID0H0      (*(volatile __near unsigned short *)0x522)
#define RMD3_4H1       (*(volatile __near unsigned short *)0x522)
#define RMD3_4H0       (*(volatile __near unsigned short *)0x522)
#define TMDF0_4H1L     (*(volatile __near unsigned char  *)0x522)
#define RMD11_4H1L     (*(volatile __near unsigned char  *)0x522)
#define GPFLID0H1L     (*(volatile __near unsigned char  *)0x522)
#define TMDF0_4H0L     (*(volatile __near unsigned char  *)0x522)
#define RMD11_4H0L     (*(volatile __near unsigned char  *)0x522)
#define GPFLID0H0L     (*(volatile __near unsigned char  *)0x522)
#define RMD3_4H1L      (*(volatile __near unsigned char  *)0x522)
#define RMD3_4H0L      (*(volatile __near unsigned char  *)0x522)
#define TMDF0_4H0H     (*(volatile __near unsigned char  *)0x523)
#define TMDF0_4H1H     (*(volatile __near unsigned char  *)0x523)
#define GPFLID0H0H     (*(volatile __near unsigned char  *)0x523)
#define GPFLID0H1H     (*(volatile __near unsigned char  *)0x523)
#define RMD11_4H0H     (*(volatile __near unsigned char  *)0x523)
#define RMD11_4H1H     (*(volatile __near unsigned char  *)0x523)
#define RMD3_4H1H      (*(volatile __near unsigned char  *)0x523)
#define RMD3_4H0H      (*(volatile __near unsigned char  *)0x523)
#define TMDF0_5L1      (*(volatile __near unsigned short *)0x524)
#define GPFLM0L1       (*(volatile __near unsigned short *)0x524)
#define RMD11_5L0      (*(volatile __near unsigned short *)0x524)
#define GPFLM0L0       (*(volatile __near unsigned short *)0x524)
#define RMD11_5L1      (*(volatile __near unsigned short *)0x524)
#define TMDF0_5L0      (*(volatile __near unsigned short *)0x524)
#define RMD3_5L0       (*(volatile __near unsigned short *)0x524)
#define RMD3_5L1       (*(volatile __near unsigned short *)0x524)
#define TMDF0_5L0L     (*(volatile __near unsigned char  *)0x524)
#define TMDF0_5L1L     (*(volatile __near unsigned char  *)0x524)
#define GPFLM0L0L      (*(volatile __near unsigned char  *)0x524)
#define GPFLM0L1L      (*(volatile __near unsigned char  *)0x524)
#define RMD11_5L1L     (*(volatile __near unsigned char  *)0x524)
#define RMD11_5L0L     (*(volatile __near unsigned char  *)0x524)
#define RMD3_5L0L      (*(volatile __near unsigned char  *)0x524)
#define RMD3_5L1L      (*(volatile __near unsigned char  *)0x524)
#define RMD11_5L1H     (*(volatile __near unsigned char  *)0x525)
#define GPFLM0L0H      (*(volatile __near unsigned char  *)0x525)
#define TMDF0_5L1H     (*(volatile __near unsigned char  *)0x525)
#define GPFLM0L1H      (*(volatile __near unsigned char  *)0x525)
#define TMDF0_5L0H     (*(volatile __near unsigned char  *)0x525)
#define RMD11_5L0H     (*(volatile __near unsigned char  *)0x525)
#define RMD3_5L0H      (*(volatile __near unsigned char  *)0x525)
#define RMD3_5L1H      (*(volatile __near unsigned char  *)0x525)
#define GPFLM0H0       (*(volatile __near unsigned short *)0x526)
#define RMD11_5H0      (*(volatile __near unsigned short *)0x526)
#define RMD11_5H1      (*(volatile __near unsigned short *)0x526)
#define GPFLM0H1       (*(volatile __near unsigned short *)0x526)
#define TMDF0_5H0      (*(volatile __near unsigned short *)0x526)
#define TMDF0_5H1      (*(volatile __near unsigned short *)0x526)
#define RMD3_5H0       (*(volatile __near unsigned short *)0x526)
#define RMD3_5H1       (*(volatile __near unsigned short *)0x526)
#define RMD11_5H1L     (*(volatile __near unsigned char  *)0x526)
#define TMDF0_5H0L     (*(volatile __near unsigned char  *)0x526)
#define RMD11_5H0L     (*(volatile __near unsigned char  *)0x526)
#define TMDF0_5H1L     (*(volatile __near unsigned char  *)0x526)
#define GPFLM0H1L      (*(volatile __near unsigned char  *)0x526)
#define GPFLM0H0L      (*(volatile __near unsigned char  *)0x526)
#define RMD3_5H0L      (*(volatile __near unsigned char  *)0x526)
#define RMD3_5H1L      (*(volatile __near unsigned char  *)0x526)
#define GPFLM0H0H      (*(volatile __near unsigned char  *)0x527)
#define RMD11_5H0H     (*(volatile __near unsigned char  *)0x527)
#define TMDF0_5H1H     (*(volatile __near unsigned char  *)0x527)
#define TMDF0_5H0H     (*(volatile __near unsigned char  *)0x527)
#define GPFLM0H1H      (*(volatile __near unsigned char  *)0x527)
#define RMD11_5H1H     (*(volatile __near unsigned char  *)0x527)
#define RMD3_5H0H      (*(volatile __near unsigned char  *)0x527)
#define RMD3_5H1H      (*(volatile __near unsigned char  *)0x527)
#define GPFLP00L1      (*(volatile __near unsigned short *)0x528)
#define TMDF0_6L1      (*(volatile __near unsigned short *)0x528)
#define RMD11_6L0      (*(volatile __near unsigned short *)0x528)
#define RMD11_6L1      (*(volatile __near unsigned short *)0x528)
#define TMDF0_6L0      (*(volatile __near unsigned short *)0x528)
#define GPFLP00L0      (*(volatile __near unsigned short *)0x528)
#define RMD3_6L1       (*(volatile __near unsigned short *)0x528)
#define RMD3_6L0       (*(volatile __near unsigned short *)0x528)
#define RMD11_6L0L     (*(volatile __near unsigned char  *)0x528)
#define RMD11_6L1L     (*(volatile __near unsigned char  *)0x528)
#define TMDF0_6L0L     (*(volatile __near unsigned char  *)0x528)
#define TMDF0_6L1L     (*(volatile __near unsigned char  *)0x528)
#define GPFLP00L1L     (*(volatile __near unsigned char  *)0x528)
#define GPFLP00L0L     (*(volatile __near unsigned char  *)0x528)
#define RMD3_6L1L      (*(volatile __near unsigned char  *)0x528)
#define RMD3_6L0L      (*(volatile __near unsigned char  *)0x528)
#define RMD11_6L1H     (*(volatile __near unsigned char  *)0x529)
#define RMD11_6L0H     (*(volatile __near unsigned char  *)0x529)
#define TMDF0_6L0H     (*(volatile __near unsigned char  *)0x529)
#define GPFLP00L1H     (*(volatile __near unsigned char  *)0x529)
#define TMDF0_6L1H     (*(volatile __near unsigned char  *)0x529)
#define GPFLP00L0H     (*(volatile __near unsigned char  *)0x529)
#define RMD3_6L1H      (*(volatile __near unsigned char  *)0x529)
#define RMD3_6L0H      (*(volatile __near unsigned char  *)0x529)
#define GPFLP00H0      (*(volatile __near unsigned short *)0x52A)
#define GPFLP00H1      (*(volatile __near unsigned short *)0x52A)
#define RMD11_6H0      (*(volatile __near unsigned short *)0x52A)
#define RMD11_6H1      (*(volatile __near unsigned short *)0x52A)
#define TMDF0_6H1      (*(volatile __near unsigned short *)0x52A)
#define TMDF0_6H0      (*(volatile __near unsigned short *)0x52A)
#define RMD3_6H0       (*(volatile __near unsigned short *)0x52A)
#define RMD3_6H1       (*(volatile __near unsigned short *)0x52A)
#define RMD11_6H1L     (*(volatile __near unsigned char  *)0x52A)
#define RMD11_6H0L     (*(volatile __near unsigned char  *)0x52A)
#define GPFLP00H0L     (*(volatile __near unsigned char  *)0x52A)
#define GPFLP00H1L     (*(volatile __near unsigned char  *)0x52A)
#define TMDF0_6H0L     (*(volatile __near unsigned char  *)0x52A)
#define TMDF0_6H1L     (*(volatile __near unsigned char  *)0x52A)
#define RMD3_6H0L      (*(volatile __near unsigned char  *)0x52A)
#define RMD3_6H1L      (*(volatile __near unsigned char  *)0x52A)
#define GPFLP00H1H     (*(volatile __near unsigned char  *)0x52B)
#define RMD11_6H1H     (*(volatile __near unsigned char  *)0x52B)
#define TMDF0_6H0H     (*(volatile __near unsigned char  *)0x52B)
#define GPFLP00H0H     (*(volatile __near unsigned char  *)0x52B)
#define TMDF0_6H1H     (*(volatile __near unsigned char  *)0x52B)
#define RMD11_6H0H     (*(volatile __near unsigned char  *)0x52B)
#define RMD3_6H1H      (*(volatile __near unsigned char  *)0x52B)
#define RMD3_6H0H      (*(volatile __near unsigned char  *)0x52B)
#define GPFLP10L1      (*(volatile __near unsigned short *)0x52C)
#define GPFLP10L0      (*(volatile __near unsigned short *)0x52C)
#define TMDF0_7L0      (*(volatile __near unsigned short *)0x52C)
#define RMD11_7L1      (*(volatile __near unsigned short *)0x52C)
#define TMDF0_7L1      (*(volatile __near unsigned short *)0x52C)
#define RMD11_7L0      (*(volatile __near unsigned short *)0x52C)
#define RMD3_7L0       (*(volatile __near unsigned short *)0x52C)
#define RMD3_7L1       (*(volatile __near unsigned short *)0x52C)
#define GPFLP10L1L     (*(volatile __near unsigned char  *)0x52C)
#define GPFLP10L0L     (*(volatile __near unsigned char  *)0x52C)
#define TMDF0_7L0L     (*(volatile __near unsigned char  *)0x52C)
#define TMDF0_7L1L     (*(volatile __near unsigned char  *)0x52C)
#define RMD11_7L0L     (*(volatile __near unsigned char  *)0x52C)
#define RMD11_7L1L     (*(volatile __near unsigned char  *)0x52C)
#define RMD3_7L0L      (*(volatile __near unsigned char  *)0x52C)
#define RMD3_7L1L      (*(volatile __near unsigned char  *)0x52C)
#define GPFLP10L0H     (*(volatile __near unsigned char  *)0x52D)
#define GPFLP10L1H     (*(volatile __near unsigned char  *)0x52D)
#define RMD11_7L0H     (*(volatile __near unsigned char  *)0x52D)
#define TMDF0_7L1H     (*(volatile __near unsigned char  *)0x52D)
#define RMD11_7L1H     (*(volatile __near unsigned char  *)0x52D)
#define RMD3_7L0H      (*(volatile __near unsigned char  *)0x52D)
#define RMD3_7L1H      (*(volatile __near unsigned char  *)0x52D)
#define TMDF0_7L0H     (*(volatile __near unsigned char  *)0x52D)
#define RMD11_7H1      (*(volatile __near unsigned short *)0x52E)
#define RMD11_7H0      (*(volatile __near unsigned short *)0x52E)
#define TMDF0_7H0      (*(volatile __near unsigned short *)0x52E)
#define TMDF0_7H1      (*(volatile __near unsigned short *)0x52E)
#define RMD3_7H1       (*(volatile __near unsigned short *)0x52E)
#define RMD3_7H0       (*(volatile __near unsigned short *)0x52E)
#define TMDF0_7H0L     (*(volatile __near unsigned char  *)0x52E)
#define TMDF0_7H1L     (*(volatile __near unsigned char  *)0x52E)
#define RMD11_7H1L     (*(volatile __near unsigned char  *)0x52E)
#define RMD11_7H0L     (*(volatile __near unsigned char  *)0x52E)
#define RMD3_7H0L      (*(volatile __near unsigned char  *)0x52E)
#define RMD3_7H1L      (*(volatile __near unsigned char  *)0x52E)
#define RMD11_7H0H     (*(volatile __near unsigned char  *)0x52F)
#define TMDF0_7H0H     (*(volatile __near unsigned char  *)0x52F)
#define RMD11_7H1H     (*(volatile __near unsigned char  *)0x52F)
#define TMDF0_7H1H     (*(volatile __near unsigned char  *)0x52F)
#define RMD3_7H0H      (*(volatile __near unsigned char  *)0x52F)
#define RMD3_7H1H      (*(volatile __near unsigned char  *)0x52F)
#define GPFLPT0L1      (*(volatile __near unsigned short *)0x530)
#define GPFLPT0L0      (*(volatile __near unsigned short *)0x530)
#define RMD11_8L1      (*(volatile __near unsigned short *)0x530)
#define RMD11_8L0      (*(volatile __near unsigned short *)0x530)
#define TMDF0_8L1      (*(volatile __near unsigned short *)0x530)
#define TMDF0_8L0      (*(volatile __near unsigned short *)0x530)
#define RMD3_8L0       (*(volatile __near unsigned short *)0x530)
#define RMD3_8L1       (*(volatile __near unsigned short *)0x530)
#define GPFLPT0L1L     (*(volatile __near unsigned char  *)0x530)
#define GPFLPT0L0L     (*(volatile __near unsigned char  *)0x530)
#define RMD11_8L1L     (*(volatile __near unsigned char  *)0x530)
#define RMD11_8L0L     (*(volatile __near unsigned char  *)0x530)
#define TMDF0_8L0L     (*(volatile __near unsigned char  *)0x530)
#define TMDF0_8L1L     (*(volatile __near unsigned char  *)0x530)
#define RMD3_8L1L      (*(volatile __near unsigned char  *)0x530)
#define RMD3_8L0L      (*(volatile __near unsigned char  *)0x530)
#define GPFLPT0L0H     (*(volatile __near unsigned char  *)0x531)
#define GPFLPT0L1H     (*(volatile __near unsigned char  *)0x531)
#define RMD11_8L1H     (*(volatile __near unsigned char  *)0x531)
#define RMD11_8L0H     (*(volatile __near unsigned char  *)0x531)
#define TMDF0_8L1H     (*(volatile __near unsigned char  *)0x531)
#define TMDF0_8L0H     (*(volatile __near unsigned char  *)0x531)
#define RMD3_8L0H      (*(volatile __near unsigned char  *)0x531)
#define RMD3_8L1H      (*(volatile __near unsigned char  *)0x531)
#define GPFLPT0H0      (*(volatile __near unsigned short *)0x532)
#define GPFLPT0H1      (*(volatile __near unsigned short *)0x532)
#define RMD11_8H1      (*(volatile __near unsigned short *)0x532)
#define TMDF0_8H0      (*(volatile __near unsigned short *)0x532)
#define TMDF0_8H1      (*(volatile __near unsigned short *)0x532)
#define RMD11_8H0      (*(volatile __near unsigned short *)0x532)
#define RMD3_8H0       (*(volatile __near unsigned short *)0x532)
#define RMD3_8H1       (*(volatile __near unsigned short *)0x532)
#define GPFLPT0H0L     (*(volatile __near unsigned char  *)0x532)
#define GPFLPT0H1L     (*(volatile __near unsigned char  *)0x532)
#define TMDF0_8H0L     (*(volatile __near unsigned char  *)0x532)
#define TMDF0_8H1L     (*(volatile __near unsigned char  *)0x532)
#define RMD11_8H1L     (*(volatile __near unsigned char  *)0x532)
#define RMD11_8H0L     (*(volatile __near unsigned char  *)0x532)
#define RMD3_8H0L      (*(volatile __near unsigned char  *)0x532)
#define RMD3_8H1L      (*(volatile __near unsigned char  *)0x532)
#define GPFLPT0H0H     (*(volatile __near unsigned char  *)0x533)
#define GPFLPT0H1H     (*(volatile __near unsigned char  *)0x533)
#define RMD11_8H0H     (*(volatile __near unsigned char  *)0x533)
#define TMDF0_8H0H     (*(volatile __near unsigned char  *)0x533)
#define TMDF0_8H1H     (*(volatile __near unsigned char  *)0x533)
#define RMD11_8H1H     (*(volatile __near unsigned char  *)0x533)
#define RMD3_8H0H      (*(volatile __near unsigned char  *)0x533)
#define RMD3_8H1H      (*(volatile __near unsigned char  *)0x533)
#define GPFLPD00L0     (*(volatile __near unsigned short *)0x534)
#define GPFLPD00L1     (*(volatile __near unsigned short *)0x534)
#define RMD3_9L0       (*(volatile __near unsigned short *)0x534)
#define RMD3_9L1       (*(volatile __near unsigned short *)0x534)
#define TMDF0_9L0      (*(volatile __near unsigned short *)0x534)
#define RMD11_9L1      (*(volatile __near unsigned short *)0x534)
#define TMDF0_9L1      (*(volatile __near unsigned short *)0x534)
#define RMD11_9L0      (*(volatile __near unsigned short *)0x534)
#define GPFLPD00L0L    (*(volatile __near unsigned char  *)0x534)
#define GPFLPD00L1L    (*(volatile __near unsigned char  *)0x534)
#define RMD3_9L0L      (*(volatile __near unsigned char  *)0x534)
#define RMD11_9L0L     (*(volatile __near unsigned char  *)0x534)
#define TMDF0_9L1L     (*(volatile __near unsigned char  *)0x534)
#define RMD3_9L1L      (*(volatile __near unsigned char  *)0x534)
#define RMD11_9L1L     (*(volatile __near unsigned char  *)0x534)
#define TMDF0_9L0L     (*(volatile __near unsigned char  *)0x534)
#define GPFLPD00L0H    (*(volatile __near unsigned char  *)0x535)
#define GPFLPD00L1H    (*(volatile __near unsigned char  *)0x535)
#define TMDF0_9L1H     (*(volatile __near unsigned char  *)0x535)
#define RMD11_9L1H     (*(volatile __near unsigned char  *)0x535)
#define TMDF0_9L0H     (*(volatile __near unsigned char  *)0x535)
#define RMD3_9L1H      (*(volatile __near unsigned char  *)0x535)
#define RMD3_9L0H      (*(volatile __near unsigned char  *)0x535)
#define RMD11_9L0H     (*(volatile __near unsigned char  *)0x535)
#define GPFLPD00H1     (*(volatile __near unsigned short *)0x536)
#define GPFLPD00H0     (*(volatile __near unsigned short *)0x536)
#define RMD11_9H0      (*(volatile __near unsigned short *)0x536)
#define TMDF0_9H0      (*(volatile __near unsigned short *)0x536)
#define TMDF0_9H1      (*(volatile __near unsigned short *)0x536)
#define RMD3_9H1       (*(volatile __near unsigned short *)0x536)
#define RMD11_9H1      (*(volatile __near unsigned short *)0x536)
#define RMD3_9H0       (*(volatile __near unsigned short *)0x536)
#define GPFLPD00H1L    (*(volatile __near unsigned char  *)0x536)
#define GPFLPD00H0L    (*(volatile __near unsigned char  *)0x536)
#define TMDF0_9H1L     (*(volatile __near unsigned char  *)0x536)
#define RMD3_9H1L      (*(volatile __near unsigned char  *)0x536)
#define TMDF0_9H0L     (*(volatile __near unsigned char  *)0x536)
#define RMD3_9H0L      (*(volatile __near unsigned char  *)0x536)
#define RMD11_9H0L     (*(volatile __near unsigned char  *)0x536)
#define RMD11_9H1L     (*(volatile __near unsigned char  *)0x536)
#define GPFLPD00H0H    (*(volatile __near unsigned char  *)0x537)
#define GPFLPD00H1H    (*(volatile __near unsigned char  *)0x537)
#define TMDF0_9H1H     (*(volatile __near unsigned char  *)0x537)
#define TMDF0_9H0H     (*(volatile __near unsigned char  *)0x537)
#define RMD11_9H1H     (*(volatile __near unsigned char  *)0x537)
#define RMD3_9H1H      (*(volatile __near unsigned char  *)0x537)
#define RMD3_9H0H      (*(volatile __near unsigned char  *)0x537)
#define RMD11_9H0H     (*(volatile __near unsigned char  *)0x537)
#define GPFLPM00L0     (*(volatile __near unsigned short *)0x538)
#define GPFLPM00L1     (*(volatile __near unsigned short *)0x538)
#define TMDF0_10L0     (*(volatile __near unsigned short *)0x538)
#define TMDF0_10L1     (*(volatile __near unsigned short *)0x538)
#define RMD11_10L1     (*(volatile __near unsigned short *)0x538)
#define RMD11_10L0     (*(volatile __near unsigned short *)0x538)
#define RMD3_10L0      (*(volatile __near unsigned short *)0x538)
#define RMD3_10L1      (*(volatile __near unsigned short *)0x538)
#define GPFLPM00L0L    (*(volatile __near unsigned char  *)0x538)
#define GPFLPM00L1L    (*(volatile __near unsigned char  *)0x538)
#define TMDF0_10L1L    (*(volatile __near unsigned char  *)0x538)
#define TMDF0_10L0L    (*(volatile __near unsigned char  *)0x538)
#define RMD11_10L1L    (*(volatile __near unsigned char  *)0x538)
#define RMD11_10L0L    (*(volatile __near unsigned char  *)0x538)
#define RMD3_10L1L     (*(volatile __near unsigned char  *)0x538)
#define RMD3_10L0L     (*(volatile __near unsigned char  *)0x538)
#define GPFLPM00L0H    (*(volatile __near unsigned char  *)0x539)
#define GPFLPM00L1H    (*(volatile __near unsigned char  *)0x539)
#define TMDF0_10L0H    (*(volatile __near unsigned char  *)0x539)
#define RMD11_10L1H    (*(volatile __near unsigned char  *)0x539)
#define RMD3_10L1H     (*(volatile __near unsigned char  *)0x539)
#define RMD11_10L0H    (*(volatile __near unsigned char  *)0x539)
#define TMDF0_10L1H    (*(volatile __near unsigned char  *)0x539)
#define RMD3_10L0H     (*(volatile __near unsigned char  *)0x539)
#define GPFLPM00H1     (*(volatile __near unsigned short *)0x53A)
#define GPFLPM00H0     (*(volatile __near unsigned short *)0x53A)
#define RMD3_10H1      (*(volatile __near unsigned short *)0x53A)
#define RMD3_10H0      (*(volatile __near unsigned short *)0x53A)
#define RMD11_10H0     (*(volatile __near unsigned short *)0x53A)
#define RMD11_10H1     (*(volatile __near unsigned short *)0x53A)
#define TMDF0_10H1     (*(volatile __near unsigned short *)0x53A)
#define TMDF0_10H0     (*(volatile __near unsigned short *)0x53A)
#define GPFLPM00H0L    (*(volatile __near unsigned char  *)0x53A)
#define GPFLPM00H1L    (*(volatile __near unsigned char  *)0x53A)
#define RMD3_10H1L     (*(volatile __near unsigned char  *)0x53A)
#define RMD3_10H0L     (*(volatile __near unsigned char  *)0x53A)
#define RMD11_10H1L    (*(volatile __near unsigned char  *)0x53A)
#define TMDF0_10H0L    (*(volatile __near unsigned char  *)0x53A)
#define TMDF0_10H1L    (*(volatile __near unsigned char  *)0x53A)
#define RMD11_10H0L    (*(volatile __near unsigned char  *)0x53A)
#define GPFLPM00H1H    (*(volatile __near unsigned char  *)0x53B)
#define GPFLPM00H0H    (*(volatile __near unsigned char  *)0x53B)
#define TMDF0_10H0H    (*(volatile __near unsigned char  *)0x53B)
#define RMD3_10H1H     (*(volatile __near unsigned char  *)0x53B)
#define RMD3_10H0H     (*(volatile __near unsigned char  *)0x53B)
#define RMD11_10H0H    (*(volatile __near unsigned char  *)0x53B)
#define RMD11_10H1H    (*(volatile __near unsigned char  *)0x53B)
#define TMDF0_10H1H    (*(volatile __near unsigned char  *)0x53B)
#define GPFLPD10L0     (*(volatile __near unsigned short *)0x53C)
#define GPFLPD10L1     (*(volatile __near unsigned short *)0x53C)
#define RMD11_11L1     (*(volatile __near unsigned short *)0x53C)
#define TMDF0_11L0     (*(volatile __near unsigned short *)0x53C)
#define RMD3_11L0      (*(volatile __near unsigned short *)0x53C)
#define RMD3_11L1      (*(volatile __near unsigned short *)0x53C)
#define RMD11_11L0     (*(volatile __near unsigned short *)0x53C)
#define TMDF0_11L1     (*(volatile __near unsigned short *)0x53C)
#define GPFLPD10L0L    (*(volatile __near unsigned char  *)0x53C)
#define GPFLPD10L1L    (*(volatile __near unsigned char  *)0x53C)
#define RMD3_11L1L     (*(volatile __near unsigned char  *)0x53C)
#define RMD3_11L0L     (*(volatile __near unsigned char  *)0x53C)
#define RMD11_11L1L    (*(volatile __near unsigned char  *)0x53C)
#define TMDF0_11L0L    (*(volatile __near unsigned char  *)0x53C)
#define RMD11_11L0L    (*(volatile __near unsigned char  *)0x53C)
#define TMDF0_11L1L    (*(volatile __near unsigned char  *)0x53C)
#define GPFLPD10L1H    (*(volatile __near unsigned char  *)0x53D)
#define GPFLPD10L0H    (*(volatile __near unsigned char  *)0x53D)
#define RMD11_11L1H    (*(volatile __near unsigned char  *)0x53D)
#define RMD11_11L0H    (*(volatile __near unsigned char  *)0x53D)
#define RMD3_11L0H     (*(volatile __near unsigned char  *)0x53D)
#define RMD3_11L1H     (*(volatile __near unsigned char  *)0x53D)
#define TMDF0_11L0H    (*(volatile __near unsigned char  *)0x53D)
#define TMDF0_11L1H    (*(volatile __near unsigned char  *)0x53D)
#define GPFLPD10H0     (*(volatile __near unsigned short *)0x53E)
#define GPFLPD10H1     (*(volatile __near unsigned short *)0x53E)
#define TMDF0_11H1     (*(volatile __near unsigned short *)0x53E)
#define RMD3_11H1      (*(volatile __near unsigned short *)0x53E)
#define TMDF0_11H0     (*(volatile __near unsigned short *)0x53E)
#define RMD11_11H1     (*(volatile __near unsigned short *)0x53E)
#define RMD3_11H0      (*(volatile __near unsigned short *)0x53E)
#define RMD11_11H0     (*(volatile __near unsigned short *)0x53E)
#define GPFLPD10H0L    (*(volatile __near unsigned char  *)0x53E)
#define GPFLPD10H1L    (*(volatile __near unsigned char  *)0x53E)
#define TMDF0_11H0L    (*(volatile __near unsigned char  *)0x53E)
#define TMDF0_11H1L    (*(volatile __near unsigned char  *)0x53E)
#define RMD11_11H0L    (*(volatile __near unsigned char  *)0x53E)
#define RMD11_11H1L    (*(volatile __near unsigned char  *)0x53E)
#define RMD3_11H1L     (*(volatile __near unsigned char  *)0x53E)
#define RMD3_11H0L     (*(volatile __near unsigned char  *)0x53E)
#define GPFLPD10H0H    (*(volatile __near unsigned char  *)0x53F)
#define GPFLPD10H1H    (*(volatile __near unsigned char  *)0x53F)
#define RMD3_11H0H     (*(volatile __near unsigned char  *)0x53F)
#define RMD11_11H0H    (*(volatile __near unsigned char  *)0x53F)
#define RMD11_11H1H    (*(volatile __near unsigned char  *)0x53F)
#define TMDF0_11H1H    (*(volatile __near unsigned char  *)0x53F)
#define RMD3_11H1H     (*(volatile __near unsigned char  *)0x53F)
#define TMDF0_11H0H    (*(volatile __near unsigned char  *)0x53F)
#define GPFLPM10L0     (*(volatile __near unsigned short *)0x540)
#define GPFLPM10L1     (*(volatile __near unsigned short *)0x540)
#define RMD3_12L1      (*(volatile __near unsigned short *)0x540)
#define TMDF0_12L0     (*(volatile __near unsigned short *)0x540)
#define RMD11_12L0     (*(volatile __near unsigned short *)0x540)
#define RMD11_12L1     (*(volatile __near unsigned short *)0x540)
#define TMDF0_12L1     (*(volatile __near unsigned short *)0x540)
#define RMD3_12L0      (*(volatile __near unsigned short *)0x540)
#define GPFLPM10L1L    (*(volatile __near unsigned char  *)0x540)
#define GPFLPM10L0L    (*(volatile __near unsigned char  *)0x540)
#define TMDF0_12L1L    (*(volatile __near unsigned char  *)0x540)
#define RMD3_12L0L     (*(volatile __near unsigned char  *)0x540)
#define RMD3_12L1L     (*(volatile __near unsigned char  *)0x540)
#define TMDF0_12L0L    (*(volatile __near unsigned char  *)0x540)
#define RMD11_12L0L    (*(volatile __near unsigned char  *)0x540)
#define RMD11_12L1L    (*(volatile __near unsigned char  *)0x540)
#define GPFLPM10L1H    (*(volatile __near unsigned char  *)0x541)
#define GPFLPM10L0H    (*(volatile __near unsigned char  *)0x541)
#define RMD3_12L0H     (*(volatile __near unsigned char  *)0x541)
#define RMD11_12L0H    (*(volatile __near unsigned char  *)0x541)
#define RMD11_12L1H    (*(volatile __near unsigned char  *)0x541)
#define TMDF0_12L0H    (*(volatile __near unsigned char  *)0x541)
#define RMD3_12L1H     (*(volatile __near unsigned char  *)0x541)
#define TMDF0_12L1H    (*(volatile __near unsigned char  *)0x541)
#define GPFLPM10H0     (*(volatile __near unsigned short *)0x542)
#define GPFLPM10H1     (*(volatile __near unsigned short *)0x542)
#define RMD3_12H0      (*(volatile __near unsigned short *)0x542)
#define TMDF0_12H1     (*(volatile __near unsigned short *)0x542)
#define RMD11_12H0     (*(volatile __near unsigned short *)0x542)
#define RMD3_12H1      (*(volatile __near unsigned short *)0x542)
#define TMDF0_12H0     (*(volatile __near unsigned short *)0x542)
#define RMD11_12H1     (*(volatile __near unsigned short *)0x542)
#define GPFLPM10H0L    (*(volatile __near unsigned char  *)0x542)
#define GPFLPM10H1L    (*(volatile __near unsigned char  *)0x542)
#define RMD3_12H0L     (*(volatile __near unsigned char  *)0x542)
#define RMD11_12H0L    (*(volatile __near unsigned char  *)0x542)
#define RMD11_12H1L    (*(volatile __near unsigned char  *)0x542)
#define TMDF0_12H0L    (*(volatile __near unsigned char  *)0x542)
#define TMDF0_12H1L    (*(volatile __near unsigned char  *)0x542)
#define RMD3_12H1L     (*(volatile __near unsigned char  *)0x542)
#define GPFLPM10H0H    (*(volatile __near unsigned char  *)0x543)
#define GPFLPM10H1H    (*(volatile __near unsigned char  *)0x543)
#define TMDF0_12H0H    (*(volatile __near unsigned char  *)0x543)
#define TMDF0_12H1H    (*(volatile __near unsigned char  *)0x543)
#define RMD3_12H0H     (*(volatile __near unsigned char  *)0x543)
#define RMD3_12H1H     (*(volatile __near unsigned char  *)0x543)
#define RMD11_12H1H    (*(volatile __near unsigned char  *)0x543)
#define RMD11_12H0H    (*(volatile __near unsigned char  *)0x543)
#define TMDF0_13L1     (*(volatile __near unsigned short *)0x544)
#define TMDF0_13L0     (*(volatile __near unsigned short *)0x544)
#define GPFLID1L1      (*(volatile __near unsigned short *)0x544)
#define RMD11_13L1     (*(volatile __near unsigned short *)0x544)
#define RMD11_13L0     (*(volatile __near unsigned short *)0x544)
#define GPFLID1L0      (*(volatile __near unsigned short *)0x544)
#define RMD3_13L0      (*(volatile __near unsigned short *)0x544)
#define RMD3_13L1      (*(volatile __near unsigned short *)0x544)
#define GPFLID1L0L     (*(volatile __near unsigned char  *)0x544)
#define GPFLID1L1L     (*(volatile __near unsigned char  *)0x544)
#define RMD11_13L1L    (*(volatile __near unsigned char  *)0x544)
#define RMD11_13L0L    (*(volatile __near unsigned char  *)0x544)
#define TMDF0_13L0L    (*(volatile __near unsigned char  *)0x544)
#define RMD3_13L1L     (*(volatile __near unsigned char  *)0x544)
#define TMDF0_13L1L    (*(volatile __near unsigned char  *)0x544)
#define RMD3_13L0L     (*(volatile __near unsigned char  *)0x544)
#define TMDF0_13L0H    (*(volatile __near unsigned char  *)0x545)
#define GPFLID1L0H     (*(volatile __near unsigned char  *)0x545)
#define GPFLID1L1H     (*(volatile __near unsigned char  *)0x545)
#define RMD11_13L1H    (*(volatile __near unsigned char  *)0x545)
#define RMD11_13L0H    (*(volatile __near unsigned char  *)0x545)
#define TMDF0_13L1H    (*(volatile __near unsigned char  *)0x545)
#define RMD3_13L0H     (*(volatile __near unsigned char  *)0x545)
#define RMD3_13L1H     (*(volatile __near unsigned char  *)0x545)
#define TMDF0_13H0     (*(volatile __near unsigned short *)0x546)
#define TMDF0_13H1     (*(volatile __near unsigned short *)0x546)
#define GPFLID1H0      (*(volatile __near unsigned short *)0x546)
#define RMD11_13H0     (*(volatile __near unsigned short *)0x546)
#define RMD3_13H1      (*(volatile __near unsigned short *)0x546)
#define RMD3_13H0      (*(volatile __near unsigned short *)0x546)
#define RMD11_13H1     (*(volatile __near unsigned short *)0x546)
#define GPFLID1H1      (*(volatile __near unsigned short *)0x546)
#define TMDF0_13H0L    (*(volatile __near unsigned char  *)0x546)
#define TMDF0_13H1L    (*(volatile __near unsigned char  *)0x546)
#define RMD3_13H1L     (*(volatile __near unsigned char  *)0x546)
#define GPFLID1H1L     (*(volatile __near unsigned char  *)0x546)
#define GPFLID1H0L     (*(volatile __near unsigned char  *)0x546)
#define RMD11_13H0L    (*(volatile __near unsigned char  *)0x546)
#define RMD3_13H0L     (*(volatile __near unsigned char  *)0x546)
#define RMD11_13H1L    (*(volatile __near unsigned char  *)0x546)
#define TMDF0_13H0H    (*(volatile __near unsigned char  *)0x547)
#define TMDF0_13H1H    (*(volatile __near unsigned char  *)0x547)
#define GPFLID1H1H     (*(volatile __near unsigned char  *)0x547)
#define RMD11_13H1H    (*(volatile __near unsigned char  *)0x547)
#define RMD3_13H0H     (*(volatile __near unsigned char  *)0x547)
#define RMD3_13H1H     (*(volatile __near unsigned char  *)0x547)
#define GPFLID1H0H     (*(volatile __near unsigned char  *)0x547)
#define RMD11_13H0H    (*(volatile __near unsigned char  *)0x547)
#define TMDF0_14L1     (*(volatile __near unsigned short *)0x548)
#define TMDF0_14L0     (*(volatile __near unsigned short *)0x548)
#define GPFLM1L1       (*(volatile __near unsigned short *)0x548)
#define RMD11_14L1     (*(volatile __near unsigned short *)0x548)
#define RMD11_14L0     (*(volatile __near unsigned short *)0x548)
#define RMD3_14L1      (*(volatile __near unsigned short *)0x548)
#define GPFLM1L0       (*(volatile __near unsigned short *)0x548)
#define RMD3_14L0      (*(volatile __near unsigned short *)0x548)
#define TMDF0_14L1L    (*(volatile __near unsigned char  *)0x548)
#define TMDF0_14L0L    (*(volatile __near unsigned char  *)0x548)
#define GPFLM1L0L      (*(volatile __near unsigned char  *)0x548)
#define RMD11_14L1L    (*(volatile __near unsigned char  *)0x548)
#define RMD11_14L0L    (*(volatile __near unsigned char  *)0x548)
#define GPFLM1L1L      (*(volatile __near unsigned char  *)0x548)
#define RMD3_14L1L     (*(volatile __near unsigned char  *)0x548)
#define RMD3_14L0L     (*(volatile __near unsigned char  *)0x548)
#define TMDF0_14L1H    (*(volatile __near unsigned char  *)0x549)
#define TMDF0_14L0H    (*(volatile __near unsigned char  *)0x549)
#define RMD11_14L1H    (*(volatile __near unsigned char  *)0x549)
#define RMD11_14L0H    (*(volatile __near unsigned char  *)0x549)
#define RMD3_14L0H     (*(volatile __near unsigned char  *)0x549)
#define RMD3_14L1H     (*(volatile __near unsigned char  *)0x549)
#define GPFLM1L1H      (*(volatile __near unsigned char  *)0x549)
#define GPFLM1L0H      (*(volatile __near unsigned char  *)0x549)
#define TMDF0_14H1     (*(volatile __near unsigned short *)0x54A)
#define TMDF0_14H0     (*(volatile __near unsigned short *)0x54A)
#define RMD11_14H0     (*(volatile __near unsigned short *)0x54A)
#define GPFLM1H0       (*(volatile __near unsigned short *)0x54A)
#define GPFLM1H1       (*(volatile __near unsigned short *)0x54A)
#define RMD11_14H1     (*(volatile __near unsigned short *)0x54A)
#define RMD3_14H1      (*(volatile __near unsigned short *)0x54A)
#define RMD3_14H0      (*(volatile __near unsigned short *)0x54A)
#define TMDF0_14H1L    (*(volatile __near unsigned char  *)0x54A)
#define TMDF0_14H0L    (*(volatile __near unsigned char  *)0x54A)
#define RMD11_14H0L    (*(volatile __near unsigned char  *)0x54A)
#define RMD11_14H1L    (*(volatile __near unsigned char  *)0x54A)
#define RMD3_14H1L     (*(volatile __near unsigned char  *)0x54A)
#define RMD3_14H0L     (*(volatile __near unsigned char  *)0x54A)
#define GPFLM1H0L      (*(volatile __near unsigned char  *)0x54A)
#define GPFLM1H1L      (*(volatile __near unsigned char  *)0x54A)
#define TMDF0_14H1H    (*(volatile __near unsigned char  *)0x54B)
#define TMDF0_14H0H    (*(volatile __near unsigned char  *)0x54B)
#define RMD11_14H0H    (*(volatile __near unsigned char  *)0x54B)
#define RMD11_14H1H    (*(volatile __near unsigned char  *)0x54B)
#define RMD3_14H1H     (*(volatile __near unsigned char  *)0x54B)
#define RMD3_14H0H     (*(volatile __near unsigned char  *)0x54B)
#define GPFLM1H0H      (*(volatile __near unsigned char  *)0x54B)
#define GPFLM1H1H      (*(volatile __near unsigned char  *)0x54B)
#define GPFLP01L0      (*(volatile __near unsigned short *)0x54C)
#define GPFLP01L1      (*(volatile __near unsigned short *)0x54C)
#define RMD3_15L0      (*(volatile __near unsigned short *)0x54C)
#define RMD11_15L1     (*(volatile __near unsigned short *)0x54C)
#define TMDF0_15L1     (*(volatile __near unsigned short *)0x54C)
#define TMDF0_15L0     (*(volatile __near unsigned short *)0x54C)
#define RMD11_15L0     (*(volatile __near unsigned short *)0x54C)
#define RMD3_15L1      (*(volatile __near unsigned short *)0x54C)
#define GPFLP01L0L     (*(volatile __near unsigned char  *)0x54C)
#define GPFLP01L1L     (*(volatile __near unsigned char  *)0x54C)
#define RMD11_15L1L    (*(volatile __near unsigned char  *)0x54C)
#define RMD11_15L0L    (*(volatile __near unsigned char  *)0x54C)
#define RMD3_15L0L     (*(volatile __near unsigned char  *)0x54C)
#define RMD3_15L1L     (*(volatile __near unsigned char  *)0x54C)
#define TMDF0_15L0L    (*(volatile __near unsigned char  *)0x54C)
#define TMDF0_15L1L    (*(volatile __near unsigned char  *)0x54C)
#define GPFLP01L0H     (*(volatile __near unsigned char  *)0x54D)
#define GPFLP01L1H     (*(volatile __near unsigned char  *)0x54D)
#define RMD11_15L1H    (*(volatile __near unsigned char  *)0x54D)
#define TMDF0_15L1H    (*(volatile __near unsigned char  *)0x54D)
#define TMDF0_15L0H    (*(volatile __near unsigned char  *)0x54D)
#define RMD11_15L0H    (*(volatile __near unsigned char  *)0x54D)
#define RMD3_15L0H     (*(volatile __near unsigned char  *)0x54D)
#define RMD3_15L1H     (*(volatile __near unsigned char  *)0x54D)
#define GPFLP01H1      (*(volatile __near unsigned short *)0x54E)
#define GPFLP01H0      (*(volatile __near unsigned short *)0x54E)
#define RMD11_15H1     (*(volatile __near unsigned short *)0x54E)
#define RMD3_15H0      (*(volatile __near unsigned short *)0x54E)
#define RMD11_15H0     (*(volatile __near unsigned short *)0x54E)
#define RMD3_15H1      (*(volatile __near unsigned short *)0x54E)
#define TMDF0_15H0     (*(volatile __near unsigned short *)0x54E)
#define TMDF0_15H1     (*(volatile __near unsigned short *)0x54E)
#define GPFLP01H0L     (*(volatile __near unsigned char  *)0x54E)
#define GPFLP01H1L     (*(volatile __near unsigned char  *)0x54E)
#define RMD11_15H0L    (*(volatile __near unsigned char  *)0x54E)
#define RMD11_15H1L    (*(volatile __near unsigned char  *)0x54E)
#define TMDF0_15H1L    (*(volatile __near unsigned char  *)0x54E)
#define RMD3_15H0L     (*(volatile __near unsigned char  *)0x54E)
#define TMDF0_15H0L    (*(volatile __near unsigned char  *)0x54E)
#define RMD3_15H1L     (*(volatile __near unsigned char  *)0x54E)
#define GPFLP01H0H     (*(volatile __near unsigned char  *)0x54F)
#define RMD11_15H1H    (*(volatile __near unsigned char  *)0x54F)
#define RMD11_15H0H    (*(volatile __near unsigned char  *)0x54F)
#define RMD3_15H1H     (*(volatile __near unsigned char  *)0x54F)
#define TMDF0_15H1H    (*(volatile __near unsigned char  *)0x54F)
#define TMDF0_15H0H    (*(volatile __near unsigned char  *)0x54F)
#define GPFLP01H1H     (*(volatile __near unsigned char  *)0x54F)
#define RMD3_15H0H     (*(volatile __near unsigned char  *)0x54F)
#define GPFLP11L1      (*(volatile __near unsigned short *)0x550)
#define GPFLP11L0      (*(volatile __near unsigned short *)0x550)
#define RMID4L0        (*(volatile __near unsigned short *)0x550)
#define RMID4L1        (*(volatile __near unsigned short *)0x550)
#define RMID12L0       (*(volatile __near unsigned short *)0x550)
#define TMID1L1        (*(volatile __near unsigned short *)0x550)
#define RMID12L1       (*(volatile __near unsigned short *)0x550)
#define TMID1L0        (*(volatile __near unsigned short *)0x550)
#define GPFLP11L1L     (*(volatile __near unsigned char  *)0x550)
#define GPFLP11L0L     (*(volatile __near unsigned char  *)0x550)
#define RMID4L1L       (*(volatile __near unsigned char  *)0x550)
#define RMID4L0L       (*(volatile __near unsigned char  *)0x550)
#define TMID1L1L       (*(volatile __near unsigned char  *)0x550)
#define TMID1L0L       (*(volatile __near unsigned char  *)0x550)
#define RMID12L1L      (*(volatile __near unsigned char  *)0x550)
#define RMID12L0L      (*(volatile __near unsigned char  *)0x550)
#define GPFLP11L0H     (*(volatile __near unsigned char  *)0x551)
#define RMID4L0H       (*(volatile __near unsigned char  *)0x551)
#define GPFLP11L1H     (*(volatile __near unsigned char  *)0x551)
#define RMID4L1H       (*(volatile __near unsigned char  *)0x551)
#define TMID1L1H       (*(volatile __near unsigned char  *)0x551)
#define TMID1L0H       (*(volatile __near unsigned char  *)0x551)
#define RMID12L1H      (*(volatile __near unsigned char  *)0x551)
#define RMID12L0H      (*(volatile __near unsigned char  *)0x551)
#define TMID1H0        (*(volatile __near unsigned short *)0x552)
#define RMID4H0        (*(volatile __near unsigned short *)0x552)
#define RMID4H1        (*(volatile __near unsigned short *)0x552)
#define RMID12H1       (*(volatile __near unsigned short *)0x552)
#define TMID1H1        (*(volatile __near unsigned short *)0x552)
#define RMID12H0       (*(volatile __near unsigned short *)0x552)
#define RMID4H1L       (*(volatile __near unsigned char  *)0x552)
#define RMID4H0L       (*(volatile __near unsigned char  *)0x552)
#define TMID1H1L       (*(volatile __near unsigned char  *)0x552)
#define TMID1H0L       (*(volatile __near unsigned char  *)0x552)
#define RMID12H1L      (*(volatile __near unsigned char  *)0x552)
#define RMID12H0L      (*(volatile __near unsigned char  *)0x552)
#define RMID4H1H       (*(volatile __near unsigned char  *)0x553)
#define RMID4H0H       (*(volatile __near unsigned char  *)0x553)
#define RMID12H1H      (*(volatile __near unsigned char  *)0x553)
#define RMID12H0H      (*(volatile __near unsigned char  *)0x553)
#define TMID1H0H       (*(volatile __near unsigned char  *)0x553)
#define TMID1H1H       (*(volatile __near unsigned char  *)0x553)
#define RMPTR12L0      (*(volatile __near unsigned short *)0x554)
#define RMPTR12L1      (*(volatile __near unsigned short *)0x554)
#define GPFLPT1L1      (*(volatile __near unsigned short *)0x554)
#define GPFLPT1L0      (*(volatile __near unsigned short *)0x554)
#define RMPTR4L0       (*(volatile __near unsigned short *)0x554)
#define RMPTR4L1       (*(volatile __near unsigned short *)0x554)
#define RMPTR12L0L     (*(volatile __near unsigned char  *)0x554)
#define RMPTR12L1L     (*(volatile __near unsigned char  *)0x554)
#define GPFLPT1L0L     (*(volatile __near unsigned char  *)0x554)
#define GPFLPT1L1L     (*(volatile __near unsigned char  *)0x554)
#define RMPTR4L0L      (*(volatile __near unsigned char  *)0x554)
#define RMPTR4L1L      (*(volatile __near unsigned char  *)0x554)
#define RMPTR12L0H     (*(volatile __near unsigned char  *)0x555)
#define GPFLPT1L0H     (*(volatile __near unsigned char  *)0x555)
#define RMPTR4L0H      (*(volatile __near unsigned char  *)0x555)
#define RMPTR4L1H      (*(volatile __near unsigned char  *)0x555)
#define RMPTR12L1H     (*(volatile __near unsigned char  *)0x555)
#define GPFLPT1L1H     (*(volatile __near unsigned char  *)0x555)
#define RMPTR12H1      (*(volatile __near unsigned short *)0x556)
#define RMPTR4H1       (*(volatile __near unsigned short *)0x556)
#define TMPTR1H1       (*(volatile __near unsigned short *)0x556)
#define GPFLPT1H0      (*(volatile __near unsigned short *)0x556)
#define GPFLPT1H1      (*(volatile __near unsigned short *)0x556)
#define RMPTR12H0      (*(volatile __near unsigned short *)0x556)
#define TMPTR1H0       (*(volatile __near unsigned short *)0x556)
#define RMPTR4H0       (*(volatile __near unsigned short *)0x556)
#define GPFLPT1H0L     (*(volatile __near unsigned char  *)0x556)
#define GPFLPT1H1L     (*(volatile __near unsigned char  *)0x556)
#define RMPTR12H1H     (*(volatile __near unsigned char  *)0x557)
#define RMPTR12H0H     (*(volatile __near unsigned char  *)0x557)
#define RMPTR4H0H      (*(volatile __near unsigned char  *)0x557)
#define RMPTR4H1H      (*(volatile __near unsigned char  *)0x557)
#define TMPTR1H1H      (*(volatile __near unsigned char  *)0x557)
#define TMPTR1H0H      (*(volatile __near unsigned char  *)0x557)
#define GPFLPT1H0H     (*(volatile __near unsigned char  *)0x557)
#define GPFLPT1H1H     (*(volatile __near unsigned char  *)0x557)
#define TMFDCTR1L0     (*(volatile __near unsigned short *)0x558)
#define GPFLPD01L0     (*(volatile __near unsigned short *)0x558)
#define GPFLPD01L1     (*(volatile __near unsigned short *)0x558)
#define RMSTS4L0       (*(volatile __near unsigned short *)0x558)
#define TMFDCTR1L1     (*(volatile __near unsigned short *)0x558)
#define RMSTS4L1       (*(volatile __near unsigned short *)0x558)
#define RMSTS12L0      (*(volatile __near unsigned short *)0x558)
#define RMSTS12L1      (*(volatile __near unsigned short *)0x558)
#define RMSTS12L0L     (*(volatile __near unsigned char  *)0x558)
#define RMSTS12L1L     (*(volatile __near unsigned char  *)0x558)
#define TMFDCTR1L1L    (*(volatile __near unsigned char  *)0x558)
#define TMFDCTR1L0L    (*(volatile __near unsigned char  *)0x558)
#define RMSTS4L0L      (*(volatile __near unsigned char  *)0x558)
#define RMSTS4L1L      (*(volatile __near unsigned char  *)0x558)
#define GPFLPD01L1L    (*(volatile __near unsigned char  *)0x558)
#define GPFLPD01L0L    (*(volatile __near unsigned char  *)0x558)
#define RMSTS12L1H     (*(volatile __near unsigned char  *)0x559)
#define RMSTS4L0H      (*(volatile __near unsigned char  *)0x559)
#define RMSTS12L0H     (*(volatile __near unsigned char  *)0x559)
#define GPFLPD01L0H    (*(volatile __near unsigned char  *)0x559)
#define TMFDCTR1L1H    (*(volatile __near unsigned char  *)0x559)
#define RMSTS4L1H      (*(volatile __near unsigned char  *)0x559)
#define GPFLPD01L1H    (*(volatile __near unsigned char  *)0x559)
#define TMFDCTR1L0H    (*(volatile __near unsigned char  *)0x559)
#define TMFDCTR1H0     (*(volatile __near unsigned short *)0x55A)
#define RMSTS4H0       (*(volatile __near unsigned short *)0x55A)
#define RMSTS4H1       (*(volatile __near unsigned short *)0x55A)
#define RMSTS12H0      (*(volatile __near unsigned short *)0x55A)
#define RMSTS12H1      (*(volatile __near unsigned short *)0x55A)
#define GPFLPD01H0     (*(volatile __near unsigned short *)0x55A)
#define GPFLPD01H1     (*(volatile __near unsigned short *)0x55A)
#define TMFDCTR1H1     (*(volatile __near unsigned short *)0x55A)
#define RMSTS4H0L      (*(volatile __near unsigned char  *)0x55A)
#define RMSTS4H1L      (*(volatile __near unsigned char  *)0x55A)
#define GPFLPD01H1L    (*(volatile __near unsigned char  *)0x55A)
#define RMSTS12H0L     (*(volatile __near unsigned char  *)0x55A)
#define RMSTS12H1L     (*(volatile __near unsigned char  *)0x55A)
#define TMFDCTR1H1L    (*(volatile __near unsigned char  *)0x55A)
#define TMFDCTR1H0L    (*(volatile __near unsigned char  *)0x55A)
#define GPFLPD01H0L    (*(volatile __near unsigned char  *)0x55A)
#define TMFDCTR1H1H    (*(volatile __near unsigned char  *)0x55B)
#define TMFDCTR1H0H    (*(volatile __near unsigned char  *)0x55B)
#define RMSTS4H0H      (*(volatile __near unsigned char  *)0x55B)
#define RMSTS4H1H      (*(volatile __near unsigned char  *)0x55B)
#define RMSTS12H0H     (*(volatile __near unsigned char  *)0x55B)
#define RMSTS12H1H     (*(volatile __near unsigned char  *)0x55B)
#define GPFLPD01H0H    (*(volatile __near unsigned char  *)0x55B)
#define GPFLPD01H1H    (*(volatile __near unsigned char  *)0x55B)
#define TMDF1_0L0      (*(volatile __near unsigned short *)0x55C)
#define TMDF1_0L1      (*(volatile __near unsigned short *)0x55C)
#define GPFLPM01L1     (*(volatile __near unsigned short *)0x55C)
#define GPFLPM01L0     (*(volatile __near unsigned short *)0x55C)
#define RMD12_0L0      (*(volatile __near unsigned short *)0x55C)
#define RMD12_0L1      (*(volatile __near unsigned short *)0x55C)
#define RMD4_0L0       (*(volatile __near unsigned short *)0x55C)
#define RMD4_0L1       (*(volatile __near unsigned short *)0x55C)
#define TMDF1_0L0L     (*(volatile __near unsigned char  *)0x55C)
#define TMDF1_0L1L     (*(volatile __near unsigned char  *)0x55C)
#define GPFLPM01L1L    (*(volatile __near unsigned char  *)0x55C)
#define GPFLPM01L0L    (*(volatile __near unsigned char  *)0x55C)
#define RMD12_0L0L     (*(volatile __near unsigned char  *)0x55C)
#define RMD12_0L1L     (*(volatile __near unsigned char  *)0x55C)
#define RMD4_0L1L      (*(volatile __near unsigned char  *)0x55C)
#define RMD4_0L0L      (*(volatile __near unsigned char  *)0x55C)
#define TMDF1_0L0H     (*(volatile __near unsigned char  *)0x55D)
#define TMDF1_0L1H     (*(volatile __near unsigned char  *)0x55D)
#define GPFLPM01L1H    (*(volatile __near unsigned char  *)0x55D)
#define GPFLPM01L0H    (*(volatile __near unsigned char  *)0x55D)
#define RMD12_0L0H     (*(volatile __near unsigned char  *)0x55D)
#define RMD12_0L1H     (*(volatile __near unsigned char  *)0x55D)
#define RMD4_0L0H      (*(volatile __near unsigned char  *)0x55D)
#define RMD4_0L1H      (*(volatile __near unsigned char  *)0x55D)
#define TMDF1_0H0      (*(volatile __near unsigned short *)0x55E)
#define TMDF1_0H1      (*(volatile __near unsigned short *)0x55E)
#define GPFLPM01H0     (*(volatile __near unsigned short *)0x55E)
#define RMD12_0H0      (*(volatile __near unsigned short *)0x55E)
#define RMD12_0H1      (*(volatile __near unsigned short *)0x55E)
#define GPFLPM01H1     (*(volatile __near unsigned short *)0x55E)
#define RMD4_0H1       (*(volatile __near unsigned short *)0x55E)
#define RMD4_0H0       (*(volatile __near unsigned short *)0x55E)
#define TMDF1_0H0L     (*(volatile __near unsigned char  *)0x55E)
#define TMDF1_0H1L     (*(volatile __near unsigned char  *)0x55E)
#define RMD12_0H0L     (*(volatile __near unsigned char  *)0x55E)
#define RMD12_0H1L     (*(volatile __near unsigned char  *)0x55E)
#define GPFLPM01H1L    (*(volatile __near unsigned char  *)0x55E)
#define GPFLPM01H0L    (*(volatile __near unsigned char  *)0x55E)
#define RMD4_0H0L      (*(volatile __near unsigned char  *)0x55E)
#define RMD4_0H1L      (*(volatile __near unsigned char  *)0x55E)
#define TMDF1_0H0H     (*(volatile __near unsigned char  *)0x55F)
#define TMDF1_0H1H     (*(volatile __near unsigned char  *)0x55F)
#define GPFLPM01H0H    (*(volatile __near unsigned char  *)0x55F)
#define RMD12_0H1H     (*(volatile __near unsigned char  *)0x55F)
#define RMD12_0H0H     (*(volatile __near unsigned char  *)0x55F)
#define GPFLPM01H1H    (*(volatile __near unsigned char  *)0x55F)
#define RMD4_0H0H      (*(volatile __near unsigned char  *)0x55F)
#define RMD4_0H1H      (*(volatile __near unsigned char  *)0x55F)
#define TMDF1_1L1      (*(volatile __near unsigned short *)0x560)
#define TMDF1_1L0      (*(volatile __near unsigned short *)0x560)
#define GPFLPD11L0     (*(volatile __near unsigned short *)0x560)
#define RMD4_1L1       (*(volatile __near unsigned short *)0x560)
#define RMD4_1L0       (*(volatile __near unsigned short *)0x560)
#define GPFLPD11L1     (*(volatile __near unsigned short *)0x560)
#define RMD12_1L1      (*(volatile __near unsigned short *)0x560)
#define RMD12_1L0      (*(volatile __near unsigned short *)0x560)
#define TMDF1_1L1L     (*(volatile __near unsigned char  *)0x560)
#define TMDF1_1L0L     (*(volatile __near unsigned char  *)0x560)
#define GPFLPD11L1L    (*(volatile __near unsigned char  *)0x560)
#define RMD4_1L0L      (*(volatile __near unsigned char  *)0x560)
#define RMD12_1L0L     (*(volatile __near unsigned char  *)0x560)
#define RMD12_1L1L     (*(volatile __near unsigned char  *)0x560)
#define RMD4_1L1L      (*(volatile __near unsigned char  *)0x560)
#define GPFLPD11L0L    (*(volatile __near unsigned char  *)0x560)
#define TMDF1_1L1H     (*(volatile __near unsigned char  *)0x561)
#define TMDF1_1L0H     (*(volatile __near unsigned char  *)0x561)
#define GPFLPD11L0H    (*(volatile __near unsigned char  *)0x561)
#define GPFLPD11L1H    (*(volatile __near unsigned char  *)0x561)
#define RMD12_1L1H     (*(volatile __near unsigned char  *)0x561)
#define RMD12_1L0H     (*(volatile __near unsigned char  *)0x561)
#define RMD4_1L0H      (*(volatile __near unsigned char  *)0x561)
#define RMD4_1L1H      (*(volatile __near unsigned char  *)0x561)
#define TMDF1_1H1      (*(volatile __near unsigned short *)0x562)
#define TMDF1_1H0      (*(volatile __near unsigned short *)0x562)
#define RMD4_1H0       (*(volatile __near unsigned short *)0x562)
#define RMD12_1H1      (*(volatile __near unsigned short *)0x562)
#define RMD4_1H1       (*(volatile __near unsigned short *)0x562)
#define RMD12_1H0      (*(volatile __near unsigned short *)0x562)
#define GPFLPD11H1     (*(volatile __near unsigned short *)0x562)
#define GPFLPD11H0     (*(volatile __near unsigned short *)0x562)
#define TMDF1_1H0L     (*(volatile __near unsigned char  *)0x562)
#define TMDF1_1H1L     (*(volatile __near unsigned char  *)0x562)
#define RMD12_1H1L     (*(volatile __near unsigned char  *)0x562)
#define GPFLPD11H1L    (*(volatile __near unsigned char  *)0x562)
#define GPFLPD11H0L    (*(volatile __near unsigned char  *)0x562)
#define RMD4_1H0L      (*(volatile __near unsigned char  *)0x562)
#define RMD12_1H0L     (*(volatile __near unsigned char  *)0x562)
#define RMD4_1H1L      (*(volatile __near unsigned char  *)0x562)
#define TMDF1_1H1H     (*(volatile __near unsigned char  *)0x563)
#define TMDF1_1H0H     (*(volatile __near unsigned char  *)0x563)
#define GPFLPD11H0H    (*(volatile __near unsigned char  *)0x563)
#define RMD12_1H0H     (*(volatile __near unsigned char  *)0x563)
#define GPFLPD11H1H    (*(volatile __near unsigned char  *)0x563)
#define RMD4_1H1H      (*(volatile __near unsigned char  *)0x563)
#define RMD4_1H0H      (*(volatile __near unsigned char  *)0x563)
#define RMD12_1H1H     (*(volatile __near unsigned char  *)0x563)
#define TMDF1_2L1      (*(volatile __near unsigned short *)0x564)
#define TMDF1_2L0      (*(volatile __near unsigned short *)0x564)
#define RMD12_2L1      (*(volatile __near unsigned short *)0x564)
#define RMD4_2L1       (*(volatile __near unsigned short *)0x564)
#define RMD12_2L0      (*(volatile __near unsigned short *)0x564)
#define RMD4_2L0       (*(volatile __near unsigned short *)0x564)
#define GPFLPM11L1     (*(volatile __near unsigned short *)0x564)
#define GPFLPM11L0     (*(volatile __near unsigned short *)0x564)
#define TMDF1_2L0L     (*(volatile __near unsigned char  *)0x564)
#define TMDF1_2L1L     (*(volatile __near unsigned char  *)0x564)
#define RMD12_2L0L     (*(volatile __near unsigned char  *)0x564)
#define RMD12_2L1L     (*(volatile __near unsigned char  *)0x564)
#define RMD4_2L0L      (*(volatile __near unsigned char  *)0x564)
#define RMD4_2L1L      (*(volatile __near unsigned char  *)0x564)
#define GPFLPM11L1L    (*(volatile __near unsigned char  *)0x564)
#define GPFLPM11L0L    (*(volatile __near unsigned char  *)0x564)
#define TMDF1_2L1H     (*(volatile __near unsigned char  *)0x565)
#define TMDF1_2L0H     (*(volatile __near unsigned char  *)0x565)
#define RMD12_2L0H     (*(volatile __near unsigned char  *)0x565)
#define RMD12_2L1H     (*(volatile __near unsigned char  *)0x565)
#define GPFLPM11L0H    (*(volatile __near unsigned char  *)0x565)
#define RMD4_2L1H      (*(volatile __near unsigned char  *)0x565)
#define GPFLPM11L1H    (*(volatile __near unsigned char  *)0x565)
#define RMD4_2L0H      (*(volatile __near unsigned char  *)0x565)
#define TMDF1_2H0      (*(volatile __near unsigned short *)0x566)
#define TMDF1_2H1      (*(volatile __near unsigned short *)0x566)
#define RMD4_2H1       (*(volatile __near unsigned short *)0x566)
#define GPFLPM11H1     (*(volatile __near unsigned short *)0x566)
#define RMD4_2H0       (*(volatile __near unsigned short *)0x566)
#define GPFLPM11H0     (*(volatile __near unsigned short *)0x566)
#define RMD12_2H1      (*(volatile __near unsigned short *)0x566)
#define RMD12_2H0      (*(volatile __near unsigned short *)0x566)
#define TMDF1_2H1L     (*(volatile __near unsigned char  *)0x566)
#define TMDF1_2H0L     (*(volatile __near unsigned char  *)0x566)
#define RMD4_2H0L      (*(volatile __near unsigned char  *)0x566)
#define GPFLPM11H0L    (*(volatile __near unsigned char  *)0x566)
#define RMD4_2H1L      (*(volatile __near unsigned char  *)0x566)
#define RMD12_2H1L     (*(volatile __near unsigned char  *)0x566)
#define RMD12_2H0L     (*(volatile __near unsigned char  *)0x566)
#define GPFLPM11H1L    (*(volatile __near unsigned char  *)0x566)
#define TMDF1_2H1H     (*(volatile __near unsigned char  *)0x567)
#define TMDF1_2H0H     (*(volatile __near unsigned char  *)0x567)
#define GPFLPM11H1H    (*(volatile __near unsigned char  *)0x567)
#define GPFLPM11H0H    (*(volatile __near unsigned char  *)0x567)
#define RMD12_2H0H     (*(volatile __near unsigned char  *)0x567)
#define RMD12_2H1H     (*(volatile __near unsigned char  *)0x567)
#define RMD4_2H0H      (*(volatile __near unsigned char  *)0x567)
#define RMD4_2H1H      (*(volatile __near unsigned char  *)0x567)
#define TMDF1_3L0      (*(volatile __near unsigned short *)0x568)
#define TMDF1_3L1      (*(volatile __near unsigned short *)0x568)
#define RMD12_3L0      (*(volatile __near unsigned short *)0x568)
#define RMD12_3L1      (*(volatile __near unsigned short *)0x568)
#define RMD4_3L0       (*(volatile __near unsigned short *)0x568)
#define RMD4_3L1       (*(volatile __near unsigned short *)0x568)
#define TMDF1_3L1L     (*(volatile __near unsigned char  *)0x568)
#define TMDF1_3L0L     (*(volatile __near unsigned char  *)0x568)
#define RMD12_3L1L     (*(volatile __near unsigned char  *)0x568)
#define RMD12_3L0L     (*(volatile __near unsigned char  *)0x568)
#define RMD4_3L0L      (*(volatile __near unsigned char  *)0x568)
#define RMD4_3L1L      (*(volatile __near unsigned char  *)0x568)
#define TMDF1_3L0H     (*(volatile __near unsigned char  *)0x569)
#define TMDF1_3L1H     (*(volatile __near unsigned char  *)0x569)
#define RMD12_3L1H     (*(volatile __near unsigned char  *)0x569)
#define RMD12_3L0H     (*(volatile __near unsigned char  *)0x569)
#define RMD4_3L0H      (*(volatile __near unsigned char  *)0x569)
#define RMD4_3L1H      (*(volatile __near unsigned char  *)0x569)
#define TMDF1_3H0      (*(volatile __near unsigned short *)0x56A)
#define TMDF1_3H1      (*(volatile __near unsigned short *)0x56A)
#define RMD12_3H1      (*(volatile __near unsigned short *)0x56A)
#define RMD12_3H0      (*(volatile __near unsigned short *)0x56A)
#define RMD4_3H1       (*(volatile __near unsigned short *)0x56A)
#define RMD4_3H0       (*(volatile __near unsigned short *)0x56A)
#define TMDF1_3H0L     (*(volatile __near unsigned char  *)0x56A)
#define TMDF1_3H1L     (*(volatile __near unsigned char  *)0x56A)
#define RMD12_3H0L     (*(volatile __near unsigned char  *)0x56A)
#define RMD12_3H1L     (*(volatile __near unsigned char  *)0x56A)
#define RMD4_3H0L      (*(volatile __near unsigned char  *)0x56A)
#define RMD4_3H1L      (*(volatile __near unsigned char  *)0x56A)
#define TMDF1_3H0H     (*(volatile __near unsigned char  *)0x56B)
#define TMDF1_3H1H     (*(volatile __near unsigned char  *)0x56B)
#define RMD12_3H0H     (*(volatile __near unsigned char  *)0x56B)
#define RMD12_3H1H     (*(volatile __near unsigned char  *)0x56B)
#define RMD4_3H0H      (*(volatile __near unsigned char  *)0x56B)
#define RMD4_3H1H      (*(volatile __near unsigned char  *)0x56B)
#define TMDF1_4L0      (*(volatile __near unsigned short *)0x56C)
#define TMDF1_4L1      (*(volatile __near unsigned short *)0x56C)
#define RMD12_4L0      (*(volatile __near unsigned short *)0x56C)
#define RMD12_4L1      (*(volatile __near unsigned short *)0x56C)
#define RMD4_4L0       (*(volatile __near unsigned short *)0x56C)
#define RMD4_4L1       (*(volatile __near unsigned short *)0x56C)
#define TMDF1_4L1L     (*(volatile __near unsigned char  *)0x56C)
#define TMDF1_4L0L     (*(volatile __near unsigned char  *)0x56C)
#define RMD12_4L0L     (*(volatile __near unsigned char  *)0x56C)
#define RMD12_4L1L     (*(volatile __near unsigned char  *)0x56C)
#define RMD4_4L0L      (*(volatile __near unsigned char  *)0x56C)
#define RMD4_4L1L      (*(volatile __near unsigned char  *)0x56C)
#define TMDF1_4L1H     (*(volatile __near unsigned char  *)0x56D)
#define TMDF1_4L0H     (*(volatile __near unsigned char  *)0x56D)
#define RMD12_4L0H     (*(volatile __near unsigned char  *)0x56D)
#define RMD12_4L1H     (*(volatile __near unsigned char  *)0x56D)
#define RMD4_4L1H      (*(volatile __near unsigned char  *)0x56D)
#define RMD4_4L0H      (*(volatile __near unsigned char  *)0x56D)
#define TMDF1_4H0      (*(volatile __near unsigned short *)0x56E)
#define TMDF1_4H1      (*(volatile __near unsigned short *)0x56E)
#define RMD12_4H1      (*(volatile __near unsigned short *)0x56E)
#define RMD12_4H0      (*(volatile __near unsigned short *)0x56E)
#define RMD4_4H0       (*(volatile __near unsigned short *)0x56E)
#define RMD4_4H1       (*(volatile __near unsigned short *)0x56E)
#define TMDF1_4H0L     (*(volatile __near unsigned char  *)0x56E)
#define TMDF1_4H1L     (*(volatile __near unsigned char  *)0x56E)
#define RMD12_4H1L     (*(volatile __near unsigned char  *)0x56E)
#define RMD12_4H0L     (*(volatile __near unsigned char  *)0x56E)
#define RMD4_4H0L      (*(volatile __near unsigned char  *)0x56E)
#define RMD4_4H1L      (*(volatile __near unsigned char  *)0x56E)
#define TMDF1_4H1H     (*(volatile __near unsigned char  *)0x56F)
#define TMDF1_4H0H     (*(volatile __near unsigned char  *)0x56F)
#define RMD12_4H0H     (*(volatile __near unsigned char  *)0x56F)
#define RMD12_4H1H     (*(volatile __near unsigned char  *)0x56F)
#define RMD4_4H1H      (*(volatile __near unsigned char  *)0x56F)
#define RMD4_4H0H      (*(volatile __near unsigned char  *)0x56F)
#define TMDF1_5L0      (*(volatile __near unsigned short *)0x570)
#define TMDF1_5L1      (*(volatile __near unsigned short *)0x570)
#define RMD12_5L0      (*(volatile __near unsigned short *)0x570)
#define RMD12_5L1      (*(volatile __near unsigned short *)0x570)
#define RMD4_5L0       (*(volatile __near unsigned short *)0x570)
#define RMD4_5L1       (*(volatile __near unsigned short *)0x570)
#define TMDF1_5L1L     (*(volatile __near unsigned char  *)0x570)
#define TMDF1_5L0L     (*(volatile __near unsigned char  *)0x570)
#define RMD12_5L1L     (*(volatile __near unsigned char  *)0x570)
#define RMD12_5L0L     (*(volatile __near unsigned char  *)0x570)
#define RMD4_5L1L      (*(volatile __near unsigned char  *)0x570)
#define RMD4_5L0L      (*(volatile __near unsigned char  *)0x570)
#define TMDF1_5L0H     (*(volatile __near unsigned char  *)0x571)
#define TMDF1_5L1H     (*(volatile __near unsigned char  *)0x571)
#define RMD12_5L0H     (*(volatile __near unsigned char  *)0x571)
#define RMD12_5L1H     (*(volatile __near unsigned char  *)0x571)
#define RMD4_5L0H      (*(volatile __near unsigned char  *)0x571)
#define RMD4_5L1H      (*(volatile __near unsigned char  *)0x571)
#define TMDF1_5H0      (*(volatile __near unsigned short *)0x572)
#define TMDF1_5H1      (*(volatile __near unsigned short *)0x572)
#define RMD12_5H1      (*(volatile __near unsigned short *)0x572)
#define RMD12_5H0      (*(volatile __near unsigned short *)0x572)
#define RMD4_5H0       (*(volatile __near unsigned short *)0x572)
#define RMD4_5H1       (*(volatile __near unsigned short *)0x572)
#define TMDF1_5H1L     (*(volatile __near unsigned char  *)0x572)
#define TMDF1_5H0L     (*(volatile __near unsigned char  *)0x572)
#define RMD12_5H1L     (*(volatile __near unsigned char  *)0x572)
#define RMD12_5H0L     (*(volatile __near unsigned char  *)0x572)
#define RMD4_5H0L      (*(volatile __near unsigned char  *)0x572)
#define RMD4_5H1L      (*(volatile __near unsigned char  *)0x572)
#define TMDF1_5H0H     (*(volatile __near unsigned char  *)0x573)
#define TMDF1_5H1H     (*(volatile __near unsigned char  *)0x573)
#define RMD12_5H1H     (*(volatile __near unsigned char  *)0x573)
#define RMD12_5H0H     (*(volatile __near unsigned char  *)0x573)
#define RMD4_5H0H      (*(volatile __near unsigned char  *)0x573)
#define RMD4_5H1H      (*(volatile __near unsigned char  *)0x573)
#define TMDF1_6L0      (*(volatile __near unsigned short *)0x574)
#define TMDF1_6L1      (*(volatile __near unsigned short *)0x574)
#define RMD12_6L0      (*(volatile __near unsigned short *)0x574)
#define RMD12_6L1      (*(volatile __near unsigned short *)0x574)
#define RMD4_6L0       (*(volatile __near unsigned short *)0x574)
#define RMD4_6L1       (*(volatile __near unsigned short *)0x574)
#define TMDF1_6L1L     (*(volatile __near unsigned char  *)0x574)
#define TMDF1_6L0L     (*(volatile __near unsigned char  *)0x574)
#define RMD12_6L0L     (*(volatile __near unsigned char  *)0x574)
#define RMD12_6L1L     (*(volatile __near unsigned char  *)0x574)
#define RMD4_6L0L      (*(volatile __near unsigned char  *)0x574)
#define RMD4_6L1L      (*(volatile __near unsigned char  *)0x574)
#define TMDF1_6L0H     (*(volatile __near unsigned char  *)0x575)
#define TMDF1_6L1H     (*(volatile __near unsigned char  *)0x575)
#define RMD12_6L1H     (*(volatile __near unsigned char  *)0x575)
#define RMD12_6L0H     (*(volatile __near unsigned char  *)0x575)
#define RMD4_6L0H      (*(volatile __near unsigned char  *)0x575)
#define RMD4_6L1H      (*(volatile __near unsigned char  *)0x575)
#define TMDF1_6H0      (*(volatile __near unsigned short *)0x576)
#define TMDF1_6H1      (*(volatile __near unsigned short *)0x576)
#define RMD12_6H0      (*(volatile __near unsigned short *)0x576)
#define RMD12_6H1      (*(volatile __near unsigned short *)0x576)
#define RMD4_6H1       (*(volatile __near unsigned short *)0x576)
#define RMD4_6H0       (*(volatile __near unsigned short *)0x576)
#define TMDF1_6H1L     (*(volatile __near unsigned char  *)0x576)
#define TMDF1_6H0L     (*(volatile __near unsigned char  *)0x576)
#define RMD12_6H1L     (*(volatile __near unsigned char  *)0x576)
#define RMD12_6H0L     (*(volatile __near unsigned char  *)0x576)
#define RMD4_6H1L      (*(volatile __near unsigned char  *)0x576)
#define RMD4_6H0L      (*(volatile __near unsigned char  *)0x576)
#define TMDF1_6H0H     (*(volatile __near unsigned char  *)0x577)
#define TMDF1_6H1H     (*(volatile __near unsigned char  *)0x577)
#define RMD12_6H1H     (*(volatile __near unsigned char  *)0x577)
#define RMD12_6H0H     (*(volatile __near unsigned char  *)0x577)
#define RMD4_6H0H      (*(volatile __near unsigned char  *)0x577)
#define RMD4_6H1H      (*(volatile __near unsigned char  *)0x577)
#define TMDF1_7L0      (*(volatile __near unsigned short *)0x578)
#define TMDF1_7L1      (*(volatile __near unsigned short *)0x578)
#define RMD12_7L1      (*(volatile __near unsigned short *)0x578)
#define RMD12_7L0      (*(volatile __near unsigned short *)0x578)
#define RMD4_7L1       (*(volatile __near unsigned short *)0x578)
#define RMD4_7L0       (*(volatile __near unsigned short *)0x578)
#define TMDF1_7L1L     (*(volatile __near unsigned char  *)0x578)
#define TMDF1_7L0L     (*(volatile __near unsigned char  *)0x578)
#define RMD12_7L1L     (*(volatile __near unsigned char  *)0x578)
#define RMD12_7L0L     (*(volatile __near unsigned char  *)0x578)
#define RMD4_7L1L      (*(volatile __near unsigned char  *)0x578)
#define RMD4_7L0L      (*(volatile __near unsigned char  *)0x578)
#define TMDF1_7L0H     (*(volatile __near unsigned char  *)0x579)
#define TMDF1_7L1H     (*(volatile __near unsigned char  *)0x579)
#define RMD12_7L0H     (*(volatile __near unsigned char  *)0x579)
#define RMD12_7L1H     (*(volatile __near unsigned char  *)0x579)
#define RMD4_7L1H      (*(volatile __near unsigned char  *)0x579)
#define RMD4_7L0H      (*(volatile __near unsigned char  *)0x579)
#define TMDF1_7H1      (*(volatile __near unsigned short *)0x57A)
#define TMDF1_7H0      (*(volatile __near unsigned short *)0x57A)
#define RMD12_7H1      (*(volatile __near unsigned short *)0x57A)
#define RMD12_7H0      (*(volatile __near unsigned short *)0x57A)
#define RMD4_7H0       (*(volatile __near unsigned short *)0x57A)
#define RMD4_7H1       (*(volatile __near unsigned short *)0x57A)
#define TMDF1_7H1L     (*(volatile __near unsigned char  *)0x57A)
#define TMDF1_7H0L     (*(volatile __near unsigned char  *)0x57A)
#define RMD12_7H1L     (*(volatile __near unsigned char  *)0x57A)
#define RMD12_7H0L     (*(volatile __near unsigned char  *)0x57A)
#define RMD4_7H1L      (*(volatile __near unsigned char  *)0x57A)
#define RMD4_7H0L      (*(volatile __near unsigned char  *)0x57A)
#define TMDF1_7H0H     (*(volatile __near unsigned char  *)0x57B)
#define TMDF1_7H1H     (*(volatile __near unsigned char  *)0x57B)
#define RMD12_7H1H     (*(volatile __near unsigned char  *)0x57B)
#define RMD12_7H0H     (*(volatile __near unsigned char  *)0x57B)
#define RMD4_7H0H      (*(volatile __near unsigned char  *)0x57B)
#define RMD4_7H1H      (*(volatile __near unsigned char  *)0x57B)
#define TMDF1_8L1      (*(volatile __near unsigned short *)0x57C)
#define TMDF1_8L0      (*(volatile __near unsigned short *)0x57C)
#define RMD12_8L0      (*(volatile __near unsigned short *)0x57C)
#define RMD12_8L1      (*(volatile __near unsigned short *)0x57C)
#define RMD4_8L0       (*(volatile __near unsigned short *)0x57C)
#define RMD4_8L1       (*(volatile __near unsigned short *)0x57C)
#define TMDF1_8L1L     (*(volatile __near unsigned char  *)0x57C)
#define TMDF1_8L0L     (*(volatile __near unsigned char  *)0x57C)
#define RMD12_8L1L     (*(volatile __near unsigned char  *)0x57C)
#define RMD12_8L0L     (*(volatile __near unsigned char  *)0x57C)
#define RMD4_8L0L      (*(volatile __near unsigned char  *)0x57C)
#define RMD4_8L1L      (*(volatile __near unsigned char  *)0x57C)
#define TMDF1_8L1H     (*(volatile __near unsigned char  *)0x57D)
#define TMDF1_8L0H     (*(volatile __near unsigned char  *)0x57D)
#define RMD12_8L0H     (*(volatile __near unsigned char  *)0x57D)
#define RMD12_8L1H     (*(volatile __near unsigned char  *)0x57D)
#define RMD4_8L0H      (*(volatile __near unsigned char  *)0x57D)
#define RMD4_8L1H      (*(volatile __near unsigned char  *)0x57D)
#define TMDF1_8H0      (*(volatile __near unsigned short *)0x57E)
#define TMDF1_8H1      (*(volatile __near unsigned short *)0x57E)
#define RMD12_8H1      (*(volatile __near unsigned short *)0x57E)
#define RMD12_8H0      (*(volatile __near unsigned short *)0x57E)
#define RMD4_8H1       (*(volatile __near unsigned short *)0x57E)
#define RMD4_8H0       (*(volatile __near unsigned short *)0x57E)
#define TMDF1_8H1L     (*(volatile __near unsigned char  *)0x57E)
#define TMDF1_8H0L     (*(volatile __near unsigned char  *)0x57E)
#define RMD12_8H0L     (*(volatile __near unsigned char  *)0x57E)
#define RMD12_8H1L     (*(volatile __near unsigned char  *)0x57E)
#define RMD4_8H0L      (*(volatile __near unsigned char  *)0x57E)
#define RMD4_8H1L      (*(volatile __near unsigned char  *)0x57E)
#define TMDF1_8H1H     (*(volatile __near unsigned char  *)0x57F)
#define TMDF1_8H0H     (*(volatile __near unsigned char  *)0x57F)
#define RMD12_8H1H     (*(volatile __near unsigned char  *)0x57F)
#define RMD12_8H0H     (*(volatile __near unsigned char  *)0x57F)
#define RMD4_8H0H      (*(volatile __near unsigned char  *)0x57F)
#define RMD4_8H1H      (*(volatile __near unsigned char  *)0x57F)
#define TMDF1_9L0      (*(volatile __near unsigned short *)0x580)
#define TMDF1_9L1      (*(volatile __near unsigned short *)0x580)
#define RMD12_9L0      (*(volatile __near unsigned short *)0x580)
#define RMD12_9L1      (*(volatile __near unsigned short *)0x580)
#define RPGACC0L0      (*(volatile __near unsigned short *)0x580)
#define RPGACC0L1      (*(volatile __near unsigned short *)0x580)
#define RMD4_9L0       (*(volatile __near unsigned short *)0x580)
#define RMD4_9L1       (*(volatile __near unsigned short *)0x580)
#define TMDF1_9L0L     (*(volatile __near unsigned char  *)0x580)
#define TMDF1_9L1L     (*(volatile __near unsigned char  *)0x580)
#define RMD12_9L0L     (*(volatile __near unsigned char  *)0x580)
#define RMD12_9L1L     (*(volatile __near unsigned char  *)0x580)
#define RPGACC0L0L     (*(volatile __near unsigned char  *)0x580)
#define RPGACC0L1L     (*(volatile __near unsigned char  *)0x580)
#define RMD4_9L0L      (*(volatile __near unsigned char  *)0x580)
#define RMD4_9L1L      (*(volatile __near unsigned char  *)0x580)
#define TMDF1_9L1H     (*(volatile __near unsigned char  *)0x581)
#define TMDF1_9L0H     (*(volatile __near unsigned char  *)0x581)
#define RMD12_9L1H     (*(volatile __near unsigned char  *)0x581)
#define RMD12_9L0H     (*(volatile __near unsigned char  *)0x581)
#define RPGACC0L0H     (*(volatile __near unsigned char  *)0x581)
#define RPGACC0L1H     (*(volatile __near unsigned char  *)0x581)
#define RMD4_9L0H      (*(volatile __near unsigned char  *)0x581)
#define RMD4_9L1H      (*(volatile __near unsigned char  *)0x581)
#define TMDF1_9H0      (*(volatile __near unsigned short *)0x582)
#define TMDF1_9H1      (*(volatile __near unsigned short *)0x582)
#define RMD12_9H1      (*(volatile __near unsigned short *)0x582)
#define RMD12_9H0      (*(volatile __near unsigned short *)0x582)
#define RMD4_9H1       (*(volatile __near unsigned short *)0x582)
#define RPGACC0H1      (*(volatile __near unsigned short *)0x582)
#define RPGACC0H0      (*(volatile __near unsigned short *)0x582)
#define RMD4_9H0       (*(volatile __near unsigned short *)0x582)
#define TMDF1_9H1L     (*(volatile __near unsigned char  *)0x582)
#define TMDF1_9H0L     (*(volatile __near unsigned char  *)0x582)
#define RMD12_9H0L     (*(volatile __near unsigned char  *)0x582)
#define RMD12_9H1L     (*(volatile __near unsigned char  *)0x582)
#define RMD4_9H1L      (*(volatile __near unsigned char  *)0x582)
#define RMD4_9H0L      (*(volatile __near unsigned char  *)0x582)
#define RPGACC0H1L     (*(volatile __near unsigned char  *)0x582)
#define RPGACC0H0L     (*(volatile __near unsigned char  *)0x582)
#define TMDF1_9H0H     (*(volatile __near unsigned char  *)0x583)
#define TMDF1_9H1H     (*(volatile __near unsigned char  *)0x583)
#define RMD12_9H0H     (*(volatile __near unsigned char  *)0x583)
#define RMD12_9H1H     (*(volatile __near unsigned char  *)0x583)
#define RPGACC0H0H     (*(volatile __near unsigned char  *)0x583)
#define RMD4_9H1H      (*(volatile __near unsigned char  *)0x583)
#define RMD4_9H0H      (*(volatile __near unsigned char  *)0x583)
#define RPGACC0H1H     (*(volatile __near unsigned char  *)0x583)
#define RMD12_10L0     (*(volatile __near unsigned short *)0x584)
#define RMD12_10L1     (*(volatile __near unsigned short *)0x584)
#define RMD4_10L1      (*(volatile __near unsigned short *)0x584)
#define RMD4_10L0      (*(volatile __near unsigned short *)0x584)
#define TMDF1_10L0     (*(volatile __near unsigned short *)0x584)
#define RPGACC1L0      (*(volatile __near unsigned short *)0x584)
#define TMDF1_10L1     (*(volatile __near unsigned short *)0x584)
#define RPGACC1L1      (*(volatile __near unsigned short *)0x584)
#define RMD12_10L0L    (*(volatile __near unsigned char  *)0x584)
#define RMD12_10L1L    (*(volatile __near unsigned char  *)0x584)
#define TMDF1_10L0L    (*(volatile __near unsigned char  *)0x584)
#define TMDF1_10L1L    (*(volatile __near unsigned char  *)0x584)
#define RMD4_10L0L     (*(volatile __near unsigned char  *)0x584)
#define RMD4_10L1L     (*(volatile __near unsigned char  *)0x584)
#define RPGACC1L0L     (*(volatile __near unsigned char  *)0x584)
#define RPGACC1L1L     (*(volatile __near unsigned char  *)0x584)
#define RMD12_10L0H    (*(volatile __near unsigned char  *)0x585)
#define RMD12_10L1H    (*(volatile __near unsigned char  *)0x585)
#define TMDF1_10L1H    (*(volatile __near unsigned char  *)0x585)
#define RPGACC1L0H     (*(volatile __near unsigned char  *)0x585)
#define TMDF1_10L0H    (*(volatile __near unsigned char  *)0x585)
#define RPGACC1L1H     (*(volatile __near unsigned char  *)0x585)
#define RMD4_10L1H     (*(volatile __near unsigned char  *)0x585)
#define RMD4_10L0H     (*(volatile __near unsigned char  *)0x585)
#define RMD12_10H0     (*(volatile __near unsigned short *)0x586)
#define RMD12_10H1     (*(volatile __near unsigned short *)0x586)
#define RPGACC1H1      (*(volatile __near unsigned short *)0x586)
#define TMDF1_10H1     (*(volatile __near unsigned short *)0x586)
#define RMD4_10H1      (*(volatile __near unsigned short *)0x586)
#define RPGACC1H0      (*(volatile __near unsigned short *)0x586)
#define TMDF1_10H0     (*(volatile __near unsigned short *)0x586)
#define RMD4_10H0      (*(volatile __near unsigned short *)0x586)
#define RMD12_10H0L    (*(volatile __near unsigned char  *)0x586)
#define RMD12_10H1L    (*(volatile __near unsigned char  *)0x586)
#define RPGACC1H1L     (*(volatile __near unsigned char  *)0x586)
#define RPGACC1H0L     (*(volatile __near unsigned char  *)0x586)
#define RMD4_10H1L     (*(volatile __near unsigned char  *)0x586)
#define RMD4_10H0L     (*(volatile __near unsigned char  *)0x586)
#define TMDF1_10H1L    (*(volatile __near unsigned char  *)0x586)
#define TMDF1_10H0L    (*(volatile __near unsigned char  *)0x586)
#define RMD12_10H0H    (*(volatile __near unsigned char  *)0x587)
#define RMD12_10H1H    (*(volatile __near unsigned char  *)0x587)
#define RMD4_10H1H     (*(volatile __near unsigned char  *)0x587)
#define RMD4_10H0H     (*(volatile __near unsigned char  *)0x587)
#define RPGACC1H0H     (*(volatile __near unsigned char  *)0x587)
#define TMDF1_10H0H    (*(volatile __near unsigned char  *)0x587)
#define TMDF1_10H1H    (*(volatile __near unsigned char  *)0x587)
#define RPGACC1H1H     (*(volatile __near unsigned char  *)0x587)
#define RMD12_11L0     (*(volatile __near unsigned short *)0x588)
#define RMD12_11L1     (*(volatile __near unsigned short *)0x588)
#define TMDF1_11L0     (*(volatile __near unsigned short *)0x588)
#define RMD4_11L1      (*(volatile __near unsigned short *)0x588)
#define TMDF1_11L1     (*(volatile __near unsigned short *)0x588)
#define RMD4_11L0      (*(volatile __near unsigned short *)0x588)
#define RPGACC2L0      (*(volatile __near unsigned short *)0x588)
#define RPGACC2L1      (*(volatile __near unsigned short *)0x588)
#define RMD12_11L0L    (*(volatile __near unsigned char  *)0x588)
#define RMD12_11L1L    (*(volatile __near unsigned char  *)0x588)
#define TMDF1_11L0L    (*(volatile __near unsigned char  *)0x588)
#define TMDF1_11L1L    (*(volatile __near unsigned char  *)0x588)
#define RMD4_11L1L     (*(volatile __near unsigned char  *)0x588)
#define RMD4_11L0L     (*(volatile __near unsigned char  *)0x588)
#define RPGACC2L0L     (*(volatile __near unsigned char  *)0x588)
#define RPGACC2L1L     (*(volatile __near unsigned char  *)0x588)
#define RMD12_11L0H    (*(volatile __near unsigned char  *)0x589)
#define RMD12_11L1H    (*(volatile __near unsigned char  *)0x589)
#define RMD4_11L1H     (*(volatile __near unsigned char  *)0x589)
#define TMDF1_11L1H    (*(volatile __near unsigned char  *)0x589)
#define TMDF1_11L0H    (*(volatile __near unsigned char  *)0x589)
#define RMD4_11L0H     (*(volatile __near unsigned char  *)0x589)
#define RPGACC2L0H     (*(volatile __near unsigned char  *)0x589)
#define RPGACC2L1H     (*(volatile __near unsigned char  *)0x589)
#define RMD12_11H1     (*(volatile __near unsigned short *)0x58A)
#define RMD12_11H0     (*(volatile __near unsigned short *)0x58A)
#define TMDF1_11H0     (*(volatile __near unsigned short *)0x58A)
#define TMDF1_11H1     (*(volatile __near unsigned short *)0x58A)
#define RMD4_11H1      (*(volatile __near unsigned short *)0x58A)
#define RMD4_11H0      (*(volatile __near unsigned short *)0x58A)
#define RPGACC2H1      (*(volatile __near unsigned short *)0x58A)
#define RPGACC2H0      (*(volatile __near unsigned short *)0x58A)
#define RMD12_11H0L    (*(volatile __near unsigned char  *)0x58A)
#define RMD12_11H1L    (*(volatile __near unsigned char  *)0x58A)
#define TMDF1_11H0L    (*(volatile __near unsigned char  *)0x58A)
#define TMDF1_11H1L    (*(volatile __near unsigned char  *)0x58A)
#define RMD4_11H0L     (*(volatile __near unsigned char  *)0x58A)
#define RMD4_11H1L     (*(volatile __near unsigned char  *)0x58A)
#define RPGACC2H0L     (*(volatile __near unsigned char  *)0x58A)
#define RPGACC2H1L     (*(volatile __near unsigned char  *)0x58A)
#define RMD12_11H1H    (*(volatile __near unsigned char  *)0x58B)
#define RMD12_11H0H    (*(volatile __near unsigned char  *)0x58B)
#define TMDF1_11H0H    (*(volatile __near unsigned char  *)0x58B)
#define TMDF1_11H1H    (*(volatile __near unsigned char  *)0x58B)
#define RMD4_11H1H     (*(volatile __near unsigned char  *)0x58B)
#define RMD4_11H0H     (*(volatile __near unsigned char  *)0x58B)
#define RPGACC2H0H     (*(volatile __near unsigned char  *)0x58B)
#define RPGACC2H1H     (*(volatile __near unsigned char  *)0x58B)
#define RMD12_12L0     (*(volatile __near unsigned short *)0x58C)
#define RMD12_12L1     (*(volatile __near unsigned short *)0x58C)
#define RMD4_12L0      (*(volatile __near unsigned short *)0x58C)
#define TMDF1_12L1     (*(volatile __near unsigned short *)0x58C)
#define RMD4_12L1      (*(volatile __near unsigned short *)0x58C)
#define TMDF1_12L0     (*(volatile __near unsigned short *)0x58C)
#define RPGACC3L1      (*(volatile __near unsigned short *)0x58C)
#define RPGACC3L0      (*(volatile __near unsigned short *)0x58C)
#define RMD12_12L1L    (*(volatile __near unsigned char  *)0x58C)
#define RMD12_12L0L    (*(volatile __near unsigned char  *)0x58C)
#define TMDF1_12L1L    (*(volatile __near unsigned char  *)0x58C)
#define TMDF1_12L0L    (*(volatile __near unsigned char  *)0x58C)
#define RMD4_12L0L     (*(volatile __near unsigned char  *)0x58C)
#define RMD4_12L1L     (*(volatile __near unsigned char  *)0x58C)
#define RPGACC3L1L     (*(volatile __near unsigned char  *)0x58C)
#define RPGACC3L0L     (*(volatile __near unsigned char  *)0x58C)
#define RMD12_12L1H    (*(volatile __near unsigned char  *)0x58D)
#define RMD12_12L0H    (*(volatile __near unsigned char  *)0x58D)
#define RMD4_12L1H     (*(volatile __near unsigned char  *)0x58D)
#define TMDF1_12L0H    (*(volatile __near unsigned char  *)0x58D)
#define TMDF1_12L1H    (*(volatile __near unsigned char  *)0x58D)
#define RMD4_12L0H     (*(volatile __near unsigned char  *)0x58D)
#define RPGACC3L0H     (*(volatile __near unsigned char  *)0x58D)
#define RPGACC3L1H     (*(volatile __near unsigned char  *)0x58D)
#define RMD12_12H0     (*(volatile __near unsigned short *)0x58E)
#define RMD12_12H1     (*(volatile __near unsigned short *)0x58E)
#define RMD4_12H0      (*(volatile __near unsigned short *)0x58E)
#define TMDF1_12H0     (*(volatile __near unsigned short *)0x58E)
#define RMD4_12H1      (*(volatile __near unsigned short *)0x58E)
#define TMDF1_12H1     (*(volatile __near unsigned short *)0x58E)
#define RPGACC3H0      (*(volatile __near unsigned short *)0x58E)
#define RPGACC3H1      (*(volatile __near unsigned short *)0x58E)
#define RMD12_12H1L    (*(volatile __near unsigned char  *)0x58E)
#define RMD12_12H0L    (*(volatile __near unsigned char  *)0x58E)
#define RMD4_12H1L     (*(volatile __near unsigned char  *)0x58E)
#define TMDF1_12H1L    (*(volatile __near unsigned char  *)0x58E)
#define RMD4_12H0L     (*(volatile __near unsigned char  *)0x58E)
#define TMDF1_12H0L    (*(volatile __near unsigned char  *)0x58E)
#define RPGACC3H0L     (*(volatile __near unsigned char  *)0x58E)
#define RPGACC3H1L     (*(volatile __near unsigned char  *)0x58E)
#define RMD12_12H1H    (*(volatile __near unsigned char  *)0x58F)
#define RMD12_12H0H    (*(volatile __near unsigned char  *)0x58F)
#define TMDF1_12H1H    (*(volatile __near unsigned char  *)0x58F)
#define TMDF1_12H0H    (*(volatile __near unsigned char  *)0x58F)
#define RMD4_12H0H     (*(volatile __near unsigned char  *)0x58F)
#define RMD4_12H1H     (*(volatile __near unsigned char  *)0x58F)
#define RPGACC3H1H     (*(volatile __near unsigned char  *)0x58F)
#define RPGACC3H0H     (*(volatile __near unsigned char  *)0x58F)
#define RMD12_13L1     (*(volatile __near unsigned short *)0x590)
#define RMD12_13L0     (*(volatile __near unsigned short *)0x590)
#define TMDF1_13L0     (*(volatile __near unsigned short *)0x590)
#define TMDF1_13L1     (*(volatile __near unsigned short *)0x590)
#define RPGACC4L0      (*(volatile __near unsigned short *)0x590)
#define RPGACC4L1      (*(volatile __near unsigned short *)0x590)
#define RMD4_13L1      (*(volatile __near unsigned short *)0x590)
#define RMD4_13L0      (*(volatile __near unsigned short *)0x590)
#define RMD12_13L0L    (*(volatile __near unsigned char  *)0x590)
#define RMD12_13L1L    (*(volatile __near unsigned char  *)0x590)
#define TMDF1_13L0L    (*(volatile __near unsigned char  *)0x590)
#define TMDF1_13L1L    (*(volatile __near unsigned char  *)0x590)
#define RPGACC4L1L     (*(volatile __near unsigned char  *)0x590)
#define RPGACC4L0L     (*(volatile __near unsigned char  *)0x590)
#define RMD4_13L1L     (*(volatile __near unsigned char  *)0x590)
#define RMD4_13L0L     (*(volatile __near unsigned char  *)0x590)
#define RMD12_13L1H    (*(volatile __near unsigned char  *)0x591)
#define RMD12_13L0H    (*(volatile __near unsigned char  *)0x591)
#define TMDF1_13L0H    (*(volatile __near unsigned char  *)0x591)
#define TMDF1_13L1H    (*(volatile __near unsigned char  *)0x591)
#define RPGACC4L0H     (*(volatile __near unsigned char  *)0x591)
#define RPGACC4L1H     (*(volatile __near unsigned char  *)0x591)
#define RMD4_13L1H     (*(volatile __near unsigned char  *)0x591)
#define RMD4_13L0H     (*(volatile __near unsigned char  *)0x591)
#define RMD12_13H0     (*(volatile __near unsigned short *)0x592)
#define RMD12_13H1     (*(volatile __near unsigned short *)0x592)
#define TMDF1_13H1     (*(volatile __near unsigned short *)0x592)
#define TMDF1_13H0     (*(volatile __near unsigned short *)0x592)
#define RPGACC4H0      (*(volatile __near unsigned short *)0x592)
#define RPGACC4H1      (*(volatile __near unsigned short *)0x592)
#define RMD4_13H0      (*(volatile __near unsigned short *)0x592)
#define RMD4_13H1      (*(volatile __near unsigned short *)0x592)
#define RMD12_13H0L    (*(volatile __near unsigned char  *)0x592)
#define RMD12_13H1L    (*(volatile __near unsigned char  *)0x592)
#define TMDF1_13H0L    (*(volatile __near unsigned char  *)0x592)
#define TMDF1_13H1L    (*(volatile __near unsigned char  *)0x592)
#define RPGACC4H1L     (*(volatile __near unsigned char  *)0x592)
#define RPGACC4H0L     (*(volatile __near unsigned char  *)0x592)
#define RMD4_13H0L     (*(volatile __near unsigned char  *)0x592)
#define RMD4_13H1L     (*(volatile __near unsigned char  *)0x592)
#define RMD12_13H1H    (*(volatile __near unsigned char  *)0x593)
#define RMD12_13H0H    (*(volatile __near unsigned char  *)0x593)
#define TMDF1_13H0H    (*(volatile __near unsigned char  *)0x593)
#define TMDF1_13H1H    (*(volatile __near unsigned char  *)0x593)
#define RPGACC4H1H     (*(volatile __near unsigned char  *)0x593)
#define RPGACC4H0H     (*(volatile __near unsigned char  *)0x593)
#define RMD4_13H0H     (*(volatile __near unsigned char  *)0x593)
#define RMD4_13H1H     (*(volatile __near unsigned char  *)0x593)
#define RMD12_14L0     (*(volatile __near unsigned short *)0x594)
#define RMD12_14L1     (*(volatile __near unsigned short *)0x594)
#define TMDF1_14L0     (*(volatile __near unsigned short *)0x594)
#define RPGACC5L1      (*(volatile __near unsigned short *)0x594)
#define RPGACC5L0      (*(volatile __near unsigned short *)0x594)
#define TMDF1_14L1     (*(volatile __near unsigned short *)0x594)
#define RMD4_14L1      (*(volatile __near unsigned short *)0x594)
#define RMD4_14L0      (*(volatile __near unsigned short *)0x594)
#define RMD12_14L0L    (*(volatile __near unsigned char  *)0x594)
#define RMD12_14L1L    (*(volatile __near unsigned char  *)0x594)
#define RPGACC5L1L     (*(volatile __near unsigned char  *)0x594)
#define RPGACC5L0L     (*(volatile __near unsigned char  *)0x594)
#define TMDF1_14L1L    (*(volatile __near unsigned char  *)0x594)
#define TMDF1_14L0L    (*(volatile __near unsigned char  *)0x594)
#define RMD4_14L1L     (*(volatile __near unsigned char  *)0x594)
#define RMD4_14L0L     (*(volatile __near unsigned char  *)0x594)
#define RMD12_14L1H    (*(volatile __near unsigned char  *)0x595)
#define RMD12_14L0H    (*(volatile __near unsigned char  *)0x595)
#define TMDF1_14L1H    (*(volatile __near unsigned char  *)0x595)
#define RPGACC5L1H     (*(volatile __near unsigned char  *)0x595)
#define RPGACC5L0H     (*(volatile __near unsigned char  *)0x595)
#define TMDF1_14L0H    (*(volatile __near unsigned char  *)0x595)
#define RMD4_14L1H     (*(volatile __near unsigned char  *)0x595)
#define RMD4_14L0H     (*(volatile __near unsigned char  *)0x595)
#define RMD12_14H1     (*(volatile __near unsigned short *)0x596)
#define RMD12_14H0     (*(volatile __near unsigned short *)0x596)
#define RPGACC5H1      (*(volatile __near unsigned short *)0x596)
#define TMDF1_14H1     (*(volatile __near unsigned short *)0x596)
#define TMDF1_14H0     (*(volatile __near unsigned short *)0x596)
#define RPGACC5H0      (*(volatile __near unsigned short *)0x596)
#define RMD4_14H1      (*(volatile __near unsigned short *)0x596)
#define RMD4_14H0      (*(volatile __near unsigned short *)0x596)
#define RMD12_14H1L    (*(volatile __near unsigned char  *)0x596)
#define RMD12_14H0L    (*(volatile __near unsigned char  *)0x596)
#define TMDF1_14H0L    (*(volatile __near unsigned char  *)0x596)
#define TMDF1_14H1L    (*(volatile __near unsigned char  *)0x596)
#define RPGACC5H0L     (*(volatile __near unsigned char  *)0x596)
#define RPGACC5H1L     (*(volatile __near unsigned char  *)0x596)
#define RMD4_14H0L     (*(volatile __near unsigned char  *)0x596)
#define RMD4_14H1L     (*(volatile __near unsigned char  *)0x596)
#define RMD12_14H1H    (*(volatile __near unsigned char  *)0x597)
#define RMD12_14H0H    (*(volatile __near unsigned char  *)0x597)
#define TMDF1_14H0H    (*(volatile __near unsigned char  *)0x597)
#define TMDF1_14H1H    (*(volatile __near unsigned char  *)0x597)
#define RPGACC5H0H     (*(volatile __near unsigned char  *)0x597)
#define RPGACC5H1H     (*(volatile __near unsigned char  *)0x597)
#define RMD4_14H1H     (*(volatile __near unsigned char  *)0x597)
#define RMD4_14H0H     (*(volatile __near unsigned char  *)0x597)
#define RMD12_15L0     (*(volatile __near unsigned short *)0x598)
#define RMD12_15L1     (*(volatile __near unsigned short *)0x598)
#define TMDF1_15L1     (*(volatile __near unsigned short *)0x598)
#define TMDF1_15L0     (*(volatile __near unsigned short *)0x598)
#define RPGACC6L0      (*(volatile __near unsigned short *)0x598)
#define RPGACC6L1      (*(volatile __near unsigned short *)0x598)
#define RMD4_15L1      (*(volatile __near unsigned short *)0x598)
#define RMD4_15L0      (*(volatile __near unsigned short *)0x598)
#define RMD12_15L0L    (*(volatile __near unsigned char  *)0x598)
#define RMD12_15L1L    (*(volatile __near unsigned char  *)0x598)
#define RPGACC6L0L     (*(volatile __near unsigned char  *)0x598)
#define RPGACC6L1L     (*(volatile __near unsigned char  *)0x598)
#define TMDF1_15L1L    (*(volatile __near unsigned char  *)0x598)
#define TMDF1_15L0L    (*(volatile __near unsigned char  *)0x598)
#define RMD4_15L0L     (*(volatile __near unsigned char  *)0x598)
#define RMD4_15L1L     (*(volatile __near unsigned char  *)0x598)
#define RMD12_15L0H    (*(volatile __near unsigned char  *)0x599)
#define RMD12_15L1H    (*(volatile __near unsigned char  *)0x599)
#define TMDF1_15L0H    (*(volatile __near unsigned char  *)0x599)
#define TMDF1_15L1H    (*(volatile __near unsigned char  *)0x599)
#define RPGACC6L0H     (*(volatile __near unsigned char  *)0x599)
#define RPGACC6L1H     (*(volatile __near unsigned char  *)0x599)
#define RMD4_15L1H     (*(volatile __near unsigned char  *)0x599)
#define RMD4_15L0H     (*(volatile __near unsigned char  *)0x599)
#define RMD12_15H1     (*(volatile __near unsigned short *)0x59A)
#define RMD12_15H0     (*(volatile __near unsigned short *)0x59A)
#define RPGACC6H1      (*(volatile __near unsigned short *)0x59A)
#define TMDF1_15H1     (*(volatile __near unsigned short *)0x59A)
#define TMDF1_15H0     (*(volatile __near unsigned short *)0x59A)
#define RPGACC6H0      (*(volatile __near unsigned short *)0x59A)
#define RMD4_15H0      (*(volatile __near unsigned short *)0x59A)
#define RMD4_15H1      (*(volatile __near unsigned short *)0x59A)
#define RMD12_15H0L    (*(volatile __near unsigned char  *)0x59A)
#define RMD12_15H1L    (*(volatile __near unsigned char  *)0x59A)
#define RPGACC6H1L     (*(volatile __near unsigned char  *)0x59A)
#define TMDF1_15H0L    (*(volatile __near unsigned char  *)0x59A)
#define RPGACC6H0L     (*(volatile __near unsigned char  *)0x59A)
#define TMDF1_15H1L    (*(volatile __near unsigned char  *)0x59A)
#define RMD4_15H0L     (*(volatile __near unsigned char  *)0x59A)
#define RMD4_15H1L     (*(volatile __near unsigned char  *)0x59A)
#define RMD12_15H1H    (*(volatile __near unsigned char  *)0x59B)
#define RMD12_15H0H    (*(volatile __near unsigned char  *)0x59B)
#define TMDF1_15H1H    (*(volatile __near unsigned char  *)0x59B)
#define TMDF1_15H0H    (*(volatile __near unsigned char  *)0x59B)
#define RPGACC6H0H     (*(volatile __near unsigned char  *)0x59B)
#define RPGACC6H1H     (*(volatile __near unsigned char  *)0x59B)
#define RMD4_15H0H     (*(volatile __near unsigned char  *)0x59B)
#define RMD4_15H1H     (*(volatile __near unsigned char  *)0x59B)
#define TMID2L0        (*(volatile __near unsigned short *)0x59C)
#define TMID2L1        (*(volatile __near unsigned short *)0x59C)
#define RPGACC7L1      (*(volatile __near unsigned short *)0x59C)
#define RPGACC7L0      (*(volatile __near unsigned short *)0x59C)
#define RMID5L0        (*(volatile __near unsigned short *)0x59C)
#define RMID13L0       (*(volatile __near unsigned short *)0x59C)
#define RMID13L1       (*(volatile __near unsigned short *)0x59C)
#define RMID5L1        (*(volatile __near unsigned short *)0x59C)
#define TMID2L1L       (*(volatile __near unsigned char  *)0x59C)
#define TMID2L0L       (*(volatile __near unsigned char  *)0x59C)
#define RPGACC7L1L     (*(volatile __near unsigned char  *)0x59C)
#define RMID5L1L       (*(volatile __near unsigned char  *)0x59C)
#define RPGACC7L0L     (*(volatile __near unsigned char  *)0x59C)
#define RMID5L0L       (*(volatile __near unsigned char  *)0x59C)
#define RMID13L1L      (*(volatile __near unsigned char  *)0x59C)
#define RMID13L0L      (*(volatile __near unsigned char  *)0x59C)
#define TMID2L1H       (*(volatile __near unsigned char  *)0x59D)
#define TMID2L0H       (*(volatile __near unsigned char  *)0x59D)
#define RMID5L0H       (*(volatile __near unsigned char  *)0x59D)
#define RMID13L1H      (*(volatile __near unsigned char  *)0x59D)
#define RMID13L0H      (*(volatile __near unsigned char  *)0x59D)
#define RPGACC7L0H     (*(volatile __near unsigned char  *)0x59D)
#define RPGACC7L1H     (*(volatile __near unsigned char  *)0x59D)
#define RMID5L1H       (*(volatile __near unsigned char  *)0x59D)
#define TMID2H1        (*(volatile __near unsigned short *)0x59E)
#define TMID2H0        (*(volatile __near unsigned short *)0x59E)
#define RMID5H1        (*(volatile __near unsigned short *)0x59E)
#define RMID5H0        (*(volatile __near unsigned short *)0x59E)
#define RPGACC7H0      (*(volatile __near unsigned short *)0x59E)
#define RMID13H0       (*(volatile __near unsigned short *)0x59E)
#define RPGACC7H1      (*(volatile __near unsigned short *)0x59E)
#define RMID13H1       (*(volatile __near unsigned short *)0x59E)
#define TMID2H1L       (*(volatile __near unsigned char  *)0x59E)
#define TMID2H0L       (*(volatile __near unsigned char  *)0x59E)
#define RMID5H1L       (*(volatile __near unsigned char  *)0x59E)
#define RPGACC7H0L     (*(volatile __near unsigned char  *)0x59E)
#define RPGACC7H1L     (*(volatile __near unsigned char  *)0x59E)
#define RMID13H1L      (*(volatile __near unsigned char  *)0x59E)
#define RMID13H0L      (*(volatile __near unsigned char  *)0x59E)
#define RMID5H0L       (*(volatile __near unsigned char  *)0x59E)
#define TMID2H1H       (*(volatile __near unsigned char  *)0x59F)
#define TMID2H0H       (*(volatile __near unsigned char  *)0x59F)
#define RMID13H1H      (*(volatile __near unsigned char  *)0x59F)
#define RPGACC7H1H     (*(volatile __near unsigned char  *)0x59F)
#define RMID13H0H      (*(volatile __near unsigned char  *)0x59F)
#define RPGACC7H0H     (*(volatile __near unsigned char  *)0x59F)
#define RMID5H0H       (*(volatile __near unsigned char  *)0x59F)
#define RMID5H1H       (*(volatile __near unsigned char  *)0x59F)
#define RMPTR13L0      (*(volatile __near unsigned short *)0x5A0)
#define RPGACC8L1      (*(volatile __near unsigned short *)0x5A0)
#define RMPTR5L0       (*(volatile __near unsigned short *)0x5A0)
#define RMPTR5L1       (*(volatile __near unsigned short *)0x5A0)
#define RPGACC8L0      (*(volatile __near unsigned short *)0x5A0)
#define RMPTR13L1      (*(volatile __near unsigned short *)0x5A0)
#define RMPTR13L0L     (*(volatile __near unsigned char  *)0x5A0)
#define RMPTR13L1L     (*(volatile __near unsigned char  *)0x5A0)
#define RMPTR5L1L      (*(volatile __near unsigned char  *)0x5A0)
#define RPGACC8L0L     (*(volatile __near unsigned char  *)0x5A0)
#define RMPTR5L0L      (*(volatile __near unsigned char  *)0x5A0)
#define RPGACC8L1L     (*(volatile __near unsigned char  *)0x5A0)
#define RPGACC8L0H     (*(volatile __near unsigned char  *)0x5A1)
#define RMPTR5L0H      (*(volatile __near unsigned char  *)0x5A1)
#define RMPTR13L0H     (*(volatile __near unsigned char  *)0x5A1)
#define RMPTR13L1H     (*(volatile __near unsigned char  *)0x5A1)
#define RMPTR5L1H      (*(volatile __near unsigned char  *)0x5A1)
#define RPGACC8L1H     (*(volatile __near unsigned char  *)0x5A1)
#define TMPTR2H1       (*(volatile __near unsigned short *)0x5A2)
#define TMPTR2H0       (*(volatile __near unsigned short *)0x5A2)
#define RPGACC8H0      (*(volatile __near unsigned short *)0x5A2)
#define RMPTR13H0      (*(volatile __near unsigned short *)0x5A2)
#define RMPTR13H1      (*(volatile __near unsigned short *)0x5A2)
#define RPGACC8H1      (*(volatile __near unsigned short *)0x5A2)
#define RMPTR5H0       (*(volatile __near unsigned short *)0x5A2)
#define RMPTR5H1       (*(volatile __near unsigned short *)0x5A2)
#define RPGACC8H0L     (*(volatile __near unsigned char  *)0x5A2)
#define RPGACC8H1L     (*(volatile __near unsigned char  *)0x5A2)
#define TMPTR2H1H      (*(volatile __near unsigned char  *)0x5A3)
#define TMPTR2H0H      (*(volatile __near unsigned char  *)0x5A3)
#define RPGACC8H0H     (*(volatile __near unsigned char  *)0x5A3)
#define RMPTR13H1H     (*(volatile __near unsigned char  *)0x5A3)
#define RPGACC8H1H     (*(volatile __near unsigned char  *)0x5A3)
#define RMPTR5H0H      (*(volatile __near unsigned char  *)0x5A3)
#define RMPTR13H0H     (*(volatile __near unsigned char  *)0x5A3)
#define RMPTR5H1H      (*(volatile __near unsigned char  *)0x5A3)
#define TMFDCTR2L1     (*(volatile __near unsigned short *)0x5A4)
#define TMFDCTR2L0     (*(volatile __near unsigned short *)0x5A4)
#define RMSTS5L0       (*(volatile __near unsigned short *)0x5A4)
#define RMSTS13L1      (*(volatile __near unsigned short *)0x5A4)
#define RMSTS13L0      (*(volatile __near unsigned short *)0x5A4)
#define RMSTS5L1       (*(volatile __near unsigned short *)0x5A4)
#define RPGACC9L1      (*(volatile __near unsigned short *)0x5A4)
#define RPGACC9L0      (*(volatile __near unsigned short *)0x5A4)
#define TMFDCTR2L1L    (*(volatile __near unsigned char  *)0x5A4)
#define TMFDCTR2L0L    (*(volatile __near unsigned char  *)0x5A4)
#define RMSTS5L1L      (*(volatile __near unsigned char  *)0x5A4)
#define RMSTS13L0L     (*(volatile __near unsigned char  *)0x5A4)
#define RMSTS5L0L      (*(volatile __near unsigned char  *)0x5A4)
#define RPGACC9L1L     (*(volatile __near unsigned char  *)0x5A4)
#define RPGACC9L0L     (*(volatile __near unsigned char  *)0x5A4)
#define RMSTS13L1L     (*(volatile __near unsigned char  *)0x5A4)
#define TMFDCTR2L1H    (*(volatile __near unsigned char  *)0x5A5)
#define TMFDCTR2L0H    (*(volatile __near unsigned char  *)0x5A5)
#define RMSTS5L0H      (*(volatile __near unsigned char  *)0x5A5)
#define RMSTS5L1H      (*(volatile __near unsigned char  *)0x5A5)
#define RPGACC9L1H     (*(volatile __near unsigned char  *)0x5A5)
#define RPGACC9L0H     (*(volatile __near unsigned char  *)0x5A5)
#define RMSTS13L1H     (*(volatile __near unsigned char  *)0x5A5)
#define RMSTS13L0H     (*(volatile __near unsigned char  *)0x5A5)
#define TMFDCTR2H1     (*(volatile __near unsigned short *)0x5A6)
#define TMFDCTR2H0     (*(volatile __near unsigned short *)0x5A6)
#define RPGACC9H0      (*(volatile __near unsigned short *)0x5A6)
#define RMSTS13H0      (*(volatile __near unsigned short *)0x5A6)
#define RPGACC9H1      (*(volatile __near unsigned short *)0x5A6)
#define RMSTS13H1      (*(volatile __near unsigned short *)0x5A6)
#define RMSTS5H0       (*(volatile __near unsigned short *)0x5A6)
#define RMSTS5H1       (*(volatile __near unsigned short *)0x5A6)
#define TMFDCTR2H1L    (*(volatile __near unsigned char  *)0x5A6)
#define TMFDCTR2H0L    (*(volatile __near unsigned char  *)0x5A6)
#define RMSTS5H0L      (*(volatile __near unsigned char  *)0x5A6)
#define RPGACC9H1L     (*(volatile __near unsigned char  *)0x5A6)
#define RMSTS13H0L     (*(volatile __near unsigned char  *)0x5A6)
#define RMSTS13H1L     (*(volatile __near unsigned char  *)0x5A6)
#define RPGACC9H0L     (*(volatile __near unsigned char  *)0x5A6)
#define RMSTS5H1L      (*(volatile __near unsigned char  *)0x5A6)
#define TMFDCTR2H1H    (*(volatile __near unsigned char  *)0x5A7)
#define TMFDCTR2H0H    (*(volatile __near unsigned char  *)0x5A7)
#define RMSTS13H1H     (*(volatile __near unsigned char  *)0x5A7)
#define RMSTS13H0H     (*(volatile __near unsigned char  *)0x5A7)
#define RPGACC9H1H     (*(volatile __near unsigned char  *)0x5A7)
#define RPGACC9H0H     (*(volatile __near unsigned char  *)0x5A7)
#define RMSTS5H0H      (*(volatile __near unsigned char  *)0x5A7)
#define RMSTS5H1H      (*(volatile __near unsigned char  *)0x5A7)
#define TMDF2_0L1      (*(volatile __near unsigned short *)0x5A8)
#define TMDF2_0L0      (*(volatile __near unsigned short *)0x5A8)
#define RMD13_0L1      (*(volatile __near unsigned short *)0x5A8)
#define RMD13_0L0      (*(volatile __near unsigned short *)0x5A8)
#define RPGACC10L0     (*(volatile __near unsigned short *)0x5A8)
#define RPGACC10L1     (*(volatile __near unsigned short *)0x5A8)
#define RMD5_0L1       (*(volatile __near unsigned short *)0x5A8)
#define RMD5_0L0       (*(volatile __near unsigned short *)0x5A8)
#define TMDF2_0L1L     (*(volatile __near unsigned char  *)0x5A8)
#define TMDF2_0L0L     (*(volatile __near unsigned char  *)0x5A8)
#define RMD13_0L1L     (*(volatile __near unsigned char  *)0x5A8)
#define RMD13_0L0L     (*(volatile __near unsigned char  *)0x5A8)
#define RPGACC10L0L    (*(volatile __near unsigned char  *)0x5A8)
#define RPGACC10L1L    (*(volatile __near unsigned char  *)0x5A8)
#define RMD5_0L1L      (*(volatile __near unsigned char  *)0x5A8)
#define RMD5_0L0L      (*(volatile __near unsigned char  *)0x5A8)
#define RMD13_0L0H     (*(volatile __near unsigned char  *)0x5A9)
#define RMD13_0L1H     (*(volatile __near unsigned char  *)0x5A9)
#define TMDF2_0L1H     (*(volatile __near unsigned char  *)0x5A9)
#define TMDF2_0L0H     (*(volatile __near unsigned char  *)0x5A9)
#define RPGACC10L0H    (*(volatile __near unsigned char  *)0x5A9)
#define RPGACC10L1H    (*(volatile __near unsigned char  *)0x5A9)
#define RMD5_0L1H      (*(volatile __near unsigned char  *)0x5A9)
#define RMD5_0L0H      (*(volatile __near unsigned char  *)0x5A9)
#define TMDF2_0H0      (*(volatile __near unsigned short *)0x5AA)
#define TMDF2_0H1      (*(volatile __near unsigned short *)0x5AA)
#define RMD13_0H0      (*(volatile __near unsigned short *)0x5AA)
#define RMD13_0H1      (*(volatile __near unsigned short *)0x5AA)
#define RPGACC10H1     (*(volatile __near unsigned short *)0x5AA)
#define RPGACC10H0     (*(volatile __near unsigned short *)0x5AA)
#define RMD5_0H1       (*(volatile __near unsigned short *)0x5AA)
#define RMD5_0H0       (*(volatile __near unsigned short *)0x5AA)
#define TMDF2_0H0L     (*(volatile __near unsigned char  *)0x5AA)
#define RMD13_0H1L     (*(volatile __near unsigned char  *)0x5AA)
#define RMD13_0H0L     (*(volatile __near unsigned char  *)0x5AA)
#define TMDF2_0H1L     (*(volatile __near unsigned char  *)0x5AA)
#define RPGACC10H0L    (*(volatile __near unsigned char  *)0x5AA)
#define RPGACC10H1L    (*(volatile __near unsigned char  *)0x5AA)
#define RMD5_0H1L      (*(volatile __near unsigned char  *)0x5AA)
#define RMD5_0H0L      (*(volatile __near unsigned char  *)0x5AA)
#define TMDF2_0H0H     (*(volatile __near unsigned char  *)0x5AB)
#define TMDF2_0H1H     (*(volatile __near unsigned char  *)0x5AB)
#define RMD13_0H1H     (*(volatile __near unsigned char  *)0x5AB)
#define RMD13_0H0H     (*(volatile __near unsigned char  *)0x5AB)
#define RPGACC10H0H    (*(volatile __near unsigned char  *)0x5AB)
#define RPGACC10H1H    (*(volatile __near unsigned char  *)0x5AB)
#define RMD5_0H1H      (*(volatile __near unsigned char  *)0x5AB)
#define RMD5_0H0H      (*(volatile __near unsigned char  *)0x5AB)
#define TMDF2_1L1      (*(volatile __near unsigned short *)0x5AC)
#define TMDF2_1L0      (*(volatile __near unsigned short *)0x5AC)
#define RMD13_1L0      (*(volatile __near unsigned short *)0x5AC)
#define RMD13_1L1      (*(volatile __near unsigned short *)0x5AC)
#define RPGACC11L0     (*(volatile __near unsigned short *)0x5AC)
#define RPGACC11L1     (*(volatile __near unsigned short *)0x5AC)
#define RMD5_1L1       (*(volatile __near unsigned short *)0x5AC)
#define RMD5_1L0       (*(volatile __near unsigned short *)0x5AC)
#define TMDF2_1L0L     (*(volatile __near unsigned char  *)0x5AC)
#define RMD13_1L0L     (*(volatile __near unsigned char  *)0x5AC)
#define TMDF2_1L1L     (*(volatile __near unsigned char  *)0x5AC)
#define RMD13_1L1L     (*(volatile __near unsigned char  *)0x5AC)
#define RPGACC11L0L    (*(volatile __near unsigned char  *)0x5AC)
#define RPGACC11L1L    (*(volatile __near unsigned char  *)0x5AC)
#define RMD5_1L1L      (*(volatile __near unsigned char  *)0x5AC)
#define RMD5_1L0L      (*(volatile __near unsigned char  *)0x5AC)
#define TMDF2_1L0H     (*(volatile __near unsigned char  *)0x5AD)
#define TMDF2_1L1H     (*(volatile __near unsigned char  *)0x5AD)
#define RMD13_1L0H     (*(volatile __near unsigned char  *)0x5AD)
#define RMD13_1L1H     (*(volatile __near unsigned char  *)0x5AD)
#define RPGACC11L0H    (*(volatile __near unsigned char  *)0x5AD)
#define RPGACC11L1H    (*(volatile __near unsigned char  *)0x5AD)
#define RMD5_1L0H      (*(volatile __near unsigned char  *)0x5AD)
#define RMD5_1L1H      (*(volatile __near unsigned char  *)0x5AD)
#define TMDF2_1H1      (*(volatile __near unsigned short *)0x5AE)
#define TMDF2_1H0      (*(volatile __near unsigned short *)0x5AE)
#define RMD13_1H0      (*(volatile __near unsigned short *)0x5AE)
#define RMD13_1H1      (*(volatile __near unsigned short *)0x5AE)
#define RPGACC11H1     (*(volatile __near unsigned short *)0x5AE)
#define RPGACC11H0     (*(volatile __near unsigned short *)0x5AE)
#define RMD5_1H1       (*(volatile __near unsigned short *)0x5AE)
#define RMD5_1H0       (*(volatile __near unsigned short *)0x5AE)
#define RMD13_1H0L     (*(volatile __near unsigned char  *)0x5AE)
#define RMD13_1H1L     (*(volatile __near unsigned char  *)0x5AE)
#define TMDF2_1H0L     (*(volatile __near unsigned char  *)0x5AE)
#define TMDF2_1H1L     (*(volatile __near unsigned char  *)0x5AE)
#define RPGACC11H0L    (*(volatile __near unsigned char  *)0x5AE)
#define RPGACC11H1L    (*(volatile __near unsigned char  *)0x5AE)
#define RMD5_1H1L      (*(volatile __near unsigned char  *)0x5AE)
#define RMD5_1H0L      (*(volatile __near unsigned char  *)0x5AE)
#define RMD13_1H1H     (*(volatile __near unsigned char  *)0x5AF)
#define TMDF2_1H1H     (*(volatile __near unsigned char  *)0x5AF)
#define TMDF2_1H0H     (*(volatile __near unsigned char  *)0x5AF)
#define RMD13_1H0H     (*(volatile __near unsigned char  *)0x5AF)
#define RPGACC11H0H    (*(volatile __near unsigned char  *)0x5AF)
#define RPGACC11H1H    (*(volatile __near unsigned char  *)0x5AF)
#define RMD5_1H1H      (*(volatile __near unsigned char  *)0x5AF)
#define RMD5_1H0H      (*(volatile __near unsigned char  *)0x5AF)
#define RMD13_2L1      (*(volatile __near unsigned short *)0x5B0)
#define TMDF2_2L1      (*(volatile __near unsigned short *)0x5B0)
#define RMD13_2L0      (*(volatile __near unsigned short *)0x5B0)
#define TMDF2_2L0      (*(volatile __near unsigned short *)0x5B0)
#define RPGACC12L1     (*(volatile __near unsigned short *)0x5B0)
#define RPGACC12L0     (*(volatile __near unsigned short *)0x5B0)
#define RMD5_2L0       (*(volatile __near unsigned short *)0x5B0)
#define RMD5_2L1       (*(volatile __near unsigned short *)0x5B0)
#define TMDF2_2L0L     (*(volatile __near unsigned char  *)0x5B0)
#define RMD13_2L1L     (*(volatile __near unsigned char  *)0x5B0)
#define TMDF2_2L1L     (*(volatile __near unsigned char  *)0x5B0)
#define RMD13_2L0L     (*(volatile __near unsigned char  *)0x5B0)
#define RPGACC12L1L    (*(volatile __near unsigned char  *)0x5B0)
#define RPGACC12L0L    (*(volatile __near unsigned char  *)0x5B0)
#define RMD5_2L0L      (*(volatile __near unsigned char  *)0x5B0)
#define RMD5_2L1L      (*(volatile __near unsigned char  *)0x5B0)
#define TMDF2_2L0H     (*(volatile __near unsigned char  *)0x5B1)
#define RMD13_2L0H     (*(volatile __near unsigned char  *)0x5B1)
#define TMDF2_2L1H     (*(volatile __near unsigned char  *)0x5B1)
#define RMD13_2L1H     (*(volatile __near unsigned char  *)0x5B1)
#define RPGACC12L1H    (*(volatile __near unsigned char  *)0x5B1)
#define RPGACC12L0H    (*(volatile __near unsigned char  *)0x5B1)
#define RMD5_2L1H      (*(volatile __near unsigned char  *)0x5B1)
#define RMD5_2L0H      (*(volatile __near unsigned char  *)0x5B1)
#define RMD13_2H0      (*(volatile __near unsigned short *)0x5B2)
#define RMD13_2H1      (*(volatile __near unsigned short *)0x5B2)
#define TMDF2_2H0      (*(volatile __near unsigned short *)0x5B2)
#define TMDF2_2H1      (*(volatile __near unsigned short *)0x5B2)
#define RPGACC12H0     (*(volatile __near unsigned short *)0x5B2)
#define RPGACC12H1     (*(volatile __near unsigned short *)0x5B2)
#define RMD5_2H0       (*(volatile __near unsigned short *)0x5B2)
#define RMD5_2H1       (*(volatile __near unsigned short *)0x5B2)
#define RMD13_2H0L     (*(volatile __near unsigned char  *)0x5B2)
#define TMDF2_2H0L     (*(volatile __near unsigned char  *)0x5B2)
#define TMDF2_2H1L     (*(volatile __near unsigned char  *)0x5B2)
#define RMD13_2H1L     (*(volatile __near unsigned char  *)0x5B2)
#define RPGACC12H1L    (*(volatile __near unsigned char  *)0x5B2)
#define RPGACC12H0L    (*(volatile __near unsigned char  *)0x5B2)
#define RMD5_2H0L      (*(volatile __near unsigned char  *)0x5B2)
#define RMD5_2H1L      (*(volatile __near unsigned char  *)0x5B2)
#define RMD13_2H0H     (*(volatile __near unsigned char  *)0x5B3)
#define TMDF2_2H0H     (*(volatile __near unsigned char  *)0x5B3)
#define TMDF2_2H1H     (*(volatile __near unsigned char  *)0x5B3)
#define RMD13_2H1H     (*(volatile __near unsigned char  *)0x5B3)
#define RPGACC12H1H    (*(volatile __near unsigned char  *)0x5B3)
#define RPGACC12H0H    (*(volatile __near unsigned char  *)0x5B3)
#define RMD5_2H0H      (*(volatile __near unsigned char  *)0x5B3)
#define RMD5_2H1H      (*(volatile __near unsigned char  *)0x5B3)
#define RMD13_3L1      (*(volatile __near unsigned short *)0x5B4)
#define TMDF2_3L0      (*(volatile __near unsigned short *)0x5B4)
#define TMDF2_3L1      (*(volatile __near unsigned short *)0x5B4)
#define RMD13_3L0      (*(volatile __near unsigned short *)0x5B4)
#define RPGACC13L1     (*(volatile __near unsigned short *)0x5B4)
#define RPGACC13L0     (*(volatile __near unsigned short *)0x5B4)
#define RMD5_3L0       (*(volatile __near unsigned short *)0x5B4)
#define RMD5_3L1       (*(volatile __near unsigned short *)0x5B4)
#define RMD13_3L0L     (*(volatile __near unsigned char  *)0x5B4)
#define RMD13_3L1L     (*(volatile __near unsigned char  *)0x5B4)
#define TMDF2_3L0L     (*(volatile __near unsigned char  *)0x5B4)
#define TMDF2_3L1L     (*(volatile __near unsigned char  *)0x5B4)
#define RPGACC13L1L    (*(volatile __near unsigned char  *)0x5B4)
#define RPGACC13L0L    (*(volatile __near unsigned char  *)0x5B4)
#define RMD5_3L1L      (*(volatile __near unsigned char  *)0x5B4)
#define RMD5_3L0L      (*(volatile __near unsigned char  *)0x5B4)
#define RMD13_3L0H     (*(volatile __near unsigned char  *)0x5B5)
#define TMDF2_3L0H     (*(volatile __near unsigned char  *)0x5B5)
#define TMDF2_3L1H     (*(volatile __near unsigned char  *)0x5B5)
#define RMD13_3L1H     (*(volatile __near unsigned char  *)0x5B5)
#define RPGACC13L0H    (*(volatile __near unsigned char  *)0x5B5)
#define RPGACC13L1H    (*(volatile __near unsigned char  *)0x5B5)
#define RMD5_3L1H      (*(volatile __near unsigned char  *)0x5B5)
#define RMD5_3L0H      (*(volatile __near unsigned char  *)0x5B5)
#define TMDF2_3H1      (*(volatile __near unsigned short *)0x5B6)
#define TMDF2_3H0      (*(volatile __near unsigned short *)0x5B6)
#define RMD13_3H1      (*(volatile __near unsigned short *)0x5B6)
#define RMD13_3H0      (*(volatile __near unsigned short *)0x5B6)
#define RPGACC13H1     (*(volatile __near unsigned short *)0x5B6)
#define RPGACC13H0     (*(volatile __near unsigned short *)0x5B6)
#define RMD5_3H0       (*(volatile __near unsigned short *)0x5B6)
#define RMD5_3H1       (*(volatile __near unsigned short *)0x5B6)
#define TMDF2_3H1L     (*(volatile __near unsigned char  *)0x5B6)
#define TMDF2_3H0L     (*(volatile __near unsigned char  *)0x5B6)
#define RMD13_3H0L     (*(volatile __near unsigned char  *)0x5B6)
#define RMD13_3H1L     (*(volatile __near unsigned char  *)0x5B6)
#define RPGACC13H0L    (*(volatile __near unsigned char  *)0x5B6)
#define RPGACC13H1L    (*(volatile __near unsigned char  *)0x5B6)
#define RMD5_3H0L      (*(volatile __near unsigned char  *)0x5B6)
#define RMD5_3H1L      (*(volatile __near unsigned char  *)0x5B6)
#define TMDF2_3H1H     (*(volatile __near unsigned char  *)0x5B7)
#define TMDF2_3H0H     (*(volatile __near unsigned char  *)0x5B7)
#define RMD13_3H0H     (*(volatile __near unsigned char  *)0x5B7)
#define RMD13_3H1H     (*(volatile __near unsigned char  *)0x5B7)
#define RPGACC13H1H    (*(volatile __near unsigned char  *)0x5B7)
#define RPGACC13H0H    (*(volatile __near unsigned char  *)0x5B7)
#define RMD5_3H0H      (*(volatile __near unsigned char  *)0x5B7)
#define RMD5_3H1H      (*(volatile __near unsigned char  *)0x5B7)
#define RMD13_4L0      (*(volatile __near unsigned short *)0x5B8)
#define TMDF2_4L0      (*(volatile __near unsigned short *)0x5B8)
#define RMD13_4L1      (*(volatile __near unsigned short *)0x5B8)
#define TMDF2_4L1      (*(volatile __near unsigned short *)0x5B8)
#define RPGACC14L0     (*(volatile __near unsigned short *)0x5B8)
#define RPGACC14L1     (*(volatile __near unsigned short *)0x5B8)
#define RMD5_4L1       (*(volatile __near unsigned short *)0x5B8)
#define RMD5_4L0       (*(volatile __near unsigned short *)0x5B8)
#define TMDF2_4L1L     (*(volatile __near unsigned char  *)0x5B8)
#define RMD13_4L0L     (*(volatile __near unsigned char  *)0x5B8)
#define TMDF2_4L0L     (*(volatile __near unsigned char  *)0x5B8)
#define RMD13_4L1L     (*(volatile __near unsigned char  *)0x5B8)
#define RPGACC14L1L    (*(volatile __near unsigned char  *)0x5B8)
#define RPGACC14L0L    (*(volatile __near unsigned char  *)0x5B8)
#define RMD5_4L1L      (*(volatile __near unsigned char  *)0x5B8)
#define RMD5_4L0L      (*(volatile __near unsigned char  *)0x5B8)
#define RMD13_4L0H     (*(volatile __near unsigned char  *)0x5B9)
#define RMD13_4L1H     (*(volatile __near unsigned char  *)0x5B9)
#define TMDF2_4L1H     (*(volatile __near unsigned char  *)0x5B9)
#define TMDF2_4L0H     (*(volatile __near unsigned char  *)0x5B9)
#define RPGACC14L0H    (*(volatile __near unsigned char  *)0x5B9)
#define RPGACC14L1H    (*(volatile __near unsigned char  *)0x5B9)
#define RMD5_4L0H      (*(volatile __near unsigned char  *)0x5B9)
#define RMD5_4L1H      (*(volatile __near unsigned char  *)0x5B9)
#define TMDF2_4H0      (*(volatile __near unsigned short *)0x5BA)
#define RMD13_4H1      (*(volatile __near unsigned short *)0x5BA)
#define TMDF2_4H1      (*(volatile __near unsigned short *)0x5BA)
#define RMD13_4H0      (*(volatile __near unsigned short *)0x5BA)
#define RPGACC14H1     (*(volatile __near unsigned short *)0x5BA)
#define RPGACC14H0     (*(volatile __near unsigned short *)0x5BA)
#define RMD5_4H0       (*(volatile __near unsigned short *)0x5BA)
#define RMD5_4H1       (*(volatile __near unsigned short *)0x5BA)
#define TMDF2_4H0L     (*(volatile __near unsigned char  *)0x5BA)
#define TMDF2_4H1L     (*(volatile __near unsigned char  *)0x5BA)
#define RMD13_4H1L     (*(volatile __near unsigned char  *)0x5BA)
#define RMD13_4H0L     (*(volatile __near unsigned char  *)0x5BA)
#define RPGACC14H1L    (*(volatile __near unsigned char  *)0x5BA)
#define RPGACC14H0L    (*(volatile __near unsigned char  *)0x5BA)
#define RMD5_4H0L      (*(volatile __near unsigned char  *)0x5BA)
#define RMD5_4H1L      (*(volatile __near unsigned char  *)0x5BA)
#define TMDF2_4H1H     (*(volatile __near unsigned char  *)0x5BB)
#define TMDF2_4H0H     (*(volatile __near unsigned char  *)0x5BB)
#define RMD13_4H1H     (*(volatile __near unsigned char  *)0x5BB)
#define RMD13_4H0H     (*(volatile __near unsigned char  *)0x5BB)
#define RPGACC14H1H    (*(volatile __near unsigned char  *)0x5BB)
#define RPGACC14H0H    (*(volatile __near unsigned char  *)0x5BB)
#define RMD5_4H1H      (*(volatile __near unsigned char  *)0x5BB)
#define RMD5_4H0H      (*(volatile __near unsigned char  *)0x5BB)
#define RMD13_5L0      (*(volatile __near unsigned short *)0x5BC)
#define RMD13_5L1      (*(volatile __near unsigned short *)0x5BC)
#define TMDF2_5L1      (*(volatile __near unsigned short *)0x5BC)
#define TMDF2_5L0      (*(volatile __near unsigned short *)0x5BC)
#define RPGACC15L0     (*(volatile __near unsigned short *)0x5BC)
#define RPGACC15L1     (*(volatile __near unsigned short *)0x5BC)
#define RMD5_5L1       (*(volatile __near unsigned short *)0x5BC)
#define RMD5_5L0       (*(volatile __near unsigned short *)0x5BC)
#define TMDF2_5L0L     (*(volatile __near unsigned char  *)0x5BC)
#define RMD13_5L0L     (*(volatile __near unsigned char  *)0x5BC)
#define TMDF2_5L1L     (*(volatile __near unsigned char  *)0x5BC)
#define RMD13_5L1L     (*(volatile __near unsigned char  *)0x5BC)
#define RPGACC15L1L    (*(volatile __near unsigned char  *)0x5BC)
#define RPGACC15L0L    (*(volatile __near unsigned char  *)0x5BC)
#define RMD5_5L0L      (*(volatile __near unsigned char  *)0x5BC)
#define RMD5_5L1L      (*(volatile __near unsigned char  *)0x5BC)
#define TMDF2_5L0H     (*(volatile __near unsigned char  *)0x5BD)
#define RMD13_5L0H     (*(volatile __near unsigned char  *)0x5BD)
#define RMD13_5L1H     (*(volatile __near unsigned char  *)0x5BD)
#define TMDF2_5L1H     (*(volatile __near unsigned char  *)0x5BD)
#define RPGACC15L0H    (*(volatile __near unsigned char  *)0x5BD)
#define RPGACC15L1H    (*(volatile __near unsigned char  *)0x5BD)
#define RMD5_5L1H      (*(volatile __near unsigned char  *)0x5BD)
#define RMD5_5L0H      (*(volatile __near unsigned char  *)0x5BD)
#define RMD13_5H0      (*(volatile __near unsigned short *)0x5BE)
#define RMD13_5H1      (*(volatile __near unsigned short *)0x5BE)
#define TMDF2_5H1      (*(volatile __near unsigned short *)0x5BE)
#define TMDF2_5H0      (*(volatile __near unsigned short *)0x5BE)
#define RPGACC15H0     (*(volatile __near unsigned short *)0x5BE)
#define RPGACC15H1     (*(volatile __near unsigned short *)0x5BE)
#define RMD5_5H0       (*(volatile __near unsigned short *)0x5BE)
#define RMD5_5H1       (*(volatile __near unsigned short *)0x5BE)
#define RMD13_5H0L     (*(volatile __near unsigned char  *)0x5BE)
#define RMD13_5H1L     (*(volatile __near unsigned char  *)0x5BE)
#define TMDF2_5H1L     (*(volatile __near unsigned char  *)0x5BE)
#define TMDF2_5H0L     (*(volatile __near unsigned char  *)0x5BE)
#define RPGACC15H0L    (*(volatile __near unsigned char  *)0x5BE)
#define RPGACC15H1L    (*(volatile __near unsigned char  *)0x5BE)
#define RMD5_5H0L      (*(volatile __near unsigned char  *)0x5BE)
#define RMD5_5H1L      (*(volatile __near unsigned char  *)0x5BE)
#define RMD13_5H0H     (*(volatile __near unsigned char  *)0x5BF)
#define RMD13_5H1H     (*(volatile __near unsigned char  *)0x5BF)
#define TMDF2_5H1H     (*(volatile __near unsigned char  *)0x5BF)
#define TMDF2_5H0H     (*(volatile __near unsigned char  *)0x5BF)
#define RPGACC15H0H    (*(volatile __near unsigned char  *)0x5BF)
#define RPGACC15H1H    (*(volatile __near unsigned char  *)0x5BF)
#define RMD5_5H1H      (*(volatile __near unsigned char  *)0x5BF)
#define RMD5_5H0H      (*(volatile __near unsigned char  *)0x5BF)
#define TMDF2_6L0      (*(volatile __near unsigned short *)0x5C0)
#define TMDF2_6L1      (*(volatile __near unsigned short *)0x5C0)
#define RMD13_6L1      (*(volatile __near unsigned short *)0x5C0)
#define RMD13_6L0      (*(volatile __near unsigned short *)0x5C0)
#define RPGACC16L0     (*(volatile __near unsigned short *)0x5C0)
#define RPGACC16L1     (*(volatile __near unsigned short *)0x5C0)
#define RMD5_6L0       (*(volatile __near unsigned short *)0x5C0)
#define RMD5_6L1       (*(volatile __near unsigned short *)0x5C0)
#define RMD13_6L0L     (*(volatile __near unsigned char  *)0x5C0)
#define TMDF2_6L1L     (*(volatile __near unsigned char  *)0x5C0)
#define TMDF2_6L0L     (*(volatile __near unsigned char  *)0x5C0)
#define RMD13_6L1L     (*(volatile __near unsigned char  *)0x5C0)
#define RPGACC16L0L    (*(volatile __near unsigned char  *)0x5C0)
#define RPGACC16L1L    (*(volatile __near unsigned char  *)0x5C0)
#define RMD5_6L1L      (*(volatile __near unsigned char  *)0x5C0)
#define RMD5_6L0L      (*(volatile __near unsigned char  *)0x5C0)
#define RMD13_6L0H     (*(volatile __near unsigned char  *)0x5C1)
#define TMDF2_6L1H     (*(volatile __near unsigned char  *)0x5C1)
#define TMDF2_6L0H     (*(volatile __near unsigned char  *)0x5C1)
#define RMD13_6L1H     (*(volatile __near unsigned char  *)0x5C1)
#define RPGACC16L0H    (*(volatile __near unsigned char  *)0x5C1)
#define RPGACC16L1H    (*(volatile __near unsigned char  *)0x5C1)
#define RMD5_6L1H      (*(volatile __near unsigned char  *)0x5C1)
#define RMD5_6L0H      (*(volatile __near unsigned char  *)0x5C1)
#define RMD13_6H1      (*(volatile __near unsigned short *)0x5C2)
#define RMD13_6H0      (*(volatile __near unsigned short *)0x5C2)
#define TMDF2_6H1      (*(volatile __near unsigned short *)0x5C2)
#define TMDF2_6H0      (*(volatile __near unsigned short *)0x5C2)
#define RPGACC16H1     (*(volatile __near unsigned short *)0x5C2)
#define RPGACC16H0     (*(volatile __near unsigned short *)0x5C2)
#define RMD5_6H0       (*(volatile __near unsigned short *)0x5C2)
#define RMD5_6H1       (*(volatile __near unsigned short *)0x5C2)
#define RMD13_6H1L     (*(volatile __near unsigned char  *)0x5C2)
#define RMD13_6H0L     (*(volatile __near unsigned char  *)0x5C2)
#define TMDF2_6H1L     (*(volatile __near unsigned char  *)0x5C2)
#define TMDF2_6H0L     (*(volatile __near unsigned char  *)0x5C2)
#define RPGACC16H1L    (*(volatile __near unsigned char  *)0x5C2)
#define RPGACC16H0L    (*(volatile __near unsigned char  *)0x5C2)
#define RMD5_6H0L      (*(volatile __near unsigned char  *)0x5C2)
#define RMD5_6H1L      (*(volatile __near unsigned char  *)0x5C2)
#define RMD13_6H1H     (*(volatile __near unsigned char  *)0x5C3)
#define RMD13_6H0H     (*(volatile __near unsigned char  *)0x5C3)
#define TMDF2_6H1H     (*(volatile __near unsigned char  *)0x5C3)
#define TMDF2_6H0H     (*(volatile __near unsigned char  *)0x5C3)
#define RPGACC16H1H    (*(volatile __near unsigned char  *)0x5C3)
#define RPGACC16H0H    (*(volatile __near unsigned char  *)0x5C3)
#define RMD5_6H0H      (*(volatile __near unsigned char  *)0x5C3)
#define RMD5_6H1H      (*(volatile __near unsigned char  *)0x5C3)
#define TMDF2_7L1      (*(volatile __near unsigned short *)0x5C4)
#define TMDF2_7L0      (*(volatile __near unsigned short *)0x5C4)
#define RMD13_7L1      (*(volatile __near unsigned short *)0x5C4)
#define RMD13_7L0      (*(volatile __near unsigned short *)0x5C4)
#define RPGACC17L0     (*(volatile __near unsigned short *)0x5C4)
#define RPGACC17L1     (*(volatile __near unsigned short *)0x5C4)
#define RMD5_7L0       (*(volatile __near unsigned short *)0x5C4)
#define RMD5_7L1       (*(volatile __near unsigned short *)0x5C4)
#define TMDF2_7L0L     (*(volatile __near unsigned char  *)0x5C4)
#define TMDF2_7L1L     (*(volatile __near unsigned char  *)0x5C4)
#define RMD13_7L0L     (*(volatile __near unsigned char  *)0x5C4)
#define RMD13_7L1L     (*(volatile __near unsigned char  *)0x5C4)
#define RPGACC17L1L    (*(volatile __near unsigned char  *)0x5C4)
#define RMD5_7L0L      (*(volatile __near unsigned char  *)0x5C4)
#define RMD5_7L1L      (*(volatile __near unsigned char  *)0x5C4)
#define RPGACC17L0L    (*(volatile __near unsigned char  *)0x5C4)
#define TMDF2_7L0H     (*(volatile __near unsigned char  *)0x5C5)
#define RMD13_7L0H     (*(volatile __near unsigned char  *)0x5C5)
#define RMD13_7L1H     (*(volatile __near unsigned char  *)0x5C5)
#define TMDF2_7L1H     (*(volatile __near unsigned char  *)0x5C5)
#define RPGACC17L1H    (*(volatile __near unsigned char  *)0x5C5)
#define RPGACC17L0H    (*(volatile __near unsigned char  *)0x5C5)
#define RMD5_7L0H      (*(volatile __near unsigned char  *)0x5C5)
#define RMD5_7L1H      (*(volatile __near unsigned char  *)0x5C5)
#define TMDF2_7H1      (*(volatile __near unsigned short *)0x5C6)
#define RMD13_7H1      (*(volatile __near unsigned short *)0x5C6)
#define RMD13_7H0      (*(volatile __near unsigned short *)0x5C6)
#define TMDF2_7H0      (*(volatile __near unsigned short *)0x5C6)
#define RPGACC17H1     (*(volatile __near unsigned short *)0x5C6)
#define RMD5_7H1       (*(volatile __near unsigned short *)0x5C6)
#define RPGACC17H0     (*(volatile __near unsigned short *)0x5C6)
#define RMD5_7H0       (*(volatile __near unsigned short *)0x5C6)
#define TMDF2_7H0L     (*(volatile __near unsigned char  *)0x5C6)
#define TMDF2_7H1L     (*(volatile __near unsigned char  *)0x5C6)
#define RMD13_7H1L     (*(volatile __near unsigned char  *)0x5C6)
#define RMD13_7H0L     (*(volatile __near unsigned char  *)0x5C6)
#define RPGACC17H1L    (*(volatile __near unsigned char  *)0x5C6)
#define RPGACC17H0L    (*(volatile __near unsigned char  *)0x5C6)
#define RMD5_7H0L      (*(volatile __near unsigned char  *)0x5C6)
#define RMD5_7H1L      (*(volatile __near unsigned char  *)0x5C6)
#define TMDF2_7H0H     (*(volatile __near unsigned char  *)0x5C7)
#define TMDF2_7H1H     (*(volatile __near unsigned char  *)0x5C7)
#define RMD13_7H1H     (*(volatile __near unsigned char  *)0x5C7)
#define RMD13_7H0H     (*(volatile __near unsigned char  *)0x5C7)
#define RPGACC17H0H    (*(volatile __near unsigned char  *)0x5C7)
#define RMD5_7H1H      (*(volatile __near unsigned char  *)0x5C7)
#define RPGACC17H1H    (*(volatile __near unsigned char  *)0x5C7)
#define RMD5_7H0H      (*(volatile __near unsigned char  *)0x5C7)
#define RMD13_8L0      (*(volatile __near unsigned short *)0x5C8)
#define RMD13_8L1      (*(volatile __near unsigned short *)0x5C8)
#define TMDF2_8L1      (*(volatile __near unsigned short *)0x5C8)
#define TMDF2_8L0      (*(volatile __near unsigned short *)0x5C8)
#define RPGACC18L1     (*(volatile __near unsigned short *)0x5C8)
#define RMD5_8L0       (*(volatile __near unsigned short *)0x5C8)
#define RMD5_8L1       (*(volatile __near unsigned short *)0x5C8)
#define RPGACC18L0     (*(volatile __near unsigned short *)0x5C8)
#define RMD13_8L1L     (*(volatile __near unsigned char  *)0x5C8)
#define TMDF2_8L1L     (*(volatile __near unsigned char  *)0x5C8)
#define TMDF2_8L0L     (*(volatile __near unsigned char  *)0x5C8)
#define RMD13_8L0L     (*(volatile __near unsigned char  *)0x5C8)
#define RMD5_8L0L      (*(volatile __near unsigned char  *)0x5C8)
#define RPGACC18L1L    (*(volatile __near unsigned char  *)0x5C8)
#define RMD5_8L1L      (*(volatile __near unsigned char  *)0x5C8)
#define RPGACC18L0L    (*(volatile __near unsigned char  *)0x5C8)
#define TMDF2_8L0H     (*(volatile __near unsigned char  *)0x5C9)
#define RMD13_8L0H     (*(volatile __near unsigned char  *)0x5C9)
#define TMDF2_8L1H     (*(volatile __near unsigned char  *)0x5C9)
#define RMD13_8L1H     (*(volatile __near unsigned char  *)0x5C9)
#define RMD5_8L0H      (*(volatile __near unsigned char  *)0x5C9)
#define RMD5_8L1H      (*(volatile __near unsigned char  *)0x5C9)
#define RPGACC18L0H    (*(volatile __near unsigned char  *)0x5C9)
#define RPGACC18L1H    (*(volatile __near unsigned char  *)0x5C9)
#define TMDF2_8H0      (*(volatile __near unsigned short *)0x5CA)
#define TMDF2_8H1      (*(volatile __near unsigned short *)0x5CA)
#define RMD13_8H0      (*(volatile __near unsigned short *)0x5CA)
#define RMD13_8H1      (*(volatile __near unsigned short *)0x5CA)
#define RMD5_8H1       (*(volatile __near unsigned short *)0x5CA)
#define RMD5_8H0       (*(volatile __near unsigned short *)0x5CA)
#define RPGACC18H1     (*(volatile __near unsigned short *)0x5CA)
#define RPGACC18H0     (*(volatile __near unsigned short *)0x5CA)
#define TMDF2_8H0L     (*(volatile __near unsigned char  *)0x5CA)
#define RMD13_8H0L     (*(volatile __near unsigned char  *)0x5CA)
#define RMD13_8H1L     (*(volatile __near unsigned char  *)0x5CA)
#define TMDF2_8H1L     (*(volatile __near unsigned char  *)0x5CA)
#define RMD5_8H1L      (*(volatile __near unsigned char  *)0x5CA)
#define RMD5_8H0L      (*(volatile __near unsigned char  *)0x5CA)
#define RPGACC18H0L    (*(volatile __near unsigned char  *)0x5CA)
#define RPGACC18H1L    (*(volatile __near unsigned char  *)0x5CA)
#define TMDF2_8H0H     (*(volatile __near unsigned char  *)0x5CB)
#define TMDF2_8H1H     (*(volatile __near unsigned char  *)0x5CB)
#define RMD13_8H0H     (*(volatile __near unsigned char  *)0x5CB)
#define RMD13_8H1H     (*(volatile __near unsigned char  *)0x5CB)
#define RMD5_8H1H      (*(volatile __near unsigned char  *)0x5CB)
#define RMD5_8H0H      (*(volatile __near unsigned char  *)0x5CB)
#define RPGACC18H0H    (*(volatile __near unsigned char  *)0x5CB)
#define RPGACC18H1H    (*(volatile __near unsigned char  *)0x5CB)
#define RMD13_9L1      (*(volatile __near unsigned short *)0x5CC)
#define RMD13_9L0      (*(volatile __near unsigned short *)0x5CC)
#define TMDF2_9L1      (*(volatile __near unsigned short *)0x5CC)
#define TMDF2_9L0      (*(volatile __near unsigned short *)0x5CC)
#define RMD5_9L1       (*(volatile __near unsigned short *)0x5CC)
#define RMD5_9L0       (*(volatile __near unsigned short *)0x5CC)
#define RPGACC19L1     (*(volatile __near unsigned short *)0x5CC)
#define RPGACC19L0     (*(volatile __near unsigned short *)0x5CC)
#define RMD13_9L0L     (*(volatile __near unsigned char  *)0x5CC)
#define RMD13_9L1L     (*(volatile __near unsigned char  *)0x5CC)
#define TMDF2_9L1L     (*(volatile __near unsigned char  *)0x5CC)
#define TMDF2_9L0L     (*(volatile __near unsigned char  *)0x5CC)
#define RMD5_9L1L      (*(volatile __near unsigned char  *)0x5CC)
#define RMD5_9L0L      (*(volatile __near unsigned char  *)0x5CC)
#define RPGACC19L0L    (*(volatile __near unsigned char  *)0x5CC)
#define RPGACC19L1L    (*(volatile __near unsigned char  *)0x5CC)
#define RMD13_9L0H     (*(volatile __near unsigned char  *)0x5CD)
#define RMD13_9L1H     (*(volatile __near unsigned char  *)0x5CD)
#define TMDF2_9L1H     (*(volatile __near unsigned char  *)0x5CD)
#define TMDF2_9L0H     (*(volatile __near unsigned char  *)0x5CD)
#define RMD5_9L0H      (*(volatile __near unsigned char  *)0x5CD)
#define RMD5_9L1H      (*(volatile __near unsigned char  *)0x5CD)
#define RPGACC19L0H    (*(volatile __near unsigned char  *)0x5CD)
#define RPGACC19L1H    (*(volatile __near unsigned char  *)0x5CD)
#define RMD13_9H0      (*(volatile __near unsigned short *)0x5CE)
#define RMD13_9H1      (*(volatile __near unsigned short *)0x5CE)
#define TMDF2_9H0      (*(volatile __near unsigned short *)0x5CE)
#define TMDF2_9H1      (*(volatile __near unsigned short *)0x5CE)
#define RMD5_9H0       (*(volatile __near unsigned short *)0x5CE)
#define RMD5_9H1       (*(volatile __near unsigned short *)0x5CE)
#define RPGACC19H1     (*(volatile __near unsigned short *)0x5CE)
#define RPGACC19H0     (*(volatile __near unsigned short *)0x5CE)
#define RMD13_9H0L     (*(volatile __near unsigned char  *)0x5CE)
#define RMD13_9H1L     (*(volatile __near unsigned char  *)0x5CE)
#define TMDF2_9H1L     (*(volatile __near unsigned char  *)0x5CE)
#define TMDF2_9H0L     (*(volatile __near unsigned char  *)0x5CE)
#define RMD5_9H0L      (*(volatile __near unsigned char  *)0x5CE)
#define RMD5_9H1L      (*(volatile __near unsigned char  *)0x5CE)
#define RPGACC19H0L    (*(volatile __near unsigned char  *)0x5CE)
#define RPGACC19H1L    (*(volatile __near unsigned char  *)0x5CE)
#define RMD13_9H1H     (*(volatile __near unsigned char  *)0x5CF)
#define RMD13_9H0H     (*(volatile __near unsigned char  *)0x5CF)
#define TMDF2_9H1H     (*(volatile __near unsigned char  *)0x5CF)
#define TMDF2_9H0H     (*(volatile __near unsigned char  *)0x5CF)
#define RMD5_9H0H      (*(volatile __near unsigned char  *)0x5CF)
#define RMD5_9H1H      (*(volatile __near unsigned char  *)0x5CF)
#define RPGACC19H1H    (*(volatile __near unsigned char  *)0x5CF)
#define RPGACC19H0H    (*(volatile __near unsigned char  *)0x5CF)
#define RMD13_10L0     (*(volatile __near unsigned short *)0x5D0)
#define RMD13_10L1     (*(volatile __near unsigned short *)0x5D0)
#define TMDF2_10L0     (*(volatile __near unsigned short *)0x5D0)
#define TMDF2_10L1     (*(volatile __near unsigned short *)0x5D0)
#define RPGACC20L0     (*(volatile __near unsigned short *)0x5D0)
#define RPGACC20L1     (*(volatile __near unsigned short *)0x5D0)
#define RMD5_10L1      (*(volatile __near unsigned short *)0x5D0)
#define RMD5_10L0      (*(volatile __near unsigned short *)0x5D0)
#define RMD13_10L1L    (*(volatile __near unsigned char  *)0x5D0)
#define RMD13_10L0L    (*(volatile __near unsigned char  *)0x5D0)
#define TMDF2_10L0L    (*(volatile __near unsigned char  *)0x5D0)
#define TMDF2_10L1L    (*(volatile __near unsigned char  *)0x5D0)
#define RPGACC20L0L    (*(volatile __near unsigned char  *)0x5D0)
#define RPGACC20L1L    (*(volatile __near unsigned char  *)0x5D0)
#define RMD5_10L0L     (*(volatile __near unsigned char  *)0x5D0)
#define RMD5_10L1L     (*(volatile __near unsigned char  *)0x5D0)
#define RMD13_10L1H    (*(volatile __near unsigned char  *)0x5D1)
#define RMD13_10L0H    (*(volatile __near unsigned char  *)0x5D1)
#define TMDF2_10L0H    (*(volatile __near unsigned char  *)0x5D1)
#define TMDF2_10L1H    (*(volatile __near unsigned char  *)0x5D1)
#define RPGACC20L0H    (*(volatile __near unsigned char  *)0x5D1)
#define RPGACC20L1H    (*(volatile __near unsigned char  *)0x5D1)
#define RMD5_10L0H     (*(volatile __near unsigned char  *)0x5D1)
#define RMD5_10L1H     (*(volatile __near unsigned char  *)0x5D1)
#define RMD13_10H1     (*(volatile __near unsigned short *)0x5D2)
#define RMD13_10H0     (*(volatile __near unsigned short *)0x5D2)
#define TMDF2_10H1     (*(volatile __near unsigned short *)0x5D2)
#define TMDF2_10H0     (*(volatile __near unsigned short *)0x5D2)
#define RPGACC20H0     (*(volatile __near unsigned short *)0x5D2)
#define RPGACC20H1     (*(volatile __near unsigned short *)0x5D2)
#define RMD5_10H1      (*(volatile __near unsigned short *)0x5D2)
#define RMD5_10H0      (*(volatile __near unsigned short *)0x5D2)
#define RMD13_10H1L    (*(volatile __near unsigned char  *)0x5D2)
#define RMD13_10H0L    (*(volatile __near unsigned char  *)0x5D2)
#define TMDF2_10H1L    (*(volatile __near unsigned char  *)0x5D2)
#define TMDF2_10H0L    (*(volatile __near unsigned char  *)0x5D2)
#define RPGACC20H0L    (*(volatile __near unsigned char  *)0x5D2)
#define RPGACC20H1L    (*(volatile __near unsigned char  *)0x5D2)
#define RMD5_10H1L     (*(volatile __near unsigned char  *)0x5D2)
#define RMD5_10H0L     (*(volatile __near unsigned char  *)0x5D2)
#define RMD13_10H1H    (*(volatile __near unsigned char  *)0x5D3)
#define RMD13_10H0H    (*(volatile __near unsigned char  *)0x5D3)
#define TMDF2_10H0H    (*(volatile __near unsigned char  *)0x5D3)
#define TMDF2_10H1H    (*(volatile __near unsigned char  *)0x5D3)
#define RPGACC20H0H    (*(volatile __near unsigned char  *)0x5D3)
#define RPGACC20H1H    (*(volatile __near unsigned char  *)0x5D3)
#define RMD5_10H1H     (*(volatile __near unsigned char  *)0x5D3)
#define RMD5_10H0H     (*(volatile __near unsigned char  *)0x5D3)
#define RMD13_11L1     (*(volatile __near unsigned short *)0x5D4)
#define RMD13_11L0     (*(volatile __near unsigned short *)0x5D4)
#define TMDF2_11L1     (*(volatile __near unsigned short *)0x5D4)
#define TMDF2_11L0     (*(volatile __near unsigned short *)0x5D4)
#define RPGACC21L0     (*(volatile __near unsigned short *)0x5D4)
#define RPGACC21L1     (*(volatile __near unsigned short *)0x5D4)
#define RMD5_11L1      (*(volatile __near unsigned short *)0x5D4)
#define RMD5_11L0      (*(volatile __near unsigned short *)0x5D4)
#define RMD13_11L0L    (*(volatile __near unsigned char  *)0x5D4)
#define RMD13_11L1L    (*(volatile __near unsigned char  *)0x5D4)
#define TMDF2_11L1L    (*(volatile __near unsigned char  *)0x5D4)
#define TMDF2_11L0L    (*(volatile __near unsigned char  *)0x5D4)
#define RPGACC21L0L    (*(volatile __near unsigned char  *)0x5D4)
#define RPGACC21L1L    (*(volatile __near unsigned char  *)0x5D4)
#define RMD5_11L1L     (*(volatile __near unsigned char  *)0x5D4)
#define RMD5_11L0L     (*(volatile __near unsigned char  *)0x5D4)
#define RMD13_11L1H    (*(volatile __near unsigned char  *)0x5D5)
#define RMD13_11L0H    (*(volatile __near unsigned char  *)0x5D5)
#define TMDF2_11L1H    (*(volatile __near unsigned char  *)0x5D5)
#define TMDF2_11L0H    (*(volatile __near unsigned char  *)0x5D5)
#define RPGACC21L1H    (*(volatile __near unsigned char  *)0x5D5)
#define RPGACC21L0H    (*(volatile __near unsigned char  *)0x5D5)
#define RMD5_11L0H     (*(volatile __near unsigned char  *)0x5D5)
#define RMD5_11L1H     (*(volatile __near unsigned char  *)0x5D5)
#define RMD13_11H0     (*(volatile __near unsigned short *)0x5D6)
#define RMD13_11H1     (*(volatile __near unsigned short *)0x5D6)
#define TMDF2_11H1     (*(volatile __near unsigned short *)0x5D6)
#define TMDF2_11H0     (*(volatile __near unsigned short *)0x5D6)
#define RPGACC21H0     (*(volatile __near unsigned short *)0x5D6)
#define RPGACC21H1     (*(volatile __near unsigned short *)0x5D6)
#define RMD5_11H1      (*(volatile __near unsigned short *)0x5D6)
#define RMD5_11H0      (*(volatile __near unsigned short *)0x5D6)
#define RMD13_11H1L    (*(volatile __near unsigned char  *)0x5D6)
#define RMD13_11H0L    (*(volatile __near unsigned char  *)0x5D6)
#define TMDF2_11H1L    (*(volatile __near unsigned char  *)0x5D6)
#define TMDF2_11H0L    (*(volatile __near unsigned char  *)0x5D6)
#define RPGACC21H0L    (*(volatile __near unsigned char  *)0x5D6)
#define RPGACC21H1L    (*(volatile __near unsigned char  *)0x5D6)
#define RMD5_11H1L     (*(volatile __near unsigned char  *)0x5D6)
#define RMD5_11H0L     (*(volatile __near unsigned char  *)0x5D6)
#define RMD13_11H1H    (*(volatile __near unsigned char  *)0x5D7)
#define RMD13_11H0H    (*(volatile __near unsigned char  *)0x5D7)
#define TMDF2_11H1H    (*(volatile __near unsigned char  *)0x5D7)
#define TMDF2_11H0H    (*(volatile __near unsigned char  *)0x5D7)
#define RPGACC21H0H    (*(volatile __near unsigned char  *)0x5D7)
#define RPGACC21H1H    (*(volatile __near unsigned char  *)0x5D7)
#define RMD5_11H1H     (*(volatile __near unsigned char  *)0x5D7)
#define RMD5_11H0H     (*(volatile __near unsigned char  *)0x5D7)
#define TMDF2_12L1     (*(volatile __near unsigned short *)0x5D8)
#define TMDF2_12L0     (*(volatile __near unsigned short *)0x5D8)
#define RMD13_12L1     (*(volatile __near unsigned short *)0x5D8)
#define RMD13_12L0     (*(volatile __near unsigned short *)0x5D8)
#define RPGACC22L1     (*(volatile __near unsigned short *)0x5D8)
#define RPGACC22L0     (*(volatile __near unsigned short *)0x5D8)
#define RMD5_12L0      (*(volatile __near unsigned short *)0x5D8)
#define RMD5_12L1      (*(volatile __near unsigned short *)0x5D8)
#define TMDF2_12L1L    (*(volatile __near unsigned char  *)0x5D8)
#define TMDF2_12L0L    (*(volatile __near unsigned char  *)0x5D8)
#define RMD13_12L1L    (*(volatile __near unsigned char  *)0x5D8)
#define RMD13_12L0L    (*(volatile __near unsigned char  *)0x5D8)
#define RPGACC22L1L    (*(volatile __near unsigned char  *)0x5D8)
#define RPGACC22L0L    (*(volatile __near unsigned char  *)0x5D8)
#define RMD5_12L0L     (*(volatile __near unsigned char  *)0x5D8)
#define RMD5_12L1L     (*(volatile __near unsigned char  *)0x5D8)
#define TMDF2_12L1H    (*(volatile __near unsigned char  *)0x5D9)
#define TMDF2_12L0H    (*(volatile __near unsigned char  *)0x5D9)
#define RMD13_12L1H    (*(volatile __near unsigned char  *)0x5D9)
#define RMD13_12L0H    (*(volatile __near unsigned char  *)0x5D9)
#define RPGACC22L0H    (*(volatile __near unsigned char  *)0x5D9)
#define RPGACC22L1H    (*(volatile __near unsigned char  *)0x5D9)
#define RMD5_12L1H     (*(volatile __near unsigned char  *)0x5D9)
#define RMD5_12L0H     (*(volatile __near unsigned char  *)0x5D9)
#define RMD13_12H0     (*(volatile __near unsigned short *)0x5DA)
#define RMD13_12H1     (*(volatile __near unsigned short *)0x5DA)
#define TMDF2_12H1     (*(volatile __near unsigned short *)0x5DA)
#define TMDF2_12H0     (*(volatile __near unsigned short *)0x5DA)
#define RPGACC22H1     (*(volatile __near unsigned short *)0x5DA)
#define RPGACC22H0     (*(volatile __near unsigned short *)0x5DA)
#define RMD5_12H0      (*(volatile __near unsigned short *)0x5DA)
#define RMD5_12H1      (*(volatile __near unsigned short *)0x5DA)
#define RMD13_12H1L    (*(volatile __near unsigned char  *)0x5DA)
#define TMDF2_12H1L    (*(volatile __near unsigned char  *)0x5DA)
#define TMDF2_12H0L    (*(volatile __near unsigned char  *)0x5DA)
#define RMD13_12H0L    (*(volatile __near unsigned char  *)0x5DA)
#define RPGACC22H1L    (*(volatile __near unsigned char  *)0x5DA)
#define RPGACC22H0L    (*(volatile __near unsigned char  *)0x5DA)
#define RMD5_12H1L     (*(volatile __near unsigned char  *)0x5DA)
#define RMD5_12H0L     (*(volatile __near unsigned char  *)0x5DA)
#define RMD13_12H1H    (*(volatile __near unsigned char  *)0x5DB)
#define TMDF2_12H1H    (*(volatile __near unsigned char  *)0x5DB)
#define TMDF2_12H0H    (*(volatile __near unsigned char  *)0x5DB)
#define RMD13_12H0H    (*(volatile __near unsigned char  *)0x5DB)
#define RPGACC22H1H    (*(volatile __near unsigned char  *)0x5DB)
#define RPGACC22H0H    (*(volatile __near unsigned char  *)0x5DB)
#define RMD5_12H0H     (*(volatile __near unsigned char  *)0x5DB)
#define RMD5_12H1H     (*(volatile __near unsigned char  *)0x5DB)
#define RMD13_13L1     (*(volatile __near unsigned short *)0x5DC)
#define TMDF2_13L0     (*(volatile __near unsigned short *)0x5DC)
#define TMDF2_13L1     (*(volatile __near unsigned short *)0x5DC)
#define RMD13_13L0     (*(volatile __near unsigned short *)0x5DC)
#define RPGACC23L1     (*(volatile __near unsigned short *)0x5DC)
#define RPGACC23L0     (*(volatile __near unsigned short *)0x5DC)
#define RMD5_13L1      (*(volatile __near unsigned short *)0x5DC)
#define RMD5_13L0      (*(volatile __near unsigned short *)0x5DC)
#define TMDF2_13L1L    (*(volatile __near unsigned char  *)0x5DC)
#define TMDF2_13L0L    (*(volatile __near unsigned char  *)0x5DC)
#define RMD13_13L1L    (*(volatile __near unsigned char  *)0x5DC)
#define RMD13_13L0L    (*(volatile __near unsigned char  *)0x5DC)
#define RPGACC23L1L    (*(volatile __near unsigned char  *)0x5DC)
#define RPGACC23L0L    (*(volatile __near unsigned char  *)0x5DC)
#define RMD5_13L1L     (*(volatile __near unsigned char  *)0x5DC)
#define RMD5_13L0L     (*(volatile __near unsigned char  *)0x5DC)
#define TMDF2_13L1H    (*(volatile __near unsigned char  *)0x5DD)
#define TMDF2_13L0H    (*(volatile __near unsigned char  *)0x5DD)
#define RMD13_13L0H    (*(volatile __near unsigned char  *)0x5DD)
#define RMD13_13L1H    (*(volatile __near unsigned char  *)0x5DD)
#define RPGACC23L1H    (*(volatile __near unsigned char  *)0x5DD)
#define RPGACC23L0H    (*(volatile __near unsigned char  *)0x5DD)
#define RMD5_13L1H     (*(volatile __near unsigned char  *)0x5DD)
#define RMD5_13L0H     (*(volatile __near unsigned char  *)0x5DD)
#define TMDF2_13H1     (*(volatile __near unsigned short *)0x5DE)
#define TMDF2_13H0     (*(volatile __near unsigned short *)0x5DE)
#define RMD13_13H1     (*(volatile __near unsigned short *)0x5DE)
#define RMD13_13H0     (*(volatile __near unsigned short *)0x5DE)
#define RPGACC23H1     (*(volatile __near unsigned short *)0x5DE)
#define RPGACC23H0     (*(volatile __near unsigned short *)0x5DE)
#define RMD5_13H1      (*(volatile __near unsigned short *)0x5DE)
#define RMD5_13H0      (*(volatile __near unsigned short *)0x5DE)
#define RMD13_13H1L    (*(volatile __near unsigned char  *)0x5DE)
#define TMDF2_13H1L    (*(volatile __near unsigned char  *)0x5DE)
#define RMD13_13H0L    (*(volatile __near unsigned char  *)0x5DE)
#define TMDF2_13H0L    (*(volatile __near unsigned char  *)0x5DE)
#define RPGACC23H0L    (*(volatile __near unsigned char  *)0x5DE)
#define RPGACC23H1L    (*(volatile __near unsigned char  *)0x5DE)
#define RMD5_13H1L     (*(volatile __near unsigned char  *)0x5DE)
#define RMD5_13H0L     (*(volatile __near unsigned char  *)0x5DE)
#define TMDF2_13H1H    (*(volatile __near unsigned char  *)0x5DF)
#define TMDF2_13H0H    (*(volatile __near unsigned char  *)0x5DF)
#define RMD13_13H0H    (*(volatile __near unsigned char  *)0x5DF)
#define RMD13_13H1H    (*(volatile __near unsigned char  *)0x5DF)
#define RPGACC23H1H    (*(volatile __near unsigned char  *)0x5DF)
#define RPGACC23H0H    (*(volatile __near unsigned char  *)0x5DF)
#define RMD5_13H1H     (*(volatile __near unsigned char  *)0x5DF)
#define RMD5_13H0H     (*(volatile __near unsigned char  *)0x5DF)
#define RMD13_14L0     (*(volatile __near unsigned short *)0x5E0)
#define RMD13_14L1     (*(volatile __near unsigned short *)0x5E0)
#define TMDF2_14L0     (*(volatile __near unsigned short *)0x5E0)
#define TMDF2_14L1     (*(volatile __near unsigned short *)0x5E0)
#define RPGACC24L1     (*(volatile __near unsigned short *)0x5E0)
#define RPGACC24L0     (*(volatile __near unsigned short *)0x5E0)
#define RMD5_14L1      (*(volatile __near unsigned short *)0x5E0)
#define RMD5_14L0      (*(volatile __near unsigned short *)0x5E0)
#define TMDF2_14L1L    (*(volatile __near unsigned char  *)0x5E0)
#define RMD13_14L0L    (*(volatile __near unsigned char  *)0x5E0)
#define TMDF2_14L0L    (*(volatile __near unsigned char  *)0x5E0)
#define RMD13_14L1L    (*(volatile __near unsigned char  *)0x5E0)
#define RPGACC24L1L    (*(volatile __near unsigned char  *)0x5E0)
#define RPGACC24L0L    (*(volatile __near unsigned char  *)0x5E0)
#define RMD5_14L1L     (*(volatile __near unsigned char  *)0x5E0)
#define RMD5_14L0L     (*(volatile __near unsigned char  *)0x5E0)
#define TMDF2_14L1H    (*(volatile __near unsigned char  *)0x5E1)
#define TMDF2_14L0H    (*(volatile __near unsigned char  *)0x5E1)
#define RMD13_14L0H    (*(volatile __near unsigned char  *)0x5E1)
#define RMD13_14L1H    (*(volatile __near unsigned char  *)0x5E1)
#define RPGACC24L1H    (*(volatile __near unsigned char  *)0x5E1)
#define RPGACC24L0H    (*(volatile __near unsigned char  *)0x5E1)
#define RMD5_14L1H     (*(volatile __near unsigned char  *)0x5E1)
#define RMD5_14L0H     (*(volatile __near unsigned char  *)0x5E1)
#define TMDF2_14H0     (*(volatile __near unsigned short *)0x5E2)
#define RMD13_14H1     (*(volatile __near unsigned short *)0x5E2)
#define RMD13_14H0     (*(volatile __near unsigned short *)0x5E2)
#define TMDF2_14H1     (*(volatile __near unsigned short *)0x5E2)
#define RPGACC24H1     (*(volatile __near unsigned short *)0x5E2)
#define RPGACC24H0     (*(volatile __near unsigned short *)0x5E2)
#define RMD5_14H1      (*(volatile __near unsigned short *)0x5E2)
#define RMD5_14H0      (*(volatile __near unsigned short *)0x5E2)
#define RMD13_14H0L    (*(volatile __near unsigned char  *)0x5E2)
#define TMDF2_14H0L    (*(volatile __near unsigned char  *)0x5E2)
#define TMDF2_14H1L    (*(volatile __near unsigned char  *)0x5E2)
#define RMD13_14H1L    (*(volatile __near unsigned char  *)0x5E2)
#define RPGACC24H0L    (*(volatile __near unsigned char  *)0x5E2)
#define RPGACC24H1L    (*(volatile __near unsigned char  *)0x5E2)
#define RMD5_14H1L     (*(volatile __near unsigned char  *)0x5E2)
#define RMD5_14H0L     (*(volatile __near unsigned char  *)0x5E2)
#define RMD13_14H1H    (*(volatile __near unsigned char  *)0x5E3)
#define RMD13_14H0H    (*(volatile __near unsigned char  *)0x5E3)
#define TMDF2_14H0H    (*(volatile __near unsigned char  *)0x5E3)
#define TMDF2_14H1H    (*(volatile __near unsigned char  *)0x5E3)
#define RPGACC24H1H    (*(volatile __near unsigned char  *)0x5E3)
#define RPGACC24H0H    (*(volatile __near unsigned char  *)0x5E3)
#define RMD5_14H1H     (*(volatile __near unsigned char  *)0x5E3)
#define RMD5_14H0H     (*(volatile __near unsigned char  *)0x5E3)
#define TMDF2_15L0     (*(volatile __near unsigned short *)0x5E4)
#define TMDF2_15L1     (*(volatile __near unsigned short *)0x5E4)
#define RMD13_15L1     (*(volatile __near unsigned short *)0x5E4)
#define RMD13_15L0     (*(volatile __near unsigned short *)0x5E4)
#define RPGACC25L0     (*(volatile __near unsigned short *)0x5E4)
#define RPGACC25L1     (*(volatile __near unsigned short *)0x5E4)
#define RMD5_15L0      (*(volatile __near unsigned short *)0x5E4)
#define RMD5_15L1      (*(volatile __near unsigned short *)0x5E4)
#define TMDF2_15L1L    (*(volatile __near unsigned char  *)0x5E4)
#define RMD13_15L1L    (*(volatile __near unsigned char  *)0x5E4)
#define TMDF2_15L0L    (*(volatile __near unsigned char  *)0x5E4)
#define RMD13_15L0L    (*(volatile __near unsigned char  *)0x5E4)
#define RPGACC25L1L    (*(volatile __near unsigned char  *)0x5E4)
#define RPGACC25L0L    (*(volatile __near unsigned char  *)0x5E4)
#define RMD5_15L0L     (*(volatile __near unsigned char  *)0x5E4)
#define RMD5_15L1L     (*(volatile __near unsigned char  *)0x5E4)
#define TMDF2_15L1H    (*(volatile __near unsigned char  *)0x5E5)
#define TMDF2_15L0H    (*(volatile __near unsigned char  *)0x5E5)
#define RMD13_15L1H    (*(volatile __near unsigned char  *)0x5E5)
#define RMD13_15L0H    (*(volatile __near unsigned char  *)0x5E5)
#define RPGACC25L0H    (*(volatile __near unsigned char  *)0x5E5)
#define RPGACC25L1H    (*(volatile __near unsigned char  *)0x5E5)
#define RMD5_15L0H     (*(volatile __near unsigned char  *)0x5E5)
#define RMD5_15L1H     (*(volatile __near unsigned char  *)0x5E5)
#define TMDF2_15H1     (*(volatile __near unsigned short *)0x5E6)
#define RMD13_15H1     (*(volatile __near unsigned short *)0x5E6)
#define TMDF2_15H0     (*(volatile __near unsigned short *)0x5E6)
#define RMD13_15H0     (*(volatile __near unsigned short *)0x5E6)
#define RPGACC25H1     (*(volatile __near unsigned short *)0x5E6)
#define RPGACC25H0     (*(volatile __near unsigned short *)0x5E6)
#define RMD5_15H0      (*(volatile __near unsigned short *)0x5E6)
#define RMD5_15H1      (*(volatile __near unsigned short *)0x5E6)
#define RMD13_15H1L    (*(volatile __near unsigned char  *)0x5E6)
#define TMDF2_15H1L    (*(volatile __near unsigned char  *)0x5E6)
#define RMD13_15H0L    (*(volatile __near unsigned char  *)0x5E6)
#define TMDF2_15H0L    (*(volatile __near unsigned char  *)0x5E6)
#define RPGACC25H0L    (*(volatile __near unsigned char  *)0x5E6)
#define RPGACC25H1L    (*(volatile __near unsigned char  *)0x5E6)
#define RMD5_15H1L     (*(volatile __near unsigned char  *)0x5E6)
#define RMD5_15H0L     (*(volatile __near unsigned char  *)0x5E6)
#define TMDF2_15H1H    (*(volatile __near unsigned char  *)0x5E7)
#define TMDF2_15H0H    (*(volatile __near unsigned char  *)0x5E7)
#define RMD13_15H1H    (*(volatile __near unsigned char  *)0x5E7)
#define RMD13_15H0H    (*(volatile __near unsigned char  *)0x5E7)
#define RPGACC25H1H    (*(volatile __near unsigned char  *)0x5E7)
#define RPGACC25H0H    (*(volatile __near unsigned char  *)0x5E7)
#define RMD5_15H0H     (*(volatile __near unsigned char  *)0x5E7)
#define RMD5_15H1H     (*(volatile __near unsigned char  *)0x5E7)
#define TMID3L1        (*(volatile __near unsigned short *)0x5E8)
#define TMID3L0        (*(volatile __near unsigned short *)0x5E8)
#define RMID14L0       (*(volatile __near unsigned short *)0x5E8)
#define RMID6L1        (*(volatile __near unsigned short *)0x5E8)
#define RMID6L0        (*(volatile __near unsigned short *)0x5E8)
#define RPGACC26L0     (*(volatile __near unsigned short *)0x5E8)
#define RMID14L1       (*(volatile __near unsigned short *)0x5E8)
#define RPGACC26L1     (*(volatile __near unsigned short *)0x5E8)
#define TMID3L0L       (*(volatile __near unsigned char  *)0x5E8)
#define TMID3L1L       (*(volatile __near unsigned char  *)0x5E8)
#define RMID6L0L       (*(volatile __near unsigned char  *)0x5E8)
#define RPGACC26L1L    (*(volatile __near unsigned char  *)0x5E8)
#define RMID14L0L      (*(volatile __near unsigned char  *)0x5E8)
#define RPGACC26L0L    (*(volatile __near unsigned char  *)0x5E8)
#define RMID6L1L       (*(volatile __near unsigned char  *)0x5E8)
#define RMID14L1L      (*(volatile __near unsigned char  *)0x5E8)
#define TMID3L0H       (*(volatile __near unsigned char  *)0x5E9)
#define TMID3L1H       (*(volatile __near unsigned char  *)0x5E9)
#define RPGACC26L1H    (*(volatile __near unsigned char  *)0x5E9)
#define RMID14L0H      (*(volatile __near unsigned char  *)0x5E9)
#define RPGACC26L0H    (*(volatile __near unsigned char  *)0x5E9)
#define RMID14L1H      (*(volatile __near unsigned char  *)0x5E9)
#define RMID6L0H       (*(volatile __near unsigned char  *)0x5E9)
#define RMID6L1H       (*(volatile __near unsigned char  *)0x5E9)
#define TMID3H0        (*(volatile __near unsigned short *)0x5EA)
#define TMID3H1        (*(volatile __near unsigned short *)0x5EA)
#define RMID6H0        (*(volatile __near unsigned short *)0x5EA)
#define RPGACC26H0     (*(volatile __near unsigned short *)0x5EA)
#define RPGACC26H1     (*(volatile __near unsigned short *)0x5EA)
#define RMID14H1       (*(volatile __near unsigned short *)0x5EA)
#define RMID6H1        (*(volatile __near unsigned short *)0x5EA)
#define RMID14H0       (*(volatile __near unsigned short *)0x5EA)
#define TMID3H1L       (*(volatile __near unsigned char  *)0x5EA)
#define TMID3H0L       (*(volatile __near unsigned char  *)0x5EA)
#define RPGACC26H0L    (*(volatile __near unsigned char  *)0x5EA)
#define RPGACC26H1L    (*(volatile __near unsigned char  *)0x5EA)
#define RMID6H0L       (*(volatile __near unsigned char  *)0x5EA)
#define RMID6H1L       (*(volatile __near unsigned char  *)0x5EA)
#define RMID14H1L      (*(volatile __near unsigned char  *)0x5EA)
#define RMID14H0L      (*(volatile __near unsigned char  *)0x5EA)
#define TMID3H0H       (*(volatile __near unsigned char  *)0x5EB)
#define TMID3H1H       (*(volatile __near unsigned char  *)0x5EB)
#define RMID6H0H       (*(volatile __near unsigned char  *)0x5EB)
#define RPGACC26H0H    (*(volatile __near unsigned char  *)0x5EB)
#define RPGACC26H1H    (*(volatile __near unsigned char  *)0x5EB)
#define RMID6H1H       (*(volatile __near unsigned char  *)0x5EB)
#define RMID14H1H      (*(volatile __near unsigned char  *)0x5EB)
#define RMID14H0H      (*(volatile __near unsigned char  *)0x5EB)
#define RMPTR14L1      (*(volatile __near unsigned short *)0x5EC)
#define RMPTR6L1       (*(volatile __near unsigned short *)0x5EC)
#define RMPTR6L0       (*(volatile __near unsigned short *)0x5EC)
#define RMPTR14L0      (*(volatile __near unsigned short *)0x5EC)
#define RPGACC27L1     (*(volatile __near unsigned short *)0x5EC)
#define RPGACC27L0     (*(volatile __near unsigned short *)0x5EC)
#define RMPTR14L0L     (*(volatile __near unsigned char  *)0x5EC)
#define RMPTR6L0L      (*(volatile __near unsigned char  *)0x5EC)
#define RMPTR14L1L     (*(volatile __near unsigned char  *)0x5EC)
#define RMPTR6L1L      (*(volatile __near unsigned char  *)0x5EC)
#define RPGACC27L0L    (*(volatile __near unsigned char  *)0x5EC)
#define RPGACC27L1L    (*(volatile __near unsigned char  *)0x5EC)
#define RPGACC27L1H    (*(volatile __near unsigned char  *)0x5ED)
#define RPGACC27L0H    (*(volatile __near unsigned char  *)0x5ED)
#define RMPTR6L1H      (*(volatile __near unsigned char  *)0x5ED)
#define RMPTR6L0H      (*(volatile __near unsigned char  *)0x5ED)
#define RMPTR14L0H     (*(volatile __near unsigned char  *)0x5ED)
#define RMPTR14L1H     (*(volatile __near unsigned char  *)0x5ED)
#define TMPTR3H1       (*(volatile __near unsigned short *)0x5EE)
#define TMPTR3H0       (*(volatile __near unsigned short *)0x5EE)
#define RMPTR6H1       (*(volatile __near unsigned short *)0x5EE)
#define RPGACC27H0     (*(volatile __near unsigned short *)0x5EE)
#define RPGACC27H1     (*(volatile __near unsigned short *)0x5EE)
#define RMPTR14H0      (*(volatile __near unsigned short *)0x5EE)
#define RMPTR14H1      (*(volatile __near unsigned short *)0x5EE)
#define RMPTR6H0       (*(volatile __near unsigned short *)0x5EE)
#define RPGACC27H1L    (*(volatile __near unsigned char  *)0x5EE)
#define RPGACC27H0L    (*(volatile __near unsigned char  *)0x5EE)
#define TMPTR3H0H      (*(volatile __near unsigned char  *)0x5EF)
#define TMPTR3H1H      (*(volatile __near unsigned char  *)0x5EF)
#define RMPTR14H0H     (*(volatile __near unsigned char  *)0x5EF)
#define RMPTR14H1H     (*(volatile __near unsigned char  *)0x5EF)
#define RMPTR6H0H      (*(volatile __near unsigned char  *)0x5EF)
#define RPGACC27H1H    (*(volatile __near unsigned char  *)0x5EF)
#define RPGACC27H0H    (*(volatile __near unsigned char  *)0x5EF)
#define RMPTR6H1H      (*(volatile __near unsigned char  *)0x5EF)
#define TMFDCTR3L1     (*(volatile __near unsigned short *)0x5F0)
#define TMFDCTR3L0     (*(volatile __near unsigned short *)0x5F0)
#define RMSTS14L0      (*(volatile __near unsigned short *)0x5F0)
#define RMSTS6L1       (*(volatile __near unsigned short *)0x5F0)
#define RMSTS6L0       (*(volatile __near unsigned short *)0x5F0)
#define RPGACC28L1     (*(volatile __near unsigned short *)0x5F0)
#define RPGACC28L0     (*(volatile __near unsigned short *)0x5F0)
#define RMSTS14L1      (*(volatile __near unsigned short *)0x5F0)
#define TMFDCTR3L1L    (*(volatile __near unsigned char  *)0x5F0)
#define TMFDCTR3L0L    (*(volatile __near unsigned char  *)0x5F0)
#define RMSTS6L0L      (*(volatile __near unsigned char  *)0x5F0)
#define RPGACC28L0L    (*(volatile __near unsigned char  *)0x5F0)
#define RMSTS14L1L     (*(volatile __near unsigned char  *)0x5F0)
#define RMSTS14L0L     (*(volatile __near unsigned char  *)0x5F0)
#define RPGACC28L1L    (*(volatile __near unsigned char  *)0x5F0)
#define RMSTS6L1L      (*(volatile __near unsigned char  *)0x5F0)
#define TMFDCTR3L0H    (*(volatile __near unsigned char  *)0x5F1)
#define TMFDCTR3L1H    (*(volatile __near unsigned char  *)0x5F1)
#define RMSTS6L1H      (*(volatile __near unsigned char  *)0x5F1)
#define RMSTS6L0H      (*(volatile __near unsigned char  *)0x5F1)
#define RPGACC28L1H    (*(volatile __near unsigned char  *)0x5F1)
#define RMSTS14L1H     (*(volatile __near unsigned char  *)0x5F1)
#define RMSTS14L0H     (*(volatile __near unsigned char  *)0x5F1)
#define RPGACC28L0H    (*(volatile __near unsigned char  *)0x5F1)
#define TMFDCTR3H1     (*(volatile __near unsigned short *)0x5F2)
#define TMFDCTR3H0     (*(volatile __near unsigned short *)0x5F2)
#define RMSTS6H1       (*(volatile __near unsigned short *)0x5F2)
#define RMSTS6H0       (*(volatile __near unsigned short *)0x5F2)
#define RMSTS14H1      (*(volatile __near unsigned short *)0x5F2)
#define RMSTS14H0      (*(volatile __near unsigned short *)0x5F2)
#define RPGACC28H0     (*(volatile __near unsigned short *)0x5F2)
#define RPGACC28H1     (*(volatile __near unsigned short *)0x5F2)
#define TMFDCTR3H0L    (*(volatile __near unsigned char  *)0x5F2)
#define TMFDCTR3H1L    (*(volatile __near unsigned char  *)0x5F2)
#define RMSTS6H1L      (*(volatile __near unsigned char  *)0x5F2)
#define RMSTS6H0L      (*(volatile __near unsigned char  *)0x5F2)
#define RMSTS14H1L     (*(volatile __near unsigned char  *)0x5F2)
#define RMSTS14H0L     (*(volatile __near unsigned char  *)0x5F2)
#define RPGACC28H1L    (*(volatile __near unsigned char  *)0x5F2)
#define RPGACC28H0L    (*(volatile __near unsigned char  *)0x5F2)
#define TMFDCTR3H0H    (*(volatile __near unsigned char  *)0x5F3)
#define TMFDCTR3H1H    (*(volatile __near unsigned char  *)0x5F3)
#define RMSTS6H1H      (*(volatile __near unsigned char  *)0x5F3)
#define RMSTS6H0H      (*(volatile __near unsigned char  *)0x5F3)
#define RMSTS14H1H     (*(volatile __near unsigned char  *)0x5F3)
#define RMSTS14H0H     (*(volatile __near unsigned char  *)0x5F3)
#define RPGACC28H1H    (*(volatile __near unsigned char  *)0x5F3)
#define RPGACC28H0H    (*(volatile __near unsigned char  *)0x5F3)
#define RMD14_0L0      (*(volatile __near unsigned short *)0x5F4)
#define RMD14_0L1      (*(volatile __near unsigned short *)0x5F4)
#define TMDF3_0L0      (*(volatile __near unsigned short *)0x5F4)
#define TMDF3_0L1      (*(volatile __near unsigned short *)0x5F4)
#define RPGACC29L1     (*(volatile __near unsigned short *)0x5F4)
#define RPGACC29L0     (*(volatile __near unsigned short *)0x5F4)
#define RMD6_0L1       (*(volatile __near unsigned short *)0x5F4)
#define RMD6_0L0       (*(volatile __near unsigned short *)0x5F4)
#define RMD14_0L1L     (*(volatile __near unsigned char  *)0x5F4)
#define RMD14_0L0L     (*(volatile __near unsigned char  *)0x5F4)
#define TMDF3_0L0L     (*(volatile __near unsigned char  *)0x5F4)
#define TMDF3_0L1L     (*(volatile __near unsigned char  *)0x5F4)
#define RPGACC29L0L    (*(volatile __near unsigned char  *)0x5F4)
#define RPGACC29L1L    (*(volatile __near unsigned char  *)0x5F4)
#define RMD6_0L1L      (*(volatile __near unsigned char  *)0x5F4)
#define RMD6_0L0L      (*(volatile __near unsigned char  *)0x5F4)
#define RMD14_0L1H     (*(volatile __near unsigned char  *)0x5F5)
#define RMD14_0L0H     (*(volatile __near unsigned char  *)0x5F5)
#define TMDF3_0L0H     (*(volatile __near unsigned char  *)0x5F5)
#define TMDF3_0L1H     (*(volatile __near unsigned char  *)0x5F5)
#define RPGACC29L1H    (*(volatile __near unsigned char  *)0x5F5)
#define RMD6_0L0H      (*(volatile __near unsigned char  *)0x5F5)
#define RMD6_0L1H      (*(volatile __near unsigned char  *)0x5F5)
#define RPGACC29L0H    (*(volatile __near unsigned char  *)0x5F5)
#define RMD14_0H1      (*(volatile __near unsigned short *)0x5F6)
#define RMD14_0H0      (*(volatile __near unsigned short *)0x5F6)
#define TMDF3_0H1      (*(volatile __near unsigned short *)0x5F6)
#define TMDF3_0H0      (*(volatile __near unsigned short *)0x5F6)
#define RMD6_0H0       (*(volatile __near unsigned short *)0x5F6)
#define RMD6_0H1       (*(volatile __near unsigned short *)0x5F6)
#define RPGACC29H1     (*(volatile __near unsigned short *)0x5F6)
#define RPGACC29H0     (*(volatile __near unsigned short *)0x5F6)
#define RMD14_0H1L     (*(volatile __near unsigned char  *)0x5F6)
#define RMD14_0H0L     (*(volatile __near unsigned char  *)0x5F6)
#define TMDF3_0H1L     (*(volatile __near unsigned char  *)0x5F6)
#define TMDF3_0H0L     (*(volatile __near unsigned char  *)0x5F6)
#define RMD6_0H0L      (*(volatile __near unsigned char  *)0x5F6)
#define RMD6_0H1L      (*(volatile __near unsigned char  *)0x5F6)
#define RPGACC29H1L    (*(volatile __near unsigned char  *)0x5F6)
#define RPGACC29H0L    (*(volatile __near unsigned char  *)0x5F6)
#define RMD14_0H1H     (*(volatile __near unsigned char  *)0x5F7)
#define RMD14_0H0H     (*(volatile __near unsigned char  *)0x5F7)
#define TMDF3_0H0H     (*(volatile __near unsigned char  *)0x5F7)
#define TMDF3_0H1H     (*(volatile __near unsigned char  *)0x5F7)
#define RMD6_0H0H      (*(volatile __near unsigned char  *)0x5F7)
#define RMD6_0H1H      (*(volatile __near unsigned char  *)0x5F7)
#define RPGACC29H0H    (*(volatile __near unsigned char  *)0x5F7)
#define RPGACC29H1H    (*(volatile __near unsigned char  *)0x5F7)
#define RMD14_1L1      (*(volatile __near unsigned short *)0x5F8)
#define RMD14_1L0      (*(volatile __near unsigned short *)0x5F8)
#define TMDF3_1L1      (*(volatile __near unsigned short *)0x5F8)
#define TMDF3_1L0      (*(volatile __near unsigned short *)0x5F8)
#define RMD6_1L0       (*(volatile __near unsigned short *)0x5F8)
#define RMD6_1L1       (*(volatile __near unsigned short *)0x5F8)
#define RPGACC30L1     (*(volatile __near unsigned short *)0x5F8)
#define RPGACC30L0     (*(volatile __near unsigned short *)0x5F8)
#define RMD14_1L0L     (*(volatile __near unsigned char  *)0x5F8)
#define RMD14_1L1L     (*(volatile __near unsigned char  *)0x5F8)
#define TMDF3_1L1L     (*(volatile __near unsigned char  *)0x5F8)
#define TMDF3_1L0L     (*(volatile __near unsigned char  *)0x5F8)
#define RMD6_1L0L      (*(volatile __near unsigned char  *)0x5F8)
#define RMD6_1L1L      (*(volatile __near unsigned char  *)0x5F8)
#define RPGACC30L1L    (*(volatile __near unsigned char  *)0x5F8)
#define RPGACC30L0L    (*(volatile __near unsigned char  *)0x5F8)
#define RMD14_1L0H     (*(volatile __near unsigned char  *)0x5F9)
#define RMD14_1L1H     (*(volatile __near unsigned char  *)0x5F9)
#define TMDF3_1L1H     (*(volatile __near unsigned char  *)0x5F9)
#define TMDF3_1L0H     (*(volatile __near unsigned char  *)0x5F9)
#define RMD6_1L0H      (*(volatile __near unsigned char  *)0x5F9)
#define RMD6_1L1H      (*(volatile __near unsigned char  *)0x5F9)
#define RPGACC30L1H    (*(volatile __near unsigned char  *)0x5F9)
#define RPGACC30L0H    (*(volatile __near unsigned char  *)0x5F9)
#define RMD14_1H1      (*(volatile __near unsigned short *)0x5FA)
#define RMD14_1H0      (*(volatile __near unsigned short *)0x5FA)
#define TMDF3_1H1      (*(volatile __near unsigned short *)0x5FA)
#define TMDF3_1H0      (*(volatile __near unsigned short *)0x5FA)
#define RPGACC30H1     (*(volatile __near unsigned short *)0x5FA)
#define RPGACC30H0     (*(volatile __near unsigned short *)0x5FA)
#define RMD6_1H0       (*(volatile __near unsigned short *)0x5FA)
#define RMD6_1H1       (*(volatile __near unsigned short *)0x5FA)
#define RMD14_1H0L     (*(volatile __near unsigned char  *)0x5FA)
#define RMD14_1H1L     (*(volatile __near unsigned char  *)0x5FA)
#define TMDF3_1H1L     (*(volatile __near unsigned char  *)0x5FA)
#define TMDF3_1H0L     (*(volatile __near unsigned char  *)0x5FA)
#define RMD6_1H1L      (*(volatile __near unsigned char  *)0x5FA)
#define RPGACC30H0L    (*(volatile __near unsigned char  *)0x5FA)
#define RMD6_1H0L      (*(volatile __near unsigned char  *)0x5FA)
#define RPGACC30H1L    (*(volatile __near unsigned char  *)0x5FA)
#define RMD14_1H1H     (*(volatile __near unsigned char  *)0x5FB)
#define RMD14_1H0H     (*(volatile __near unsigned char  *)0x5FB)
#define TMDF3_1H1H     (*(volatile __near unsigned char  *)0x5FB)
#define TMDF3_1H0H     (*(volatile __near unsigned char  *)0x5FB)
#define RPGACC30H0H    (*(volatile __near unsigned char  *)0x5FB)
#define RMD6_1H0H      (*(volatile __near unsigned char  *)0x5FB)
#define RMD6_1H1H      (*(volatile __near unsigned char  *)0x5FB)
#define RPGACC30H1H    (*(volatile __near unsigned char  *)0x5FB)
#define RMD14_2L1      (*(volatile __near unsigned short *)0x5FC)
#define TMDF3_2L0      (*(volatile __near unsigned short *)0x5FC)
#define TMDF3_2L1      (*(volatile __near unsigned short *)0x5FC)
#define RMD14_2L0      (*(volatile __near unsigned short *)0x5FC)
#define RPGACC31L0     (*(volatile __near unsigned short *)0x5FC)
#define RPGACC31L1     (*(volatile __near unsigned short *)0x5FC)
#define RMD6_2L1       (*(volatile __near unsigned short *)0x5FC)
#define RMD6_2L0       (*(volatile __near unsigned short *)0x5FC)
#define RMD14_2L0L     (*(volatile __near unsigned char  *)0x5FC)
#define RMD14_2L1L     (*(volatile __near unsigned char  *)0x5FC)
#define TMDF3_2L1L     (*(volatile __near unsigned char  *)0x5FC)
#define TMDF3_2L0L     (*(volatile __near unsigned char  *)0x5FC)
#define RPGACC31L0L    (*(volatile __near unsigned char  *)0x5FC)
#define RMD6_2L1L      (*(volatile __near unsigned char  *)0x5FC)
#define RPGACC31L1L    (*(volatile __near unsigned char  *)0x5FC)
#define RMD6_2L0L      (*(volatile __near unsigned char  *)0x5FC)
#define TMDF3_2L1H     (*(volatile __near unsigned char  *)0x5FD)
#define TMDF3_2L0H     (*(volatile __near unsigned char  *)0x5FD)
#define RMD14_2L0H     (*(volatile __near unsigned char  *)0x5FD)
#define RMD14_2L1H     (*(volatile __near unsigned char  *)0x5FD)
#define RPGACC31L0H    (*(volatile __near unsigned char  *)0x5FD)
#define RPGACC31L1H    (*(volatile __near unsigned char  *)0x5FD)
#define RMD6_2L1H      (*(volatile __near unsigned char  *)0x5FD)
#define RMD6_2L0H      (*(volatile __near unsigned char  *)0x5FD)
#define TMDF3_2H1      (*(volatile __near unsigned short *)0x5FE)
#define RMD14_2H1      (*(volatile __near unsigned short *)0x5FE)
#define TMDF3_2H0      (*(volatile __near unsigned short *)0x5FE)
#define RMD14_2H0      (*(volatile __near unsigned short *)0x5FE)
#define RMD6_2H0       (*(volatile __near unsigned short *)0x5FE)
#define RMD6_2H1       (*(volatile __near unsigned short *)0x5FE)
#define RPGACC31H0     (*(volatile __near unsigned short *)0x5FE)
#define RPGACC31H1     (*(volatile __near unsigned short *)0x5FE)
#define TMDF3_2H1L     (*(volatile __near unsigned char  *)0x5FE)
#define TMDF3_2H0L     (*(volatile __near unsigned char  *)0x5FE)
#define RMD14_2H0L     (*(volatile __near unsigned char  *)0x5FE)
#define RMD14_2H1L     (*(volatile __near unsigned char  *)0x5FE)
#define RPGACC31H1L    (*(volatile __near unsigned char  *)0x5FE)
#define RMD6_2H1L      (*(volatile __near unsigned char  *)0x5FE)
#define RMD6_2H0L      (*(volatile __near unsigned char  *)0x5FE)
#define RPGACC31H0L    (*(volatile __near unsigned char  *)0x5FE)
#define TMDF3_2H1H     (*(volatile __near unsigned char  *)0x5FF)
#define TMDF3_2H0H     (*(volatile __near unsigned char  *)0x5FF)
#define RMD14_2H1H     (*(volatile __near unsigned char  *)0x5FF)
#define RMD14_2H0H     (*(volatile __near unsigned char  *)0x5FF)
#define RPGACC31H1H    (*(volatile __near unsigned char  *)0x5FF)
#define RPGACC31H0H    (*(volatile __near unsigned char  *)0x5FF)
#define RMD6_2H0H      (*(volatile __near unsigned char  *)0x5FF)
#define RMD6_2H1H      (*(volatile __near unsigned char  *)0x5FF)
#define TMDF3_3L1      (*(volatile __near unsigned short *)0x600)
#define TMDF3_3L0      (*(volatile __near unsigned short *)0x600)
#define RMD14_3L0      (*(volatile __near unsigned short *)0x600)
#define RMD14_3L1      (*(volatile __near unsigned short *)0x600)
#define RPGACC32L1     (*(volatile __near unsigned short *)0x600)
#define RMD6_3L0       (*(volatile __near unsigned short *)0x600)
#define RPGACC32L0     (*(volatile __near unsigned short *)0x600)
#define RMD6_3L1       (*(volatile __near unsigned short *)0x600)
#define RMD14_3L1L     (*(volatile __near unsigned char  *)0x600)
#define TMDF3_3L0L     (*(volatile __near unsigned char  *)0x600)
#define TMDF3_3L1L     (*(volatile __near unsigned char  *)0x600)
#define RMD14_3L0L     (*(volatile __near unsigned char  *)0x600)
#define RPGACC32L0L    (*(volatile __near unsigned char  *)0x600)
#define RPGACC32L1L    (*(volatile __near unsigned char  *)0x600)
#define RMD6_3L1L      (*(volatile __near unsigned char  *)0x600)
#define RMD6_3L0L      (*(volatile __near unsigned char  *)0x600)
#define TMDF3_3L0H     (*(volatile __near unsigned char  *)0x601)
#define RMD14_3L1H     (*(volatile __near unsigned char  *)0x601)
#define TMDF3_3L1H     (*(volatile __near unsigned char  *)0x601)
#define RMD14_3L0H     (*(volatile __near unsigned char  *)0x601)
#define RMD6_3L1H      (*(volatile __near unsigned char  *)0x601)
#define RPGACC32L1H    (*(volatile __near unsigned char  *)0x601)
#define RPGACC32L0H    (*(volatile __near unsigned char  *)0x601)
#define RMD6_3L0H      (*(volatile __near unsigned char  *)0x601)
#define RMD14_3H0      (*(volatile __near unsigned short *)0x602)
#define RMD14_3H1      (*(volatile __near unsigned short *)0x602)
#define TMDF3_3H0      (*(volatile __near unsigned short *)0x602)
#define TMDF3_3H1      (*(volatile __near unsigned short *)0x602)
#define RMD6_3H1       (*(volatile __near unsigned short *)0x602)
#define RMD6_3H0       (*(volatile __near unsigned short *)0x602)
#define RPGACC32H0     (*(volatile __near unsigned short *)0x602)
#define RPGACC32H1     (*(volatile __near unsigned short *)0x602)
#define RMD14_3H0L     (*(volatile __near unsigned char  *)0x602)
#define TMDF3_3H0L     (*(volatile __near unsigned char  *)0x602)
#define TMDF3_3H1L     (*(volatile __near unsigned char  *)0x602)
#define RMD14_3H1L     (*(volatile __near unsigned char  *)0x602)
#define RMD6_3H1L      (*(volatile __near unsigned char  *)0x602)
#define RMD6_3H0L      (*(volatile __near unsigned char  *)0x602)
#define RPGACC32H0L    (*(volatile __near unsigned char  *)0x602)
#define RPGACC32H1L    (*(volatile __near unsigned char  *)0x602)
#define RMD14_3H0H     (*(volatile __near unsigned char  *)0x603)
#define TMDF3_3H0H     (*(volatile __near unsigned char  *)0x603)
#define TMDF3_3H1H     (*(volatile __near unsigned char  *)0x603)
#define RMD14_3H1H     (*(volatile __near unsigned char  *)0x603)
#define RMD6_3H0H      (*(volatile __near unsigned char  *)0x603)
#define RPGACC32H1H    (*(volatile __near unsigned char  *)0x603)
#define RPGACC32H0H    (*(volatile __near unsigned char  *)0x603)
#define RMD6_3H1H      (*(volatile __near unsigned char  *)0x603)
#define TMDF3_4L0      (*(volatile __near unsigned short *)0x604)
#define TMDF3_4L1      (*(volatile __near unsigned short *)0x604)
#define RMD14_4L0      (*(volatile __near unsigned short *)0x604)
#define RMD14_4L1      (*(volatile __near unsigned short *)0x604)
#define RPGACC33L0     (*(volatile __near unsigned short *)0x604)
#define RPGACC33L1     (*(volatile __near unsigned short *)0x604)
#define RMD6_4L1       (*(volatile __near unsigned short *)0x604)
#define RMD6_4L0       (*(volatile __near unsigned short *)0x604)
#define TMDF3_4L0L     (*(volatile __near unsigned char  *)0x604)
#define TMDF3_4L1L     (*(volatile __near unsigned char  *)0x604)
#define RMD14_4L0L     (*(volatile __near unsigned char  *)0x604)
#define RMD14_4L1L     (*(volatile __near unsigned char  *)0x604)
#define RPGACC33L0L    (*(volatile __near unsigned char  *)0x604)
#define RPGACC33L1L    (*(volatile __near unsigned char  *)0x604)
#define RMD6_4L0L      (*(volatile __near unsigned char  *)0x604)
#define RMD6_4L1L      (*(volatile __near unsigned char  *)0x604)
#define TMDF3_4L1H     (*(volatile __near unsigned char  *)0x605)
#define TMDF3_4L0H     (*(volatile __near unsigned char  *)0x605)
#define RMD14_4L0H     (*(volatile __near unsigned char  *)0x605)
#define RMD14_4L1H     (*(volatile __near unsigned char  *)0x605)
#define RPGACC33L0H    (*(volatile __near unsigned char  *)0x605)
#define RPGACC33L1H    (*(volatile __near unsigned char  *)0x605)
#define RMD6_4L1H      (*(volatile __near unsigned char  *)0x605)
#define RMD6_4L0H      (*(volatile __near unsigned char  *)0x605)
#define TMDF3_4H1      (*(volatile __near unsigned short *)0x606)
#define TMDF3_4H0      (*(volatile __near unsigned short *)0x606)
#define RMD14_4H0      (*(volatile __near unsigned short *)0x606)
#define RMD14_4H1      (*(volatile __near unsigned short *)0x606)
#define RPGACC33H0     (*(volatile __near unsigned short *)0x606)
#define RPGACC33H1     (*(volatile __near unsigned short *)0x606)
#define RMD6_4H1       (*(volatile __near unsigned short *)0x606)
#define RMD6_4H0       (*(volatile __near unsigned short *)0x606)
#define TMDF3_4H1L     (*(volatile __near unsigned char  *)0x606)
#define TMDF3_4H0L     (*(volatile __near unsigned char  *)0x606)
#define RMD14_4H0L     (*(volatile __near unsigned char  *)0x606)
#define RMD14_4H1L     (*(volatile __near unsigned char  *)0x606)
#define RPGACC33H0L    (*(volatile __near unsigned char  *)0x606)
#define RPGACC33H1L    (*(volatile __near unsigned char  *)0x606)
#define RMD6_4H1L      (*(volatile __near unsigned char  *)0x606)
#define RMD6_4H0L      (*(volatile __near unsigned char  *)0x606)
#define TMDF3_4H1H     (*(volatile __near unsigned char  *)0x607)
#define TMDF3_4H0H     (*(volatile __near unsigned char  *)0x607)
#define RMD14_4H1H     (*(volatile __near unsigned char  *)0x607)
#define RMD14_4H0H     (*(volatile __near unsigned char  *)0x607)
#define RPGACC33H0H    (*(volatile __near unsigned char  *)0x607)
#define RPGACC33H1H    (*(volatile __near unsigned char  *)0x607)
#define RMD6_4H1H      (*(volatile __near unsigned char  *)0x607)
#define RMD6_4H0H      (*(volatile __near unsigned char  *)0x607)
#define RMD14_5L1      (*(volatile __near unsigned short *)0x608)
#define TMDF3_5L0      (*(volatile __near unsigned short *)0x608)
#define TMDF3_5L1      (*(volatile __near unsigned short *)0x608)
#define RMD14_5L0      (*(volatile __near unsigned short *)0x608)
#define RPGACC34L0     (*(volatile __near unsigned short *)0x608)
#define RMD6_5L1       (*(volatile __near unsigned short *)0x608)
#define RMD6_5L0       (*(volatile __near unsigned short *)0x608)
#define RPGACC34L1     (*(volatile __near unsigned short *)0x608)
#define RMD14_5L0L     (*(volatile __near unsigned char  *)0x608)
#define TMDF3_5L0L     (*(volatile __near unsigned char  *)0x608)
#define RMD14_5L1L     (*(volatile __near unsigned char  *)0x608)
#define TMDF3_5L1L     (*(volatile __near unsigned char  *)0x608)
#define RMD6_5L1L      (*(volatile __near unsigned char  *)0x608)
#define RMD6_5L0L      (*(volatile __near unsigned char  *)0x608)
#define RPGACC34L0L    (*(volatile __near unsigned char  *)0x608)
#define RPGACC34L1L    (*(volatile __near unsigned char  *)0x608)
#define RMD14_5L1H     (*(volatile __near unsigned char  *)0x609)
#define TMDF3_5L0H     (*(volatile __near unsigned char  *)0x609)
#define RMD14_5L0H     (*(volatile __near unsigned char  *)0x609)
#define TMDF3_5L1H     (*(volatile __near unsigned char  *)0x609)
#define RMD6_5L1H      (*(volatile __near unsigned char  *)0x609)
#define RMD6_5L0H      (*(volatile __near unsigned char  *)0x609)
#define RPGACC34L0H    (*(volatile __near unsigned char  *)0x609)
#define RPGACC34L1H    (*(volatile __near unsigned char  *)0x609)
#define TMDF3_5H0      (*(volatile __near unsigned short *)0x60A)
#define TMDF3_5H1      (*(volatile __near unsigned short *)0x60A)
#define RMD14_5H0      (*(volatile __near unsigned short *)0x60A)
#define RMD14_5H1      (*(volatile __near unsigned short *)0x60A)
#define RPGACC34H1     (*(volatile __near unsigned short *)0x60A)
#define RMD6_5H1       (*(volatile __near unsigned short *)0x60A)
#define RPGACC34H0     (*(volatile __near unsigned short *)0x60A)
#define RMD6_5H0       (*(volatile __near unsigned short *)0x60A)
#define RMD14_5H0L     (*(volatile __near unsigned char  *)0x60A)
#define RMD14_5H1L     (*(volatile __near unsigned char  *)0x60A)
#define TMDF3_5H1L     (*(volatile __near unsigned char  *)0x60A)
#define TMDF3_5H0L     (*(volatile __near unsigned char  *)0x60A)
#define RMD6_5H1L      (*(volatile __near unsigned char  *)0x60A)
#define RPGACC34H1L    (*(volatile __near unsigned char  *)0x60A)
#define RPGACC34H0L    (*(volatile __near unsigned char  *)0x60A)
#define RMD6_5H0L      (*(volatile __near unsigned char  *)0x60A)
#define RMD14_5H0H     (*(volatile __near unsigned char  *)0x60B)
#define RMD14_5H1H     (*(volatile __near unsigned char  *)0x60B)
#define TMDF3_5H1H     (*(volatile __near unsigned char  *)0x60B)
#define TMDF3_5H0H     (*(volatile __near unsigned char  *)0x60B)
#define RMD6_5H1H      (*(volatile __near unsigned char  *)0x60B)
#define RPGACC34H0H    (*(volatile __near unsigned char  *)0x60B)
#define RPGACC34H1H    (*(volatile __near unsigned char  *)0x60B)
#define RMD6_5H0H      (*(volatile __near unsigned char  *)0x60B)
#define TMDF3_6L1      (*(volatile __near unsigned short *)0x60C)
#define RMD14_6L0      (*(volatile __near unsigned short *)0x60C)
#define RMD14_6L1      (*(volatile __near unsigned short *)0x60C)
#define TMDF3_6L0      (*(volatile __near unsigned short *)0x60C)
#define RMD6_6L1       (*(volatile __near unsigned short *)0x60C)
#define RMD6_6L0       (*(volatile __near unsigned short *)0x60C)
#define RPGACC35L0     (*(volatile __near unsigned short *)0x60C)
#define RPGACC35L1     (*(volatile __near unsigned short *)0x60C)
#define TMDF3_6L0L     (*(volatile __near unsigned char  *)0x60C)
#define TMDF3_6L1L     (*(volatile __near unsigned char  *)0x60C)
#define RMD14_6L0L     (*(volatile __near unsigned char  *)0x60C)
#define RMD14_6L1L     (*(volatile __near unsigned char  *)0x60C)
#define RPGACC35L0L    (*(volatile __near unsigned char  *)0x60C)
#define RMD6_6L0L      (*(volatile __near unsigned char  *)0x60C)
#define RPGACC35L1L    (*(volatile __near unsigned char  *)0x60C)
#define RMD6_6L1L      (*(volatile __near unsigned char  *)0x60C)
#define TMDF3_6L0H     (*(volatile __near unsigned char  *)0x60D)
#define RMD14_6L0H     (*(volatile __near unsigned char  *)0x60D)
#define TMDF3_6L1H     (*(volatile __near unsigned char  *)0x60D)
#define RMD14_6L1H     (*(volatile __near unsigned char  *)0x60D)
#define RMD6_6L0H      (*(volatile __near unsigned char  *)0x60D)
#define RPGACC35L0H    (*(volatile __near unsigned char  *)0x60D)
#define RMD6_6L1H      (*(volatile __near unsigned char  *)0x60D)
#define RPGACC35L1H    (*(volatile __near unsigned char  *)0x60D)
#define RMD14_6H0      (*(volatile __near unsigned short *)0x60E)
#define RMD14_6H1      (*(volatile __near unsigned short *)0x60E)
#define TMDF3_6H1      (*(volatile __near unsigned short *)0x60E)
#define TMDF3_6H0      (*(volatile __near unsigned short *)0x60E)
#define RMD6_6H0       (*(volatile __near unsigned short *)0x60E)
#define RMD6_6H1       (*(volatile __near unsigned short *)0x60E)
#define RPGACC35H0     (*(volatile __near unsigned short *)0x60E)
#define RPGACC35H1     (*(volatile __near unsigned short *)0x60E)
#define RMD14_6H1L     (*(volatile __near unsigned char  *)0x60E)
#define RMD14_6H0L     (*(volatile __near unsigned char  *)0x60E)
#define TMDF3_6H1L     (*(volatile __near unsigned char  *)0x60E)
#define TMDF3_6H0L     (*(volatile __near unsigned char  *)0x60E)
#define RMD6_6H0L      (*(volatile __near unsigned char  *)0x60E)
#define RMD6_6H1L      (*(volatile __near unsigned char  *)0x60E)
#define RPGACC35H0L    (*(volatile __near unsigned char  *)0x60E)
#define RPGACC35H1L    (*(volatile __near unsigned char  *)0x60E)
#define TMDF3_6H0H     (*(volatile __near unsigned char  *)0x60F)
#define RMD14_6H0H     (*(volatile __near unsigned char  *)0x60F)
#define RMD14_6H1H     (*(volatile __near unsigned char  *)0x60F)
#define TMDF3_6H1H     (*(volatile __near unsigned char  *)0x60F)
#define RMD6_6H0H      (*(volatile __near unsigned char  *)0x60F)
#define RMD6_6H1H      (*(volatile __near unsigned char  *)0x60F)
#define RPGACC35H0H    (*(volatile __near unsigned char  *)0x60F)
#define RPGACC35H1H    (*(volatile __near unsigned char  *)0x60F)
#define TMDF3_7L0      (*(volatile __near unsigned short *)0x610)
#define TMDF3_7L1      (*(volatile __near unsigned short *)0x610)
#define RMD14_7L1      (*(volatile __near unsigned short *)0x610)
#define RMD14_7L0      (*(volatile __near unsigned short *)0x610)
#define RPGACC36L0     (*(volatile __near unsigned short *)0x610)
#define RMD6_7L1       (*(volatile __near unsigned short *)0x610)
#define RMD6_7L0       (*(volatile __near unsigned short *)0x610)
#define RPGACC36L1     (*(volatile __near unsigned short *)0x610)
#define TMDF3_7L0L     (*(volatile __near unsigned char  *)0x610)
#define TMDF3_7L1L     (*(volatile __near unsigned char  *)0x610)
#define RMD14_7L0L     (*(volatile __near unsigned char  *)0x610)
#define RMD14_7L1L     (*(volatile __near unsigned char  *)0x610)
#define RMD6_7L0L      (*(volatile __near unsigned char  *)0x610)
#define RPGACC36L0L    (*(volatile __near unsigned char  *)0x610)
#define RMD6_7L1L      (*(volatile __near unsigned char  *)0x610)
#define RPGACC36L1L    (*(volatile __near unsigned char  *)0x610)
#define TMDF3_7L1H     (*(volatile __near unsigned char  *)0x611)
#define TMDF3_7L0H     (*(volatile __near unsigned char  *)0x611)
#define RMD14_7L0H     (*(volatile __near unsigned char  *)0x611)
#define RMD14_7L1H     (*(volatile __near unsigned char  *)0x611)
#define RMD6_7L0H      (*(volatile __near unsigned char  *)0x611)
#define RPGACC36L0H    (*(volatile __near unsigned char  *)0x611)
#define RPGACC36L1H    (*(volatile __near unsigned char  *)0x611)
#define RMD6_7L1H      (*(volatile __near unsigned char  *)0x611)
#define RMD14_7H0      (*(volatile __near unsigned short *)0x612)
#define TMDF3_7H0      (*(volatile __near unsigned short *)0x612)
#define TMDF3_7H1      (*(volatile __near unsigned short *)0x612)
#define RMD14_7H1      (*(volatile __near unsigned short *)0x612)
#define RPGACC36H1     (*(volatile __near unsigned short *)0x612)
#define RPGACC36H0     (*(volatile __near unsigned short *)0x612)
#define RMD6_7H0       (*(volatile __near unsigned short *)0x612)
#define RMD6_7H1       (*(volatile __near unsigned short *)0x612)
#define TMDF3_7H0L     (*(volatile __near unsigned char  *)0x612)
#define TMDF3_7H1L     (*(volatile __near unsigned char  *)0x612)
#define RMD14_7H1L     (*(volatile __near unsigned char  *)0x612)
#define RMD14_7H0L     (*(volatile __near unsigned char  *)0x612)
#define RMD6_7H0L      (*(volatile __near unsigned char  *)0x612)
#define RPGACC36H1L    (*(volatile __near unsigned char  *)0x612)
#define RPGACC36H0L    (*(volatile __near unsigned char  *)0x612)
#define RMD6_7H1L      (*(volatile __near unsigned char  *)0x612)
#define TMDF3_7H0H     (*(volatile __near unsigned char  *)0x613)
#define TMDF3_7H1H     (*(volatile __near unsigned char  *)0x613)
#define RMD14_7H1H     (*(volatile __near unsigned char  *)0x613)
#define RMD14_7H0H     (*(volatile __near unsigned char  *)0x613)
#define RPGACC36H1H    (*(volatile __near unsigned char  *)0x613)
#define RMD6_7H1H      (*(volatile __near unsigned char  *)0x613)
#define RPGACC36H0H    (*(volatile __near unsigned char  *)0x613)
#define RMD6_7H0H      (*(volatile __near unsigned char  *)0x613)
#define TMDF3_8L0      (*(volatile __near unsigned short *)0x614)
#define RMD14_8L1      (*(volatile __near unsigned short *)0x614)
#define RMD14_8L0      (*(volatile __near unsigned short *)0x614)
#define TMDF3_8L1      (*(volatile __near unsigned short *)0x614)
#define RPGACC37L0     (*(volatile __near unsigned short *)0x614)
#define RMD6_8L1       (*(volatile __near unsigned short *)0x614)
#define RPGACC37L1     (*(volatile __near unsigned short *)0x614)
#define RMD6_8L0       (*(volatile __near unsigned short *)0x614)
#define RMD14_8L1L     (*(volatile __near unsigned char  *)0x614)
#define RMD14_8L0L     (*(volatile __near unsigned char  *)0x614)
#define TMDF3_8L0L     (*(volatile __near unsigned char  *)0x614)
#define TMDF3_8L1L     (*(volatile __near unsigned char  *)0x614)
#define RMD6_8L1L      (*(volatile __near unsigned char  *)0x614)
#define RPGACC37L0L    (*(volatile __near unsigned char  *)0x614)
#define RMD6_8L0L      (*(volatile __near unsigned char  *)0x614)
#define RPGACC37L1L    (*(volatile __near unsigned char  *)0x614)
#define RMD14_8L1H     (*(volatile __near unsigned char  *)0x615)
#define RMD14_8L0H     (*(volatile __near unsigned char  *)0x615)
#define TMDF3_8L0H     (*(volatile __near unsigned char  *)0x615)
#define TMDF3_8L1H     (*(volatile __near unsigned char  *)0x615)
#define RMD6_8L1H      (*(volatile __near unsigned char  *)0x615)
#define RPGACC37L1H    (*(volatile __near unsigned char  *)0x615)
#define RPGACC37L0H    (*(volatile __near unsigned char  *)0x615)
#define RMD6_8L0H      (*(volatile __near unsigned char  *)0x615)
#define TMDF3_8H0      (*(volatile __near unsigned short *)0x616)
#define TMDF3_8H1      (*(volatile __near unsigned short *)0x616)
#define RMD14_8H1      (*(volatile __near unsigned short *)0x616)
#define RMD14_8H0      (*(volatile __near unsigned short *)0x616)
#define RMD6_8H0       (*(volatile __near unsigned short *)0x616)
#define RMD6_8H1       (*(volatile __near unsigned short *)0x616)
#define RPGACC37H1     (*(volatile __near unsigned short *)0x616)
#define RPGACC37H0     (*(volatile __near unsigned short *)0x616)
#define TMDF3_8H0L     (*(volatile __near unsigned char  *)0x616)
#define TMDF3_8H1L     (*(volatile __near unsigned char  *)0x616)
#define RMD14_8H1L     (*(volatile __near unsigned char  *)0x616)
#define RMD14_8H0L     (*(volatile __near unsigned char  *)0x616)
#define RMD6_8H0L      (*(volatile __near unsigned char  *)0x616)
#define RMD6_8H1L      (*(volatile __near unsigned char  *)0x616)
#define RPGACC37H0L    (*(volatile __near unsigned char  *)0x616)
#define RPGACC37H1L    (*(volatile __near unsigned char  *)0x616)
#define RMD14_8H0H     (*(volatile __near unsigned char  *)0x617)
#define TMDF3_8H0H     (*(volatile __near unsigned char  *)0x617)
#define RMD14_8H1H     (*(volatile __near unsigned char  *)0x617)
#define TMDF3_8H1H     (*(volatile __near unsigned char  *)0x617)
#define RMD6_8H0H      (*(volatile __near unsigned char  *)0x617)
#define RMD6_8H1H      (*(volatile __near unsigned char  *)0x617)
#define RPGACC37H0H    (*(volatile __near unsigned char  *)0x617)
#define RPGACC37H1H    (*(volatile __near unsigned char  *)0x617)
#define TMDF3_9L1      (*(volatile __near unsigned short *)0x618)
#define TMDF3_9L0      (*(volatile __near unsigned short *)0x618)
#define RMD14_9L0      (*(volatile __near unsigned short *)0x618)
#define RMD14_9L1      (*(volatile __near unsigned short *)0x618)
#define RPGACC38L0     (*(volatile __near unsigned short *)0x618)
#define RPGACC38L1     (*(volatile __near unsigned short *)0x618)
#define RMD6_9L1       (*(volatile __near unsigned short *)0x618)
#define RMD6_9L0       (*(volatile __near unsigned short *)0x618)
#define TMDF3_9L1L     (*(volatile __near unsigned char  *)0x618)
#define TMDF3_9L0L     (*(volatile __near unsigned char  *)0x618)
#define RMD14_9L1L     (*(volatile __near unsigned char  *)0x618)
#define RMD14_9L0L     (*(volatile __near unsigned char  *)0x618)
#define RPGACC38L0L    (*(volatile __near unsigned char  *)0x618)
#define RPGACC38L1L    (*(volatile __near unsigned char  *)0x618)
#define RMD6_9L0L      (*(volatile __near unsigned char  *)0x618)
#define RMD6_9L1L      (*(volatile __near unsigned char  *)0x618)
#define TMDF3_9L1H     (*(volatile __near unsigned char  *)0x619)
#define RMD14_9L1H     (*(volatile __near unsigned char  *)0x619)
#define RMD14_9L0H     (*(volatile __near unsigned char  *)0x619)
#define TMDF3_9L0H     (*(volatile __near unsigned char  *)0x619)
#define RPGACC38L0H    (*(volatile __near unsigned char  *)0x619)
#define RPGACC38L1H    (*(volatile __near unsigned char  *)0x619)
#define RMD6_9L0H      (*(volatile __near unsigned char  *)0x619)
#define RMD6_9L1H      (*(volatile __near unsigned char  *)0x619)
#define RMD14_9H1      (*(volatile __near unsigned short *)0x61A)
#define TMDF3_9H0      (*(volatile __near unsigned short *)0x61A)
#define TMDF3_9H1      (*(volatile __near unsigned short *)0x61A)
#define RMD14_9H0      (*(volatile __near unsigned short *)0x61A)
#define RPGACC38H0     (*(volatile __near unsigned short *)0x61A)
#define RPGACC38H1     (*(volatile __near unsigned short *)0x61A)
#define RMD6_9H0       (*(volatile __near unsigned short *)0x61A)
#define RMD6_9H1       (*(volatile __near unsigned short *)0x61A)
#define RMD14_9H1L     (*(volatile __near unsigned char  *)0x61A)
#define RMD14_9H0L     (*(volatile __near unsigned char  *)0x61A)
#define TMDF3_9H0L     (*(volatile __near unsigned char  *)0x61A)
#define TMDF3_9H1L     (*(volatile __near unsigned char  *)0x61A)
#define RPGACC38H0L    (*(volatile __near unsigned char  *)0x61A)
#define RPGACC38H1L    (*(volatile __near unsigned char  *)0x61A)
#define RMD6_9H0L      (*(volatile __near unsigned char  *)0x61A)
#define RMD6_9H1L      (*(volatile __near unsigned char  *)0x61A)
#define RMD14_9H1H     (*(volatile __near unsigned char  *)0x61B)
#define TMDF3_9H0H     (*(volatile __near unsigned char  *)0x61B)
#define TMDF3_9H1H     (*(volatile __near unsigned char  *)0x61B)
#define RMD14_9H0H     (*(volatile __near unsigned char  *)0x61B)
#define RPGACC38H0H    (*(volatile __near unsigned char  *)0x61B)
#define RPGACC38H1H    (*(volatile __near unsigned char  *)0x61B)
#define RMD6_9H0H      (*(volatile __near unsigned char  *)0x61B)
#define RMD6_9H1H      (*(volatile __near unsigned char  *)0x61B)
#define TMDF3_10L1     (*(volatile __near unsigned short *)0x61C)
#define RMD14_10L0     (*(volatile __near unsigned short *)0x61C)
#define RMD14_10L1     (*(volatile __near unsigned short *)0x61C)
#define TMDF3_10L0     (*(volatile __near unsigned short *)0x61C)
#define RPGACC39L0     (*(volatile __near unsigned short *)0x61C)
#define RPGACC39L1     (*(volatile __near unsigned short *)0x61C)
#define RMD6_10L0      (*(volatile __near unsigned short *)0x61C)
#define RMD6_10L1      (*(volatile __near unsigned short *)0x61C)
#define TMDF3_10L1L    (*(volatile __near unsigned char  *)0x61C)
#define RMD14_10L1L    (*(volatile __near unsigned char  *)0x61C)
#define RMD14_10L0L    (*(volatile __near unsigned char  *)0x61C)
#define TMDF3_10L0L    (*(volatile __near unsigned char  *)0x61C)
#define RPGACC39L1L    (*(volatile __near unsigned char  *)0x61C)
#define RPGACC39L0L    (*(volatile __near unsigned char  *)0x61C)
#define RMD6_10L0L     (*(volatile __near unsigned char  *)0x61C)
#define RMD6_10L1L     (*(volatile __near unsigned char  *)0x61C)
#define RMD14_10L1H    (*(volatile __near unsigned char  *)0x61D)
#define RMD14_10L0H    (*(volatile __near unsigned char  *)0x61D)
#define TMDF3_10L1H    (*(volatile __near unsigned char  *)0x61D)
#define TMDF3_10L0H    (*(volatile __near unsigned char  *)0x61D)
#define RPGACC39L1H    (*(volatile __near unsigned char  *)0x61D)
#define RPGACC39L0H    (*(volatile __near unsigned char  *)0x61D)
#define RMD6_10L0H     (*(volatile __near unsigned char  *)0x61D)
#define RMD6_10L1H     (*(volatile __near unsigned char  *)0x61D)
#define RMD14_10H0     (*(volatile __near unsigned short *)0x61E)
#define TMDF3_10H0     (*(volatile __near unsigned short *)0x61E)
#define RMD14_10H1     (*(volatile __near unsigned short *)0x61E)
#define TMDF3_10H1     (*(volatile __near unsigned short *)0x61E)
#define RPGACC39H1     (*(volatile __near unsigned short *)0x61E)
#define RPGACC39H0     (*(volatile __near unsigned short *)0x61E)
#define RMD6_10H0      (*(volatile __near unsigned short *)0x61E)
#define RMD6_10H1      (*(volatile __near unsigned short *)0x61E)
#define RMD14_10H1L    (*(volatile __near unsigned char  *)0x61E)
#define TMDF3_10H0L    (*(volatile __near unsigned char  *)0x61E)
#define RMD14_10H0L    (*(volatile __near unsigned char  *)0x61E)
#define TMDF3_10H1L    (*(volatile __near unsigned char  *)0x61E)
#define RPGACC39H0L    (*(volatile __near unsigned char  *)0x61E)
#define RPGACC39H1L    (*(volatile __near unsigned char  *)0x61E)
#define RMD6_10H0L     (*(volatile __near unsigned char  *)0x61E)
#define RMD6_10H1L     (*(volatile __near unsigned char  *)0x61E)
#define RMD14_10H1H    (*(volatile __near unsigned char  *)0x61F)
#define RMD14_10H0H    (*(volatile __near unsigned char  *)0x61F)
#define TMDF3_10H0H    (*(volatile __near unsigned char  *)0x61F)
#define TMDF3_10H1H    (*(volatile __near unsigned char  *)0x61F)
#define RPGACC39H0H    (*(volatile __near unsigned char  *)0x61F)
#define RPGACC39H1H    (*(volatile __near unsigned char  *)0x61F)
#define RMD6_10H0H     (*(volatile __near unsigned char  *)0x61F)
#define RMD6_10H1H     (*(volatile __near unsigned char  *)0x61F)
#define TMDF3_11L0     (*(volatile __near unsigned short *)0x620)
#define TMDF3_11L1     (*(volatile __near unsigned short *)0x620)
#define RMD14_11L0     (*(volatile __near unsigned short *)0x620)
#define RMD14_11L1     (*(volatile __near unsigned short *)0x620)
#define RPGACC40L1     (*(volatile __near unsigned short *)0x620)
#define RPGACC40L0     (*(volatile __near unsigned short *)0x620)
#define RMD6_11L0      (*(volatile __near unsigned short *)0x620)
#define RMD6_11L1      (*(volatile __near unsigned short *)0x620)
#define RMD14_11L1L    (*(volatile __near unsigned char  *)0x620)
#define RMD14_11L0L    (*(volatile __near unsigned char  *)0x620)
#define TMDF3_11L0L    (*(volatile __near unsigned char  *)0x620)
#define TMDF3_11L1L    (*(volatile __near unsigned char  *)0x620)
#define RPGACC40L0L    (*(volatile __near unsigned char  *)0x620)
#define RMD6_11L1L     (*(volatile __near unsigned char  *)0x620)
#define RPGACC40L1L    (*(volatile __near unsigned char  *)0x620)
#define RMD6_11L0L     (*(volatile __near unsigned char  *)0x620)
#define TMDF3_11L0H    (*(volatile __near unsigned char  *)0x621)
#define TMDF3_11L1H    (*(volatile __near unsigned char  *)0x621)
#define RMD14_11L0H    (*(volatile __near unsigned char  *)0x621)
#define RMD14_11L1H    (*(volatile __near unsigned char  *)0x621)
#define RPGACC40L0H    (*(volatile __near unsigned char  *)0x621)
#define RPGACC40L1H    (*(volatile __near unsigned char  *)0x621)
#define RMD6_11L1H     (*(volatile __near unsigned char  *)0x621)
#define RMD6_11L0H     (*(volatile __near unsigned char  *)0x621)
#define TMDF3_11H0     (*(volatile __near unsigned short *)0x622)
#define TMDF3_11H1     (*(volatile __near unsigned short *)0x622)
#define RMD14_11H0     (*(volatile __near unsigned short *)0x622)
#define RMD14_11H1     (*(volatile __near unsigned short *)0x622)
#define RPGACC40H0     (*(volatile __near unsigned short *)0x622)
#define RPGACC40H1     (*(volatile __near unsigned short *)0x622)
#define RMD6_11H1      (*(volatile __near unsigned short *)0x622)
#define RMD6_11H0      (*(volatile __near unsigned short *)0x622)
#define TMDF3_11H0L    (*(volatile __near unsigned char  *)0x622)
#define TMDF3_11H1L    (*(volatile __near unsigned char  *)0x622)
#define RMD14_11H1L    (*(volatile __near unsigned char  *)0x622)
#define RMD14_11H0L    (*(volatile __near unsigned char  *)0x622)
#define RMD6_11H1L     (*(volatile __near unsigned char  *)0x622)
#define RMD6_11H0L     (*(volatile __near unsigned char  *)0x622)
#define RPGACC40H1L    (*(volatile __near unsigned char  *)0x622)
#define RPGACC40H0L    (*(volatile __near unsigned char  *)0x622)
#define TMDF3_11H0H    (*(volatile __near unsigned char  *)0x623)
#define TMDF3_11H1H    (*(volatile __near unsigned char  *)0x623)
#define RMD14_11H0H    (*(volatile __near unsigned char  *)0x623)
#define RMD14_11H1H    (*(volatile __near unsigned char  *)0x623)
#define RMD6_11H1H     (*(volatile __near unsigned char  *)0x623)
#define RMD6_11H0H     (*(volatile __near unsigned char  *)0x623)
#define RPGACC40H0H    (*(volatile __near unsigned char  *)0x623)
#define RPGACC40H1H    (*(volatile __near unsigned char  *)0x623)
#define TMDF3_12L0     (*(volatile __near unsigned short *)0x624)
#define TMDF3_12L1     (*(volatile __near unsigned short *)0x624)
#define RMD14_12L0     (*(volatile __near unsigned short *)0x624)
#define RMD14_12L1     (*(volatile __near unsigned short *)0x624)
#define RMD6_12L1      (*(volatile __near unsigned short *)0x624)
#define RPGACC41L0     (*(volatile __near unsigned short *)0x624)
#define RPGACC41L1     (*(volatile __near unsigned short *)0x624)
#define RMD6_12L0      (*(volatile __near unsigned short *)0x624)
#define TMDF3_12L0L    (*(volatile __near unsigned char  *)0x624)
#define RMD14_12L0L    (*(volatile __near unsigned char  *)0x624)
#define TMDF3_12L1L    (*(volatile __near unsigned char  *)0x624)
#define RMD14_12L1L    (*(volatile __near unsigned char  *)0x624)
#define RPGACC41L1L    (*(volatile __near unsigned char  *)0x624)
#define RMD6_12L1L     (*(volatile __near unsigned char  *)0x624)
#define RPGACC41L0L    (*(volatile __near unsigned char  *)0x624)
#define RMD6_12L0L     (*(volatile __near unsigned char  *)0x624)
#define TMDF3_12L0H    (*(volatile __near unsigned char  *)0x625)
#define TMDF3_12L1H    (*(volatile __near unsigned char  *)0x625)
#define RMD14_12L1H    (*(volatile __near unsigned char  *)0x625)
#define RMD14_12L0H    (*(volatile __near unsigned char  *)0x625)
#define RMD6_12L0H     (*(volatile __near unsigned char  *)0x625)
#define RMD6_12L1H     (*(volatile __near unsigned char  *)0x625)
#define RPGACC41L0H    (*(volatile __near unsigned char  *)0x625)
#define RPGACC41L1H    (*(volatile __near unsigned char  *)0x625)
#define TMDF3_12H0     (*(volatile __near unsigned short *)0x626)
#define TMDF3_12H1     (*(volatile __near unsigned short *)0x626)
#define RMD14_12H0     (*(volatile __near unsigned short *)0x626)
#define RMD14_12H1     (*(volatile __near unsigned short *)0x626)
#define RMD6_12H1      (*(volatile __near unsigned short *)0x626)
#define RMD6_12H0      (*(volatile __near unsigned short *)0x626)
#define RPGACC41H1     (*(volatile __near unsigned short *)0x626)
#define RPGACC41H0     (*(volatile __near unsigned short *)0x626)
#define TMDF3_12H0L    (*(volatile __near unsigned char  *)0x626)
#define TMDF3_12H1L    (*(volatile __near unsigned char  *)0x626)
#define RMD14_12H1L    (*(volatile __near unsigned char  *)0x626)
#define RMD14_12H0L    (*(volatile __near unsigned char  *)0x626)
#define RPGACC41H0L    (*(volatile __near unsigned char  *)0x626)
#define RMD6_12H0L     (*(volatile __near unsigned char  *)0x626)
#define RPGACC41H1L    (*(volatile __near unsigned char  *)0x626)
#define RMD6_12H1L     (*(volatile __near unsigned char  *)0x626)
#define TMDF3_12H0H    (*(volatile __near unsigned char  *)0x627)
#define TMDF3_12H1H    (*(volatile __near unsigned char  *)0x627)
#define RMD14_12H1H    (*(volatile __near unsigned char  *)0x627)
#define RMD14_12H0H    (*(volatile __near unsigned char  *)0x627)
#define RPGACC41H1H    (*(volatile __near unsigned char  *)0x627)
#define RPGACC41H0H    (*(volatile __near unsigned char  *)0x627)
#define RMD6_12H1H     (*(volatile __near unsigned char  *)0x627)
#define RMD6_12H0H     (*(volatile __near unsigned char  *)0x627)
#define RMD14_13L1     (*(volatile __near unsigned short *)0x628)
#define RMD14_13L0     (*(volatile __near unsigned short *)0x628)
#define TMDF3_13L1     (*(volatile __near unsigned short *)0x628)
#define TMDF3_13L0     (*(volatile __near unsigned short *)0x628)
#define RPGACC42L1     (*(volatile __near unsigned short *)0x628)
#define RPGACC42L0     (*(volatile __near unsigned short *)0x628)
#define RMD6_13L0      (*(volatile __near unsigned short *)0x628)
#define RMD6_13L1      (*(volatile __near unsigned short *)0x628)
#define RMD14_13L0L    (*(volatile __near unsigned char  *)0x628)
#define RMD14_13L1L    (*(volatile __near unsigned char  *)0x628)
#define TMDF3_13L1L    (*(volatile __near unsigned char  *)0x628)
#define TMDF3_13L0L    (*(volatile __near unsigned char  *)0x628)
#define RPGACC42L0L    (*(volatile __near unsigned char  *)0x628)
#define RMD6_13L0L     (*(volatile __near unsigned char  *)0x628)
#define RMD6_13L1L     (*(volatile __near unsigned char  *)0x628)
#define RPGACC42L1L    (*(volatile __near unsigned char  *)0x628)
#define RMD14_13L1H    (*(volatile __near unsigned char  *)0x629)
#define TMDF3_13L1H    (*(volatile __near unsigned char  *)0x629)
#define TMDF3_13L0H    (*(volatile __near unsigned char  *)0x629)
#define RMD14_13L0H    (*(volatile __near unsigned char  *)0x629)
#define RPGACC42L0H    (*(volatile __near unsigned char  *)0x629)
#define RPGACC42L1H    (*(volatile __near unsigned char  *)0x629)
#define RMD6_13L0H     (*(volatile __near unsigned char  *)0x629)
#define RMD6_13L1H     (*(volatile __near unsigned char  *)0x629)
#define RMD14_13H0     (*(volatile __near unsigned short *)0x62A)
#define RMD14_13H1     (*(volatile __near unsigned short *)0x62A)
#define TMDF3_13H1     (*(volatile __near unsigned short *)0x62A)
#define TMDF3_13H0     (*(volatile __near unsigned short *)0x62A)
#define RPGACC42H1     (*(volatile __near unsigned short *)0x62A)
#define RPGACC42H0     (*(volatile __near unsigned short *)0x62A)
#define RMD6_13H0      (*(volatile __near unsigned short *)0x62A)
#define RMD6_13H1      (*(volatile __near unsigned short *)0x62A)
#define RMD14_13H0L    (*(volatile __near unsigned char  *)0x62A)
#define RMD14_13H1L    (*(volatile __near unsigned char  *)0x62A)
#define TMDF3_13H1L    (*(volatile __near unsigned char  *)0x62A)
#define TMDF3_13H0L    (*(volatile __near unsigned char  *)0x62A)
#define RPGACC42H0L    (*(volatile __near unsigned char  *)0x62A)
#define RPGACC42H1L    (*(volatile __near unsigned char  *)0x62A)
#define RMD6_13H0L     (*(volatile __near unsigned char  *)0x62A)
#define RMD6_13H1L     (*(volatile __near unsigned char  *)0x62A)
#define RMD14_13H1H    (*(volatile __near unsigned char  *)0x62B)
#define RMD14_13H0H    (*(volatile __near unsigned char  *)0x62B)
#define TMDF3_13H0H    (*(volatile __near unsigned char  *)0x62B)
#define TMDF3_13H1H    (*(volatile __near unsigned char  *)0x62B)
#define RPGACC42H0H    (*(volatile __near unsigned char  *)0x62B)
#define RPGACC42H1H    (*(volatile __near unsigned char  *)0x62B)
#define RMD6_13H0H     (*(volatile __near unsigned char  *)0x62B)
#define RMD6_13H1H     (*(volatile __near unsigned char  *)0x62B)
#define RMD14_14L1     (*(volatile __near unsigned short *)0x62C)
#define RMD14_14L0     (*(volatile __near unsigned short *)0x62C)
#define TMDF3_14L1     (*(volatile __near unsigned short *)0x62C)
#define TMDF3_14L0     (*(volatile __near unsigned short *)0x62C)
#define RPGACC43L0     (*(volatile __near unsigned short *)0x62C)
#define RMD6_14L1      (*(volatile __near unsigned short *)0x62C)
#define RMD6_14L0      (*(volatile __near unsigned short *)0x62C)
#define RPGACC43L1     (*(volatile __near unsigned short *)0x62C)
#define RMD14_14L1L    (*(volatile __near unsigned char  *)0x62C)
#define RMD14_14L0L    (*(volatile __near unsigned char  *)0x62C)
#define TMDF3_14L1L    (*(volatile __near unsigned char  *)0x62C)
#define TMDF3_14L0L    (*(volatile __near unsigned char  *)0x62C)
#define RPGACC43L1L    (*(volatile __near unsigned char  *)0x62C)
#define RMD6_14L1L     (*(volatile __near unsigned char  *)0x62C)
#define RPGACC43L0L    (*(volatile __near unsigned char  *)0x62C)
#define RMD6_14L0L     (*(volatile __near unsigned char  *)0x62C)
#define RMD14_14L1H    (*(volatile __near unsigned char  *)0x62D)
#define RMD14_14L0H    (*(volatile __near unsigned char  *)0x62D)
#define TMDF3_14L1H    (*(volatile __near unsigned char  *)0x62D)
#define TMDF3_14L0H    (*(volatile __near unsigned char  *)0x62D)
#define RPGACC43L1H    (*(volatile __near unsigned char  *)0x62D)
#define RMD6_14L0H     (*(volatile __near unsigned char  *)0x62D)
#define RPGACC43L0H    (*(volatile __near unsigned char  *)0x62D)
#define RMD6_14L1H     (*(volatile __near unsigned char  *)0x62D)
#define RMD14_14H1     (*(volatile __near unsigned short *)0x62E)
#define RMD14_14H0     (*(volatile __near unsigned short *)0x62E)
#define TMDF3_14H1     (*(volatile __near unsigned short *)0x62E)
#define TMDF3_14H0     (*(volatile __near unsigned short *)0x62E)
#define RMD6_14H0      (*(volatile __near unsigned short *)0x62E)
#define RMD6_14H1      (*(volatile __near unsigned short *)0x62E)
#define RPGACC43H1     (*(volatile __near unsigned short *)0x62E)
#define RPGACC43H0     (*(volatile __near unsigned short *)0x62E)
#define RMD14_14H1L    (*(volatile __near unsigned char  *)0x62E)
#define RMD14_14H0L    (*(volatile __near unsigned char  *)0x62E)
#define TMDF3_14H1L    (*(volatile __near unsigned char  *)0x62E)
#define TMDF3_14H0L    (*(volatile __near unsigned char  *)0x62E)
#define RPGACC43H1L    (*(volatile __near unsigned char  *)0x62E)
#define RMD6_14H0L     (*(volatile __near unsigned char  *)0x62E)
#define RMD6_14H1L     (*(volatile __near unsigned char  *)0x62E)
#define RPGACC43H0L    (*(volatile __near unsigned char  *)0x62E)
#define RMD14_14H1H    (*(volatile __near unsigned char  *)0x62F)
#define RMD14_14H0H    (*(volatile __near unsigned char  *)0x62F)
#define TMDF3_14H0H    (*(volatile __near unsigned char  *)0x62F)
#define TMDF3_14H1H    (*(volatile __near unsigned char  *)0x62F)
#define RMD6_14H0H     (*(volatile __near unsigned char  *)0x62F)
#define RMD6_14H1H     (*(volatile __near unsigned char  *)0x62F)
#define RPGACC43H0H    (*(volatile __near unsigned char  *)0x62F)
#define RPGACC43H1H    (*(volatile __near unsigned char  *)0x62F)
#define RMD14_15L0     (*(volatile __near unsigned short *)0x630)
#define TMDF3_15L0     (*(volatile __near unsigned short *)0x630)
#define RMD14_15L1     (*(volatile __near unsigned short *)0x630)
#define TMDF3_15L1     (*(volatile __near unsigned short *)0x630)
#define RMD6_15L1      (*(volatile __near unsigned short *)0x630)
#define RMD6_15L0      (*(volatile __near unsigned short *)0x630)
#define RPGACC44L0     (*(volatile __near unsigned short *)0x630)
#define RPGACC44L1     (*(volatile __near unsigned short *)0x630)
#define TMDF3_15L1L    (*(volatile __near unsigned char  *)0x630)
#define RMD14_15L0L    (*(volatile __near unsigned char  *)0x630)
#define TMDF3_15L0L    (*(volatile __near unsigned char  *)0x630)
#define RMD14_15L1L    (*(volatile __near unsigned char  *)0x630)
#define RPGACC44L0L    (*(volatile __near unsigned char  *)0x630)
#define RMD6_15L0L     (*(volatile __near unsigned char  *)0x630)
#define RMD6_15L1L     (*(volatile __near unsigned char  *)0x630)
#define RPGACC44L1L    (*(volatile __near unsigned char  *)0x630)
#define RMD14_15L0H    (*(volatile __near unsigned char  *)0x631)
#define TMDF3_15L0H    (*(volatile __near unsigned char  *)0x631)
#define TMDF3_15L1H    (*(volatile __near unsigned char  *)0x631)
#define RMD14_15L1H    (*(volatile __near unsigned char  *)0x631)
#define RPGACC44L0H    (*(volatile __near unsigned char  *)0x631)
#define RMD6_15L1H     (*(volatile __near unsigned char  *)0x631)
#define RPGACC44L1H    (*(volatile __near unsigned char  *)0x631)
#define RMD6_15L0H     (*(volatile __near unsigned char  *)0x631)
#define TMDF3_15H0     (*(volatile __near unsigned short *)0x632)
#define TMDF3_15H1     (*(volatile __near unsigned short *)0x632)
#define RMD14_15H0     (*(volatile __near unsigned short *)0x632)
#define RMD14_15H1     (*(volatile __near unsigned short *)0x632)
#define RMD6_15H0      (*(volatile __near unsigned short *)0x632)
#define RMD6_15H1      (*(volatile __near unsigned short *)0x632)
#define RPGACC44H1     (*(volatile __near unsigned short *)0x632)
#define RPGACC44H0     (*(volatile __near unsigned short *)0x632)
#define TMDF3_15H0L    (*(volatile __near unsigned char  *)0x632)
#define RMD14_15H1L    (*(volatile __near unsigned char  *)0x632)
#define TMDF3_15H1L    (*(volatile __near unsigned char  *)0x632)
#define RMD14_15H0L    (*(volatile __near unsigned char  *)0x632)
#define RMD6_15H0L     (*(volatile __near unsigned char  *)0x632)
#define RPGACC44H1L    (*(volatile __near unsigned char  *)0x632)
#define RMD6_15H1L     (*(volatile __near unsigned char  *)0x632)
#define RPGACC44H0L    (*(volatile __near unsigned char  *)0x632)
#define RMD14_15H1H    (*(volatile __near unsigned char  *)0x633)
#define RMD14_15H0H    (*(volatile __near unsigned char  *)0x633)
#define TMDF3_15H1H    (*(volatile __near unsigned char  *)0x633)
#define TMDF3_15H0H    (*(volatile __near unsigned char  *)0x633)
#define RPGACC44H1H    (*(volatile __near unsigned char  *)0x633)
#define RPGACC44H0H    (*(volatile __near unsigned char  *)0x633)
#define RMD6_15H1H     (*(volatile __near unsigned char  *)0x633)
#define RMD6_15H0H     (*(volatile __near unsigned char  *)0x633)
#define RMID15L1       (*(volatile __near unsigned short *)0x634)
#define RMID7L0        (*(volatile __near unsigned short *)0x634)
#define RMID7L1        (*(volatile __near unsigned short *)0x634)
#define RMID15L0       (*(volatile __near unsigned short *)0x634)
#define RPGACC45L1     (*(volatile __near unsigned short *)0x634)
#define RPGACC45L0     (*(volatile __near unsigned short *)0x634)
#define RMID15L1L      (*(volatile __near unsigned char  *)0x634)
#define RMID15L0L      (*(volatile __near unsigned char  *)0x634)
#define RMID7L1L       (*(volatile __near unsigned char  *)0x634)
#define RPGACC45L1L    (*(volatile __near unsigned char  *)0x634)
#define RPGACC45L0L    (*(volatile __near unsigned char  *)0x634)
#define RMID7L0L       (*(volatile __near unsigned char  *)0x634)
#define RMID15L1H      (*(volatile __near unsigned char  *)0x635)
#define RMID7L1H       (*(volatile __near unsigned char  *)0x635)
#define RMID15L0H      (*(volatile __near unsigned char  *)0x635)
#define RMID7L0H       (*(volatile __near unsigned char  *)0x635)
#define RPGACC45L0H    (*(volatile __near unsigned char  *)0x635)
#define RPGACC45L1H    (*(volatile __near unsigned char  *)0x635)
#define RPGACC45H1     (*(volatile __near unsigned short *)0x636)
#define RPGACC45H0     (*(volatile __near unsigned short *)0x636)
#define RMID15H1       (*(volatile __near unsigned short *)0x636)
#define RMID15H0       (*(volatile __near unsigned short *)0x636)
#define RMID7H1        (*(volatile __near unsigned short *)0x636)
#define RMID7H0        (*(volatile __near unsigned short *)0x636)
#define RPGACC45H0L    (*(volatile __near unsigned char  *)0x636)
#define RPGACC45H1L    (*(volatile __near unsigned char  *)0x636)
#define RMID7H1L       (*(volatile __near unsigned char  *)0x636)
#define RMID7H0L       (*(volatile __near unsigned char  *)0x636)
#define RMID15H1L      (*(volatile __near unsigned char  *)0x636)
#define RMID15H0L      (*(volatile __near unsigned char  *)0x636)
#define RPGACC45H0H    (*(volatile __near unsigned char  *)0x637)
#define RPGACC45H1H    (*(volatile __near unsigned char  *)0x637)
#define RMID7H1H       (*(volatile __near unsigned char  *)0x637)
#define RMID7H0H       (*(volatile __near unsigned char  *)0x637)
#define RMID15H1H      (*(volatile __near unsigned char  *)0x637)
#define RMID15H0H      (*(volatile __near unsigned char  *)0x637)
#define RMPTR15L0      (*(volatile __near unsigned short *)0x638)
#define RMPTR15L1      (*(volatile __near unsigned short *)0x638)
#define RMPTR7L0       (*(volatile __near unsigned short *)0x638)
#define RMPTR7L1       (*(volatile __near unsigned short *)0x638)
#define RPGACC46L1     (*(volatile __near unsigned short *)0x638)
#define RPGACC46L0     (*(volatile __near unsigned short *)0x638)
#define RMPTR15L0L     (*(volatile __near unsigned char  *)0x638)
#define RMPTR7L0L      (*(volatile __near unsigned char  *)0x638)
#define RMPTR7L1L      (*(volatile __near unsigned char  *)0x638)
#define RMPTR15L1L     (*(volatile __near unsigned char  *)0x638)
#define RPGACC46L1L    (*(volatile __near unsigned char  *)0x638)
#define RPGACC46L0L    (*(volatile __near unsigned char  *)0x638)
#define RMPTR15L1H     (*(volatile __near unsigned char  *)0x639)
#define RMPTR15L0H     (*(volatile __near unsigned char  *)0x639)
#define RMPTR7L0H      (*(volatile __near unsigned char  *)0x639)
#define RMPTR7L1H      (*(volatile __near unsigned char  *)0x639)
#define RPGACC46L1H    (*(volatile __near unsigned char  *)0x639)
#define RPGACC46L0H    (*(volatile __near unsigned char  *)0x639)
#define RMPTR7H1       (*(volatile __near unsigned short *)0x63A)
#define RMPTR7H0       (*(volatile __near unsigned short *)0x63A)
#define RMPTR15H1      (*(volatile __near unsigned short *)0x63A)
#define RPGACC46H1     (*(volatile __near unsigned short *)0x63A)
#define RMPTR15H0      (*(volatile __near unsigned short *)0x63A)
#define RPGACC46H0     (*(volatile __near unsigned short *)0x63A)
#define RPGACC46H0L    (*(volatile __near unsigned char  *)0x63A)
#define RPGACC46H1L    (*(volatile __near unsigned char  *)0x63A)
#define RMPTR7H0H      (*(volatile __near unsigned char  *)0x63B)
#define RMPTR7H1H      (*(volatile __near unsigned char  *)0x63B)
#define RMPTR15H1H     (*(volatile __near unsigned char  *)0x63B)
#define RMPTR15H0H     (*(volatile __near unsigned char  *)0x63B)
#define RPGACC46H0H    (*(volatile __near unsigned char  *)0x63B)
#define RPGACC46H1H    (*(volatile __near unsigned char  *)0x63B)
#define RMSTS7L1       (*(volatile __near unsigned short *)0x63C)
#define RMSTS7L0       (*(volatile __near unsigned short *)0x63C)
#define RPGACC47L0     (*(volatile __near unsigned short *)0x63C)
#define RPGACC47L1     (*(volatile __near unsigned short *)0x63C)
#define RMSTS15L0      (*(volatile __near unsigned short *)0x63C)
#define RMSTS15L1      (*(volatile __near unsigned short *)0x63C)
#define RMSTS7L1L      (*(volatile __near unsigned char  *)0x63C)
#define RMSTS7L0L      (*(volatile __near unsigned char  *)0x63C)
#define RPGACC47L0L    (*(volatile __near unsigned char  *)0x63C)
#define RPGACC47L1L    (*(volatile __near unsigned char  *)0x63C)
#define RMSTS15L1L     (*(volatile __near unsigned char  *)0x63C)
#define RMSTS15L0L     (*(volatile __near unsigned char  *)0x63C)
#define RMSTS7L1H      (*(volatile __near unsigned char  *)0x63D)
#define RMSTS7L0H      (*(volatile __near unsigned char  *)0x63D)
#define RPGACC47L0H    (*(volatile __near unsigned char  *)0x63D)
#define RPGACC47L1H    (*(volatile __near unsigned char  *)0x63D)
#define RMSTS15L1H     (*(volatile __near unsigned char  *)0x63D)
#define RMSTS15L0H     (*(volatile __near unsigned char  *)0x63D)
#define RMSTS7H1       (*(volatile __near unsigned short *)0x63E)
#define RPGACC47H1     (*(volatile __near unsigned short *)0x63E)
#define RMSTS15H0      (*(volatile __near unsigned short *)0x63E)
#define RMSTS15H1      (*(volatile __near unsigned short *)0x63E)
#define RPGACC47H0     (*(volatile __near unsigned short *)0x63E)
#define RMSTS7H0       (*(volatile __near unsigned short *)0x63E)
#define RMSTS15H0L     (*(volatile __near unsigned char  *)0x63E)
#define RMSTS7H0L      (*(volatile __near unsigned char  *)0x63E)
#define RMSTS7H1L      (*(volatile __near unsigned char  *)0x63E)
#define RMSTS15H1L     (*(volatile __near unsigned char  *)0x63E)
#define RPGACC47H0L    (*(volatile __near unsigned char  *)0x63E)
#define RPGACC47H1L    (*(volatile __near unsigned char  *)0x63E)
#define RPGACC47H1H    (*(volatile __near unsigned char  *)0x63F)
#define RMSTS7H1H      (*(volatile __near unsigned char  *)0x63F)
#define RMSTS15H1H     (*(volatile __near unsigned char  *)0x63F)
#define RPGACC47H0H    (*(volatile __near unsigned char  *)0x63F)
#define RMSTS15H0H     (*(volatile __near unsigned char  *)0x63F)
#define RMSTS7H0H      (*(volatile __near unsigned char  *)0x63F)
#define RMD15_0L0      (*(volatile __near unsigned short *)0x640)
#define RMD15_0L1      (*(volatile __near unsigned short *)0x640)
#define RPGACC48L1     (*(volatile __near unsigned short *)0x640)
#define RMD7_0L1       (*(volatile __near unsigned short *)0x640)
#define RMD7_0L0       (*(volatile __near unsigned short *)0x640)
#define RPGACC48L0     (*(volatile __near unsigned short *)0x640)
#define THLACC0L0      (*(volatile __near unsigned short *)0x640)
#define THLACC0L1      (*(volatile __near unsigned short *)0x640)
#define RMD15_0L1L     (*(volatile __near unsigned char  *)0x640)
#define RMD15_0L0L     (*(volatile __near unsigned char  *)0x640)
#define RMD7_0L0L      (*(volatile __near unsigned char  *)0x640)
#define RMD7_0L1L      (*(volatile __near unsigned char  *)0x640)
#define RPGACC48L1L    (*(volatile __near unsigned char  *)0x640)
#define RPGACC48L0L    (*(volatile __near unsigned char  *)0x640)
#define THLACC0L1L     (*(volatile __near unsigned char  *)0x640)
#define THLACC0L0L     (*(volatile __near unsigned char  *)0x640)
#define RMD15_0L0H     (*(volatile __near unsigned char  *)0x641)
#define RMD15_0L1H     (*(volatile __near unsigned char  *)0x641)
#define RMD7_0L1H      (*(volatile __near unsigned char  *)0x641)
#define RMD7_0L0H      (*(volatile __near unsigned char  *)0x641)
#define RPGACC48L0H    (*(volatile __near unsigned char  *)0x641)
#define RPGACC48L1H    (*(volatile __near unsigned char  *)0x641)
#define RMD15_0H0      (*(volatile __near unsigned short *)0x642)
#define RMD15_0H1      (*(volatile __near unsigned short *)0x642)
#define RPGACC48H0     (*(volatile __near unsigned short *)0x642)
#define RPGACC48H1     (*(volatile __near unsigned short *)0x642)
#define RMD7_0H1       (*(volatile __near unsigned short *)0x642)
#define RMD7_0H0       (*(volatile __near unsigned short *)0x642)
#define THLACC0H1      (*(volatile __near unsigned short *)0x642)
#define THLACC0H0      (*(volatile __near unsigned short *)0x642)
#define RMD15_0H0L     (*(volatile __near unsigned char  *)0x642)
#define RMD15_0H1L     (*(volatile __near unsigned char  *)0x642)
#define RPGACC48H1L    (*(volatile __near unsigned char  *)0x642)
#define RPGACC48H0L    (*(volatile __near unsigned char  *)0x642)
#define RMD7_0H0L      (*(volatile __near unsigned char  *)0x642)
#define RMD7_0H1L      (*(volatile __near unsigned char  *)0x642)
#define THLACC0H1L     (*(volatile __near unsigned char  *)0x642)
#define THLACC0H0L     (*(volatile __near unsigned char  *)0x642)
#define RMD15_0H1H     (*(volatile __near unsigned char  *)0x643)
#define RMD15_0H0H     (*(volatile __near unsigned char  *)0x643)
#define RPGACC48H1H    (*(volatile __near unsigned char  *)0x643)
#define RMD7_0H0H      (*(volatile __near unsigned char  *)0x643)
#define RPGACC48H0H    (*(volatile __near unsigned char  *)0x643)
#define RMD7_0H1H      (*(volatile __near unsigned char  *)0x643)
#define THLACC0H0H     (*(volatile __near unsigned char  *)0x643)
#define THLACC0H1H     (*(volatile __near unsigned char  *)0x643)
#define RMD15_1L1      (*(volatile __near unsigned short *)0x644)
#define RMD15_1L0      (*(volatile __near unsigned short *)0x644)
#define RMD7_1L1       (*(volatile __near unsigned short *)0x644)
#define RMD7_1L0       (*(volatile __near unsigned short *)0x644)
#define RPGACC49L0     (*(volatile __near unsigned short *)0x644)
#define RPGACC49L1     (*(volatile __near unsigned short *)0x644)
#define THLACC1L1      (*(volatile __near unsigned short *)0x644)
#define THLACC1L0      (*(volatile __near unsigned short *)0x644)
#define RMD15_1L0L     (*(volatile __near unsigned char  *)0x644)
#define RMD15_1L1L     (*(volatile __near unsigned char  *)0x644)
#define RPGACC49L0L    (*(volatile __near unsigned char  *)0x644)
#define RMD7_1L0L      (*(volatile __near unsigned char  *)0x644)
#define RPGACC49L1L    (*(volatile __near unsigned char  *)0x644)
#define RMD7_1L1L      (*(volatile __near unsigned char  *)0x644)
#define THLACC1L1L     (*(volatile __near unsigned char  *)0x644)
#define THLACC1L0L     (*(volatile __near unsigned char  *)0x644)
#define RMD15_1L1H     (*(volatile __near unsigned char  *)0x645)
#define RMD15_1L0H     (*(volatile __near unsigned char  *)0x645)
#define RMD7_1L1H      (*(volatile __near unsigned char  *)0x645)
#define RPGACC49L0H    (*(volatile __near unsigned char  *)0x645)
#define RMD7_1L0H      (*(volatile __near unsigned char  *)0x645)
#define RPGACC49L1H    (*(volatile __near unsigned char  *)0x645)
#define THLACC1L0H     (*(volatile __near unsigned char  *)0x645)
#define THLACC1L1H     (*(volatile __near unsigned char  *)0x645)
#define RMD15_1H1      (*(volatile __near unsigned short *)0x646)
#define RMD15_1H0      (*(volatile __near unsigned short *)0x646)
#define RPGACC49H1     (*(volatile __near unsigned short *)0x646)
#define RMD7_1H0       (*(volatile __near unsigned short *)0x646)
#define RPGACC49H0     (*(volatile __near unsigned short *)0x646)
#define RMD7_1H1       (*(volatile __near unsigned short *)0x646)
#define THLACC1H0      (*(volatile __near unsigned short *)0x646)
#define THLACC1H1      (*(volatile __near unsigned short *)0x646)
#define RMD15_1H0L     (*(volatile __near unsigned char  *)0x646)
#define RMD15_1H1L     (*(volatile __near unsigned char  *)0x646)
#define RPGACC49H0L    (*(volatile __near unsigned char  *)0x646)
#define RPGACC49H1L    (*(volatile __near unsigned char  *)0x646)
#define RMD7_1H0L      (*(volatile __near unsigned char  *)0x646)
#define RMD7_1H1L      (*(volatile __near unsigned char  *)0x646)
#define THLACC1H0L     (*(volatile __near unsigned char  *)0x646)
#define THLACC1H1L     (*(volatile __near unsigned char  *)0x646)
#define RMD15_1H0H     (*(volatile __near unsigned char  *)0x647)
#define RMD15_1H1H     (*(volatile __near unsigned char  *)0x647)
#define RPGACC49H1H    (*(volatile __near unsigned char  *)0x647)
#define RPGACC49H0H    (*(volatile __near unsigned char  *)0x647)
#define RMD7_1H1H      (*(volatile __near unsigned char  *)0x647)
#define RMD7_1H0H      (*(volatile __near unsigned char  *)0x647)
#define RMD15_2L1      (*(volatile __near unsigned short *)0x648)
#define RMD15_2L0      (*(volatile __near unsigned short *)0x648)
#define RPGACC50L0     (*(volatile __near unsigned short *)0x648)
#define RMD7_2L0       (*(volatile __near unsigned short *)0x648)
#define RPGACC50L1     (*(volatile __near unsigned short *)0x648)
#define RMD7_2L1       (*(volatile __near unsigned short *)0x648)
#define RMD15_2L0L     (*(volatile __near unsigned char  *)0x648)
#define RMD15_2L1L     (*(volatile __near unsigned char  *)0x648)
#define RPGACC50L0L    (*(volatile __near unsigned char  *)0x648)
#define RPGACC50L1L    (*(volatile __near unsigned char  *)0x648)
#define RMD7_2L0L      (*(volatile __near unsigned char  *)0x648)
#define RMD7_2L1L      (*(volatile __near unsigned char  *)0x648)
#define RMD15_2L1H     (*(volatile __near unsigned char  *)0x649)
#define RMD15_2L0H     (*(volatile __near unsigned char  *)0x649)
#define RPGACC50L1H    (*(volatile __near unsigned char  *)0x649)
#define RPGACC50L0H    (*(volatile __near unsigned char  *)0x649)
#define RMD7_2L1H      (*(volatile __near unsigned char  *)0x649)
#define RMD7_2L0H      (*(volatile __near unsigned char  *)0x649)
#define RMD15_2H1      (*(volatile __near unsigned short *)0x64A)
#define RMD15_2H0      (*(volatile __near unsigned short *)0x64A)
#define RPGACC50H0     (*(volatile __near unsigned short *)0x64A)
#define RMD7_2H1       (*(volatile __near unsigned short *)0x64A)
#define RMD7_2H0       (*(volatile __near unsigned short *)0x64A)
#define RPGACC50H1     (*(volatile __near unsigned short *)0x64A)
#define RMD15_2H0L     (*(volatile __near unsigned char  *)0x64A)
#define RMD15_2H1L     (*(volatile __near unsigned char  *)0x64A)
#define RMD7_2H0L      (*(volatile __near unsigned char  *)0x64A)
#define RPGACC50H0L    (*(volatile __near unsigned char  *)0x64A)
#define RMD7_2H1L      (*(volatile __near unsigned char  *)0x64A)
#define RPGACC50H1L    (*(volatile __near unsigned char  *)0x64A)
#define RMD15_2H0H     (*(volatile __near unsigned char  *)0x64B)
#define RMD15_2H1H     (*(volatile __near unsigned char  *)0x64B)
#define RMD7_2H1H      (*(volatile __near unsigned char  *)0x64B)
#define RMD7_2H0H      (*(volatile __near unsigned char  *)0x64B)
#define RPGACC50H0H    (*(volatile __near unsigned char  *)0x64B)
#define RPGACC50H1H    (*(volatile __near unsigned char  *)0x64B)
#define RPGACC51L0     (*(volatile __near unsigned short *)0x64C)
#define RMD7_3L0       (*(volatile __near unsigned short *)0x64C)
#define RPGACC51L1     (*(volatile __near unsigned short *)0x64C)
#define RMD15_3L1      (*(volatile __near unsigned short *)0x64C)
#define RMD7_3L1       (*(volatile __near unsigned short *)0x64C)
#define RMD15_3L0      (*(volatile __near unsigned short *)0x64C)
#define RPGACC51L0L    (*(volatile __near unsigned char  *)0x64C)
#define RPGACC51L1L    (*(volatile __near unsigned char  *)0x64C)
#define RMD15_3L1L     (*(volatile __near unsigned char  *)0x64C)
#define RMD7_3L1L      (*(volatile __near unsigned char  *)0x64C)
#define RMD7_3L0L      (*(volatile __near unsigned char  *)0x64C)
#define RMD15_3L0L     (*(volatile __near unsigned char  *)0x64C)
#define RMD15_3L1H     (*(volatile __near unsigned char  *)0x64D)
#define RPGACC51L0H    (*(volatile __near unsigned char  *)0x64D)
#define RMD7_3L1H      (*(volatile __near unsigned char  *)0x64D)
#define RMD15_3L0H     (*(volatile __near unsigned char  *)0x64D)
#define RMD7_3L0H      (*(volatile __near unsigned char  *)0x64D)
#define RPGACC51L1H    (*(volatile __near unsigned char  *)0x64D)
#define RMD15_3H0      (*(volatile __near unsigned short *)0x64E)
#define RMD7_3H0       (*(volatile __near unsigned short *)0x64E)
#define RMD15_3H1      (*(volatile __near unsigned short *)0x64E)
#define RPGACC51H0     (*(volatile __near unsigned short *)0x64E)
#define RMD7_3H1       (*(volatile __near unsigned short *)0x64E)
#define RPGACC51H1     (*(volatile __near unsigned short *)0x64E)
#define RMD7_3H0L      (*(volatile __near unsigned char  *)0x64E)
#define RMD7_3H1L      (*(volatile __near unsigned char  *)0x64E)
#define RMD15_3H0L     (*(volatile __near unsigned char  *)0x64E)
#define RPGACC51H1L    (*(volatile __near unsigned char  *)0x64E)
#define RPGACC51H0L    (*(volatile __near unsigned char  *)0x64E)
#define RMD15_3H1L     (*(volatile __near unsigned char  *)0x64E)
#define RMD7_3H0H      (*(volatile __near unsigned char  *)0x64F)
#define RMD7_3H1H      (*(volatile __near unsigned char  *)0x64F)
#define RMD15_3H1H     (*(volatile __near unsigned char  *)0x64F)
#define RPGACC51H1H    (*(volatile __near unsigned char  *)0x64F)
#define RPGACC51H0H    (*(volatile __near unsigned char  *)0x64F)
#define RMD15_3H0H     (*(volatile __near unsigned char  *)0x64F)
#define RPGACC52L1     (*(volatile __near unsigned short *)0x650)
#define RMD15_4L1      (*(volatile __near unsigned short *)0x650)
#define RMD15_4L0      (*(volatile __near unsigned short *)0x650)
#define RPGACC52L0     (*(volatile __near unsigned short *)0x650)
#define RMD7_4L1       (*(volatile __near unsigned short *)0x650)
#define RMD7_4L0       (*(volatile __near unsigned short *)0x650)
#define RPGACC52L1L    (*(volatile __near unsigned char  *)0x650)
#define RPGACC52L0L    (*(volatile __near unsigned char  *)0x650)
#define RMD15_4L1L     (*(volatile __near unsigned char  *)0x650)
#define RMD7_4L1L      (*(volatile __near unsigned char  *)0x650)
#define RMD7_4L0L      (*(volatile __near unsigned char  *)0x650)
#define RMD15_4L0L     (*(volatile __near unsigned char  *)0x650)
#define RPGACC52L1H    (*(volatile __near unsigned char  *)0x651)
#define RMD15_4L1H     (*(volatile __near unsigned char  *)0x651)
#define RPGACC52L0H    (*(volatile __near unsigned char  *)0x651)
#define RMD7_4L1H      (*(volatile __near unsigned char  *)0x651)
#define RMD7_4L0H      (*(volatile __near unsigned char  *)0x651)
#define RMD15_4L0H     (*(volatile __near unsigned char  *)0x651)
#define RMD15_4H1      (*(volatile __near unsigned short *)0x652)
#define RMD15_4H0      (*(volatile __near unsigned short *)0x652)
#define RMD7_4H1       (*(volatile __near unsigned short *)0x652)
#define RMD7_4H0       (*(volatile __near unsigned short *)0x652)
#define RPGACC52H1     (*(volatile __near unsigned short *)0x652)
#define RPGACC52H0     (*(volatile __near unsigned short *)0x652)
#define RMD15_4H0L     (*(volatile __near unsigned char  *)0x652)
#define RMD15_4H1L     (*(volatile __near unsigned char  *)0x652)
#define RMD7_4H1L      (*(volatile __near unsigned char  *)0x652)
#define RPGACC52H0L    (*(volatile __near unsigned char  *)0x652)
#define RPGACC52H1L    (*(volatile __near unsigned char  *)0x652)
#define RMD7_4H0L      (*(volatile __near unsigned char  *)0x652)
#define RMD15_4H0H     (*(volatile __near unsigned char  *)0x653)
#define RMD15_4H1H     (*(volatile __near unsigned char  *)0x653)
#define RMD7_4H0H      (*(volatile __near unsigned char  *)0x653)
#define RMD7_4H1H      (*(volatile __near unsigned char  *)0x653)
#define RPGACC52H0H    (*(volatile __near unsigned char  *)0x653)
#define RPGACC52H1H    (*(volatile __near unsigned char  *)0x653)
#define RPGACC53L1     (*(volatile __near unsigned short *)0x654)
#define RPGACC53L0     (*(volatile __near unsigned short *)0x654)
#define RMD7_5L0       (*(volatile __near unsigned short *)0x654)
#define RMD7_5L1       (*(volatile __near unsigned short *)0x654)
#define RMD15_5L0      (*(volatile __near unsigned short *)0x654)
#define RMD15_5L1      (*(volatile __near unsigned short *)0x654)
#define RPGACC53L1L    (*(volatile __near unsigned char  *)0x654)
#define RPGACC53L0L    (*(volatile __near unsigned char  *)0x654)
#define RMD7_5L0L      (*(volatile __near unsigned char  *)0x654)
#define RMD7_5L1L      (*(volatile __near unsigned char  *)0x654)
#define RMD15_5L0L     (*(volatile __near unsigned char  *)0x654)
#define RMD15_5L1L     (*(volatile __near unsigned char  *)0x654)
#define RPGACC53L1H    (*(volatile __near unsigned char  *)0x655)
#define RPGACC53L0H    (*(volatile __near unsigned char  *)0x655)
#define RMD15_5L0H     (*(volatile __near unsigned char  *)0x655)
#define RMD7_5L0H      (*(volatile __near unsigned char  *)0x655)
#define RMD7_5L1H      (*(volatile __near unsigned char  *)0x655)
#define RMD15_5L1H     (*(volatile __near unsigned char  *)0x655)
#define RPGACC53H1     (*(volatile __near unsigned short *)0x656)
#define RMD15_5H1      (*(volatile __near unsigned short *)0x656)
#define RMD15_5H0      (*(volatile __near unsigned short *)0x656)
#define RMD7_5H0       (*(volatile __near unsigned short *)0x656)
#define RMD7_5H1       (*(volatile __near unsigned short *)0x656)
#define RPGACC53H0     (*(volatile __near unsigned short *)0x656)
#define RMD15_5H0L     (*(volatile __near unsigned char  *)0x656)
#define RPGACC53H1L    (*(volatile __near unsigned char  *)0x656)
#define RPGACC53H0L    (*(volatile __near unsigned char  *)0x656)
#define RMD7_5H0L      (*(volatile __near unsigned char  *)0x656)
#define RMD7_5H1L      (*(volatile __near unsigned char  *)0x656)
#define RMD15_5H1L     (*(volatile __near unsigned char  *)0x656)
#define RMD15_5H0H     (*(volatile __near unsigned char  *)0x657)
#define RPGACC53H1H    (*(volatile __near unsigned char  *)0x657)
#define RMD7_5H0H      (*(volatile __near unsigned char  *)0x657)
#define RMD7_5H1H      (*(volatile __near unsigned char  *)0x657)
#define RPGACC53H0H    (*(volatile __near unsigned char  *)0x657)
#define RMD15_5H1H     (*(volatile __near unsigned char  *)0x657)
#define RMD15_6L0      (*(volatile __near unsigned short *)0x658)
#define RPGACC54L0     (*(volatile __near unsigned short *)0x658)
#define RMD15_6L1      (*(volatile __near unsigned short *)0x658)
#define RMD7_6L1       (*(volatile __near unsigned short *)0x658)
#define RPGACC54L1     (*(volatile __near unsigned short *)0x658)
#define RMD7_6L0       (*(volatile __near unsigned short *)0x658)
#define RPGACC54L0L    (*(volatile __near unsigned char  *)0x658)
#define RPGACC54L1L    (*(volatile __near unsigned char  *)0x658)
#define RMD15_6L0L     (*(volatile __near unsigned char  *)0x658)
#define RMD15_6L1L     (*(volatile __near unsigned char  *)0x658)
#define RMD7_6L1L      (*(volatile __near unsigned char  *)0x658)
#define RMD7_6L0L      (*(volatile __near unsigned char  *)0x658)
#define RMD15_6L0H     (*(volatile __near unsigned char  *)0x659)
#define RPGACC54L1H    (*(volatile __near unsigned char  *)0x659)
#define RPGACC54L0H    (*(volatile __near unsigned char  *)0x659)
#define RMD7_6L1H      (*(volatile __near unsigned char  *)0x659)
#define RMD7_6L0H      (*(volatile __near unsigned char  *)0x659)
#define RMD15_6L1H     (*(volatile __near unsigned char  *)0x659)
#define RMD7_6H1       (*(volatile __near unsigned short *)0x65A)
#define RPGACC54H1     (*(volatile __near unsigned short *)0x65A)
#define RMD7_6H0       (*(volatile __near unsigned short *)0x65A)
#define RMD15_6H1      (*(volatile __near unsigned short *)0x65A)
#define RMD15_6H0      (*(volatile __near unsigned short *)0x65A)
#define RPGACC54H0     (*(volatile __near unsigned short *)0x65A)
#define RPGACC54H0L    (*(volatile __near unsigned char  *)0x65A)
#define RMD7_6H1L      (*(volatile __near unsigned char  *)0x65A)
#define RMD15_6H1L     (*(volatile __near unsigned char  *)0x65A)
#define RPGACC54H1L    (*(volatile __near unsigned char  *)0x65A)
#define RMD7_6H0L      (*(volatile __near unsigned char  *)0x65A)
#define RMD15_6H0L     (*(volatile __near unsigned char  *)0x65A)
#define RMD15_6H1H     (*(volatile __near unsigned char  *)0x65B)
#define RPGACC54H1H    (*(volatile __near unsigned char  *)0x65B)
#define RMD15_6H0H     (*(volatile __near unsigned char  *)0x65B)
#define RMD7_6H1H      (*(volatile __near unsigned char  *)0x65B)
#define RMD7_6H0H      (*(volatile __near unsigned char  *)0x65B)
#define RPGACC54H0H    (*(volatile __near unsigned char  *)0x65B)
#define RMD15_7L1      (*(volatile __near unsigned short *)0x65C)
#define RPGACC55L1     (*(volatile __near unsigned short *)0x65C)
#define RMD15_7L0      (*(volatile __near unsigned short *)0x65C)
#define RMD7_7L1       (*(volatile __near unsigned short *)0x65C)
#define RMD7_7L0       (*(volatile __near unsigned short *)0x65C)
#define RPGACC55L0     (*(volatile __near unsigned short *)0x65C)
#define RMD15_7L1L     (*(volatile __near unsigned char  *)0x65C)
#define RMD15_7L0L     (*(volatile __near unsigned char  *)0x65C)
#define RPGACC55L1L    (*(volatile __near unsigned char  *)0x65C)
#define RMD7_7L0L      (*(volatile __near unsigned char  *)0x65C)
#define RPGACC55L0L    (*(volatile __near unsigned char  *)0x65C)
#define RMD7_7L1L      (*(volatile __near unsigned char  *)0x65C)
#define RMD7_7L0H      (*(volatile __near unsigned char  *)0x65D)
#define RMD7_7L1H      (*(volatile __near unsigned char  *)0x65D)
#define RPGACC55L0H    (*(volatile __near unsigned char  *)0x65D)
#define RPGACC55L1H    (*(volatile __near unsigned char  *)0x65D)
#define RMD15_7L1H     (*(volatile __near unsigned char  *)0x65D)
#define RMD15_7L0H     (*(volatile __near unsigned char  *)0x65D)
#define RPGACC55H1     (*(volatile __near unsigned short *)0x65E)
#define RMD7_7H0       (*(volatile __near unsigned short *)0x65E)
#define RMD15_7H1      (*(volatile __near unsigned short *)0x65E)
#define RMD15_7H0      (*(volatile __near unsigned short *)0x65E)
#define RMD7_7H1       (*(volatile __near unsigned short *)0x65E)
#define RPGACC55H0     (*(volatile __near unsigned short *)0x65E)
#define RMD7_7H1L      (*(volatile __near unsigned char  *)0x65E)
#define RPGACC55H0L    (*(volatile __near unsigned char  *)0x65E)
#define RMD7_7H0L      (*(volatile __near unsigned char  *)0x65E)
#define RMD15_7H1L     (*(volatile __near unsigned char  *)0x65E)
#define RMD15_7H0L     (*(volatile __near unsigned char  *)0x65E)
#define RPGACC55H1L    (*(volatile __near unsigned char  *)0x65E)
#define RMD15_7H0H     (*(volatile __near unsigned char  *)0x65F)
#define RPGACC55H0H    (*(volatile __near unsigned char  *)0x65F)
#define RPGACC55H1H    (*(volatile __near unsigned char  *)0x65F)
#define RMD7_7H1H      (*(volatile __near unsigned char  *)0x65F)
#define RMD7_7H0H      (*(volatile __near unsigned char  *)0x65F)
#define RMD15_7H1H     (*(volatile __near unsigned char  *)0x65F)
#define RMD7_8L0       (*(volatile __near unsigned short *)0x660)
#define RMD15_8L1      (*(volatile __near unsigned short *)0x660)
#define RMD15_8L0      (*(volatile __near unsigned short *)0x660)
#define RPGACC56L1     (*(volatile __near unsigned short *)0x660)
#define RPGACC56L0     (*(volatile __near unsigned short *)0x660)
#define RMD7_8L1       (*(volatile __near unsigned short *)0x660)
#define RMD7_8L0L      (*(volatile __near unsigned char  *)0x660)
#define RPGACC56L0L    (*(volatile __near unsigned char  *)0x660)
#define RMD15_8L0L     (*(volatile __near unsigned char  *)0x660)
#define RMD7_8L1L      (*(volatile __near unsigned char  *)0x660)
#define RPGACC56L1L    (*(volatile __near unsigned char  *)0x660)
#define RMD15_8L1L     (*(volatile __near unsigned char  *)0x660)
#define RMD7_8L0H      (*(volatile __near unsigned char  *)0x661)
#define RPGACC56L1H    (*(volatile __near unsigned char  *)0x661)
#define RPGACC56L0H    (*(volatile __near unsigned char  *)0x661)
#define RMD7_8L1H      (*(volatile __near unsigned char  *)0x661)
#define RMD15_8L1H     (*(volatile __near unsigned char  *)0x661)
#define RMD15_8L0H     (*(volatile __near unsigned char  *)0x661)
#define RMD7_8H0       (*(volatile __near unsigned short *)0x662)
#define RMD15_8H1      (*(volatile __near unsigned short *)0x662)
#define RMD7_8H1       (*(volatile __near unsigned short *)0x662)
#define RMD15_8H0      (*(volatile __near unsigned short *)0x662)
#define RPGACC56H1     (*(volatile __near unsigned short *)0x662)
#define RPGACC56H0     (*(volatile __near unsigned short *)0x662)
#define RMD15_8H1L     (*(volatile __near unsigned char  *)0x662)
#define RMD7_8H0L      (*(volatile __near unsigned char  *)0x662)
#define RMD15_8H0L     (*(volatile __near unsigned char  *)0x662)
#define RMD7_8H1L      (*(volatile __near unsigned char  *)0x662)
#define RPGACC56H1L    (*(volatile __near unsigned char  *)0x662)
#define RPGACC56H0L    (*(volatile __near unsigned char  *)0x662)
#define RMD15_8H1H     (*(volatile __near unsigned char  *)0x663)
#define RMD15_8H0H     (*(volatile __near unsigned char  *)0x663)
#define RMD7_8H0H      (*(volatile __near unsigned char  *)0x663)
#define RMD7_8H1H      (*(volatile __near unsigned char  *)0x663)
#define RPGACC56H1H    (*(volatile __near unsigned char  *)0x663)
#define RPGACC56H0H    (*(volatile __near unsigned char  *)0x663)
#define RPGACC57L1     (*(volatile __near unsigned short *)0x664)
#define RPGACC57L0     (*(volatile __near unsigned short *)0x664)
#define RMD15_9L0      (*(volatile __near unsigned short *)0x664)
#define RMD15_9L1      (*(volatile __near unsigned short *)0x664)
#define RMD7_9L0       (*(volatile __near unsigned short *)0x664)
#define RMD7_9L1       (*(volatile __near unsigned short *)0x664)
#define RMD15_9L1L     (*(volatile __near unsigned char  *)0x664)
#define RMD15_9L0L     (*(volatile __near unsigned char  *)0x664)
#define RPGACC57L1L    (*(volatile __near unsigned char  *)0x664)
#define RMD7_9L0L      (*(volatile __near unsigned char  *)0x664)
#define RMD7_9L1L      (*(volatile __near unsigned char  *)0x664)
#define RPGACC57L0L    (*(volatile __near unsigned char  *)0x664)
#define RMD15_9L0H     (*(volatile __near unsigned char  *)0x665)
#define RMD15_9L1H     (*(volatile __near unsigned char  *)0x665)
#define RPGACC57L1H    (*(volatile __near unsigned char  *)0x665)
#define RPGACC57L0H    (*(volatile __near unsigned char  *)0x665)
#define RMD7_9L1H      (*(volatile __near unsigned char  *)0x665)
#define RMD7_9L0H      (*(volatile __near unsigned char  *)0x665)
#define RMD7_9H1       (*(volatile __near unsigned short *)0x666)
#define RMD15_9H1      (*(volatile __near unsigned short *)0x666)
#define RPGACC57H1     (*(volatile __near unsigned short *)0x666)
#define RPGACC57H0     (*(volatile __near unsigned short *)0x666)
#define RMD15_9H0      (*(volatile __near unsigned short *)0x666)
#define RMD7_9H0       (*(volatile __near unsigned short *)0x666)
#define RMD15_9H0L     (*(volatile __near unsigned char  *)0x666)
#define RMD15_9H1L     (*(volatile __near unsigned char  *)0x666)
#define RPGACC57H1L    (*(volatile __near unsigned char  *)0x666)
#define RPGACC57H0L    (*(volatile __near unsigned char  *)0x666)
#define RMD7_9H0L      (*(volatile __near unsigned char  *)0x666)
#define RMD7_9H1L      (*(volatile __near unsigned char  *)0x666)
#define RMD15_9H0H     (*(volatile __near unsigned char  *)0x667)
#define RMD15_9H1H     (*(volatile __near unsigned char  *)0x667)
#define RPGACC57H1H    (*(volatile __near unsigned char  *)0x667)
#define RPGACC57H0H    (*(volatile __near unsigned char  *)0x667)
#define RMD7_9H0H      (*(volatile __near unsigned char  *)0x667)
#define RMD7_9H1H      (*(volatile __near unsigned char  *)0x667)
#define RPGACC58L1     (*(volatile __near unsigned short *)0x668)
#define RPGACC58L0     (*(volatile __near unsigned short *)0x668)
#define RMD7_10L0      (*(volatile __near unsigned short *)0x668)
#define RMD7_10L1      (*(volatile __near unsigned short *)0x668)
#define RMD15_10L0     (*(volatile __near unsigned short *)0x668)
#define RMD15_10L1     (*(volatile __near unsigned short *)0x668)
#define RPGACC58L0L    (*(volatile __near unsigned char  *)0x668)
#define RPGACC58L1L    (*(volatile __near unsigned char  *)0x668)
#define RMD7_10L0L     (*(volatile __near unsigned char  *)0x668)
#define RMD7_10L1L     (*(volatile __near unsigned char  *)0x668)
#define RMD15_10L0L    (*(volatile __near unsigned char  *)0x668)
#define RMD15_10L1L    (*(volatile __near unsigned char  *)0x668)
#define RPGACC58L0H    (*(volatile __near unsigned char  *)0x669)
#define RPGACC58L1H    (*(volatile __near unsigned char  *)0x669)
#define RMD7_10L1H     (*(volatile __near unsigned char  *)0x669)
#define RMD7_10L0H     (*(volatile __near unsigned char  *)0x669)
#define RMD15_10L0H    (*(volatile __near unsigned char  *)0x669)
#define RMD15_10L1H    (*(volatile __near unsigned char  *)0x669)
#define RPGACC58H0     (*(volatile __near unsigned short *)0x66A)
#define RMD7_10H1      (*(volatile __near unsigned short *)0x66A)
#define RMD15_10H0     (*(volatile __near unsigned short *)0x66A)
#define RMD7_10H0      (*(volatile __near unsigned short *)0x66A)
#define RPGACC58H1     (*(volatile __near unsigned short *)0x66A)
#define RMD15_10H1     (*(volatile __near unsigned short *)0x66A)
#define RMD7_10H0L     (*(volatile __near unsigned char  *)0x66A)
#define RMD7_10H1L     (*(volatile __near unsigned char  *)0x66A)
#define RPGACC58H1L    (*(volatile __near unsigned char  *)0x66A)
#define RMD15_10H1L    (*(volatile __near unsigned char  *)0x66A)
#define RMD15_10H0L    (*(volatile __near unsigned char  *)0x66A)
#define RPGACC58H0L    (*(volatile __near unsigned char  *)0x66A)
#define RMD15_10H1H    (*(volatile __near unsigned char  *)0x66B)
#define RMD7_10H1H     (*(volatile __near unsigned char  *)0x66B)
#define RMD7_10H0H     (*(volatile __near unsigned char  *)0x66B)
#define RPGACC58H0H    (*(volatile __near unsigned char  *)0x66B)
#define RPGACC58H1H    (*(volatile __near unsigned char  *)0x66B)
#define RMD15_10H0H    (*(volatile __near unsigned char  *)0x66B)
#define RMD15_11L1     (*(volatile __near unsigned short *)0x66C)
#define RMD7_11L1      (*(volatile __near unsigned short *)0x66C)
#define RMD7_11L0      (*(volatile __near unsigned short *)0x66C)
#define RPGACC59L0     (*(volatile __near unsigned short *)0x66C)
#define RMD15_11L0     (*(volatile __near unsigned short *)0x66C)
#define RPGACC59L1     (*(volatile __near unsigned short *)0x66C)
#define RMD7_11L0L     (*(volatile __near unsigned char  *)0x66C)
#define RMD7_11L1L     (*(volatile __near unsigned char  *)0x66C)
#define RPGACC59L0L    (*(volatile __near unsigned char  *)0x66C)
#define RPGACC59L1L    (*(volatile __near unsigned char  *)0x66C)
#define RMD15_11L1L    (*(volatile __near unsigned char  *)0x66C)
#define RMD15_11L0L    (*(volatile __near unsigned char  *)0x66C)
#define RPGACC59L1H    (*(volatile __near unsigned char  *)0x66D)
#define RPGACC59L0H    (*(volatile __near unsigned char  *)0x66D)
#define RMD7_11L1H     (*(volatile __near unsigned char  *)0x66D)
#define RMD15_11L1H    (*(volatile __near unsigned char  *)0x66D)
#define RMD7_11L0H     (*(volatile __near unsigned char  *)0x66D)
#define RMD15_11L0H    (*(volatile __near unsigned char  *)0x66D)
#define RMD7_11H0      (*(volatile __near unsigned short *)0x66E)
#define RPGACC59H0     (*(volatile __near unsigned short *)0x66E)
#define RPGACC59H1     (*(volatile __near unsigned short *)0x66E)
#define RMD7_11H1      (*(volatile __near unsigned short *)0x66E)
#define RMD15_11H0     (*(volatile __near unsigned short *)0x66E)
#define RMD15_11H1     (*(volatile __near unsigned short *)0x66E)
#define RMD15_11H1L    (*(volatile __near unsigned char  *)0x66E)
#define RPGACC59H1L    (*(volatile __near unsigned char  *)0x66E)
#define RMD15_11H0L    (*(volatile __near unsigned char  *)0x66E)
#define RMD7_11H1L     (*(volatile __near unsigned char  *)0x66E)
#define RMD7_11H0L     (*(volatile __near unsigned char  *)0x66E)
#define RPGACC59H0L    (*(volatile __near unsigned char  *)0x66E)
#define RMD15_11H1H    (*(volatile __near unsigned char  *)0x66F)
#define RMD15_11H0H    (*(volatile __near unsigned char  *)0x66F)
#define RMD7_11H1H     (*(volatile __near unsigned char  *)0x66F)
#define RMD7_11H0H     (*(volatile __near unsigned char  *)0x66F)
#define RPGACC59H1H    (*(volatile __near unsigned char  *)0x66F)
#define RPGACC59H0H    (*(volatile __near unsigned char  *)0x66F)
#define RPGACC60L0     (*(volatile __near unsigned short *)0x670)
#define RMD15_12L0     (*(volatile __near unsigned short *)0x670)
#define RMD7_12L1      (*(volatile __near unsigned short *)0x670)
#define RMD15_12L1     (*(volatile __near unsigned short *)0x670)
#define RPGACC60L1     (*(volatile __near unsigned short *)0x670)
#define RMD7_12L0      (*(volatile __near unsigned short *)0x670)
#define RMD15_12L1L    (*(volatile __near unsigned char  *)0x670)
#define RPGACC60L0L    (*(volatile __near unsigned char  *)0x670)
#define RMD15_12L0L    (*(volatile __near unsigned char  *)0x670)
#define RMD7_12L1L     (*(volatile __near unsigned char  *)0x670)
#define RMD7_12L0L     (*(volatile __near unsigned char  *)0x670)
#define RPGACC60L1L    (*(volatile __near unsigned char  *)0x670)
#define RPGACC60L0H    (*(volatile __near unsigned char  *)0x671)
#define RMD15_12L0H    (*(volatile __near unsigned char  *)0x671)
#define RMD7_12L1H     (*(volatile __near unsigned char  *)0x671)
#define RMD15_12L1H    (*(volatile __near unsigned char  *)0x671)
#define RMD7_12L0H     (*(volatile __near unsigned char  *)0x671)
#define RPGACC60L1H    (*(volatile __near unsigned char  *)0x671)
#define RPGACC60H1     (*(volatile __near unsigned short *)0x672)
#define RMD7_12H0      (*(volatile __near unsigned short *)0x672)
#define RMD7_12H1      (*(volatile __near unsigned short *)0x672)
#define RPGACC60H0     (*(volatile __near unsigned short *)0x672)
#define RMD15_12H1     (*(volatile __near unsigned short *)0x672)
#define RMD15_12H0     (*(volatile __near unsigned short *)0x672)
#define RMD7_12H0L     (*(volatile __near unsigned char  *)0x672)
#define RMD7_12H1L     (*(volatile __near unsigned char  *)0x672)
#define RMD15_12H1L    (*(volatile __near unsigned char  *)0x672)
#define RMD15_12H0L    (*(volatile __near unsigned char  *)0x672)
#define RPGACC60H0L    (*(volatile __near unsigned char  *)0x672)
#define RPGACC60H1L    (*(volatile __near unsigned char  *)0x672)
#define RPGACC60H0H    (*(volatile __near unsigned char  *)0x673)
#define RMD15_12H1H    (*(volatile __near unsigned char  *)0x673)
#define RMD7_12H0H     (*(volatile __near unsigned char  *)0x673)
#define RMD7_12H1H     (*(volatile __near unsigned char  *)0x673)
#define RMD15_12H0H    (*(volatile __near unsigned char  *)0x673)
#define RPGACC60H1H    (*(volatile __near unsigned char  *)0x673)
#define RMD7_13L0      (*(volatile __near unsigned short *)0x674)
#define RMD15_13L0     (*(volatile __near unsigned short *)0x674)
#define RMD7_13L1      (*(volatile __near unsigned short *)0x674)
#define RPGACC61L1     (*(volatile __near unsigned short *)0x674)
#define RMD15_13L1     (*(volatile __near unsigned short *)0x674)
#define RPGACC61L0     (*(volatile __near unsigned short *)0x674)
#define RMD7_13L1L     (*(volatile __near unsigned char  *)0x674)
#define RPGACC61L0L    (*(volatile __near unsigned char  *)0x674)
#define RPGACC61L1L    (*(volatile __near unsigned char  *)0x674)
#define RMD7_13L0L     (*(volatile __near unsigned char  *)0x674)
#define RMD15_13L0L    (*(volatile __near unsigned char  *)0x674)
#define RMD15_13L1L    (*(volatile __near unsigned char  *)0x674)
#define RMD15_13L0H    (*(volatile __near unsigned char  *)0x675)
#define RMD7_13L1H     (*(volatile __near unsigned char  *)0x675)
#define RPGACC61L0H    (*(volatile __near unsigned char  *)0x675)
#define RPGACC61L1H    (*(volatile __near unsigned char  *)0x675)
#define RMD7_13L0H     (*(volatile __near unsigned char  *)0x675)
#define RMD15_13L1H    (*(volatile __near unsigned char  *)0x675)
#define RPGACC61H1     (*(volatile __near unsigned short *)0x676)
#define RMD15_13H0     (*(volatile __near unsigned short *)0x676)
#define RMD7_13H1      (*(volatile __near unsigned short *)0x676)
#define RMD7_13H0      (*(volatile __near unsigned short *)0x676)
#define RPGACC61H0     (*(volatile __near unsigned short *)0x676)
#define RMD15_13H1     (*(volatile __near unsigned short *)0x676)
#define RPGACC61H1L    (*(volatile __near unsigned char  *)0x676)
#define RPGACC61H0L    (*(volatile __near unsigned char  *)0x676)
#define RMD7_13H1L     (*(volatile __near unsigned char  *)0x676)
#define RMD7_13H0L     (*(volatile __near unsigned char  *)0x676)
#define RMD15_13H1L    (*(volatile __near unsigned char  *)0x676)
#define RMD15_13H0L    (*(volatile __near unsigned char  *)0x676)
#define RPGACC61H1H    (*(volatile __near unsigned char  *)0x677)
#define RMD15_13H1H    (*(volatile __near unsigned char  *)0x677)
#define RMD15_13H0H    (*(volatile __near unsigned char  *)0x677)
#define RPGACC61H0H    (*(volatile __near unsigned char  *)0x677)
#define RMD7_13H1H     (*(volatile __near unsigned char  *)0x677)
#define RMD7_13H0H     (*(volatile __near unsigned char  *)0x677)
#define RPGACC62L0     (*(volatile __near unsigned short *)0x678)
#define RPGACC62L1     (*(volatile __near unsigned short *)0x678)
#define RMD7_14L0      (*(volatile __near unsigned short *)0x678)
#define RMD7_14L1      (*(volatile __near unsigned short *)0x678)
#define RMD15_14L1     (*(volatile __near unsigned short *)0x678)
#define RMD15_14L0     (*(volatile __near unsigned short *)0x678)
#define RPGACC62L0L    (*(volatile __near unsigned char  *)0x678)
#define RPGACC62L1L    (*(volatile __near unsigned char  *)0x678)
#define RMD7_14L0L     (*(volatile __near unsigned char  *)0x678)
#define RMD7_14L1L     (*(volatile __near unsigned char  *)0x678)
#define RMD15_14L1L    (*(volatile __near unsigned char  *)0x678)
#define RMD15_14L0L    (*(volatile __near unsigned char  *)0x678)
#define RPGACC62L0H    (*(volatile __near unsigned char  *)0x679)
#define RPGACC62L1H    (*(volatile __near unsigned char  *)0x679)
#define RMD7_14L0H     (*(volatile __near unsigned char  *)0x679)
#define RMD7_14L1H     (*(volatile __near unsigned char  *)0x679)
#define RMD15_14L0H    (*(volatile __near unsigned char  *)0x679)
#define RMD15_14L1H    (*(volatile __near unsigned char  *)0x679)
#define RPGACC62H1     (*(volatile __near unsigned short *)0x67A)
#define RPGACC62H0     (*(volatile __near unsigned short *)0x67A)
#define RMD15_14H0     (*(volatile __near unsigned short *)0x67A)
#define RMD15_14H1     (*(volatile __near unsigned short *)0x67A)
#define RMD7_14H1      (*(volatile __near unsigned short *)0x67A)
#define RMD7_14H0      (*(volatile __near unsigned short *)0x67A)
#define RPGACC62H0L    (*(volatile __near unsigned char  *)0x67A)
#define RPGACC62H1L    (*(volatile __near unsigned char  *)0x67A)
#define RMD7_14H1L     (*(volatile __near unsigned char  *)0x67A)
#define RMD15_14H0L    (*(volatile __near unsigned char  *)0x67A)
#define RMD15_14H1L    (*(volatile __near unsigned char  *)0x67A)
#define RMD7_14H0L     (*(volatile __near unsigned char  *)0x67A)
#define RPGACC62H0H    (*(volatile __near unsigned char  *)0x67B)
#define RPGACC62H1H    (*(volatile __near unsigned char  *)0x67B)
#define RMD15_14H0H    (*(volatile __near unsigned char  *)0x67B)
#define RMD7_14H1H     (*(volatile __near unsigned char  *)0x67B)
#define RMD15_14H1H    (*(volatile __near unsigned char  *)0x67B)
#define RMD7_14H0H     (*(volatile __near unsigned char  *)0x67B)
#define RPGACC63L0     (*(volatile __near unsigned short *)0x67C)
#define RPGACC63L1     (*(volatile __near unsigned short *)0x67C)
#define RMD15_15L0     (*(volatile __near unsigned short *)0x67C)
#define RMD15_15L1     (*(volatile __near unsigned short *)0x67C)
#define RMD7_15L1      (*(volatile __near unsigned short *)0x67C)
#define RMD7_15L0      (*(volatile __near unsigned short *)0x67C)
#define RPGACC63L1L    (*(volatile __near unsigned char  *)0x67C)
#define RPGACC63L0L    (*(volatile __near unsigned char  *)0x67C)
#define RMD15_15L1L    (*(volatile __near unsigned char  *)0x67C)
#define RMD15_15L0L    (*(volatile __near unsigned char  *)0x67C)
#define RMD7_15L0L     (*(volatile __near unsigned char  *)0x67C)
#define RMD7_15L1L     (*(volatile __near unsigned char  *)0x67C)
#define RPGACC63L1H    (*(volatile __near unsigned char  *)0x67D)
#define RPGACC63L0H    (*(volatile __near unsigned char  *)0x67D)
#define RMD15_15L1H    (*(volatile __near unsigned char  *)0x67D)
#define RMD15_15L0H    (*(volatile __near unsigned char  *)0x67D)
#define RMD7_15L1H     (*(volatile __near unsigned char  *)0x67D)
#define RMD7_15L0H     (*(volatile __near unsigned char  *)0x67D)
#define RPGACC63H0     (*(volatile __near unsigned short *)0x67E)
#define RPGACC63H1     (*(volatile __near unsigned short *)0x67E)
#define RMD15_15H1     (*(volatile __near unsigned short *)0x67E)
#define RMD15_15H0     (*(volatile __near unsigned short *)0x67E)
#define RMD7_15H0      (*(volatile __near unsigned short *)0x67E)
#define RMD7_15H1      (*(volatile __near unsigned short *)0x67E)
#define RPGACC63H0L    (*(volatile __near unsigned char  *)0x67E)
#define RPGACC63H1L    (*(volatile __near unsigned char  *)0x67E)
#define RMD15_15H1L    (*(volatile __near unsigned char  *)0x67E)
#define RMD15_15H0L    (*(volatile __near unsigned char  *)0x67E)
#define RMD7_15H0L     (*(volatile __near unsigned char  *)0x67E)
#define RMD7_15H1L     (*(volatile __near unsigned char  *)0x67E)
#define RPGACC63H0H    (*(volatile __near unsigned char  *)0x67F)
#define RPGACC63H1H    (*(volatile __near unsigned char  *)0x67F)
#define RMD15_15H1H    (*(volatile __near unsigned char  *)0x67F)
#define RMD7_15H1H     (*(volatile __near unsigned char  *)0x67F)
#define RMD7_15H0H     (*(volatile __near unsigned char  *)0x67F)
#define RMD15_15H0H    (*(volatile __near unsigned char  *)0x67F)
#define ADDR0M         (*(volatile __near unsigned short *)0x6A0)
#define ADDR1M         (*(volatile __near unsigned short *)0x6A2)
#define ADDR2M         (*(volatile __near unsigned short *)0x6A4)
#define ADDR3M         (*(volatile __near unsigned short *)0x6A6)
#define ADDR4M         (*(volatile __near unsigned short *)0x6A8)
#define ADDR5M         (*(volatile __near unsigned short *)0x6AA)
#define ADDR6M         (*(volatile __near unsigned short *)0x6AC)
#define ADDR7M         (*(volatile __near unsigned short *)0x6AE)
#define ADDR8          (*(volatile __near unsigned short *)0x6B0)
#define ADSTRGR        (*(volatile __near unsigned short *)0x6B0)
#define ADCSR          (*(volatile __near unsigned short *)0x6B0)
#define ADDR0          (*(volatile __near unsigned short *)0x6B0)
#define ADDR24         (*(volatile __near unsigned short *)0x6B0)
#define ADGSPCR        (*(volatile __near unsigned short *)0x6B0)
#define ADSSTR0        (*(volatile __near unsigned char  *)0x6B0)
#define ADSSTR1        (*(volatile __near unsigned char  *)0x6B1)
#define ADDR1          (*(volatile __near unsigned short *)0x6B2)
#define ADDR25         (*(volatile __near unsigned short *)0x6B2)
#define ADEXICR        (*(volatile __near unsigned short *)0x6B2)
#define ADDR9          (*(volatile __near unsigned short *)0x6B2)
#define ADSSTR2        (*(volatile __near unsigned char  *)0x6B2)
#define ADSSTR3        (*(volatile __near unsigned char  *)0x6B3)
#define ADDR10         (*(volatile __near unsigned short *)0x6B4)
#define ADANSA0        (*(volatile __near unsigned short *)0x6B4)
#define ADDR26         (*(volatile __near unsigned short *)0x6B4)
#define ADANSB0        (*(volatile __near unsigned short *)0x6B4)
#define ADDR2          (*(volatile __near unsigned short *)0x6B4)
#define ADSSTR4        (*(volatile __near unsigned char  *)0x6B4)
#define ADSSTR5        (*(volatile __near unsigned char  *)0x6B5)
#define ADSHCR         (*(volatile __near unsigned short *)0x6B6)
#define ADDR27         (*(volatile __near unsigned short *)0x6B6)
#define ADDR3          (*(volatile __near unsigned short *)0x6B6)
#define ADANSB1        (*(volatile __near unsigned short *)0x6B6)
#define ADDR11         (*(volatile __near unsigned short *)0x6B6)
#define ADANSA1        (*(volatile __near unsigned short *)0x6B6)
#define ADSSTR6        (*(volatile __near unsigned char  *)0x6B6)
#define ADSSTR7        (*(volatile __near unsigned char  *)0x6B7)
#define ADADS0         (*(volatile __near unsigned short *)0x6B8)
#define ADDR4          (*(volatile __near unsigned short *)0x6B8)
#define ADDR28         (*(volatile __near unsigned short *)0x6B8)
#define ADDR12         (*(volatile __near unsigned short *)0x6B8)
#define ADSSTR8        (*(volatile __near unsigned char  *)0x6B8)
#define ADSSTR9        (*(volatile __near unsigned char  *)0x6B9)
#define ADADS1         (*(volatile __near unsigned short *)0x6BA)
#define ADDR29         (*(volatile __near unsigned short *)0x6BA)
#define ADDR5          (*(volatile __near unsigned short *)0x6BA)
#define ADDR13         (*(volatile __near unsigned short *)0x6BA)
#define ADSSTR10       (*(volatile __near unsigned char  *)0x6BA)
#define ADDISCR        (*(volatile __near unsigned char  *)0x6BA)
#define ADHVREFCNT     (*(volatile __near unsigned char  *)0x6BA)
#define ADHVREFCNT_bit (*(volatile __near __bitf_T *)0x6BA)
#define ADSSTR11       (*(volatile __near unsigned char  *)0x6BB)
#define ADSLP          (((volatile __near __bitf_T *)0x6BA)->no7)
#define ADDR6          (*(volatile __near unsigned short *)0x6BC)
#define ADDR14         (*(volatile __near unsigned short *)0x6BC)
#define ADDR22         (*(volatile __near unsigned short *)0x6BC)
#define ADOCDR         (*(volatile __near unsigned short *)0x6BC)
#define ADSSTR12       (*(volatile __near unsigned char  *)0x6BC)
#define ADADC          (*(volatile __near unsigned char  *)0x6BC)
#define ADADC_bit      (*(volatile __near __bitf_T *)0x6BC)
#define ADSSTR13       (*(volatile __near unsigned char  *)0x6BD)
#define ADSSTRL        (*(volatile __near unsigned char  *)0x6BD)
#define AVEE           (((volatile __near __bitf_T *)0x6BC)->no7)
#define ADDR7          (*(volatile __near unsigned short *)0x6BE)
#define ADCER          (*(volatile __near unsigned short *)0x6BE)
#define ADDR15         (*(volatile __near unsigned short *)0x6BE)
#define ADDR23         (*(volatile __near unsigned short *)0x6BE)
#define ADRD           (*(volatile __near unsigned short *)0x6BE)
#define ADSSTR14       (*(volatile __near unsigned char  *)0x6BE)
#define ADSSTR15       (*(volatile __near unsigned char  *)0x6BF)
#define ADSSTRO        (*(volatile __near unsigned char  *)0x6BF)
#define LWBR2          (*(volatile __near unsigned char  *)0x6C1)
#define LWBR1          (*(volatile __near unsigned char  *)0x6C1)
#define LWBR0          (*(volatile __near unsigned char  *)0x6C1)
#define LBRP1          (*(volatile __near unsigned short *)0x6C2)
#define LBRP2          (*(volatile __near unsigned short *)0x6C2)
#define LBRP0          (*(volatile __near unsigned short *)0x6C2)
#define LBRP20         (*(volatile __near unsigned char  *)0x6C2)
#define LBRP00         (*(volatile __near unsigned char  *)0x6C2)
#define LBRP10         (*(volatile __near unsigned char  *)0x6C2)
#define LBRP21         (*(volatile __near unsigned char  *)0x6C3)
#define LBRP11         (*(volatile __near unsigned char  *)0x6C3)
#define LBRP01         (*(volatile __near unsigned char  *)0x6C3)
#define LSTC1          (*(volatile __near unsigned char  *)0x6C4)
#define LSTC2          (*(volatile __near unsigned char  *)0x6C4)
#define LSTC0          (*(volatile __near unsigned char  *)0x6C4)
#define LUSC2          (*(volatile __near unsigned char  *)0x6C5)
#define LUSC0          (*(volatile __near unsigned char  *)0x6C5)
#define LUSC1          (*(volatile __near unsigned char  *)0x6C5)
#define LMD0           (*(volatile __near unsigned char  *)0x6C8)
#define LMD1           (*(volatile __near unsigned char  *)0x6C8)
#define LMD2           (*(volatile __near unsigned char  *)0x6C8)
#define LBFC0          (*(volatile __near unsigned char  *)0x6C9)
#define LBFC1          (*(volatile __near unsigned char  *)0x6C9)
#define LBFC2          (*(volatile __near unsigned char  *)0x6C9)
#define LSC2           (*(volatile __near unsigned char  *)0x6CA)
#define LSC1           (*(volatile __near unsigned char  *)0x6CA)
#define LSC0           (*(volatile __near unsigned char  *)0x6CA)
#define LWUP2          (*(volatile __near unsigned char  *)0x6CB)
#define LWUP1          (*(volatile __near unsigned char  *)0x6CB)
#define LWUP0          (*(volatile __near unsigned char  *)0x6CB)
#define LIE2           (*(volatile __near unsigned char  *)0x6CC)
#define LIE1           (*(volatile __near unsigned char  *)0x6CC)
#define LIE0           (*(volatile __near unsigned char  *)0x6CC)
#define LEDE1          (*(volatile __near unsigned char  *)0x6CD)
#define LEDE0          (*(volatile __near unsigned char  *)0x6CD)
#define LEDE2          (*(volatile __near unsigned char  *)0x6CD)
#define LCUC2          (*(volatile __near unsigned char  *)0x6CE)
#define LCUC1          (*(volatile __near unsigned char  *)0x6CE)
#define LCUC0          (*(volatile __near unsigned char  *)0x6CE)
#define LTRC1          (*(volatile __near unsigned char  *)0x6D0)
#define LTRC2          (*(volatile __near unsigned char  *)0x6D0)
#define LTRC0          (*(volatile __near unsigned char  *)0x6D0)
#define LMST2          (*(volatile __near unsigned char  *)0x6D1)
#define LMST0          (*(volatile __near unsigned char  *)0x6D1)
#define LMST1          (*(volatile __near unsigned char  *)0x6D1)
#define LST0           (*(volatile __near unsigned char  *)0x6D2)
#define LST1           (*(volatile __near unsigned char  *)0x6D2)
#define LST2           (*(volatile __near unsigned char  *)0x6D2)
#define LEST1          (*(volatile __near unsigned char  *)0x6D3)
#define LEST2          (*(volatile __near unsigned char  *)0x6D3)
#define LEST0          (*(volatile __near unsigned char  *)0x6D3)
#define LDFC2          (*(volatile __near unsigned char  *)0x6D4)
#define LDFC0          (*(volatile __near unsigned char  *)0x6D4)
#define LDFC1          (*(volatile __near unsigned char  *)0x6D4)
#define LIDB0          (*(volatile __near unsigned char  *)0x6D5)
#define LIDB1          (*(volatile __near unsigned char  *)0x6D5)
#define LIDB2          (*(volatile __near unsigned char  *)0x6D5)
#define LCBR1          (*(volatile __near unsigned char  *)0x6D6)
#define LCBR0          (*(volatile __near unsigned char  *)0x6D6)
#define LCBR2          (*(volatile __near unsigned char  *)0x6D6)
#define LUDB00         (*(volatile __near unsigned char  *)0x6D7)
#define LUDB10         (*(volatile __near unsigned char  *)0x6D7)
#define LUDB20         (*(volatile __near unsigned char  *)0x6D7)
#define LDB01          (*(volatile __near unsigned char  *)0x6D8)
#define LDB21          (*(volatile __near unsigned char  *)0x6D8)
#define LDB11          (*(volatile __near unsigned char  *)0x6D8)
#define LDB02          (*(volatile __near unsigned char  *)0x6D9)
#define LDB22          (*(volatile __near unsigned char  *)0x6D9)
#define LDB12          (*(volatile __near unsigned char  *)0x6D9)
#define LDB23          (*(volatile __near unsigned char  *)0x6DA)
#define LDB13          (*(volatile __near unsigned char  *)0x6DA)
#define LDB03          (*(volatile __near unsigned char  *)0x6DA)
#define LDB24          (*(volatile __near unsigned char  *)0x6DB)
#define LDB14          (*(volatile __near unsigned char  *)0x6DB)
#define LDB04          (*(volatile __near unsigned char  *)0x6DB)
#define LDB05          (*(volatile __near unsigned char  *)0x6DC)
#define LDB15          (*(volatile __near unsigned char  *)0x6DC)
#define LDB25          (*(volatile __near unsigned char  *)0x6DC)
#define LDB26          (*(volatile __near unsigned char  *)0x6DD)
#define LDB06          (*(volatile __near unsigned char  *)0x6DD)
#define LDB16          (*(volatile __near unsigned char  *)0x6DD)
#define LDB27          (*(volatile __near unsigned char  *)0x6DE)
#define LDB17          (*(volatile __near unsigned char  *)0x6DE)
#define LDB07          (*(volatile __near unsigned char  *)0x6DE)
#define LDB28          (*(volatile __near unsigned char  *)0x6DF)
#define LDB18          (*(volatile __near unsigned char  *)0x6DF)
#define LDB08          (*(volatile __near unsigned char  *)0x6DF)
#define LUOER0         (*(volatile __near unsigned char  *)0x6E0)
#define LUOER1         (*(volatile __near unsigned char  *)0x6E0)
#define LUOER2         (*(volatile __near unsigned char  *)0x6E0)
#define LUOR01         (*(volatile __near unsigned char  *)0x6E1)
#define LUOR11         (*(volatile __near unsigned char  *)0x6E1)
#define LUOR21         (*(volatile __near unsigned char  *)0x6E1)
#define LUTDR0         (*(volatile __near unsigned short *)0x6E4)
#define LUTDR1         (*(volatile __near unsigned short *)0x6E4)
#define LUTDR2         (*(volatile __near unsigned short *)0x6E4)
#define LUTDR0L        (*(volatile __near unsigned char  *)0x6E4)
#define LUTDR1L        (*(volatile __near unsigned char  *)0x6E4)
#define LUTDR2L        (*(volatile __near unsigned char  *)0x6E4)
#define LUTDR2H        (*(volatile __near unsigned char  *)0x6E5)
#define LUTDR0H        (*(volatile __near unsigned char  *)0x6E5)
#define LUTDR1H        (*(volatile __near unsigned char  *)0x6E5)
#define LURDR1         (*(volatile __near unsigned short *)0x6E6)
#define LURDR2         (*(volatile __near unsigned short *)0x6E6)
#define LURDR0         (*(volatile __near unsigned short *)0x6E6)
#define LURDR2L        (*(volatile __near unsigned char  *)0x6E6)
#define LURDR1L        (*(volatile __near unsigned char  *)0x6E6)
#define LURDR0L        (*(volatile __near unsigned char  *)0x6E6)
#define LURDR2H        (*(volatile __near unsigned char  *)0x6E7)
#define LURDR0H        (*(volatile __near unsigned char  *)0x6E7)
#define LURDR1H        (*(volatile __near unsigned char  *)0x6E7)
#define LUWTDR0        (*(volatile __near unsigned short *)0x6E8)
#define LUWTDR1        (*(volatile __near unsigned short *)0x6E8)
#define LUWTDR2        (*(volatile __near unsigned short *)0x6E8)
#define LUWTDR0L       (*(volatile __near unsigned char  *)0x6E8)
#define LUWTDR1L       (*(volatile __near unsigned char  *)0x6E8)
#define LUWTDR2L       (*(volatile __near unsigned char  *)0x6E8)
#define LUWTDR0H       (*(volatile __near unsigned char  *)0x6E9)
#define LUWTDR1H       (*(volatile __near unsigned char  *)0x6E9)
#define LUWTDR2H       (*(volatile __near unsigned char  *)0x6E9)
#define LBSS2          (*(volatile __near unsigned char  *)0x6EC)
#define LBSS1          (*(volatile __near unsigned char  *)0x6EC)
#define LBSS0          (*(volatile __near unsigned char  *)0x6EC)
#define LRSS0          (*(volatile __near unsigned char  *)0x6EE)
#define LRSS1          (*(volatile __near unsigned char  *)0x6EE)
#define LRSS2          (*(volatile __near unsigned char  *)0x6EE)
#define TRJ0           (*(volatile __near unsigned short *)0x6F0)
#define ELSELR00       (*(volatile __near unsigned char  *)0x780)
#define ELSELR00_bit   (*(volatile __near __bitf_T *)0x780)
#define ELSELR01       (*(volatile __near unsigned char  *)0x781)
#define ELSELR01_bit   (*(volatile __near __bitf_T *)0x781)
#define ELSELR02       (*(volatile __near unsigned char  *)0x782)
#define ELSELR02_bit   (*(volatile __near __bitf_T *)0x782)
#define ELSELR03       (*(volatile __near unsigned char  *)0x783)
#define ELSELR03_bit   (*(volatile __near __bitf_T *)0x783)
#define ELSELR04       (*(volatile __near unsigned char  *)0x784)
#define ELSELR04_bit   (*(volatile __near __bitf_T *)0x784)
#define ELSELR05       (*(volatile __near unsigned char  *)0x785)
#define ELSELR05_bit   (*(volatile __near __bitf_T *)0x785)
#define ELSELR06       (*(volatile __near unsigned char  *)0x786)
#define ELSELR06_bit   (*(volatile __near __bitf_T *)0x786)
#define ELSELR07       (*(volatile __near unsigned char  *)0x787)
#define ELSELR07_bit   (*(volatile __near __bitf_T *)0x787)
#define ELSELR08       (*(volatile __near unsigned char  *)0x788)
#define ELSELR08_bit   (*(volatile __near __bitf_T *)0x788)
#define ELSELR09       (*(volatile __near unsigned char  *)0x789)
#define ELSELR09_bit   (*(volatile __near __bitf_T *)0x789)
#define ELSELR10       (*(volatile __near unsigned char  *)0x78A)
#define ELSELR10_bit   (*(volatile __near __bitf_T *)0x78A)
#define ELSELR11       (*(volatile __near unsigned char  *)0x78B)
#define ELSELR11_bit   (*(volatile __near __bitf_T *)0x78B)
#define ELSELR12       (*(volatile __near unsigned char  *)0x78C)
#define ELSELR12_bit   (*(volatile __near __bitf_T *)0x78C)
#define ELSELR13       (*(volatile __near unsigned char  *)0x78D)
#define ELSELR13_bit   (*(volatile __near __bitf_T *)0x78D)
#define ELSELR14       (*(volatile __near unsigned char  *)0x78E)
#define ELSELR14_bit   (*(volatile __near __bitf_T *)0x78E)
#define ELSELR15       (*(volatile __near unsigned char  *)0x78F)
#define ELSELR15_bit   (*(volatile __near __bitf_T *)0x78F)
#define ELSELR16       (*(volatile __near unsigned char  *)0x790)
#define ELSELR16_bit   (*(volatile __near __bitf_T *)0x790)
#define ELSELR17       (*(volatile __near unsigned char  *)0x791)
#define ELSELR17_bit   (*(volatile __near __bitf_T *)0x791)
#define ELSELR18       (*(volatile __near unsigned char  *)0x792)
#define ELSELR18_bit   (*(volatile __near __bitf_T *)0x792)
#define ELSELR19       (*(volatile __near unsigned char  *)0x793)
#define ELSELR19_bit   (*(volatile __near __bitf_T *)0x793)
#define ELSELR20       (*(volatile __near unsigned char  *)0x794)
#define ELSELR20_bit   (*(volatile __near __bitf_T *)0x794)
#define ELSELR21       (*(volatile __near unsigned char  *)0x795)
#define ELSELR21_bit   (*(volatile __near __bitf_T *)0x795)
#define ELSELR22       (*(volatile __near unsigned char  *)0x796)
#define ELSELR22_bit   (*(volatile __near __bitf_T *)0x796)
#define ELSELR23       (*(volatile __near unsigned char  *)0x797)
#define ELSELR23_bit   (*(volatile __near __bitf_T *)0x797)
#define ELSELR24       (*(volatile __near unsigned char  *)0x798)
#define ELSELR24_bit   (*(volatile __near __bitf_T *)0x798)
#define ELSELR25       (*(volatile __near unsigned char  *)0x799)
#define ELSELR25_bit   (*(volatile __near __bitf_T *)0x799)
#define CFDECCTL1      (*(volatile __near unsigned short *)0x7C0)
#define CFDECCTL0      (*(volatile __near unsigned short *)0x7C0)
#define CFDECCTL0L     (*(volatile __near unsigned char  *)0x7C0)
#define CFDECCTL1L     (*(volatile __near unsigned char  *)0x7C0)
#define CFDECCTL1H     (*(volatile __near unsigned char  *)0x7C1)
#define CFDECCTL0H     (*(volatile __near unsigned char  *)0x7C1)
#define CFDECTMC0      (*(volatile __near unsigned short *)0x7C4)
#define CFDECTMC1      (*(volatile __near unsigned short *)0x7C4)
#define CFDECTMC0L     (*(volatile __near unsigned char  *)0x7C4)
#define CFDECTMC1L     (*(volatile __near unsigned char  *)0x7C4)
#define CFDECTMC1H     (*(volatile __near unsigned char  *)0x7C5)
#define CFDECTMC0H     (*(volatile __near unsigned char  *)0x7C5)
#define CFDECERDB1     (*(volatile __near unsigned char  *)0x7C8)
#define CFDECERDB0     (*(volatile __near unsigned char  *)0x7C8)
#define CFDECHORD0     (*(volatile __near unsigned char  *)0x7CA)
#define CFDECHORD1     (*(volatile __near unsigned char  *)0x7CA)
#define CFDECSYND1     (*(volatile __near unsigned char  *)0x7CB)
#define CFDECSYND0     (*(volatile __near unsigned char  *)0x7CB)
#define CFDECTED0L     (*(volatile __near unsigned short *)0x7CC)
#define CFDECTED1L     (*(volatile __near unsigned short *)0x7CC)
#define CFDECTED0H     (*(volatile __near unsigned short *)0x7CE)
#define CFDECTED1H     (*(volatile __near unsigned short *)0x7CE)
#define CFDECEAD1      (*(volatile __near unsigned short *)0x7D0)
#define CFDECEAD0      (*(volatile __near unsigned short *)0x7D0)
#define P0             (*(volatile __near unsigned char  *)0xFF00)
#define P0_bit         (*(volatile __near __bitf_T *)0xFF00)
#define P1             (*(volatile __near unsigned char  *)0xFF01)
#define P1_bit         (*(volatile __near __bitf_T *)0xFF01)
#define P3             (*(volatile __near unsigned char  *)0xFF03)
#define P3_bit         (*(volatile __near __bitf_T *)0xFF03)
#define P4             (*(volatile __near unsigned char  *)0xFF04)
#define P4_bit         (*(volatile __near __bitf_T *)0xFF04)
#define P5             (*(volatile __near unsigned char  *)0xFF05)
#define P5_bit         (*(volatile __near __bitf_T *)0xFF05)
#define P6             (*(volatile __near unsigned char  *)0xFF06)
#define P6_bit         (*(volatile __near __bitf_T *)0xFF06)
#define P7             (*(volatile __near unsigned char  *)0xFF07)
#define P7_bit         (*(volatile __near __bitf_T *)0xFF07)
#define P8             (*(volatile __near unsigned char  *)0xFF08)
#define P8_bit         (*(volatile __near __bitf_T *)0xFF08)
#define P9             (*(volatile __near unsigned char  *)0xFF09)
#define P9_bit         (*(volatile __near __bitf_T *)0xFF09)
#define P12            (*(volatile __near unsigned char  *)0xFF0C)
#define P12_bit        (*(volatile __near __bitf_T *)0xFF0C)
#define P13            (*(volatile __near unsigned char  *)0xFF0D)
#define P13_bit        (*(volatile __near __bitf_T *)0xFF0D)
#define P14            (*(volatile __near unsigned char  *)0xFF0E)
#define P14_bit        (*(volatile __near __bitf_T *)0xFF0E)
#define SDR00          (*(volatile __near unsigned short *)0xFF10)
#define SDR00L         (*(volatile __near unsigned char  *)0xFF10)
#define SDR01          (*(volatile __near unsigned short *)0xFF12)
#define SDR01L         (*(volatile __near unsigned char  *)0xFF12)
#define TDR00          (*(volatile __near unsigned short *)0xFF18)
#define TDR01          (*(volatile __near unsigned short *)0xFF1A)
#define TDR01L         (*(volatile __near unsigned char  *)0xFF1A)
#define TDR01H         (*(volatile __near unsigned char  *)0xFF1B)
#define PM0            (*(volatile __near unsigned char  *)0xFF20)
#define PM0_bit        (*(volatile __near __bitf_T *)0xFF20)
#define PM1            (*(volatile __near unsigned char  *)0xFF21)
#define PM1_bit        (*(volatile __near __bitf_T *)0xFF21)
#define PM3            (*(volatile __near unsigned char  *)0xFF23)
#define PM3_bit        (*(volatile __near __bitf_T *)0xFF23)
#define PM4            (*(volatile __near unsigned char  *)0xFF24)
#define PM4_bit        (*(volatile __near __bitf_T *)0xFF24)
#define PM5            (*(volatile __near unsigned char  *)0xFF25)
#define PM5_bit        (*(volatile __near __bitf_T *)0xFF25)
#define PM6            (*(volatile __near unsigned char  *)0xFF26)
#define PM6_bit        (*(volatile __near __bitf_T *)0xFF26)
#define PM7            (*(volatile __near unsigned char  *)0xFF27)
#define PM7_bit        (*(volatile __near __bitf_T *)0xFF27)
#define PM8            (*(volatile __near unsigned char  *)0xFF28)
#define PM8_bit        (*(volatile __near __bitf_T *)0xFF28)
#define PM9            (*(volatile __near unsigned char  *)0xFF29)
#define PM9_bit        (*(volatile __near __bitf_T *)0xFF29)
#define PM12           (*(volatile __near unsigned char  *)0xFF2C)
#define PM12_bit       (*(volatile __near __bitf_T *)0xFF2C)
#define PM14           (*(volatile __near unsigned char  *)0xFF2E)
#define PM14_bit       (*(volatile __near __bitf_T *)0xFF2E)
#define ADWINR         (*(volatile __near unsigned char  *)0xFF30)
#define AAUWINR        (*(volatile __near unsigned char  *)0xFF32)
#define DACS0          (*(volatile __near unsigned char  *)0xFF34)
#define DAM            (*(volatile __near unsigned char  *)0xFF36)
#define DAM_bit        (*(volatile __near __bitf_T *)0xFF36)
#define DACE0          (((volatile __near __bitf_T *)0xFF36)->no4)
#define KRM            (*(volatile __near unsigned char  *)0xFF37)
#define KRM_bit        (*(volatile __near __bitf_T *)0xFF37)
#define EGP0           (*(volatile __near unsigned char  *)0xFF38)
#define EGP0_bit       (*(volatile __near __bitf_T *)0xFF38)
#define EGN0           (*(volatile __near unsigned char  *)0xFF39)
#define EGN0_bit       (*(volatile __near __bitf_T *)0xFF39)
#define EGP1           (*(volatile __near unsigned char  *)0xFF3A)
#define EGP1_bit       (*(volatile __near __bitf_T *)0xFF3A)
#define EGN1           (*(volatile __near unsigned char  *)0xFF3B)
#define EGN1_bit       (*(volatile __near __bitf_T *)0xFF3B)
#define SDR10          (*(volatile __near unsigned short *)0xFF48)
#define SDR10L         (*(volatile __near unsigned char  *)0xFF48)
#define SDR11          (*(volatile __near unsigned short *)0xFF4A)
#define SDR11L         (*(volatile __near unsigned char  *)0xFF4A)
#define IICA0          (*(volatile __near unsigned char  *)0xFF50)
#define IICS0          (*(volatile __near unsigned char  *)0xFF51)
#define IICS0_bit      (*(volatile __near __bitf_T *)0xFF51)
#define SPD0           (((volatile __near __bitf_T *)0xFF51)->no0)
#define STD0           (((volatile __near __bitf_T *)0xFF51)->no1)
#define ACKD0          (((volatile __near __bitf_T *)0xFF51)->no2)
#define TRC0           (((volatile __near __bitf_T *)0xFF51)->no3)
#define COI0           (((volatile __near __bitf_T *)0xFF51)->no4)
#define EXC0           (((volatile __near __bitf_T *)0xFF51)->no5)
#define ALD0           (((volatile __near __bitf_T *)0xFF51)->no6)
#define MSTS0          (((volatile __near __bitf_T *)0xFF51)->no7)
#define IICF0          (*(volatile __near unsigned char  *)0xFF52)
#define IICF0_bit      (*(volatile __near __bitf_T *)0xFF52)
#define IICRSV0        (((volatile __near __bitf_T *)0xFF52)->no0)
#define STCEN0         (((volatile __near __bitf_T *)0xFF52)->no1)
#define IICBSY0        (((volatile __near __bitf_T *)0xFF52)->no6)
#define STCF0          (((volatile __near __bitf_T *)0xFF52)->no7)
#define SUBCUDW        (*(volatile __near unsigned short *)0xFF54)
#define TRDGRC0        (*(volatile __near unsigned short *)0xFF58)
#define TRDGRD0        (*(volatile __near unsigned short *)0xFF5A)
#define TRDGRC1        (*(volatile __near unsigned short *)0xFF5C)
#define TRDGRD1        (*(volatile __near unsigned short *)0xFF5E)
#define TRDCMPD0       (*(volatile __near unsigned short *)0xFF60)
#define TRDCMPC1       (*(volatile __near unsigned short *)0xFF62)
#define TRDCMPD1       (*(volatile __near unsigned short *)0xFF64)
#define TRDADTB0       (*(volatile __near unsigned short *)0xFF66)
#define TRDADTB1       (*(volatile __near unsigned short *)0xFF68)
#define TRDRDT01       (*(volatile __near unsigned short *)0xFF6A)
#define TRDRDT0        (*(volatile __near unsigned char  *)0xFF6A)
#define TRDRDT0_bit    (*(volatile __near __bitf_T *)0xFF6A)
#define TRDRDT1        (*(volatile __near unsigned char  *)0xFF6B)
#define TRDRDT1_bit    (*(volatile __near __bitf_T *)0xFF6B)
#define TRDDGCR0       (*(volatile __near unsigned short *)0xFF6C)
#define TRDDNR0        (*(volatile __near unsigned char  *)0xFF6C)
#define TRDDNR0_bit    (*(volatile __near __bitf_T *)0xFF6C)
#define TRDGPR0        (*(volatile __near unsigned char  *)0xFF6D)
#define TRDGPR0_bit    (*(volatile __near __bitf_T *)0xFF6D)
#define TRDDGCR1       (*(volatile __near unsigned short *)0xFF6E)
#define TRDDNR1        (*(volatile __near unsigned char  *)0xFF6E)
#define TRDDNR1_bit    (*(volatile __near __bitf_T *)0xFF6E)
#define TRDGPR1        (*(volatile __near unsigned char  *)0xFF6F)
#define TRDGPR1_bit    (*(volatile __near __bitf_T *)0xFF6F)
#define TDR02          (*(volatile __near unsigned short *)0xFF74)
#define TDR03          (*(volatile __near unsigned short *)0xFF76)
#define TDR03L         (*(volatile __near unsigned char  *)0xFF76)
#define TDR03H         (*(volatile __near unsigned char  *)0xFF77)
#define TDR04          (*(volatile __near unsigned short *)0xFF78)
#define TDR05          (*(volatile __near unsigned short *)0xFF7A)
#define TDR06          (*(volatile __near unsigned short *)0xFF7C)
#define TDR07          (*(volatile __near unsigned short *)0xFF7E)
#define TDR10          (*(volatile __near unsigned short *)0xFF80)
#define TDR11          (*(volatile __near unsigned short *)0xFF82)
#define TDR11L         (*(volatile __near unsigned char  *)0xFF82)
#define TDR11H         (*(volatile __near unsigned char  *)0xFF83)
#define TDR12          (*(volatile __near unsigned short *)0xFF84)
#define TDR13          (*(volatile __near unsigned short *)0xFF86)
#define TDR13L         (*(volatile __near unsigned char  *)0xFF86)
#define TDR13H         (*(volatile __near unsigned char  *)0xFF87)
#define TDR14          (*(volatile __near unsigned short *)0xFF88)
#define TDR15          (*(volatile __near unsigned short *)0xFF8A)
#define TDR16          (*(volatile __near unsigned short *)0xFF8C)
#define TDR17          (*(volatile __near unsigned short *)0xFF8E)
#define SEC            (*(volatile __near unsigned char  *)0xFF92)
#define MIN            (*(volatile __near unsigned char  *)0xFF93)
#define HOUR           (*(volatile __near unsigned char  *)0xFF94)
#define WEEK           (*(volatile __near unsigned char  *)0xFF95)
#define DAY            (*(volatile __near unsigned char  *)0xFF96)
#define MONTH          (*(volatile __near unsigned char  *)0xFF97)
#define YEAR           (*(volatile __near unsigned char  *)0xFF98)
#define SUBCUD         (*(volatile __near unsigned char  *)0xFF99)
#define ALARMWM        (*(volatile __near unsigned char  *)0xFF9A)
#define ALARMWH        (*(volatile __near unsigned char  *)0xFF9B)
#define ALARMWW        (*(volatile __near unsigned char  *)0xFF9C)
#define RTCC0          (*(volatile __near unsigned char  *)0xFF9D)
#define RTCC0_bit      (*(volatile __near __bitf_T *)0xFF9D)
#define RCLOE1         (((volatile __near __bitf_T *)0xFF9D)->no5)
#define RTCE           (((volatile __near __bitf_T *)0xFF9D)->no7)
#define RTCC1          (*(volatile __near unsigned char  *)0xFF9E)
#define RTCC1_bit      (*(volatile __near __bitf_T *)0xFF9E)
#define RWAIT          (((volatile __near __bitf_T *)0xFF9E)->no0)
#define RWST           (((volatile __near __bitf_T *)0xFF9E)->no1)
#define RIFG           (((volatile __near __bitf_T *)0xFF9E)->no3)
#define WAFG           (((volatile __near __bitf_T *)0xFF9E)->no4)
#define WALIE          (((volatile __near __bitf_T *)0xFF9E)->no6)
#define WALE           (((volatile __near __bitf_T *)0xFF9E)->no7)
#define CMC            (*(volatile __near unsigned char  *)0xFFA0)
#define CSC            (*(volatile __near unsigned char  *)0xFFA1)
#define CSC_bit        (*(volatile __near __bitf_T *)0xFFA1)
#define HIOSTOP        (((volatile __near __bitf_T *)0xFFA1)->no0)
#define XTSTOP         (((volatile __near __bitf_T *)0xFFA1)->no6)
#define MSTOP          (((volatile __near __bitf_T *)0xFFA1)->no7)
#define OSTC           (*(volatile __near unsigned char  *)0xFFA2)
#define OSTC_bit       (*(volatile __near __bitf_T *)0xFFA2)
#define OSTS           (*(volatile __near unsigned char  *)0xFFA3)
#define CKC            (*(volatile __near unsigned char  *)0xFFA4)
#define CKC_bit        (*(volatile __near __bitf_T *)0xFFA4)
#define MCM0           (((volatile __near __bitf_T *)0xFFA4)->no4)
#define MCS            (((volatile __near __bitf_T *)0xFFA4)->no5)
#define CSS            (((volatile __near __bitf_T *)0xFFA4)->no6)
#define CLS            (((volatile __near __bitf_T *)0xFFA4)->no7)
#define CKS0           (*(volatile __near unsigned char  *)0xFFA5)
#define CKS0_bit       (*(volatile __near __bitf_T *)0xFFA5)
#define PCLOE0         (((volatile __near __bitf_T *)0xFFA5)->no7)
#define RESF           (*(volatile __near unsigned char  *)0xFFA8)
#define LVIM           (*(volatile __near unsigned char  *)0xFFA9)
#define LVIM_bit       (*(volatile __near __bitf_T *)0xFFA9)
#define LVD0F          (((volatile __near __bitf_T *)0xFFA9)->no0)
#define LVD1F          (((volatile __near __bitf_T *)0xFFA9)->no1)
#define DLVD1F         (((volatile __near __bitf_T *)0xFFA9)->no3)
#define LVISEN         (((volatile __near __bitf_T *)0xFFA9)->no7)
#define LVIS           (*(volatile __near unsigned char  *)0xFFAA)
#define LVIS_bit       (*(volatile __near __bitf_T *)0xFFAA)
#define LVD1V0         (((volatile __near __bitf_T *)0xFFAA)->no0)
#define LVD1V1         (((volatile __near __bitf_T *)0xFFAA)->no1)
#define LVD1V2         (((volatile __near __bitf_T *)0xFFAA)->no2)
#define LVD1V3         (((volatile __near __bitf_T *)0xFFAA)->no3)
#define LVD1V4         (((volatile __near __bitf_T *)0xFFAA)->no4)
#define LVD1EN         (((volatile __near __bitf_T *)0xFFAA)->no7)
#define WDTE           (*(volatile __near unsigned char  *)0xFFAB)
#define CRCIN          (*(volatile __near unsigned char  *)0xFFAC)
#define FLSEC          (*(volatile __near unsigned short *)0xFFB0)
#define FLFSWS         (*(volatile __near unsigned short *)0xFFB2)
#define FLFSWE         (*(volatile __near unsigned short *)0xFFB4)
#define FSSET          (*(volatile __near unsigned char  *)0xFFB6)
#define FSSE           (*(volatile __near unsigned char  *)0xFFB7)
#define FSSE_bit       (*(volatile __near __bitf_T *)0xFFB7)
#define ESQST          (((volatile __near __bitf_T *)0xFFB7)->no7)
#define PFCMD          (*(volatile __near unsigned char  *)0xFFC0)
#define PFS            (*(volatile __near unsigned char  *)0xFFC1)
#define PFS_bit        (*(volatile __near __bitf_T *)0xFFC1)
#define FLWE           (*(volatile __near unsigned char  *)0xFFC6)
#define IF2            (*(volatile __near unsigned short *)0xFFD0)
#define IF2L           (*(volatile __near unsigned char  *)0xFFD0)
#define IF2L_bit       (*(volatile __near __bitf_T *)0xFFD0)
#define IF2H           (*(volatile __near unsigned char  *)0xFFD1)
#define IF2H_bit       (*(volatile __near __bitf_T *)0xFFD1)
#define LIN0TRMIF      (((volatile __near __bitf_T *)0xFFD0)->no0)
#define TMIF05         (((volatile __near __bitf_T *)0xFFD0)->no0)
#define LIN0RVCIF      (((volatile __near __bitf_T *)0xFFD0)->no1)
#define TMIF06         (((volatile __near __bitf_T *)0xFFD0)->no1)
#define LIN0STAIF      (((volatile __near __bitf_T *)0xFFD0)->no2)
#define LIN0IF         (((volatile __near __bitf_T *)0xFFD0)->no2)
#define TMIF07         (((volatile __near __bitf_T *)0xFFD0)->no2)
#define PIF11          (((volatile __near __bitf_T *)0xFFD0)->no3)
#define LIN0WUPIF      (((volatile __near __bitf_T *)0xFFD0)->no3)
#define TMIF10         (((volatile __near __bitf_T *)0xFFD0)->no4)
#define LIN1TRMIF      (((volatile __near __bitf_T *)0xFFD0)->no5)
#define TMIF11         (((volatile __near __bitf_T *)0xFFD0)->no5)
#define LIN1RVCIF      (((volatile __near __bitf_T *)0xFFD0)->no6)
#define TMIF12         (((volatile __near __bitf_T *)0xFFD0)->no6)
#define LIN1IF         (((volatile __near __bitf_T *)0xFFD0)->no7)
#define LIN1STAIF      (((volatile __near __bitf_T *)0xFFD0)->no7)
#define TMIF13         (((volatile __near __bitf_T *)0xFFD0)->no7)
#define ADGBIF         (((volatile __near __bitf_T *)0xFFD1)->no2)
#define ROMIF          (((volatile __near __bitf_T *)0xFFD1)->no3)
#define KRIF           (((volatile __near __bitf_T *)0xFFD1)->no4)
#define CAN0GRVCIF     (((volatile __near __bitf_T *)0xFFD1)->no4)
#define CAN0ERRIF      (((volatile __near __bitf_T *)0xFFD1)->no5)
#define CAN0WUPIF      (((volatile __near __bitf_T *)0xFFD1)->no6)
#define IF3            (*(volatile __near unsigned short *)0xFFD2)
#define IF3L           (*(volatile __near unsigned char  *)0xFFD2)
#define IF3L_bit       (*(volatile __near __bitf_T *)0xFFD2)
#define IF3H           (*(volatile __near unsigned char  *)0xFFD3)
#define IF3H_bit       (*(volatile __near __bitf_T *)0xFFD3)
#define CAN0CFRIF      (((volatile __near __bitf_T *)0xFFD2)->no0)
#define CAN0TRMIF      (((volatile __near __bitf_T *)0xFFD2)->no1)
#define CAN0GRFRIF     (((volatile __near __bitf_T *)0xFFD2)->no2)
#define CAN0GERRIF     (((volatile __near __bitf_T *)0xFFD2)->no3)
#define PIF12          (((volatile __near __bitf_T *)0xFFD2)->no4)
#define LIN1WUPIF      (((volatile __near __bitf_T *)0xFFD2)->no4)
#define CAN1GRFRIF     (((volatile __near __bitf_T *)0xFFD2)->no5)
#define CAN1GERRIF     (((volatile __near __bitf_T *)0xFFD2)->no6)
#define CAN1WUPIF      (((volatile __near __bitf_T *)0xFFD2)->no7)
#define CAN1GRVCIF     (((volatile __near __bitf_T *)0xFFD3)->no0)
#define TMIF14         (((volatile __near __bitf_T *)0xFFD3)->no0)
#define CAN1ERRIF      (((volatile __near __bitf_T *)0xFFD3)->no1)
#define TMIF15         (((volatile __near __bitf_T *)0xFFD3)->no1)
#define CAN1CFRIF      (((volatile __near __bitf_T *)0xFFD3)->no2)
#define TMIF16         (((volatile __near __bitf_T *)0xFFD3)->no2)
#define CAN1TRMIF      (((volatile __near __bitf_T *)0xFFD3)->no3)
#define TMIF17         (((volatile __near __bitf_T *)0xFFD3)->no3)
#define CRAMIF         (((volatile __near __bitf_T *)0xFFD3)->no4)
#define MK2            (*(volatile __near unsigned short *)0xFFD4)
#define MK2L           (*(volatile __near unsigned char  *)0xFFD4)
#define MK2L_bit       (*(volatile __near __bitf_T *)0xFFD4)
#define MK2H           (*(volatile __near unsigned char  *)0xFFD5)
#define MK2H_bit       (*(volatile __near __bitf_T *)0xFFD5)
#define LIN0TRMMK      (((volatile __near __bitf_T *)0xFFD4)->no0)
#define TMMK05         (((volatile __near __bitf_T *)0xFFD4)->no0)
#define LIN0RVCMK      (((volatile __near __bitf_T *)0xFFD4)->no1)
#define TMMK06         (((volatile __near __bitf_T *)0xFFD4)->no1)
#define LIN0STAMK      (((volatile __near __bitf_T *)0xFFD4)->no2)
#define LIN0MK         (((volatile __near __bitf_T *)0xFFD4)->no2)
#define TMMK07         (((volatile __near __bitf_T *)0xFFD4)->no2)
#define PMK11          (((volatile __near __bitf_T *)0xFFD4)->no3)
#define LIN0WUPMK      (((volatile __near __bitf_T *)0xFFD4)->no3)
#define TMMK10         (((volatile __near __bitf_T *)0xFFD4)->no4)
#define LIN1TRMMK      (((volatile __near __bitf_T *)0xFFD4)->no5)
#define TMMK11         (((volatile __near __bitf_T *)0xFFD4)->no5)
#define LIN1RVCMK      (((volatile __near __bitf_T *)0xFFD4)->no6)
#define TMMK12         (((volatile __near __bitf_T *)0xFFD4)->no6)
#define LIN1MK         (((volatile __near __bitf_T *)0xFFD4)->no7)
#define LIN1STAMK      (((volatile __near __bitf_T *)0xFFD4)->no7)
#define TMMK13         (((volatile __near __bitf_T *)0xFFD4)->no7)
#define ADGBMK         (((volatile __near __bitf_T *)0xFFD5)->no2)
#define ROMMK          (((volatile __near __bitf_T *)0xFFD5)->no3)
#define CAN0GRVCMK     (((volatile __near __bitf_T *)0xFFD5)->no4)
#define KRMK           (((volatile __near __bitf_T *)0xFFD5)->no4)
#define CAN0ERRMK      (((volatile __near __bitf_T *)0xFFD5)->no5)
#define CAN0WUPMK      (((volatile __near __bitf_T *)0xFFD5)->no6)
#define MK3            (*(volatile __near unsigned short *)0xFFD6)
#define MK3L           (*(volatile __near unsigned char  *)0xFFD6)
#define MK3L_bit       (*(volatile __near __bitf_T *)0xFFD6)
#define MK3H           (*(volatile __near unsigned char  *)0xFFD7)
#define MK3H_bit       (*(volatile __near __bitf_T *)0xFFD7)
#define CAN0CFRMK      (((volatile __near __bitf_T *)0xFFD6)->no0)
#define CAN0TRMMK      (((volatile __near __bitf_T *)0xFFD6)->no1)
#define CAN0GRFRMK     (((volatile __near __bitf_T *)0xFFD6)->no2)
#define CAN0GERRMK     (((volatile __near __bitf_T *)0xFFD6)->no3)
#define PMK12          (((volatile __near __bitf_T *)0xFFD6)->no4)
#define LIN1WUPMK      (((volatile __near __bitf_T *)0xFFD6)->no4)
#define CAN1GRFRMK     (((volatile __near __bitf_T *)0xFFD6)->no5)
#define CAN1GERRMK     (((volatile __near __bitf_T *)0xFFD6)->no6)
#define CAN1WUPMK      (((volatile __near __bitf_T *)0xFFD6)->no7)
#define CAN1GRVCMK     (((volatile __near __bitf_T *)0xFFD7)->no0)
#define TMMK14         (((volatile __near __bitf_T *)0xFFD7)->no0)
#define TMMK15         (((volatile __near __bitf_T *)0xFFD7)->no1)
#define CAN1ERRMK      (((volatile __near __bitf_T *)0xFFD7)->no1)
#define TMMK16         (((volatile __near __bitf_T *)0xFFD7)->no2)
#define CAN1CFRMK      (((volatile __near __bitf_T *)0xFFD7)->no2)
#define TMMK17         (((volatile __near __bitf_T *)0xFFD7)->no3)
#define CAN1TRMMK      (((volatile __near __bitf_T *)0xFFD7)->no3)
#define CRAMMK         (((volatile __near __bitf_T *)0xFFD7)->no4)
#define PR02           (*(volatile __near unsigned short *)0xFFD8)
#define PR02L          (*(volatile __near unsigned char  *)0xFFD8)
#define PR02L_bit      (*(volatile __near __bitf_T *)0xFFD8)
#define PR02H          (*(volatile __near unsigned char  *)0xFFD9)
#define PR02H_bit      (*(volatile __near __bitf_T *)0xFFD9)
#define TMPR005        (((volatile __near __bitf_T *)0xFFD8)->no0)
#define LIN0TRMPR0     (((volatile __near __bitf_T *)0xFFD8)->no0)
#define TMPR006        (((volatile __near __bitf_T *)0xFFD8)->no1)
#define LIN0RVCPR0     (((volatile __near __bitf_T *)0xFFD8)->no1)
#define TMPR007        (((volatile __near __bitf_T *)0xFFD8)->no2)
#define LIN0STAPR0     (((volatile __near __bitf_T *)0xFFD8)->no2)
#define LIN0PR0        (((volatile __near __bitf_T *)0xFFD8)->no2)
#define PPR011         (((volatile __near __bitf_T *)0xFFD8)->no3)
#define LIN0WUPPR0     (((volatile __near __bitf_T *)0xFFD8)->no3)
#define TMPR010        (((volatile __near __bitf_T *)0xFFD8)->no4)
#define TMPR011        (((volatile __near __bitf_T *)0xFFD8)->no5)
#define LIN1TRMPR0     (((volatile __near __bitf_T *)0xFFD8)->no5)
#define TMPR012        (((volatile __near __bitf_T *)0xFFD8)->no6)
#define LIN1RVCPR0     (((volatile __near __bitf_T *)0xFFD8)->no6)
#define TMPR013        (((volatile __near __bitf_T *)0xFFD8)->no7)
#define LIN1PR0        (((volatile __near __bitf_T *)0xFFD8)->no7)
#define LIN1STAPR0     (((volatile __near __bitf_T *)0xFFD8)->no7)
#define ADGBPR0        (((volatile __near __bitf_T *)0xFFD9)->no2)
#define ROMPR0         (((volatile __near __bitf_T *)0xFFD9)->no3)
#define CAN0GRVCPR0    (((volatile __near __bitf_T *)0xFFD9)->no4)
#define KRPR0          (((volatile __near __bitf_T *)0xFFD9)->no4)
#define CAN0ERRPR0     (((volatile __near __bitf_T *)0xFFD9)->no5)
#define CAN0WUPPR0     (((volatile __near __bitf_T *)0xFFD9)->no6)
#define PR03           (*(volatile __near unsigned short *)0xFFDA)
#define PR03L          (*(volatile __near unsigned char  *)0xFFDA)
#define PR03L_bit      (*(volatile __near __bitf_T *)0xFFDA)
#define PR03H          (*(volatile __near unsigned char  *)0xFFDB)
#define PR03H_bit      (*(volatile __near __bitf_T *)0xFFDB)
#define CAN0CFRPR0     (((volatile __near __bitf_T *)0xFFDA)->no0)
#define CAN0TRMPR0     (((volatile __near __bitf_T *)0xFFDA)->no1)
#define CAN0GRFRPR0    (((volatile __near __bitf_T *)0xFFDA)->no2)
#define CAN0GERRPR0    (((volatile __near __bitf_T *)0xFFDA)->no3)
#define PPR012         (((volatile __near __bitf_T *)0xFFDA)->no4)
#define LIN1WUPPR0     (((volatile __near __bitf_T *)0xFFDA)->no4)
#define CAN1GRFRPR0    (((volatile __near __bitf_T *)0xFFDA)->no5)
#define CAN1GERRPR0    (((volatile __near __bitf_T *)0xFFDA)->no6)
#define CAN1WUPPR0     (((volatile __near __bitf_T *)0xFFDA)->no7)
#define TMPR014        (((volatile __near __bitf_T *)0xFFDB)->no0)
#define CAN1GRVCPR0    (((volatile __near __bitf_T *)0xFFDB)->no0)
#define TMPR015        (((volatile __near __bitf_T *)0xFFDB)->no1)
#define CAN1ERRPR0     (((volatile __near __bitf_T *)0xFFDB)->no1)
#define TMPR016        (((volatile __near __bitf_T *)0xFFDB)->no2)
#define CAN1CFRPR0     (((volatile __near __bitf_T *)0xFFDB)->no2)
#define TMPR017        (((volatile __near __bitf_T *)0xFFDB)->no3)
#define CAN1TRMPR0     (((volatile __near __bitf_T *)0xFFDB)->no3)
#define CRAMPR0        (((volatile __near __bitf_T *)0xFFDB)->no4)
#define PR12           (*(volatile __near unsigned short *)0xFFDC)
#define PR12L          (*(volatile __near unsigned char  *)0xFFDC)
#define PR12L_bit      (*(volatile __near __bitf_T *)0xFFDC)
#define PR12H          (*(volatile __near unsigned char  *)0xFFDD)
#define PR12H_bit      (*(volatile __near __bitf_T *)0xFFDD)
#define TMPR105        (((volatile __near __bitf_T *)0xFFDC)->no0)
#define LIN0TRMPR1     (((volatile __near __bitf_T *)0xFFDC)->no0)
#define TMPR106        (((volatile __near __bitf_T *)0xFFDC)->no1)
#define LIN0RVCPR1     (((volatile __near __bitf_T *)0xFFDC)->no1)
#define TMPR107        (((volatile __near __bitf_T *)0xFFDC)->no2)
#define LIN0STAPR1     (((volatile __near __bitf_T *)0xFFDC)->no2)
#define LIN0PR1        (((volatile __near __bitf_T *)0xFFDC)->no2)
#define PPR111         (((volatile __near __bitf_T *)0xFFDC)->no3)
#define LIN0WUPPR1     (((volatile __near __bitf_T *)0xFFDC)->no3)
#define TMPR110        (((volatile __near __bitf_T *)0xFFDC)->no4)
#define LIN1TRMPR1     (((volatile __near __bitf_T *)0xFFDC)->no5)
#define TMPR111        (((volatile __near __bitf_T *)0xFFDC)->no5)
#define TMPR112        (((volatile __near __bitf_T *)0xFFDC)->no6)
#define LIN1RVCPR1     (((volatile __near __bitf_T *)0xFFDC)->no6)
#define LIN1STAPR1     (((volatile __near __bitf_T *)0xFFDC)->no7)
#define TMPR113        (((volatile __near __bitf_T *)0xFFDC)->no7)
#define LIN1PR1        (((volatile __near __bitf_T *)0xFFDC)->no7)
#define ADGBPR1        (((volatile __near __bitf_T *)0xFFDD)->no2)
#define ROMPR1         (((volatile __near __bitf_T *)0xFFDD)->no3)
#define CAN0GRVCPR1    (((volatile __near __bitf_T *)0xFFDD)->no4)
#define KRPR1          (((volatile __near __bitf_T *)0xFFDD)->no4)
#define CAN0ERRPR1     (((volatile __near __bitf_T *)0xFFDD)->no5)
#define CAN0WUPPR1     (((volatile __near __bitf_T *)0xFFDD)->no6)
#define PR13           (*(volatile __near unsigned short *)0xFFDE)
#define PR13L          (*(volatile __near unsigned char  *)0xFFDE)
#define PR13L_bit      (*(volatile __near __bitf_T *)0xFFDE)
#define PR13H          (*(volatile __near unsigned char  *)0xFFDF)
#define PR13H_bit      (*(volatile __near __bitf_T *)0xFFDF)
#define CAN0CFRPR1     (((volatile __near __bitf_T *)0xFFDE)->no0)
#define CAN0TRMPR1     (((volatile __near __bitf_T *)0xFFDE)->no1)
#define CAN0GRFRPR1    (((volatile __near __bitf_T *)0xFFDE)->no2)
#define CAN0GERRPR1    (((volatile __near __bitf_T *)0xFFDE)->no3)
#define PPR112         (((volatile __near __bitf_T *)0xFFDE)->no4)
#define LIN1WUPPR1     (((volatile __near __bitf_T *)0xFFDE)->no4)
#define CAN1GRFRPR1    (((volatile __near __bitf_T *)0xFFDE)->no5)
#define CAN1GERRPR1    (((volatile __near __bitf_T *)0xFFDE)->no6)
#define CAN1WUPPR1     (((volatile __near __bitf_T *)0xFFDE)->no7)
#define TMPR114        (((volatile __near __bitf_T *)0xFFDF)->no0)
#define CAN1GRVCPR1    (((volatile __near __bitf_T *)0xFFDF)->no0)
#define CAN1ERRPR1     (((volatile __near __bitf_T *)0xFFDF)->no1)
#define TMPR115        (((volatile __near __bitf_T *)0xFFDF)->no1)
#define TMPR116        (((volatile __near __bitf_T *)0xFFDF)->no2)
#define CAN1CFRPR1     (((volatile __near __bitf_T *)0xFFDF)->no2)
#define TMPR117        (((volatile __near __bitf_T *)0xFFDF)->no3)
#define CAN1TRMPR1     (((volatile __near __bitf_T *)0xFFDF)->no3)
#define CRAMPR1        (((volatile __near __bitf_T *)0xFFDF)->no4)
#define IF0            (*(volatile __near unsigned short *)0xFFE0)
#define IF0L           (*(volatile __near unsigned char  *)0xFFE0)
#define IF0L_bit       (*(volatile __near __bitf_T *)0xFFE0)
#define IF0H           (*(volatile __near unsigned char  *)0xFFE1)
#define IF0H_bit       (*(volatile __near __bitf_T *)0xFFE1)
#define WDTIIF         (((volatile __near __bitf_T *)0xFFE0)->no0)
#define LVIIF          (((volatile __near __bitf_T *)0xFFE0)->no1)
#define PIF0           (((volatile __near __bitf_T *)0xFFE0)->no2)
#define PIF1           (((volatile __near __bitf_T *)0xFFE0)->no3)
#define PIF2           (((volatile __near __bitf_T *)0xFFE0)->no4)
#define PIF3           (((volatile __near __bitf_T *)0xFFE0)->no5)
#define PIF4           (((volatile __near __bitf_T *)0xFFE0)->no6)
#define SPMIF          (((volatile __near __bitf_T *)0xFFE0)->no6)
#define PIF5           (((volatile __near __bitf_T *)0xFFE0)->no7)
#define CMPIF0         (((volatile __near __bitf_T *)0xFFE0)->no7)
#define PIF13          (((volatile __near __bitf_T *)0xFFE1)->no0)
#define CLMIF          (((volatile __near __bitf_T *)0xFFE1)->no0)
#define STIF0          (((volatile __near __bitf_T *)0xFFE1)->no1)
#define CSIIF00        (((volatile __near __bitf_T *)0xFFE1)->no1)
#define IICIF00        (((volatile __near __bitf_T *)0xFFE1)->no1)
#define SRIF0          (((volatile __near __bitf_T *)0xFFE1)->no2)
#define CSIIF01        (((volatile __near __bitf_T *)0xFFE1)->no2)
#define IICIF01        (((volatile __near __bitf_T *)0xFFE1)->no2)
#define TRDIF0         (((volatile __near __bitf_T *)0xFFE1)->no3)
#define TRDIF1         (((volatile __near __bitf_T *)0xFFE1)->no4)
#define TRJIF0         (((volatile __near __bitf_T *)0xFFE1)->no5)
#define RAMIF          (((volatile __near __bitf_T *)0xFFE1)->no6)
#define CTSUWRIF       (((volatile __near __bitf_T *)0xFFE1)->no7)
#define IF1            (*(volatile __near unsigned short *)0xFFE2)
#define IF1L           (*(volatile __near unsigned char  *)0xFFE2)
#define IF1L_bit       (*(volatile __near __bitf_T *)0xFFE2)
#define IF1H           (*(volatile __near unsigned char  *)0xFFE3)
#define IF1H_bit       (*(volatile __near __bitf_T *)0xFFE3)
#define CTSURDIF       (((volatile __near __bitf_T *)0xFFE2)->no0)
#define CTSUFNIF       (((volatile __near __bitf_T *)0xFFE2)->no1)
#define IICAIF0        (((volatile __near __bitf_T *)0xFFE2)->no2)
#define PIF8           (((volatile __near __bitf_T *)0xFFE2)->no3)
#define RTCIF          (((volatile __near __bitf_T *)0xFFE2)->no3)
#define TMIF00         (((volatile __near __bitf_T *)0xFFE2)->no4)
#define LIN2TRMIF      (((volatile __near __bitf_T *)0xFFE2)->no5)
#define TMIF01         (((volatile __near __bitf_T *)0xFFE2)->no5)
#define TMIF02         (((volatile __near __bitf_T *)0xFFE2)->no6)
#define LIN2RVCIF      (((volatile __near __bitf_T *)0xFFE2)->no6)
#define TMIF03         (((volatile __near __bitf_T *)0xFFE2)->no7)
#define LIN2STAIF      (((volatile __near __bitf_T *)0xFFE2)->no7)
#define LIN2IF         (((volatile __near __bitf_T *)0xFFE2)->no7)
#define ADIF           (((volatile __near __bitf_T *)0xFFE3)->no0)
#define PIF6           (((volatile __near __bitf_T *)0xFFE3)->no1)
#define LIN2WUPIF      (((volatile __near __bitf_T *)0xFFE3)->no1)
#define TMIF11H        (((volatile __near __bitf_T *)0xFFE3)->no1)
#define PIF7           (((volatile __near __bitf_T *)0xFFE3)->no2)
#define TMIF13H        (((volatile __near __bitf_T *)0xFFE3)->no2)
#define PIF9           (((volatile __near __bitf_T *)0xFFE3)->no3)
#define TMIF01H        (((volatile __near __bitf_T *)0xFFE3)->no3)
#define PIF10          (((volatile __near __bitf_T *)0xFFE3)->no4)
#define TMIF03H        (((volatile __near __bitf_T *)0xFFE3)->no4)
#define STIF1          (((volatile __near __bitf_T *)0xFFE3)->no5)
#define CSIIF10        (((volatile __near __bitf_T *)0xFFE3)->no5)
#define IICIF10        (((volatile __near __bitf_T *)0xFFE3)->no5)
#define SRIF1          (((volatile __near __bitf_T *)0xFFE3)->no6)
#define CSIIF11        (((volatile __near __bitf_T *)0xFFE3)->no6)
#define IICIF11        (((volatile __near __bitf_T *)0xFFE3)->no6)
#define TMIF04         (((volatile __near __bitf_T *)0xFFE3)->no7)
#define MK0            (*(volatile __near unsigned short *)0xFFE4)
#define MK0L           (*(volatile __near unsigned char  *)0xFFE4)
#define MK0L_bit       (*(volatile __near __bitf_T *)0xFFE4)
#define MK0H           (*(volatile __near unsigned char  *)0xFFE5)
#define MK0H_bit       (*(volatile __near __bitf_T *)0xFFE5)
#define WDTIMK         (((volatile __near __bitf_T *)0xFFE4)->no0)
#define LVIMK          (((volatile __near __bitf_T *)0xFFE4)->no1)
#define PMK0           (((volatile __near __bitf_T *)0xFFE4)->no2)
#define PMK1           (((volatile __near __bitf_T *)0xFFE4)->no3)
#define PMK2           (((volatile __near __bitf_T *)0xFFE4)->no4)
#define PMK3           (((volatile __near __bitf_T *)0xFFE4)->no5)
#define PMK4           (((volatile __near __bitf_T *)0xFFE4)->no6)
#define SPMMK          (((volatile __near __bitf_T *)0xFFE4)->no6)
#define PMK5           (((volatile __near __bitf_T *)0xFFE4)->no7)
#define CMPMK0         (((volatile __near __bitf_T *)0xFFE4)->no7)
#define PMK13          (((volatile __near __bitf_T *)0xFFE5)->no0)
#define CLMMK          (((volatile __near __bitf_T *)0xFFE5)->no0)
#define STMK0          (((volatile __near __bitf_T *)0xFFE5)->no1)
#define CSIMK00        (((volatile __near __bitf_T *)0xFFE5)->no1)
#define IICMK00        (((volatile __near __bitf_T *)0xFFE5)->no1)
#define SRMK0          (((volatile __near __bitf_T *)0xFFE5)->no2)
#define CSIMK01        (((volatile __near __bitf_T *)0xFFE5)->no2)
#define IICMK01        (((volatile __near __bitf_T *)0xFFE5)->no2)
#define TRDMK0         (((volatile __near __bitf_T *)0xFFE5)->no3)
#define TRDMK1         (((volatile __near __bitf_T *)0xFFE5)->no4)
#define TRJMK0         (((volatile __near __bitf_T *)0xFFE5)->no5)
#define RAMMK          (((volatile __near __bitf_T *)0xFFE5)->no6)
#define CTSUWRMK       (((volatile __near __bitf_T *)0xFFE5)->no7)
#define MK1            (*(volatile __near unsigned short *)0xFFE6)
#define MK1L           (*(volatile __near unsigned char  *)0xFFE6)
#define MK1L_bit       (*(volatile __near __bitf_T *)0xFFE6)
#define MK1H           (*(volatile __near unsigned char  *)0xFFE7)
#define MK1H_bit       (*(volatile __near __bitf_T *)0xFFE7)
#define CTSURDMK       (((volatile __near __bitf_T *)0xFFE6)->no0)
#define CTSUFNMK       (((volatile __near __bitf_T *)0xFFE6)->no1)
#define IICAMK0        (((volatile __near __bitf_T *)0xFFE6)->no2)
#define PMK8           (((volatile __near __bitf_T *)0xFFE6)->no3)
#define RTCMK          (((volatile __near __bitf_T *)0xFFE6)->no3)
#define TMMK00         (((volatile __near __bitf_T *)0xFFE6)->no4)
#define LIN2TRMMK      (((volatile __near __bitf_T *)0xFFE6)->no5)
#define TMMK01         (((volatile __near __bitf_T *)0xFFE6)->no5)
#define LIN2RVCMK      (((volatile __near __bitf_T *)0xFFE6)->no6)
#define TMMK02         (((volatile __near __bitf_T *)0xFFE6)->no6)
#define LIN2MK         (((volatile __near __bitf_T *)0xFFE6)->no7)
#define LIN2STAMK      (((volatile __near __bitf_T *)0xFFE6)->no7)
#define TMMK03         (((volatile __near __bitf_T *)0xFFE6)->no7)
#define ADMK           (((volatile __near __bitf_T *)0xFFE7)->no0)
#define LIN2WUPMK      (((volatile __near __bitf_T *)0xFFE7)->no1)
#define PMK6           (((volatile __near __bitf_T *)0xFFE7)->no1)
#define TMMK11H        (((volatile __near __bitf_T *)0xFFE7)->no1)
#define PMK7           (((volatile __near __bitf_T *)0xFFE7)->no2)
#define TMMK13H        (((volatile __near __bitf_T *)0xFFE7)->no2)
#define PMK9           (((volatile __near __bitf_T *)0xFFE7)->no3)
#define TMMK01H        (((volatile __near __bitf_T *)0xFFE7)->no3)
#define TMMK03H        (((volatile __near __bitf_T *)0xFFE7)->no4)
#define PMK10          (((volatile __near __bitf_T *)0xFFE7)->no4)
#define STMK1          (((volatile __near __bitf_T *)0xFFE7)->no5)
#define CSIMK10        (((volatile __near __bitf_T *)0xFFE7)->no5)
#define IICMK10        (((volatile __near __bitf_T *)0xFFE7)->no5)
#define SRMK1          (((volatile __near __bitf_T *)0xFFE7)->no6)
#define CSIMK11        (((volatile __near __bitf_T *)0xFFE7)->no6)
#define IICMK11        (((volatile __near __bitf_T *)0xFFE7)->no6)
#define TMMK04         (((volatile __near __bitf_T *)0xFFE7)->no7)
#define PR00           (*(volatile __near unsigned short *)0xFFE8)
#define PR00L          (*(volatile __near unsigned char  *)0xFFE8)
#define PR00L_bit      (*(volatile __near __bitf_T *)0xFFE8)
#define PR00H          (*(volatile __near unsigned char  *)0xFFE9)
#define PR00H_bit      (*(volatile __near __bitf_T *)0xFFE9)
#define WDTIPR0        (((volatile __near __bitf_T *)0xFFE8)->no0)
#define LVIPR0         (((volatile __near __bitf_T *)0xFFE8)->no1)
#define PPR00          (((volatile __near __bitf_T *)0xFFE8)->no2)
#define PPR01          (((volatile __near __bitf_T *)0xFFE8)->no3)
#define PPR02          (((volatile __near __bitf_T *)0xFFE8)->no4)
#define PPR03          (((volatile __near __bitf_T *)0xFFE8)->no5)
#define SPMPR0         (((volatile __near __bitf_T *)0xFFE8)->no6)
#define PPR04          (((volatile __near __bitf_T *)0xFFE8)->no6)
#define PPR05          (((volatile __near __bitf_T *)0xFFE8)->no7)
#define CMPPR00        (((volatile __near __bitf_T *)0xFFE8)->no7)
#define PPR013         (((volatile __near __bitf_T *)0xFFE9)->no0)
#define CLMPR0         (((volatile __near __bitf_T *)0xFFE9)->no0)
#define IICPR000       (((volatile __near __bitf_T *)0xFFE9)->no1)
#define CSIPR000       (((volatile __near __bitf_T *)0xFFE9)->no1)
#define STPR00         (((volatile __near __bitf_T *)0xFFE9)->no1)
#define IICPR001       (((volatile __near __bitf_T *)0xFFE9)->no2)
#define CSIPR001       (((volatile __near __bitf_T *)0xFFE9)->no2)
#define SRPR00         (((volatile __near __bitf_T *)0xFFE9)->no2)
#define TRDPR00        (((volatile __near __bitf_T *)0xFFE9)->no3)
#define TRDPR01        (((volatile __near __bitf_T *)0xFFE9)->no4)
#define TRJPR00        (((volatile __near __bitf_T *)0xFFE9)->no5)
#define RAMPR0         (((volatile __near __bitf_T *)0xFFE9)->no6)
#define CTSUWRPR0      (((volatile __near __bitf_T *)0xFFE9)->no7)
#define PR01           (*(volatile __near unsigned short *)0xFFEA)
#define PR01L          (*(volatile __near unsigned char  *)0xFFEA)
#define PR01L_bit      (*(volatile __near __bitf_T *)0xFFEA)
#define PR01H          (*(volatile __near unsigned char  *)0xFFEB)
#define PR01H_bit      (*(volatile __near __bitf_T *)0xFFEB)
#define CTSURDPR0      (((volatile __near __bitf_T *)0xFFEA)->no0)
#define CTSUFNPR0      (((volatile __near __bitf_T *)0xFFEA)->no1)
#define IICAPR00       (((volatile __near __bitf_T *)0xFFEA)->no2)
#define PPR08          (((volatile __near __bitf_T *)0xFFEA)->no3)
#define RTCPR0         (((volatile __near __bitf_T *)0xFFEA)->no3)
#define TMPR000        (((volatile __near __bitf_T *)0xFFEA)->no4)
#define TMPR001        (((volatile __near __bitf_T *)0xFFEA)->no5)
#define LIN2TRMPR0     (((volatile __near __bitf_T *)0xFFEA)->no5)
#define LIN2RVCPR0     (((volatile __near __bitf_T *)0xFFEA)->no6)
#define TMPR002        (((volatile __near __bitf_T *)0xFFEA)->no6)
#define LIN2PR0        (((volatile __near __bitf_T *)0xFFEA)->no7)
#define LIN2STAPR0     (((volatile __near __bitf_T *)0xFFEA)->no7)
#define TMPR003        (((volatile __near __bitf_T *)0xFFEA)->no7)
#define ADPR0          (((volatile __near __bitf_T *)0xFFEB)->no0)
#define PPR06          (((volatile __near __bitf_T *)0xFFEB)->no1)
#define TMPR011H       (((volatile __near __bitf_T *)0xFFEB)->no1)
#define LIN2WUPPR0     (((volatile __near __bitf_T *)0xFFEB)->no1)
#define PPR07          (((volatile __near __bitf_T *)0xFFEB)->no2)
#define TMPR013H       (((volatile __near __bitf_T *)0xFFEB)->no2)
#define PPR09          (((volatile __near __bitf_T *)0xFFEB)->no3)
#define TMPR001H       (((volatile __near __bitf_T *)0xFFEB)->no3)
#define TMPR003H       (((volatile __near __bitf_T *)0xFFEB)->no4)
#define PPR010         (((volatile __near __bitf_T *)0xFFEB)->no4)
#define IICPR010       (((volatile __near __bitf_T *)0xFFEB)->no5)
#define STPR01         (((volatile __near __bitf_T *)0xFFEB)->no5)
#define CSIPR010       (((volatile __near __bitf_T *)0xFFEB)->no5)
#define IICPR011       (((volatile __near __bitf_T *)0xFFEB)->no6)
#define SRPR01         (((volatile __near __bitf_T *)0xFFEB)->no6)
#define CSIPR011       (((volatile __near __bitf_T *)0xFFEB)->no6)
#define TMPR004        (((volatile __near __bitf_T *)0xFFEB)->no7)
#define PR10           (*(volatile __near unsigned short *)0xFFEC)
#define PR10L          (*(volatile __near unsigned char  *)0xFFEC)
#define PR10L_bit      (*(volatile __near __bitf_T *)0xFFEC)
#define PR10H          (*(volatile __near unsigned char  *)0xFFED)
#define PR10H_bit      (*(volatile __near __bitf_T *)0xFFED)
#define WDTIPR1        (((volatile __near __bitf_T *)0xFFEC)->no0)
#define LVIPR1         (((volatile __near __bitf_T *)0xFFEC)->no1)
#define PPR10          (((volatile __near __bitf_T *)0xFFEC)->no2)
#define PPR11          (((volatile __near __bitf_T *)0xFFEC)->no3)
#define PPR12          (((volatile __near __bitf_T *)0xFFEC)->no4)
#define PPR13          (((volatile __near __bitf_T *)0xFFEC)->no5)
#define SPMPR1         (((volatile __near __bitf_T *)0xFFEC)->no6)
#define PPR14          (((volatile __near __bitf_T *)0xFFEC)->no6)
#define CMPPR10        (((volatile __near __bitf_T *)0xFFEC)->no7)
#define PPR15          (((volatile __near __bitf_T *)0xFFEC)->no7)
#define CLMPR1         (((volatile __near __bitf_T *)0xFFED)->no0)
#define PPR113         (((volatile __near __bitf_T *)0xFFED)->no0)
#define STPR10         (((volatile __near __bitf_T *)0xFFED)->no1)
#define CSIPR100       (((volatile __near __bitf_T *)0xFFED)->no1)
#define IICPR100       (((volatile __near __bitf_T *)0xFFED)->no1)
#define SRPR10         (((volatile __near __bitf_T *)0xFFED)->no2)
#define CSIPR101       (((volatile __near __bitf_T *)0xFFED)->no2)
#define IICPR101       (((volatile __near __bitf_T *)0xFFED)->no2)
#define TRDPR10        (((volatile __near __bitf_T *)0xFFED)->no3)
#define TRDPR11        (((volatile __near __bitf_T *)0xFFED)->no4)
#define TRJPR10        (((volatile __near __bitf_T *)0xFFED)->no5)
#define RAMPR1         (((volatile __near __bitf_T *)0xFFED)->no6)
#define CTSUWRPR1      (((volatile __near __bitf_T *)0xFFED)->no7)
#define PR11           (*(volatile __near unsigned short *)0xFFEE)
#define PR11L          (*(volatile __near unsigned char  *)0xFFEE)
#define PR11L_bit      (*(volatile __near __bitf_T *)0xFFEE)
#define PR11H          (*(volatile __near unsigned char  *)0xFFEF)
#define PR11H_bit      (*(volatile __near __bitf_T *)0xFFEF)
#define CTSURDPR1      (((volatile __near __bitf_T *)0xFFEE)->no0)
#define CTSUFNPR1      (((volatile __near __bitf_T *)0xFFEE)->no1)
#define IICAPR10       (((volatile __near __bitf_T *)0xFFEE)->no2)
#define PPR18          (((volatile __near __bitf_T *)0xFFEE)->no3)
#define RTCPR1         (((volatile __near __bitf_T *)0xFFEE)->no3)
#define TMPR100        (((volatile __near __bitf_T *)0xFFEE)->no4)
#define LIN2TRMPR1     (((volatile __near __bitf_T *)0xFFEE)->no5)
#define TMPR101        (((volatile __near __bitf_T *)0xFFEE)->no5)
#define TMPR102        (((volatile __near __bitf_T *)0xFFEE)->no6)
#define LIN2RVCPR1     (((volatile __near __bitf_T *)0xFFEE)->no6)
#define TMPR103        (((volatile __near __bitf_T *)0xFFEE)->no7)
#define LIN2PR1        (((volatile __near __bitf_T *)0xFFEE)->no7)
#define LIN2STAPR1     (((volatile __near __bitf_T *)0xFFEE)->no7)
#define ADPR1          (((volatile __near __bitf_T *)0xFFEF)->no0)
#define TMPR111H       (((volatile __near __bitf_T *)0xFFEF)->no1)
#define LIN2WUPPR1     (((volatile __near __bitf_T *)0xFFEF)->no1)
#define PPR16          (((volatile __near __bitf_T *)0xFFEF)->no1)
#define PPR17          (((volatile __near __bitf_T *)0xFFEF)->no2)
#define TMPR113H       (((volatile __near __bitf_T *)0xFFEF)->no2)
#define TMPR101H       (((volatile __near __bitf_T *)0xFFEF)->no3)
#define PPR19          (((volatile __near __bitf_T *)0xFFEF)->no3)
#define TMPR103H       (((volatile __near __bitf_T *)0xFFEF)->no4)
#define PPR110         (((volatile __near __bitf_T *)0xFFEF)->no4)
#define STPR11         (((volatile __near __bitf_T *)0xFFEF)->no5)
#define CSIPR110       (((volatile __near __bitf_T *)0xFFEF)->no5)
#define IICPR110       (((volatile __near __bitf_T *)0xFFEF)->no5)
#define CSIPR111       (((volatile __near __bitf_T *)0xFFEF)->no6)
#define IICPR111       (((volatile __near __bitf_T *)0xFFEF)->no6)
#define SRPR11         (((volatile __near __bitf_T *)0xFFEF)->no6)
#define TMPR104        (((volatile __near __bitf_T *)0xFFEF)->no7)
#define MACRL          (*(volatile __near unsigned short *)0xFFF0)
#define MACRH          (*(volatile __near unsigned short *)0xFFF2)
#define PMC            (*(volatile __near unsigned char  *)0xFFFE)
#define PMC_bit        (*(volatile __near __bitf_T *)0xFFFE)
#define MAA            (((volatile __near __bitf_T *)0xFFFE)->no0)


#define INTWDTI                         0x0004
#define INTLVI                          0x0006
#define INTP0                           0x0008
#define INTP1                           0x000A
#define INTP2                           0x000C
#define INTP3                           0x000E
#define INTP4                           0x0010
#define INTSPM                          0x0010
#define INTCMP0                         0x0012
#define INTP5                           0x0012
#define INTCLM                          0x0014
#define INTP13                          0x0014
#define INTCSI00                        0x0016
#define INTIIC00                        0x0016
#define INTST0                          0x0016
#define INTCSI01                        0x0018
#define INTIIC01                        0x0018
#define INTSR0                          0x0018
#define INTTRD0                         0x001A
#define INTTRD1                         0x001C
#define INTTRJ0                         0x001E
#define INTRAM                          0x0020
#define INTCTSUWR                       0x0022
#define INTCTSURD                       0x0024
#define INTCTSUFN                       0x0026
#define INTIICA0                        0x0028
#define INTP8                           0x002A
#define INTRTC                          0x002A
#define INTTM00                         0x002C
#define INTLIN2TRM                      0x002E
#define INTTM01                         0x002E
#define INTLIN2RVC                      0x0030
#define INTTM02                         0x0030
#define INTLIN2                         0x0032
#define INTLIN2STA                      0x0032
#define INTTM03                         0x0032
#define INTAD                           0x0034
#define INTLIN2WUP                      0x0036
#define INTP6                           0x0036
#define INTTM11H                        0x0036
#define INTP7                           0x0038
#define INTTM13H                        0x0038
#define INTP9                           0x003A
#define INTTM01H                        0x003A
#define INTP10                          0x003C
#define INTTM03H                        0x003C
#define INTCSI10                        0x003E
#define INTIIC10                        0x003E
#define INTST1                          0x003E
#define INTCSI11                        0x0040
#define INTIIC11                        0x0040
#define INTSR1                          0x0040
#define INTTM04                         0x0042
#define INTLIN0TRM                      0x0044
#define INTTM05                         0x0044
#define INTLIN0RVC                      0x0046
#define INTTM06                         0x0046
#define INTLIN0                         0x0048
#define INTLIN0STA                      0x0048
#define INTTM07                         0x0048
#define INTLIN0WUP                      0x004A
#define INTP11                          0x004A
#define INTTM10                         0x004C
#define INTLIN1TRM                      0x004E
#define INTTM11                         0x004E
#define INTLIN1RVC                      0x0050
#define INTTM12                         0x0050
#define INTLIN1                         0x0052
#define INTLIN1STA                      0x0052
#define INTTM13                         0x0052
#define INTADGB                         0x0058
#define INTROM                          0x005A
#define INTKR                           0x005C
#define INTRCAN0GRVC                    0x005C
#define INTRCAN0ERR                     0x005E
#define INTRCAN0WUP                     0x0060
#define INTRCAN0CFR                     0x0064
#define INTRCAN0TRM                     0x0066
#define INTRCAN0GRFR                    0x0068
#define INTRCAN0GERR                    0x006A
#define INTLIN1WUP                      0x006C
#define INTP12                          0x006C
#define INTRCAN1GRFR                    0x006E
#define INTRCAN1GERR                    0x0070
#define INTRCAN1WUP                     0x0072
#define INTRCAN1GRVC                    0x0074
#define INTTM14                         0x0074
#define INTRCAN1ERR                     0x0076
#define INTTM15                         0x0076
#define INTRCAN1CFR                     0x0078
#define INTTM16                         0x0078
#define INTRCAN1TRM                     0x007A
#define INTTM17                         0x007A
#define INTCRAM                         0x007C

#endif
