/***********************************************************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only intended for use with Renesas products.
* No other uses are authorized. This software is owned by Renesas Electronics Corporation and is protected under all
* applicable laws, including copyright laws. 
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING THIS SOFTWARE, WHETHER EXPRESS, IMPLIED
* OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NON-INFRINGEMENT.  ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY
* LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE FOR ANY DIRECT,
* INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR
* ITS AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software and to discontinue the availability 
* of this software. By using this software, you agree to the additional terms and conditions found by accessing the 
* following link:
* http://www.renesas.com/disclaimer
*
* Copyright (C) 2021, 2025 Renesas Electronics Corporation. All rights reserved.
***********************************************************************************************************************/

/***********************************************************************************************************************
* File Name        : Config_TAU1_4.c
* Component Version: 1.10.0
* Device(s)        : R7F125FML4xFB
* Description      : This file implements device driver for Config_TAU1_4.
***********************************************************************************************************************/
/***********************************************************************************************************************
Includes
***********************************************************************************************************************/
#include "r_cg_macrodriver.h"
#include "r_cg_userdefine.h"
#include "Config_TAU1_4.h"
/* Start user code for include. Do not edit comment generated here */
/* End user code. Do not edit comment generated here */

/***********************************************************************************************************************
Pragma directive
***********************************************************************************************************************/
/* Start user code for pragma. Do not edit comment generated here */
/* End user code. Do not edit comment generated here */

/***********************************************************************************************************************
Global variables and functions
***********************************************************************************************************************/
/* Start user code for global. Do not edit comment generated here */
/* End user code. Do not edit comment generated here */

/***********************************************************************************************************************
* Function Name: R_Config_TAU1_4_Create
* Description  : This function initializes the TAU1 channel4 module.
* Arguments    : None
* Return Value : None
***********************************************************************************************************************/
void R_Config_TAU1_4_Create(void)
{
    UTSEL |= _01_TAU_TAU1_ENABLE;    /* TAU1 selection (register access of TAU1 is possible) */
    TPS1 &= _FFF0_TAU_CKM0_CLEAR;
    TPS1 |= _0008_TAU_CKM0_FCLK_8;
    TT1 |= (_0040_TAU_CH6_STOP_TRG_ON | _0010_TAU_CH4_STOP_TRG_ON);
    TMMK14 = 1U;    /* disable INTTM14 interrupt */
    TMIF14 = 0U;    /* clear INTTM14 interrupt flag */
    TMMK16 = 1U;    /* disable INTTM16 interrupt */
    TMIF16 = 0U;    /* clear INTTM16 interrupt flag */
    /* Set INTTM14 low priority */
    TMPR114 = 1U;
    TMPR014 = 1U;
    /* Set INTTM16 low priority */
    TMPR116 = 1U;
    TMPR016 = 1U;
    /* Channel 4 is used as master channel for PWM output function */
    TMR14 = _0000_TAU_CLOCK_SELECT_CKM0 | _0000_TAU_CLOCK_MODE_CKS | _0800_TAU_COMBINATION_MASTER | 
            _0000_TAU_TRIGGER_SOFTWARE | _0001_TAU_MODE_PWM_MASTER;
    TDR14 = _F423_TAU_TDR14_VALUE;
    TOM1 &= (uint16_t)~_0010_TAU_CH4_SLAVE_OUTPUT;
    TOL1 &= (uint16_t)~_0010_TAU_CH4_OUTPUT_LEVEL_L;
    TO1 &= (uint16_t)~_0010_TAU_CH4_OUTPUT_VALUE_1;
    TOE1 &= (uint16_t)~_0010_TAU_CH4_OUTPUT_ENABLE;
    /* Channel 6 is used as slave channel for PWM output function */
    TMR16 = _0000_TAU_CLOCK_SELECT_CKM0 | _0000_TAU_CLOCK_MODE_CKS | _0000_TAU_COMBINATION_SLAVE | 
            _0400_TAU_TRIGGER_MASTER_INT | _0009_TAU_MODE_PWM_SLAVE;
    TDR16 = _7A12_TAU_TDR16_VALUE;
    TOM1 |= _0040_TAU_CH6_SLAVE_OUTPUT;
    TOL1 &= (uint16_t)~_0040_TAU_CH6_OUTPUT_LEVEL_L;
    TO1 &= (uint16_t)~_0040_TAU_CH6_OUTPUT_VALUE_1;
    PWMDLY2 &= _CFFF_TAU_CH6_OUTPUT_CLEAR;
    PWMDLY2 |= _0000_TAU_CH6_OUTPUT_NO_DELAY;
    TOE1 |= _0040_TAU_CH6_OUTPUT_ENABLE;
    /* Set TO16 pin */
    TSPMC6 &= 0xDFU;
    P6 &= 0xDFU;
    PM6 &= 0xDFU;

    R_Config_TAU1_4_Create_UserInit();
}

/***********************************************************************************************************************
* Function Name: R_Config_TAU1_4_Start
* Description  : This function starts the TAU1 channel4 counter.
* Arguments    : None
* Return Value : None
***********************************************************************************************************************/
void R_Config_TAU1_4_Start(void)
{
    TMIF14 = 0U;    /* clear INTTM14 interrupt flag */
    TMMK14 = 0U;    /* enable INTTM14 interrupt */
    TMIF16 = 0U;    /* clear INTTM16 interrupt flag */
    TMMK16 = 0U;    /* enable INTTM16 interrupt */
    UTSEL |= _01_TAU_TAU1_ENABLE;    /* TAU1 selection (register access of TAU1 is possible) */
    TOE1 |= _0040_TAU_CH6_OUTPUT_ENABLE;
    TS1 |= (_0040_TAU_CH6_START_TRG_ON | _0010_TAU_CH4_START_TRG_ON);
}

/***********************************************************************************************************************
* Function Name: R_Config_TAU1_4_Stop
* Description  : This function stops the TAU1 channel4 counter.
* Arguments    : None
* Return Value : None
***********************************************************************************************************************/
void R_Config_TAU1_4_Stop(void)
{
    UTSEL |= _01_TAU_TAU1_ENABLE;    /* TAU1 selection (register access of TAU1 is possible) */
    TT1 |= (_0040_TAU_CH6_STOP_TRG_ON | _0010_TAU_CH4_STOP_TRG_ON);
    TOE1 &= (uint16_t)~_0040_TAU_CH6_OUTPUT_ENABLE;
    TMMK14 = 1U;    /* disable INTTM14 interrupt */
    TMIF14 = 0U;    /* clear INTTM14 interrupt flag */
    TMMK16 = 1U;    /* disable INTTM16 interrupt */
    TMIF16 = 0U;    /* clear INTTM16 interrupt flag */
}

/* Start user code for adding. Do not edit comment generated here */
/* End user code. Do not edit comment generated here */

