/***********************************************************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only intended for use with Renesas products.
* No other uses are authorized. This software is owned by Renesas Electronics Corporation and is protected under all
* applicable laws, including copyright laws. 
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING THIS SOFTWARE, WHETHER EXPRESS, IMPLIED
* OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NON-INFRINGEMENT.  ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY
* LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE FOR ANY DIRECT,
* INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR
* ITS AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software and to discontinue the availability 
* of this software. By using this software, you agree to the additional terms and conditions found by accessing the 
* following link:
* http://www.renesas.com/disclaimer
*
* Copyright (C) 2021, 2025 Renesas Electronics Corporation. All rights reserved.
***********************************************************************************************************************/

/***********************************************************************************************************************
* File Name        : Config_TAU1_7.c
* Component Version: 1.8.0
* Device(s)        : R7F125FML4xFB
* Description      : This file implements device driver for Config_TAU1_7.
***********************************************************************************************************************/
/***********************************************************************************************************************
Includes
***********************************************************************************************************************/
#include "r_cg_macrodriver.h"
#include "r_cg_userdefine.h"
#include "Config_TAU1_7.h"
/* Start user code for include. Do not edit comment generated here */
/* End user code. Do not edit comment generated here */

/***********************************************************************************************************************
Pragma directive
***********************************************************************************************************************/
/* Start user code for pragma. Do not edit comment generated here */
/* End user code. Do not edit comment generated here */

/***********************************************************************************************************************
Global variables and functions
***********************************************************************************************************************/
/* Start user code for global. Do not edit comment generated here */
/* End user code. Do not edit comment generated here */

/***********************************************************************************************************************
* Function Name: R_Config_TAU1_7_Create
* Description  : This function initializes the TAU1 channel 7 module.
* Arguments    : None
* Return Value : None
***********************************************************************************************************************/
void R_Config_TAU1_7_Create(void)
{
    UTSEL |= _01_TAU_TAU1_ENABLE;    /* TAU1 selection (register access of TAU1 is possible) */
    TPS1 &= _FFF0_TAU_CKM0_CLEAR;
    TPS1 |= _0008_TAU_CKM0_FCLK_8;
    /* Stop channel 7 */
    TT1 |= _0080_TAU_CH7_STOP_TRG_ON;
    /* Mask channel 7 interrupt */
    TMMK17 = 1U;    /* disable INTTM17 interrupt */
    TMIF17 = 0U;    /* clear INTTM17 interrupt flag */
    /* Set INTTM17 low priority */
    TMPR117 = 1U;
    TMPR017 = 1U;
    /* TAU17 used as interval timer */
    TMR17 = _0000_TAU_CLOCK_SELECT_CKM0 | _0000_TAU_CLOCK_MODE_CKS | _0000_TAU_TRIGGER_SOFTWARE | 
            _0000_TAU_MODE_INTERVAL_TIMER | _0000_TAU_START_INT_UNUSED;
    TDR17 = _F423_TAU_TDR17_VALUE;
    TOM1 &= (uint16_t)~_0080_TAU_CH7_SLAVE_OUTPUT;
    TOL1 &= (uint16_t)~_0080_TAU_CH7_OUTPUT_LEVEL_L;
    TO1 &= (uint16_t)~_0080_TAU_CH7_OUTPUT_VALUE_1;
    TOE1 &= (uint16_t)~_0080_TAU_CH7_OUTPUT_ENABLE;

    R_Config_TAU1_7_Create_UserInit();
}

/***********************************************************************************************************************
* Function Name: R_Config_TAU1_7_Start
* Description  : This function starts the TAU1 channel 7 counter.
* Arguments    : None
* Return Value : None
***********************************************************************************************************************/
void R_Config_TAU1_7_Start(void)
{
    TMIF17 = 0U;    /* clear INTTM17 interrupt flag */
    TMMK17 = 0U;    /* enable INTTM17 interrupt */
    UTSEL |= _01_TAU_TAU1_ENABLE;    /* TAU1 selection (register access of TAU1 is possible) */
    TS1 |= _0080_TAU_CH7_START_TRG_ON;
}

/***********************************************************************************************************************
* Function Name: R_Config_TAU1_7_Stop
* Description  : This function stops the TAU1 channel 7 counter.
* Arguments    : None
* Return Value : None
***********************************************************************************************************************/
void R_Config_TAU1_7_Stop(void)
{
    UTSEL |= _01_TAU_TAU1_ENABLE;    /* TAU1 selection (register access of TAU1 is possible) */
    TT1 |= _0080_TAU_CH7_STOP_TRG_ON;
    /* Mask channel 7 interrupt */
    TMMK17 = 1U;    /* disable INTTM17 interrupt */
    TMIF17 = 0U;    /* clear INTTM17 interrupt flag */
}

/* Start user code for adding. Do not edit comment generated here */
/* End user code. Do not edit comment generated here */
